(function() {
	var instances = {};

	function ShortURLInstance(oOptions) {
		oOptions = oOptions || {};

		this.filename = oOptions.filename;
		this.password = '';
		this.expiration = false;
		this.error = false;
		this.downloadable = true;
		this.editable = true;
		this.collaborationURL;
	}

	ShortURLInstance.prototype.resolve = function(oOptions) {
		oOptions = Object.assign({
			callback: void 0,
			doNotTrack: false,
			skipPasswordPrompt: false
		}, oOptions);

		this.error = false;
		this.url = oOptions.url;

		this.resolveIcwLi(function() {
			this.resolveCollaboration(function() {
				this.resolveFileExists(oOptions);
			}.bind(this), oOptions);
		}.bind(this), oOptions);
	};

	ShortURLInstance.prototype.resolveIcwLi = function(fCallback, oOptions) {
		if (!this.url.match(/^https:\/\/icw\.li\//)) {
			return fCallback && fCallback();
		}

		oOptions = oOptions || {};

		var xhr = new XMLHttpRequest();
		xhr.addEventListener('readystatechange', function() {
			if (xhr.readyState === 2) {
				this.url = xhr.responseURL;
				xhr.abort();
				fCallback && fCallback();
			}
		}.bind(this));
		xhr.onerror = function(e) {
			executeCallbackFunction([oOptions.callback], false, e);
		};
		xhr.open('GET', this.url);
		if (oOptions.doNotTrack) {
			xhr.setRequestHeader('Do-Not-Track', true);
		}
		xhr.send();
	};

	ShortURLInstance.prototype.resolveCollaboration = function(fCallback, oOptions) {
		var match = this.url.match(/\/collaboration\/\?ticket=(.*?)&url=(.*?)(?:&|$)/);
		if (!match) {
			return fCallback && fCallback();
		}

		this.collaborationURL = this.url;

		var apiPath = decodeURIComponent(match[2]);

		var aData = {
			ticket: match[1],
			password: this.password
		};

		var xhr = new XMLHttpRequest();
		xhr.addEventListener('load', async function() {
			var response;
			try {
				response = JSON.parse(xhr.responseText);
			} catch (e) {
				return await executeCallbackFunction([oOptions.callback], false, e);
			}

			if (response.error) {
				switch(response.error) {
					case 'E_DOCUMENT_INVITE_PASSWORD':
						if (oOptions.skipPasswordPrompt) {
							return executeCallbackFunction([oOptions.callback], false, response.error);
						}
						var pass = await gui._create('password', 'frm_password_protected', '', '', [function(password) {
							this.password = password;
							this.resolveCollaboration(fCallback, oOptions);
							pass._remove_destructor('__destructor');
						}.bind(this)], this.filename, !!this.password);
						pass.__destructor = function() {
							executeCallbackFunction([oOptions.callback], false);
						}
						pass._add_destructor('__destructor');
						break;
					default:
						executeCallbackFunction([oOptions.callback], false, response.error);
				}
			} else {
				this.editable = response.DocEditable || (response.DocIssuerEmail === sPrimaryAccount);
				this.downloadable = !response.DocDisableDownload;
				this.expiration = response.DocExpiration;
				this.filename = response.DocName || this.filename;
				this.url = apiPath + 'files.download?' + buildURL(aData);
				fCallback && fCallback();
			}
		}.bind(this));
		xhr.onerror = function(e) {
			executeCallbackFunction([oOptions.callback], false, e);
		};
		xhr.open('POST', apiPath + 'files.invite.info');
		xhr.send(buildURL(aData));
	};

	ShortURLInstance.prototype.resolveFileExists = async function(oOptions) {
		instances[this.url] = this;
		if (!this.url.match(/\/files\.download?/)) {
			return await executeCallbackFunction([oOptions.callback]);
		}

		var xhr = new XMLHttpRequest();
		xhr.addEventListener('load', async function() {
			var response;
			try {
				response = JSON.parse(xhr.responseText);
			} catch (e) {
				return await executeCallbackFunction([oOptions.callback], false, e);
			}

			if (response.ok || response.result) {
				executeCallbackFunction([oOptions.callback], this);
			} else {
				executeCallbackFunction([oOptions.callback], false);
			}
		}.bind(this));
		xhr.onerror = function(e) {
			executeCallbackFunction([oOptions.callback], false, e);
		};
		xhr.open('GET', this.url.replace('files.download', 'files.exists'));
		xhr.send();
	};

	window.ShortURL = {
		resolve: function(oOptions) {
			if (!instances[oOptions.url]) {
				instances[oOptions.url] = new ShortURLInstance(oOptions);
			}
			return instances[oOptions.url].resolve(oOptions);
		},
		services: [
			/https?:\/\/(?:www\.)?icw.li\/[-_\w]+/g
		],
		match: function(sURL) {
			var match;
			for (var i in ShortURL.services) {
				if ((match = sURL.match(ShortURL.services[i]))) {
					return match;
				}
			}
		},
		matches: function(sURL) {
			return ShortURL.services.some(function(service) {
				return sURL.match(service);
			});
		}
	};
})();