# Search Wizard
Library for search wizard

# Installation
```cmd
> npm i
```

# Build process
```cmd
> npm run build
```

# Query syntax
```
	query	= keyword : value meta
	keyword	= .*
	value	= ".*"
	meta	= JSON
```
E.g.: `with:"adam@icewarp.com"{"label":"Adam Paclt","image":"path/to/avatar","hidden_keyword":"+with"}`  
`image` path is used as bubble image source  
`label` is shown instead of a value, though value is still sent to server  
`hidden_keyword` when specified, matched keyword is hidden from user, though still sent to server

# Initialization
```html
<script src="path/to/search-wizard.js"></script>
<script>
	var config = {
		id: 'id.to.short.history.by',
		input: document.getElementById('input'),
		i18n: {
			show_more: 'Show more',
			placeholder: 'Type some more',
			placeholder_empty: 'Type something here',
			keyword_optional: 'Optional',
			keyword_required: 'Required',
			keyword_excluded: 'Excluded'
		},
		autosuggestContainer: document.body,
		onSubmit: function (query) {
			console.log('Submit:', query);
		},
		keywords: {}, // see Keywords section
		components: [] // see Components section
	};

	var searchWizard = new SearchWizard(config);
</script>
```

## Keywords
```js
{
	subject: { // used as a keyword
		label: "Label for keyword",
		type: "date", // [text, date, number, enum]
		unique: ['subject'], // array of keywords to overwrite
		values: { // in case of type == "enum"
			value1: { label: "Label for value1" },
			value2: { label: "Label for value2", unique: [] }
		},
		similar: ['body', 'fulltext'], // an array of prefered keywords suggestions
		meta: true, // should meta data be used
		image: true // should an image be shown
	}
}
```

## Components

### Common attributes
```js
{
	class: "recent", // css class
	label: "History", // label
	maxItems: 5 // max results to show
}
```

### Special type - Recent
```js
{
	type: "recent", // show recent searches
}
```

### Special type - Keywords
```js
{
	type: "keywords",
	keywords: ['subject'] // array of keywords to suggest
}
```

### User defined component

#### Callback
```js
{
	keyword: "with", // use search result values with this keyword
	keywords: ["with", "cc", "bcc"], // call callback if keyword is one of keywords
	timeout: 250, // delay search in ms
	callback: function (query, maxItems, callback) { // function called to return results
	// callback accepts array of queries
		callback(Server.request(query, maxItems));
	},
	render: function (data) { // custom result template; data contains parsed response queries
		return `
			<img src="${data.meta.image}">
			<div>${data.meta.label}</div>
			<div>${data.value}</div>
		`;
	}
}
```

#### Fields
```js
{
	fields: [
		{
			label: "label",
			keyword: "keyword",
			value: "value",
			onCreate: function(input) {
				// called after field input gets rendered
			}
		}
	],
}
```

### Shortcuts
```js
{
	shortcuts: [
		{
			label: "label",
			callback: function () { // shortcut onclick handler
				searchWizard.addQuery('last:"1"');
			}
		}
	]
}
```