/**
 * Text range module for Rangy.
 * Text-based manipulation and searching of ranges and selections.
 *
 * Features
 *
 * - Ability to move range boundaries by character or word offsets
 * - Customizable word tokenizer
 * - Ignores text nodes inside <script> or <style> elements or those hidden by CSS display and visibility properties
 * - Range findText method to search for text or regex within the page or within a range. Flags for whole words and case
 *   sensitivity
 * - Selection and range save/restore as text offsets within a node
 * - Methods to return visible text within a range or selection
 * - innerText method for elements
 *
 * References
 *
 * https://www.w3.org/Bugs/Public/show_bug.cgi?id=13145
 * http://aryeh.name/spec/innertext/innertext.html
 * http://dvcs.w3.org/hg/editing/raw-file/tip/editing.html
 *
 * Part of Rangy, a cross-browser JavaScript range and selection library
 * https://github.com/timdown/rangy
 *
 * Depends on Rangy core.
 *
 * Copyright 2022, Tim Down
 * Licensed under the MIT license.
 * Version: 1.3.1
 * Build date: 17 August 2022
 */
!function(e,t){"function"==typeof define&&define.amd?define(["./rangy-core"],e):"undefined"!=typeof module&&"object"==typeof exports?module.exports=e(require("rangy")):e(t.rangy)}((function(e){return e.createModule("TextRange",["WrappedSelection"],(function(e,t){var n,r,i,o="character",a="word",s=e.dom,c=e.util,u=c.extend,d=c.createOptions,l=s.getBody,h=/^[ \t\f\r\n]+$/,p=/^[ \t\f\r]+$/,f=/^[\t-\r \u0085\u00A0\u1680\u180E\u2000-\u200B\u2028\u2029\u202F\u205F\u3000]+$/,g=/^[\t \u00A0\u1680\u180E\u2000-\u200B\u202F\u205F\u3000]+$/,v="en",S=e.Selection.isDirectionBackward,C=!1,N=!1;function y(e,t){for(var n=e.slice(t.start,t.end),r={isWord:t.isWord,chars:n,toString:function(){return n.join("")}},i=0,o=n.length;i<o;++i)n[i].token=r;return r}function m(e,t,n){for(var r,i=n(e,t),o=[],a=0;r=i[a++];)o.push(y(e,r));return o}n=s.createTestElement(document,"<p>1 </p><p></p>",!0),r=n.firstChild,(i=e.getSelection()).collapse(r.lastChild,2),i.setStart(r.firstChild,0),n.innerHTML="1 <br />",i.collapse(n,2),i.setStart(n.firstChild,0),C=1==(""+i).length,n.innerHTML="1 <p>1</p>",i.collapse(n,2),i.setStart(n.firstChild,0),N=1==(""+i).length,s.removeNode(n),i.removeAllRanges();var x={includeBlockContentTrailingSpace:!0,includeSpaceBeforeBr:!0,includeSpaceBeforeBlock:!0,includePreLineTrailingSpace:!0,ignoreCharacters:""};var T={includeBlockContentTrailingSpace:!1,includeSpaceBeforeBr:!C,includeSpaceBeforeBlock:!N,includePreLineTrailingSpace:!0},P={en:{wordRegex:/[a-z0-9]+('[a-z0-9]+)*/gi,includeTrailingSpace:!1,tokenizer:function(e,t){var n,r=e.join(""),i=[];function o(e,t,n){i.push({start:e,end:t,isWord:n})}for(var a,s,c=0;n=t.wordRegex.exec(r);){if(s=(a=n.index)+n[0].length,a>c&&o(c,a,!1),t.includeTrailingSpace)for(;g.test(e[s]);)++s;o(a,s,!0),c=s}return c<e.length&&o(c,e.length,!1),i}}},b={caseSensitive:!1,withinRange:null,wholeWordsOnly:!1,wrap:!1,direction:"forward",wordOptions:null,characterOptions:null},w={wordOptions:null,characterOptions:null},R={wordOptions:null,characterOptions:null,trim:!1,trimStart:!0,trimEnd:!0},E={wordOptions:null,characterOptions:null,direction:"forward"};function B(e,t){var n=d(e,t);return t.hasOwnProperty("wordOptions")&&(n.wordOptions=function(e){var t,n;return e?(t=e.language||v,u(n={},P[t]||P.en),u(n,e),n):P.en}(n.wordOptions)),t.hasOwnProperty("characterOptions")&&(n.characterOptions=d(n.characterOptions,x)),n}var O,k,L,I=s.getComputedStyleProperty;k=document.createElement("table"),(L=l(document)).appendChild(k),O="block"==I(k,"display"),L.removeChild(k);var A={table:"table",caption:"table-caption",colgroup:"table-column-group",col:"table-column",thead:"table-header-group",tbody:"table-row-group",tfoot:"table-footer-group",tr:"table-row",td:"table-cell",th:"table-cell"};function W(e,t){var n=I(e,"display",t),r=e.tagName.toLowerCase();return"block"==n&&O&&A.hasOwnProperty(r)?A[r]:n}function _(e){for(var t=function(e){return function(e){var t=[];for(;e.parentNode;)t.unshift(e.parentNode),e=e.parentNode;return t}(e).concat([e])}(e),n=0,r=t.length;n<r;++n)if(1==t[n].nodeType&&"none"==W(t[n]))return!0;return!1}function D(e,t){return!t&&e.hasChildNodes()?e.firstChild:function(e){for(;e&&!e.nextSibling;)e=e.parentNode;return e?e.nextSibling:null}(e)}function F(e){var t=e.previousSibling;if(t){for(e=t;e.hasChildNodes();)e=e.lastChild;return e}var n=e.parentNode;return n&&1==n.nodeType?n:null}function V(e){if(!e||3!=e.nodeType)return!1;var t=e.data;if(""===t)return!0;var n=e.parentNode;if(!n||1!=n.nodeType)return!1;var r=I(e.parentNode,"whiteSpace");return/^[\t\n\r ]+$/.test(t)&&/^(normal|nowrap)$/.test(r)||/^[\t\r ]+$/.test(t)&&"pre-line"==r}function $(e){return""===e.data||!!V(e)&&(!e.parentNode||!!_(e))}function q(e){var t=e.nodeType;return 7==t||8==t||_(e)||/^(script|style)$/i.test(e.nodeName)||function(e){var t;return 3==e.nodeType&&(t=e.parentNode)&&"hidden"==I(t,"visibility")}(e)||$(e)}function M(e,t){var n=e.nodeType;return 7==n||8==n||1==n&&"none"==W(e,t)}function j(){this.store={}}j.prototype={get:function(e){return this.store.hasOwnProperty(e)?this.store[e]:null},set:function(e,t){return this.store[e]=t}};function U(e,t,n){return function(r){var i=this.cache;if(i.hasOwnProperty(e))return i[e];0;var o=t.call(this,n?this[n]:this,r);return i[e]=o,o}}function G(e,t){this.node=e,this.session=t,this.cache=new j,this.positions=new j}var K={getPosition:function(e){var t=this.positions;return t.get(e)||t.set(e,new ne(this,e))},toString:function(){return"[NodeWrapper("+s.inspectNode(this.node)+")]"}};G.prototype=K;var z="EMPTY",H="NON_SPACE",Y="UNCOLLAPSIBLE_SPACE",J="COLLAPSIBLE_SPACE",Q="TRAILING_SPACE_BEFORE_BLOCK",X="TRAILING_SPACE_IN_BLOCK",Z="TRAILING_SPACE_BEFORE_BR",ee="PRE_LINE_TRAILING_SPACE_BEFORE_LINE_BREAK",te="INCLUDED_TRAILING_LINE_BREAK_AFTER_BR";function ne(e,t){this.offset=t,this.nodeWrapper=e,this.node=e.node,this.session=e.session,this.cache=new j}u(K,{isCharacterDataNode:U("isCharacterDataNode",s.isCharacterDataNode,"node"),getNodeIndex:U("nodeIndex",s.getNodeIndex,"node"),getLength:U("nodeLength",s.getNodeLength,"node"),containsPositions:U("containsPositions",(function(e){return s.isCharacterDataNode(e)||!/^(area|base|basefont|br|col|frame|hr|img|input|isindex|link|meta|param)$/i.test(e.nodeName)}),"node"),isWhitespace:U("isWhitespace",V,"node"),isCollapsedWhitespace:U("isCollapsedWhitespace",$,"node"),getComputedDisplay:U("computedDisplay",W,"node"),isCollapsed:U("collapsed",q,"node"),isIgnored:U("ignored",M,"node"),next:U("nextPos",D,"node"),previous:U("previous",F,"node"),getTextNodeInfo:U("textNodeInfo",(function(e){var t=null,n=!1,r=I(e.parentNode,"whiteSpace"),i="pre-line"==r;return i?(t=p,n=!0):"normal"!=r&&"nowrap"!=r||(t=h,n=!0),{node:e,text:e.data,spaceRegex:t,collapseSpaces:n,preLine:i}}),"node"),hasInnerText:U("hasInnerText",(function(e,t){for(var n=this.session,r=n.getPosition(e.parentNode,this.getNodeIndex()+1),i=n.getPosition(e,0),o=t?r:i,a=t?i:r;o!==a;){if(o.prepopulateChar(),o.isDefinitelyNonEmpty())return!0;o=t?o.previousVisible():o.nextVisible()}return!1}),"node"),isRenderedBlock:U("isRenderedBlock",(function(e){for(var t=e.getElementsByTagName("br"),n=0,r=t.length;n<r;++n)if(!q(t[n]))return!0;return this.hasInnerText()}),"node"),getTrailingSpace:U("trailingSpace",(function(e){if("br"==e.tagName.toLowerCase())return"";switch(this.getComputedDisplay()){case"inline":for(var t=e.lastChild;t;){if(!M(t))return 1==t.nodeType?this.session.getNodeWrapper(t).getTrailingSpace():"";t=t.previousSibling}break;case"inline-block":case"inline-table":case"none":case"table-column":case"table-column-group":break;case"table-cell":return"\t";default:return this.isRenderedBlock(!0)?"\n":""}return""}),"node"),getLeadingSpace:U("leadingSpace",(function(e){switch(this.getComputedDisplay()){case"inline":case"inline-block":case"inline-table":case"none":case"table-column":case"table-column-group":case"table-cell":break;default:return this.isRenderedBlock(!1)?"\n":""}return""}),"node")});var re={character:"",characterType:z,isBr:!1,prepopulateChar:function(){var e=this;if(!e.prepopulatedChar){var t=e.node,n=e.offset,r="",i=z,o=!1;if(n>0)if(3==t.nodeType){var a=t.data,s=a.charAt(n-1),c=e.nodeWrapper.getTextNodeInfo(),u=c.spaceRegex;c.collapseSpaces?u.test(s)?n>1&&u.test(a.charAt(n-2))||(c.preLine&&"\n"===a.charAt(n)?(r=" ",i=ee):(r=" ",i=J)):(r=s,i=H,o=!0):(r=s,i=Y,o=!0)}else{var d=t.childNodes[n-1];if(d&&1==d.nodeType&&!q(d)&&("br"==d.tagName.toLowerCase()?(r="\n",e.isBr=!0,i=J,o=!1):e.checkForTrailingSpace=!0),!r){var l=t.childNodes[n];l&&1==l.nodeType&&!q(l)&&(e.checkForLeadingSpace=!0)}}e.prepopulatedChar=!0,e.character=r,e.characterType=i,e.isCharInvariant=o}},isDefinitelyNonEmpty:function(){var e=this.characterType;return e==H||e==Y},resolveLeadingAndTrailingSpaces:function(){if(this.prepopulatedChar||this.prepopulateChar(),this.checkForTrailingSpace){var e=this.session.getNodeWrapper(this.node.childNodes[this.offset-1]).getTrailingSpace();e&&(this.isTrailingSpace=!0,this.character=e,this.characterType=J),this.checkForTrailingSpace=!1}if(this.checkForLeadingSpace){var t=this.session.getNodeWrapper(this.node.childNodes[this.offset]).getLeadingSpace();t&&(this.isLeadingSpace=!0,this.character=t,this.characterType=J),this.checkForLeadingSpace=!1}},getPrecedingUncollapsedPosition:function(e){for(var t=this;t=t.previousVisible();)if(""!==t.getCharacter(e))return t;return null},getCharacter:function(e){this.resolveLeadingAndTrailingSpaces();var t=this.character,n=function(e){var t=e||"",n="string"==typeof t?t.split(""):t;return n.sort((function(e,t){return e.charCodeAt(0)-t.charCodeAt(0)})),n.join("").replace(/(.)\1+/g,"$1")}(e.ignoreCharacters),r=""!==t&&n.indexOf(t)>-1;if(this.isCharInvariant)return r?"":t;var i=["character",e.includeSpaceBeforeBr,e.includeBlockContentTrailingSpace,e.includePreLineTrailingSpace,n].join("_"),o=this.cache.get(i);if(null!==o)return o;var a,s,c="",u=this.characterType==J,d=!1,l=this;function h(){return d||(s=l.getPrecedingUncollapsedPosition(e),d=!0),s}return u&&(this.type==te?c="\n":" "==t&&(!h()||s.isTrailingSpace||"\n"==s.character||" "==s.character&&s.characterType==J)||("\n"==t&&this.isLeadingSpace?h()&&"\n"!=s.character&&(c="\n"):(a=this.nextUncollapsed())&&(a.isBr?this.type=Z:a.isTrailingSpace&&"\n"==a.character?this.type=X:a.isLeadingSpace&&"\n"==a.character&&(this.type=Q),"\n"==a.character?(this.type!=Z||e.includeSpaceBeforeBr)&&(this.type!=Q||e.includeSpaceBeforeBlock)&&(this.type==X&&a.isTrailingSpace&&!e.includeBlockContentTrailingSpace||(this.type!=ee||a.type!=H||e.includePreLineTrailingSpace)&&("\n"==t?a.isTrailingSpace?this.isTrailingSpace||this.isBr&&(a.type="TRAILING_LINE_BREAK_AFTER_BR",h()&&s.isLeadingSpace&&!s.isTrailingSpace&&"\n"==s.character?a.character="":a.type=te):c="\n":" "==t&&(c=" "))):c=t))),n.indexOf(c)>-1&&(c=""),this.cache.set(i,c),c},equals:function(e){return!!e&&this.node===e.node&&this.offset===e.offset},inspect:function(){return"[Position("+s.inspectNode(this.node)+":"+this.offset+")]"},toString:function(){return this.character}};ne.prototype=re,u(re,{next:U("nextPos",(function(e){var t,n,r,i=e.nodeWrapper,o=e.node,a=e.offset,s=i.session;return o?(a==i.getLength()?n=(t=o.parentNode)?i.getNodeIndex()+1:0:i.isCharacterDataNode()?(t=o,n=a+1):(r=o.childNodes[a],s.getNodeWrapper(r).containsPositions()?(t=r,n=0):(t=o,n=a+1)),t?s.getPosition(t,n):null):null})),previous:U("previous",(function(e){var t,n,r,i=e.nodeWrapper,o=e.node,a=e.offset,c=i.session;return 0==a?n=(t=o.parentNode)?i.getNodeIndex():0:i.isCharacterDataNode()?(t=o,n=a-1):(r=o.childNodes[a-1],c.getNodeWrapper(r).containsPositions()?(t=r,n=s.getNodeLength(r)):(t=o,n=a-1)),t?c.getPosition(t,n):null})),nextVisible:U("nextVisible",(function(e){var t=e.next();if(!t)return null;var n=t.nodeWrapper,r=t.node,i=t;return n.isCollapsed()&&(i=n.session.getPosition(r.parentNode,n.getNodeIndex()+1)),i})),nextUncollapsed:U("nextUncollapsed",(function(e){for(var t=e;t=t.nextVisible();)if(t.resolveLeadingAndTrailingSpaces(),""!==t.character)return t;return null})),previousVisible:U("previousVisible",(function(e){var t=e.previous();if(!t)return null;var n=t.nodeWrapper,r=t.node,i=t;return n.isCollapsed()&&(i=n.session.getPosition(r.parentNode,n.getNodeIndex())),i}))});var ie=null,oe=function(){function e(e){var t=new j;return{get:function(n){var r=t.get(n[e]);if(r)for(var i,o=0;i=r[o++];)if(i.node===n)return i;return null},set:function(n){var r=n.node[e];(t.get(r)||t.set(r,[])).push(n)}}}var t=c.isHostProperty(document.documentElement,"uniqueID");function n(){this.initCaches()}return n.prototype={initCaches:function(){var n;this.elementCache=t?(n=new j,{get:function(e){return n.get(e.uniqueID)},set:function(e){n.set(e.node.uniqueID,e)}}):e("tagName"),this.textNodeCache=e("data"),this.otherNodeCache=e("nodeName")},getNodeWrapper:function(e){var t;switch(e.nodeType){case 1:t=this.elementCache;break;case 3:t=this.textNodeCache;break;default:t=this.otherNodeCache}var n=t.get(e);return n||(n=new G(e,this),t.set(n)),n},getPosition:function(e,t){return this.getNodeWrapper(e).getPosition(t)},getRangeBoundaryPosition:function(e,t){var n=t?"start":"end";return this.getPosition(e[n+"Container"],e[n+"Offset"])},detach:function(){this.elementCache=this.textNodeCache=this.otherNodeCache=null}},n}();function ae(){return ie||(se(),ie=new oe)}function se(){ie&&ie.detach(),ie=null}function ce(e,n,r,i){r&&(n?q(r.node)&&(r=e.previousVisible()):q(r.node)&&(r=r.nextVisible()));var o=e,a=!1;function s(){var e=null;return n?(e=o,a||(o=o.previousVisible(),a=!o||r&&o.equals(r))):a||(e=o=o.nextVisible(),a=!o||r&&o.equals(r)),a&&(o=null),e}var c,u=!1;return{next:function(){if(u)return u=!1,c;for(var e;e=s();)if(e.getCharacter(i))return c=e,e;return null},rewind:function(){if(!c)throw t.createError("createCharacterIterator: cannot rewind. Only one position can be rewound.");u=!0},dispose:function(){e=r=null}}}u(s,{nextNode:D,previousNode:F});var ue=Array.prototype.indexOf?function(e,t){return e.indexOf(t)}:function(e,t){for(var n=0,r=e.length;n<r;++n)if(e[n]===t)return n;return-1};function de(e,t,n){var r=ce(e,!1,null,t),i=ce(e,!0,null,t),o=n.tokenizer;function a(e){for(var t,n,o=[],a=e?r:i,s=!1,c=!1;t=a.next();){if(n=t.character,f.test(n))c&&(c=!1,s=!0);else{if(s){a.rewind();break}c=!0}o.push(t)}return o}var s=a(!0),c=a(!1).reverse(),u=m(c.concat(s),n,o),d=s.length?u.slice(ue(u,s[0].token)):[],l=c.length?u.slice(0,ue(u,c.pop().token)+1):[];return{nextEndToken:function(){for(var e,t;1==d.length&&!(e=d[0]).isWord&&(t=a(!0)).length>0;)d=m(e.chars.concat(t),n,o);return d.shift()},previousStartToken:function(){for(var e,t;1==l.length&&!(e=l[0]).isWord&&(t=a(!1)).length>0;)l=m(t.reverse().concat(e.chars),n,o);return l.pop()},dispose:function(){r.dispose(),i.dispose(),d=l=null}}}function le(e,t,n,r){var i=e.getRangeBoundaryPosition(t,!0),o=e.getRangeBoundaryPosition(t,!1);return ce(r?o:i,!!r,r?i:o,n)}function he(t,n,r,i,o){var a,s,c,u,d,l,h=S(o.direction),p=ce(t,h,t.session.getRangeBoundaryPosition(i,h),o.characterOptions),f="",g=[],v=null;function C(t,n){var r=g[t].previousVisible(),i=g[n-1],a=!o.wholeWordsOnly||function(t,n,r){var i=e.createRange(t.node);return i.setStartAndEnd(t.node,t.offset,n.node,n.offset),!i.expand("word",{wordOptions:r})}(r,i,o.wordOptions);return{startPos:r,endPos:i,valid:a}}for(;a=p.next();)if(s=a.character,r||o.caseSensitive||(s=s.toLowerCase()),h?(g.unshift(a),f=s+f):(g.push(a),f+=s),r){if(d=n.exec(f))if(u=(c=d.index)+d[0].length,l){if(!h&&u<f.length||h&&c>0){v=C(c,u);break}}else l=!0}else if(-1!=(c=f.indexOf(n))){v=C(c,c+n.length);break}return l&&(v=C(c,u)),p.dispose(),v}function pe(e){return function(){var t=!!ie,n=ae(),r=[n].concat(c.toArray(arguments)),i=e.apply(this,r);return t||se(),i}}function fe(e,t){return pe((function(n,r,i,s){void 0===i&&(i=r,r=o),s=B(s,w);var c=e;t&&(c=i>=0,this.collapse(!c));var u=function(e,t,n,r,i){var s,c,u,d,l=0,h=e,p=Math.abs(n);if(0!==n){var f=n<0;switch(t){case o:for(c=ce(e,f,null,r);(s=c.next())&&l<p;)++l,h=s;u=s,c.dispose();break;case a:for(var g=de(e,r,i),v=f?g.previousStartToken:g.nextEndToken;(d=v())&&l<p;)d.isWord&&(++l,h=f?d.chars[0]:d.chars[d.chars.length-1]);break;default:throw new Error("movePositionBy: unit '"+t+"' not implemented")}f?(h=h.previousVisible(),l=-l):h&&h.isLeadingSpace&&!h.isTrailingSpace&&(t==a&&(u=(c=ce(e,!1,null,r)).next(),c.dispose()),u&&(h=u.previousVisible()))}return{position:h,unitsMoved:l}}(n.getRangeBoundaryPosition(this,c),r,i,s.characterOptions,s.wordOptions),d=u.position;return this[c?"setStart":"setEnd"](d.node,d.offset),u.unitsMoved}))}function ge(e){return pe((function(t,n){for(var r,i=le(t,this,n=d(n,x),!e),o=0;(r=i.next())&&f.test(r.character);)++o;i.dispose();var a=o>0;return a&&this[e?"moveStart":"moveEnd"]("character",e?o:-o,{characterOptions:n}),a}))}function ve(e){return pe((function(t,n){var r=!1;return this.changeEachRange((function(t){r=t[e](n)||r})),r}))}u(e.rangePrototype,{moveStart:fe(!0,!1),moveEnd:fe(!1,!1),move:fe(!0,!0),trimStart:ge(!0),trimEnd:ge(!1),trim:pe((function(e,t){var n=this.trimStart(t),r=this.trimEnd(t);return n||r})),expand:pe((function(e,t,n){var r=!1,i=(n=B(n,R)).characterOptions;if(t||(t=o),t==a){var s,c,u=n.wordOptions,d=e.getRangeBoundaryPosition(this,!0),l=e.getRangeBoundaryPosition(this,!1),h=de(d,i,u).nextEndToken(),p=h.chars[0].previousVisible();if(this.collapsed)s=h;else s=de(l,i,u).previousStartToken();return c=s.chars[s.chars.length-1],p.equals(d)||(this.setStart(p.node,p.offset),r=!0),c&&!c.equals(l)&&(this.setEnd(c.node,c.offset),r=!0),n.trim&&(n.trimStart&&(r=this.trimStart(i)||r),n.trimEnd&&(r=this.trimEnd(i)||r)),r}return this.moveEnd(o,1,n)})),text:pe((function(e,t){return this.collapsed?"":function(e,t,n){for(var r,i=[],o=le(e,t,n);r=o.next();)i.push(r);return o.dispose(),i}(e,this,d(t,x)).join("")})),selectCharacters:pe((function(e,t,n,r,i){var o={characterOptions:i};t||(t=l(this.getDocument())),this.selectNodeContents(t),this.collapse(!0),this.moveStart("character",n,o),this.collapse(!0),this.moveEnd("character",r-n,o)})),toCharacterRange:pe((function(e,t,n){t||(t=l(this.getDocument()));var r,i=t.parentNode,o=s.getNodeIndex(t),a=-1==s.comparePoints(this.startContainer,this.endContainer,i,o),c=this.cloneRange();return a?(c.setStartAndEnd(this.startContainer,this.startOffset,i,o),r=-c.text(n).length):(c.setStartAndEnd(i,o,this.startContainer,this.startOffset),r=c.text(n).length),{start:r,end:r+this.text(n).length}})),findText:pe((function(t,n,r){(r=B(r,b)).wholeWordsOnly&&(r.wordOptions.includeTrailingSpace=!1);var i=S(r.direction),o=r.withinRange;o||(o=e.createRange()).selectNodeContents(this.getDocument());var a=n,s=!1;"string"==typeof a?r.caseSensitive||(a=a.toLowerCase()):s=!0;var c=t.getRangeBoundaryPosition(this,!i),u=o.comparePoint(c.node,c.offset);-1===u?c=t.getRangeBoundaryPosition(o,!0):1===u&&(c=t.getRangeBoundaryPosition(o,!1));for(var d,l=c,h=!1;;)if(d=he(l,a,s,o,r)){if(d.valid)return this.setStartAndEnd(d.startPos.node,d.startPos.offset,d.endPos.node,d.endPos.offset),!0;l=i?d.startPos:d.endPos}else{if(!r.wrap||h)return!1;o=o.cloneRange(),l=t.getRangeBoundaryPosition(o,!i),o.setBoundary(c.node,c.offset,i),h=!0}})),pasteHtml:function(e){if(this.deleteContents(),e){var t=this.createContextualFragment(e),n=t.lastChild;this.insertNode(t),this.collapseAfter(n)}}}),u(e.selectionPrototype,{expand:pe((function(e,t,n){this.changeEachRange((function(e){e.expand(t,n)}))})),move:pe((function(e,t,n,r){var i=0;if(this.focusNode){this.collapse(this.focusNode,this.focusOffset);var o=this.getRangeAt(0);r||(r={}),r.characterOptions=d(r.characterOptions,T),i=o.move(t,n,r),this.setSingleRange(o)}return i})),trimStart:ve("trimStart"),trimEnd:ve("trimEnd"),trim:ve("trim"),selectCharacters:pe((function(t,n,r,i,o,a){var s=e.createRange(n);s.selectCharacters(n,r,i,a),this.setSingleRange(s,o)})),saveCharacterRanges:pe((function(e,t,n){for(var r=this.getAllRanges(),i=[],o=1==r.length&&this.isBackward(),a=0,s=r.length;a<s;++a)i[a]={characterRange:r[a].toCharacterRange(t,n),backward:o,characterOptions:n};return i})),restoreCharacterRanges:pe((function(t,n,r){this.removeAllRanges();for(var i,o,a,s=0,c=r.length;s<c;++s)a=(o=r[s]).characterRange,(i=e.createRange(n)).selectCharacters(n,a.start,a.end,o.characterOptions),this.addRange(i,o.backward)})),text:pe((function(e,t){for(var n=[],r=0,i=this.rangeCount;r<i;++r)n[r]=this.getRangeAt(r).text(t);return n.join("")}))}),e.innerText=function(t,n){var r=e.createRange(t);return r.selectNodeContents(t),r.text(n)},e.createWordIterator=function(e,t,n){var r=ae();n=B(n,E);var i=de(r.getPosition(e,t),n.characterOptions,n.wordOptions),o=S(n.direction);return{next:function(){return o?i.previousStartToken():i.nextEndToken()},dispose:function(){i.dispose(),this.next=function(){}}}},e.noMutation=function(e){e(ae()),se()},e.noMutation.createEntryPointFunction=pe,e.textRange={isBlockNode:function(e){return e&&(1==e.nodeType&&!/^(inline(-block|-table)?|none)$/.test(W(e))||9==e.nodeType||11==e.nodeType)},isCollapsedWhitespaceNode:$,createPosition:pe((function(e,t,n){return e.getPosition(t,n)}))}})),e}),this);