/**
 * Serializer module for Rangy.
 * Serializes Ranges and Selections. An example use would be to store a user's selection on a particular page in a
 * cookie or local storage and restore it on the user's next visit to the same page.
 *
 * Part of Rangy, a cross-browser JavaScript range and selection library
 * https://github.com/timdown/rangy
 *
 * Depends on Rangy core.
 *
 * Copyright 2022, Tim Down
 * Licensed under the MIT license.
 * Version: 1.3.1
 * Build date: 17 August 2022
 */
!function(e,n){"function"==typeof define&&define.amd?define(["./rangy-core"],e):"undefined"!=typeof module&&"object"==typeof exports?module.exports=e(require("rangy")):e(n.rangy)}((function(e){return e.createModule("Serializer",["WrappedSelection"],(function(e,n){var o="undefined",t=e.util;typeof encodeURIComponent!=o&&typeof decodeURIComponent!=o||n.fail("encodeURIComponent and/or decodeURIComponent method is missing");var r,i=(r=null,function(e){for(var n=function(e){for(var n,o=[],t=0,r=e.length;t<r;++t)(n=e.charCodeAt(t))<128?o.push(n):n<2048?o.push(n>>6|192,63&n|128):o.push(n>>12|224,n>>6&63|128,63&n|128);return o}(e),o=-1,t=(r||(r=function(){for(var e,n,o=[],t=0;t<256;++t){for(n=t,e=8;e--;)1==(1&n)?n=n>>>1^3988292384:n>>>=1;o[t]=n>>>0}return o}()),r),i=0,c=n.length;i<c;++i)o=o>>>8^t[255&(o^n[i])];return(-1^o)>>>0}),c=e.dom;function a(e){return e.replace(/</g,"&lt;").replace(/>/g,"&gt;")}function d(e,n){n=n||[];var o=e.nodeType,t=e.childNodes,r=t.length,i=[o,e.nodeName,r].join(":"),c="",u="";switch(o){case 3:c=a(e.nodeValue);break;case 8:c="\x3c!--"+a(e.nodeValue)+"--\x3e";break;default:c="<"+i+">",u="</>"}c&&n.push(c);for(var s=0;s<r;++s)d(t[s],n);return u&&n.push(u),n}function u(e){var n=d(e).join("");return i(n).toString(16)}function s(e,n,o){var t=[],r=e;for(o=o||c.getDocument(e).documentElement;r&&r!=o;)t.push(c.getNodeIndex(r,!0)),r=r.parentNode;return t.join("/")+":"+n}function l(e,o,t){o||(o=(t||document).documentElement);for(var r,i=e.split(":"),a=o,d=i[0]?i[0].split("/"):[],u=d.length;u--;){if(!((r=parseInt(d[u],10))<a.childNodes.length))throw n.createError("deserializePosition() failed: node "+c.inspectNode(a)+" has no child with index "+r+", "+u);a=a.childNodes[r]}return new c.DomPosition(a,parseInt(i[1],10))}function f(o,t,r){if(r=r||e.DomRange.getRangeDocument(o).documentElement,!c.isOrIsAncestorOf(r,o.commonAncestorContainer))throw n.createError("serializeRange(): range "+o.inspect()+" is not wholly contained within specified root node "+c.inspectNode(r));var i=s(o.startContainer,o.startOffset,r)+","+s(o.endContainer,o.endOffset,r);return t||(i+="{"+u(r)+"}"),i}var m=/^([^,]+),([^,\{]+)(\{([^}]+)\})?$/;function p(o,t,r){t?r=r||c.getDocument(t):t=(r=r||document).documentElement;var i=m.exec(o),a=i[4];if(a){var d=u(t);if(a!==d)throw n.createError("deserializeRange(): checksums of serialized range root node ("+a+") and target root node ("+d+") do not match")}var s=l(i[1],t,r),f=l(i[2],t,r),p=e.createRange(r);return p.setStartAndEnd(s.node,s.offset,f.node,f.offset),p}function g(e,n,o){n||(n=(o||document).documentElement);var t=m.exec(e)[3];return!t||t===u(n)}function h(n,o,t){for(var r=(n=e.getSelection(n)).getAllRanges(),i=[],c=0,a=r.length;c<a;++c)i[c]=f(r[c],o,t);return i.join("|")}function v(n,o,t){o?t=t||c.getWindow(o):o=(t=t||window).document.documentElement;for(var r=n.split("|"),i=e.getSelection(t),a=[],d=0,u=r.length;d<u;++d)a[d]=p(r[d],o,t.document);return i.setRanges(a),i}var w="rangySerializedSelection";t.extend(e,{serializePosition:s,deserializePosition:l,serializeRange:f,deserializeRange:p,canDeserializeRange:g,serializeSelection:h,deserializeSelection:v,canDeserializeSelection:function(e,n,o){var t;n?t=o?o.document:c.getDocument(n):n=(o=o||window).document.documentElement;for(var r=e.split("|"),i=0,a=r.length;i<a;++i)if(!g(r[i],n,t))return!1;return!0},restoreSelectionFromCookie:function(e){var n=function(e){for(var n,o,t=e.split(/[;,]/),r=0,i=t.length;r<i;++r)if((n=t[r].split("="))[0].replace(/^\s+/,"")==w&&(o=n[1]))return decodeURIComponent(o.replace(/\s+$/,""));return null}((e=e||window).document.cookie);n&&v(n,e.doc)},saveSelectionCookie:function(n,o){n=n||window;var t=(o="object"==typeof o?o:{}).expires?";expires="+o.expires.toUTCString():"",r=o.path?";path="+o.path:"",i=o.domain?";domain="+o.domain:"",c=o.secure?";secure":"",a=h(e.getSelection(n));n.document.cookie=encodeURIComponent(w)+"="+encodeURIComponent(a)+t+r+i+c},getElementChecksum:u,nodeToInfoString:d}),t.crc32=i})),e}),this);