/**
 * Selection save and restore module for Rangy.
 * Saves and restores user selections using marker invisible elements in the DOM.
 *
 * Part of Rangy, a cross-browser JavaScript range and selection library
 * https://github.com/timdown/rangy
 *
 * Depends on Rangy core.
 *
 * Copyright 2022, Tim Down
 * Licensed under the MIT license.
 * Version: 1.3.1
 * Build date: 17 August 2022
 */
!function(e,n){"function"==typeof define&&define.amd?define(["./rangy-core"],e):"undefined"!=typeof module&&"object"==typeof exports?module.exports=e(require("rangy")):e(n.rangy)}((function(e){return e.createModule("SaveRestore",["WrappedSelection"],(function(e,n){var r=e.dom,t=r.removeNode,a=e.Selection.isDirectionBackward;function o(e,n){return(n||document).getElementById(e)}function s(e,n){var t,a="selectionBoundary_"+ +new Date+"_"+(""+Math.random()).slice(2),o=r.getDocument(e.startContainer),s=e.cloneRange();return s.collapse(n),(t=o.createElement("span")).id=a,t.style.lineHeight="0",t.style.display="none",t.className="rangySelectionBoundary",t.appendChild(o.createTextNode("\ufeff")),s.insertNode(t),t}function i(e,r,a,s){var i=o(a,e);i?(r[s?"setStartBefore":"setEndBefore"](i),t(i)):n.warn("Marker element has been removed. Cannot restore selection.")}function l(e,n){return n.compareBoundaryPoints(e.START_TO_START,e)}function d(n,r){var t,o=e.DomRange.getRangeDocument(n),i=n.toString(),l=a(r);return n.collapsed?{document:o,markerId:(t=s(n,!1)).id,collapsed:!0}:(t=s(n,!1),{document:o,startMarkerId:s(n,!0).id,endMarkerId:t.id,collapsed:!1,backward:l,toString:function(){return"original text: '"+i+"', new text: '"+n.toString()+"'"}})}function c(r,a){var s=r.document;void 0===a&&(a=!0);var l=e.createRange(s);if(r.collapsed){var d=o(r.markerId,s);if(d){d.style.display="inline";var c=d.previousSibling;c&&3==c.nodeType?(t(d),l.collapseToPoint(c,c.length)):(l.collapseBefore(d),t(d))}else n.warn("Marker element has been removed. Cannot restore selection.")}else i(s,l,r.startMarkerId,!0),i(s,l,r.endMarkerId,!1);return a&&l.normalizeBoundaries(),l}function u(n,r){var t,s,i=[],c=a(r);(n=n.slice(0)).sort(l);for(var u=0,f=n.length;u<f;++u)i[u]=d(n[u],c);for(u=f-1;u>=0;--u)t=n[u],s=e.DomRange.getRangeDocument(t),t.collapsed?t.collapseAfter(o(i[u].markerId,s)):(t.setEndBefore(o(i[u].endMarkerId,s)),t.setStartAfter(o(i[u].startMarkerId,s)));return i}function f(e){for(var n=[],r=e.length-1;r>=0;r--)n[r]=c(e[r],!0);return n}function g(e,n){var r=o(n,e);r&&t(r)}e.util.extend(e,{saveRange:d,restoreRange:c,saveRanges:u,restoreRanges:f,saveSelection:function(r){if(!e.isSelectionValid(r))return n.warn("Cannot save selection. This usually happens when the selection is collapsed and the selection document has lost focus."),null;var t=e.getSelection(r),a=t.getAllRanges(),o=1==a.length&&t.isBackward(),s=u(a,o);return o?t.setSingleRange(a[0],o):t.setRanges(a),{win:r,rangeInfos:s,restored:!1}},restoreSelection:function(n,r){if(!n.restored){var t=n.rangeInfos,a=e.getSelection(n.win),o=f(t);1==t.length&&r&&e.features.selectionHasExtend&&t[0].backward?(a.removeAllRanges(),a.addRange(o[0],!0)):a.setRanges(o),n.restored=!0}},removeMarkerElement:g,removeMarkers:function(e){for(var n,r=e.rangeInfos,t=0,a=r.length;t<a;++t)(n=r[t]).collapsed?g(e.doc,n.markerId):(g(e.doc,n.startMarkerId),g(e.doc,n.endMarkerId))}})})),e}),this);