/**
 * Class Applier module for Rangy.
 * Adds, removes and toggles classes on Ranges and Selections
 *
 * Part of Rangy, a cross-browser JavaScript range and selection library
 * https://github.com/timdown/rangy
 *
 * Depends on Rangy core.
 *
 * Copyright 2022, Tim Down
 * Licensed under the MIT license.
 * Version: 1.3.1
 * Build date: 17 August 2022
 */
!function(e,t){"function"==typeof define&&define.amd?define(["./rangy-core"],e):"undefined"!=typeof module&&"object"==typeof exports?module.exports=e(require("rangy")):e(t.rangy)}((function(e){return e.createModule("ClassApplier",["WrappedSelection"],(function(e,t){var n=e.dom,s=n.DomPosition,r=n.arrayContains,i=e.util,o=i.forEach,a=i.isHostMethod(document,"createElementNS");function l(e,t){for(var n in e)if(e.hasOwnProperty(n)&&!1===t(n,e[n]))return!1;return!0}function u(e){return e.replace(/^\s\s*/,"").replace(/\s\s*$/,"")}function f(e,t){return!!e&&new RegExp("(?:^|\\s)"+t+"(?:\\s|$)").test(e)}function c(e,t){return"object"==typeof e.classList?e.classList.contains(t):f("string"==typeof e.className?e.className:e.getAttribute("class"),t)}function p(e,t){if("object"==typeof e.classList)e.classList.add(t);else{var n="string"==typeof e.className,s=n?e.className:e.getAttribute("class");s?f(s,t)||(s+=" "+t):s=t,n?e.className=s:e.setAttribute("class",s)}}var d=function(){function e(e,t,n){return t&&n?" ":""}return function(t,n){if("object"==typeof t.classList)t.classList.remove(n);else{var s="string"==typeof t.className,r=s?t.className:t.getAttribute("class");r=r.replace(new RegExp("(^|\\s)"+n+"(\\s|$)"),e),s?t.className=r:t.setAttribute("class",r)}}}();function h(e){return"string"==typeof e.className?e.className:e.getAttribute("class")}function m(e){return e&&e.split(/\s+/).sort().join(" ")}function g(e){return m(h(e))}function N(e,t){return g(e)==g(t)}function v(e,t){for(var n=t.split(/\s+/),s=0,r=n.length;s<r;++s)if(!c(e,u(n[s])))return!1;return!0}function y(e,t,s,r){-1==s&&(s=t.childNodes.length);var i=e.parentNode,a=n.getNodeIndex(e);o(r,(function(e){!function(e,t,n,s,r){var i=e.node,o=e.offset,a=i,l=o;i==s&&o>r&&++l,i!=t||o!=n&&o!=n+1||(a=s,l+=r-n),i==t&&o>n+1&&--l,e.node=a,e.offset=l}(e,i,a,t,s)})),t.childNodes.length==s?t.appendChild(e):t.insertBefore(e,t.childNodes[s])}function C(e,t){var s=e.parentNode,r=n.getNodeIndex(e);o(t,(function(e){!function(e,t,n){e.node==t&&e.offset>n&&--e.offset}(e,s,r)})),n.removeNode(e)}function T(e,t){return function(e,t,n,s,r){for(var i,o=[];i=e.firstChild;)y(i,t,n++,r),o.push(i);return s&&C(e,r),o}(e,e.parentNode,n.getNodeIndex(e),!0,t)}function E(e,t){var n=e.cloneRange();n.selectNodeContents(t);var s=n.intersection(e);return""!=(s?s.toString():"")}function b(e){for(var t,n=e.getNodes([3]),s=0;(t=n[s])&&!E(e,t);)++s;for(var r=n.length-1;(t=n[r])&&!E(e,t);)--r;return n.slice(s,r+1)}function A(e,t){if(e.attributes.length!=t.attributes.length)return!1;for(var n,s,r,i=0,o=e.attributes.length;i<o;++i)if("class"!=(r=(n=e.attributes[i]).name)){if(null===n!=(null===(s=t.attributes.getNamedItem(r))))return!1;if(n.specified!=s.specified)return!1;if(n.specified&&n.nodeValue!==s.nodeValue)return!1}return!0}function S(e,t){for(var n,s=0,i=e.attributes.length;s<i;++s)if(n=e.attributes[s].name,(!t||!r(t,n))&&e.attributes[s].specified&&"class"!=n)return!0;return!1}var x=n.getComputedStyleProperty,R="boolean"==typeof document.createElement("div").isContentEditable?function(e){return e&&1==e.nodeType&&e.isContentEditable}:function(e){return!(!e||1!=e.nodeType||"false"==e.contentEditable)&&("true"==e.contentEditable||R(e.parentNode))};function P(e){var t;return e&&1==e.nodeType&&((t=e.parentNode)&&9==t.nodeType&&"on"==t.designMode||R(e)&&!R(e.parentNode))}function w(e){return(R(e)||1!=e.nodeType&&R(e.parentNode))&&!P(e)}var O=/^inline(-block|-table)?$/i;function I(e){return e&&1==e.nodeType&&!O.test(x(e,"display"))}var W=/[^\r\n\t\f \u200B]/;function L(e){var t,n,r=[];for(t=0;n=e[t++];)r.push(new s(n.startContainer,n.startOffset),new s(n.endContainer,n.endOffset));return r}function M(e,t){for(var n,s,r,i=0,o=e.length;i<o;++i)n=e[i],s=t[2*i],r=t[2*i+1],n.setStartAndEnd(s.node,s.offset,r.node,r.offset)}function H(e,s,r,i){var o,a,l=0==r;if(n.isAncestorOf(s,e))return e;if(n.isCharacterDataNode(s)){var u=n.getNodeIndex(s);if(0==r)r=u;else{if(r!=s.length)throw t.createError("splitNodeAt() should not be called with offset in the middle of a data node ("+r+" in "+s.data);r=u+1}s=s.parentNode}if(function(e,t){return n.isCharacterDataNode(e)?0==t?!!e.previousSibling:t!=e.length||!!e.nextSibling:t>0&&t<e.childNodes.length}(s,r)){o=s.cloneNode(!1),a=s.parentNode,o.id&&o.removeAttribute("id");for(var f,c=0;f=s.childNodes[r];)y(f,o,c++,i);return y(o,a,n.getNodeIndex(s)+1,i),s==e?o:H(e,a,n.getNodeIndex(o),i)}if(e!=s){o=s.parentNode;var p=n.getNodeIndex(s);return l||p++,H(e,o,p,i)}return e}function j(e){var t=e?"nextSibling":"previousSibling";return function(n,s){var r,i,o=n.parentNode,a=n[t];if(a){if(a&&3==a.nodeType)return a}else if(s&&(a=o[t])&&1==a.nodeType&&(i=a,(r=o).namespaceURI==i.namespaceURI&&r.tagName.toLowerCase()==i.tagName.toLowerCase()&&N(r,i)&&A(r,i)&&"inline"==x(r,"display")&&"inline"==x(i,"display"))){var l=a[e?"firstChild":"lastChild"];if(l&&3==l.nodeType)return l}return null}}var $=j(!1),z=j(!0);function B(e){this.isElementMerge=1==e.nodeType,this.textNodes=[];var t=this.isElementMerge?e.lastChild:e;t&&(this.textNodes[0]=t)}B.prototype={doMerge:function(e){var t=this.textNodes,s=t[0];if(t.length>1){var r,i=n.getNodeIndex(s),a=[],l=0;o(t,(function(u,f){r=u.parentNode,f>0&&(r.removeChild(u),r.hasChildNodes()||n.removeNode(r),e&&o(e,(function(e){e.node==u&&(e.node=s,e.offset+=l),e.node==r&&e.offset>i&&(--e.offset,e.offset==i+1&&f<t.length-1&&(e.node=s,e.offset=l))}))),a[f]=u.data,l+=u.data.length})),s.data=a.join("")}return s.data},getLength:function(){for(var e=this.textNodes.length,t=0;e--;)t+=this.textNodes[e].length;return t},toString:function(){var e=[];return o(this.textNodes,(function(t,n){e[n]="'"+t.data+"'"})),"[Merge("+e.join(",")+")]"}};var D=["elementTagName","ignoreWhiteSpace","applyToEditableOnly","useExistingElements","removeEmptyElements","onElementCreate"],U={};function V(e,t,n){var s,r,i,o,a=this;a.cssClass=a.className=e;var f=null,c={};if("object"==typeof t&&null!==t){for(void 0!==t.elementTagName&&(t.elementTagName=t.elementTagName.toLowerCase()),n=t.tagNames,f=t.elementProperties,c=t.elementAttributes,r=0;o=D[r++];)t.hasOwnProperty(o)&&(a[o]=t[o]);s=t.normalize}else s=t;a.normalize=void 0===s||s,a.attrExceptions=[];var p=document.createElement(a.elementTagName);a.elementProperties=a.copyPropertiesToElement(f,p,!0),l(c,(function(e,t){a.attrExceptions.push(e),c[e]=""+t})),a.elementAttributes=c,a.elementSortedClassName=a.elementProperties.hasOwnProperty("className")?m(a.elementProperties.className+" "+e):e,a.applyToAnyTagName=!1;var d=typeof n;if("string"==d)"*"==n?a.applyToAnyTagName=!0:a.tagNames=u(n.toLowerCase()).split(/\s*,\s*/);else if("object"==d&&"number"==typeof n.length)for(a.tagNames=[],r=0,i=n.length;r<i;++r)"*"==n[r]?a.applyToAnyTagName=!0:a.tagNames.push(n[r].toLowerCase());else a.tagNames=[a.elementTagName]}V.prototype={elementTagName:"span",elementProperties:{},elementAttributes:{},ignoreWhiteSpace:!0,applyToEditableOnly:!1,useExistingElements:!0,removeEmptyElements:!0,onElementCreate:null,copyPropertiesToElement:function(e,t,n){var s,r,i,o,a,l,u={};for(var f in e)if(e.hasOwnProperty(f))if(o=e[f],a=t[f],"className"==f)p(t,o),p(t,this.className),t[f]=m(t[f]),n&&(u[f]=o);else if("style"==f){for(s in r=a,n&&(u[f]=i={}),e[f])e[f].hasOwnProperty(s)&&(r[s]=o[s],n&&(i[s]=r[s]));this.attrExceptions.push(f)}else t[f]=o,n&&(u[f]=t[f],l=U.hasOwnProperty(f)?U[f]:f,this.attrExceptions.push(l));return n?u:""},copyAttributesToElement:function(e,t){for(var n in e)e.hasOwnProperty(n)&&!/^class(?:Name)?$/i.test(n)&&t.setAttribute(n,e[n])},appliesToElement:function(e){return r(this.tagNames,e.tagName.toLowerCase())},getEmptyElements:function(e){var t=this;return e.getNodes([1],(function(e){return t.appliesToElement(e)&&!e.hasChildNodes()}))},hasClass:function(e){return 1==e.nodeType&&(this.applyToAnyTagName||this.appliesToElement(e))&&c(e,this.className)},getSelfOrAncestorWithClass:function(e){for(;e;){if(this.hasClass(e))return e;e=e.parentNode}return null},isModifiable:function(e){return!this.applyToEditableOnly||w(e)},isIgnorableWhiteSpaceNode:function(e){return this.ignoreWhiteSpace&&e&&3==e.nodeType&&function(e){if(0==e.data.length)return!0;if(W.test(e.data))return!1;switch(x(e.parentNode,"whiteSpace")){case"pre":case"pre-wrap":case"-moz-pre-wrap":return!1;case"pre-line":if(/[\r\n]/.test(e.data))return!1}return I(e.previousSibling)||I(e.nextSibling)}(e)},postApply:function(e,t,n,s){var r,i,a=e[0],l=e[e.length-1],u=[],f=a,c=l,p=0,d=l.length;o(e,(function(e){(i=$(e,!s))?(r||(r=new B(i),u.push(r)),r.textNodes.push(e),e===a&&(f=r.textNodes[0],p=f.length),e===l&&(c=r.textNodes[0],d=r.getLength())):r=null}));var h=z(l,!s);if(h&&(r||(r=new B(l),u.push(r)),r.textNodes.push(h)),u.length){for(var m=0,g=u.length;m<g;++m)u[m].doMerge(n);t.setStartAndEnd(f,p,c,d)}},createContainer:function(e){var t=n.getDocument(e),s=a&&!n.isHtmlNamespace(e)&&e.namespaceURI?t.createElementNS(e.namespaceURI,this.elementTagName):t.createElement(this.elementTagName);return this.copyPropertiesToElement(this.elementProperties,s,!1),this.copyAttributesToElement(this.elementAttributes,s),p(s,this.className),this.onElementCreate&&this.onElementCreate(s,this),s},elementHasProperties:function(e,t){var n=this;return l(t,(function(t,s){if("className"==t)return v(e,s);if("object"==typeof s){if(!n.elementHasProperties(e[t],s))return!1}else if(e[t]!==s)return!1}))},elementHasAttributes:function(e,t){return l(t,(function(t,n){if(e.getAttribute(t)!==n)return!1}))},applyToTextNode:function(e,t){if(function(e){var t=e.parentNode;return t&&1==t.nodeType&&!/^(textarea|style|script|select|iframe)$/i.test(t.nodeName)}(e)){var n=e.parentNode;if(1==n.childNodes.length&&this.useExistingElements&&this.appliesToElement(n)&&this.elementHasProperties(n,this.elementProperties)&&this.elementHasAttributes(n,this.elementAttributes))p(n,this.className);else{var s=e.parentNode,r=this.createContainer(s);s.insertBefore(r,e),r.appendChild(e)}}},isRemovable:function(e){return e.tagName.toLowerCase()==this.elementTagName&&g(e)==this.elementSortedClassName&&this.elementHasProperties(e,this.elementProperties)&&!S(e,this.attrExceptions)&&this.elementHasAttributes(e,this.elementAttributes)&&this.isModifiable(e)},isEmptyContainer:function(e){var t=e.childNodes.length;return 1==e.nodeType&&this.isRemovable(e)&&(0==t||1==t&&this.isEmptyContainer(e.firstChild))},removeEmptyContainers:function(e){var t=this,n=e.getNodes([1],(function(e){return t.isEmptyContainer(e)})),s=[e],r=L(s);o(n,(function(e){C(e,r)})),M(s,r)},undoToTextNode:function(e,t,n,s){if(!t.containsNode(n)){var r=t.cloneRange();r.selectNode(n),r.isPointInRange(t.endContainer,t.endOffset)&&(H(n,t.endContainer,t.endOffset,s),t.setEndAfter(n)),r.isPointInRange(t.startContainer,t.startOffset)&&(n=H(n,t.startContainer,t.startOffset,s))}this.isRemovable(n)?T(n,s):d(n,this.className)},splitAncestorWithClass:function(e,t,n){var s=this.getSelfOrAncestorWithClass(e);s&&H(s,e,t,n)},undoToAncestor:function(e,t){this.isRemovable(e)?T(e,t):d(e,this.className)},applyToRange:function(e,t){var n=this,s=L((t=t||[])||[]);e.splitBoundariesPreservingPositions(s),n.removeEmptyElements&&n.removeEmptyContainers(e);var r=b(e);if(r.length){o(r,(function(e){n.isIgnorableWhiteSpaceNode(e)||n.getSelfOrAncestorWithClass(e)||!n.isModifiable(e)||n.applyToTextNode(e,s)}));var i=r[r.length-1];e.setStartAndEnd(r[0],0,i,i.length),n.normalize&&n.postApply(r,e,s,!1),M(t,s)}var a=n.getEmptyElements(e);o(a,(function(e){p(e,n.className)}))},applyToRanges:function(e){for(var t=e.length;t--;)this.applyToRange(e[t],e);return e},applyToSelection:function(t){var n=e.getSelection(t);n.setRanges(this.applyToRanges(n.getAllRanges()))},undoToRange:function(e,t){var n=this,s=L(t=t||[]);e.splitBoundariesPreservingPositions(s),n.removeEmptyElements&&n.removeEmptyContainers(e,s);var r,i,a=b(e),l=a[a.length-1];if(a.length){n.splitAncestorWithClass(e.endContainer,e.endOffset,s),n.splitAncestorWithClass(e.startContainer,e.startOffset,s);for(var u=0,f=a.length;u<f;++u)r=a[u],(i=n.getSelfOrAncestorWithClass(r))&&n.isModifiable(r)&&n.undoToAncestor(i,s);e.setStartAndEnd(a[0],0,l,l.length),n.normalize&&n.postApply(a,e,s,!0),M(t,s)}var c=n.getEmptyElements(e);o(c,(function(e){d(e,n.className)}))},undoToRanges:function(e){for(var t=e.length;t--;)this.undoToRange(e[t],e);return e},undoToSelection:function(t){var n=e.getSelection(t),s=e.getSelection(t).getAllRanges();this.undoToRanges(s),n.setRanges(s)},isAppliedToRange:function(e){if(e.collapsed||""==e.toString())return!!this.getSelfOrAncestorWithClass(e.commonAncestorContainer);var t=e.getNodes([3]);if(t.length)for(var n,s=0;n=t[s++];)if(!this.isIgnorableWhiteSpaceNode(n)&&E(e,n)&&this.isModifiable(n)&&!this.getSelfOrAncestorWithClass(n))return!1;return!0},isAppliedToRanges:function(e){var t=e.length;if(0==t)return!1;for(;t--;)if(!this.isAppliedToRange(e[t]))return!1;return!0},isAppliedToSelection:function(t){var n=e.getSelection(t);return this.isAppliedToRanges(n.getAllRanges())},toggleRange:function(e){this.isAppliedToRange(e)?this.undoToRange(e):this.applyToRange(e)},toggleSelection:function(e){this.isAppliedToSelection(e)?this.undoToSelection(e):this.applyToSelection(e)},getElementsWithClassIntersectingRange:function(e){var t=[],n=this;return e.getNodes([3],(function(e){var s=n.getSelfOrAncestorWithClass(e);s&&!r(t,s)&&t.push(s)})),t},detach:function(){}},V.util={hasClass:c,addClass:p,removeClass:d,getClass:h,hasSameClasses:N,hasAllClasses:v,replaceWithOwnChildren:T,elementsHaveSameNonClassAttributes:A,elementHasNonClassAttributes:S,splitNodeAt:H,isEditableElement:R,isEditingHost:P,isEditable:w},e.CssClassApplier=e.ClassApplier=V,e.createClassApplier=function(e,t,n){return new V(e,t,n)},i.createAliasForDeprecatedMethod(e,"createCssClassApplier","createClassApplier",t)})),e}),this);