var default_allowed_attributes = ["accept", "action", "align", 'allow', 'allowfullscreen', "alt", "autocomplete", "background", "bgcolor", "border", "cellpadding", "cellspacing", "checked", "cite", "class", "clear", "color", "cols", "colspan", "controls", "coords", "crossorigin", "datetime", "default", "dir", "disabled", "download", "enctype", "face", "for", 'frameborder', "headers", "height", "hidden", "high", "href", "hreflang", "id", "integrity", "ismap", "label", "lang", "list", "loop", "low", "max", "maxlength", "media", "method", "min", "multiple", "name", "noshade", "novalidate", "nowrap", "open", "optimum", "pattern", "placeholder", "poster", "preload", "pubdate", "radiogroup", "readonly", "rel", "required", "rev", "reversed", "role", "rows", "rowspan", "spellcheck", "scope", 'scrolling', "selected", "shape", "size", "sizes", "span", "srclang", "start", "src", "srcset", "step", "style", "summary", "tabindex", "title", "type", "usemap", "valign", "value", "width", "xmlns", "x-em-cloudAttachments"];

var custom_allowed_attributes = ['fr-iw-spell'];

(async function() {
	await storage.library('purify.min', 'purify');
	DOMPurify && DOMPurify.setConfig({
		ALLOW_UNKNOWN_PROTOCOLS: true,
		FORBID_TAGS: ['blink', 'ilayer', 'form'],
		ALLOWED_ATTR: default_allowed_attributes.concat(custom_allowed_attributes),
		ADD_TAGS: ['iframe', 'link', 'style']
	});
	
	DOMPurify.addHook('afterSanitizeAttributes', function(node) {
		switch(node.tagName.toLowerCase()) {
			case 'iframe':
				var sandbox = 'allow-scripts allow-downloads allow-presentation';
				var src = node.getAttribute('src') || '';
				if ((src + '/').match(/^https:\/\/(www\.)?youtube\.com\//) || (src + '/').match(/^https:\/\/(www\.)?youtu\.be\//)) {
					sandbox += ' allow-same-origin';
				}
				node.setAttribute('sandbox', sandbox);
			break;
			case 'a':
				node.setAttribute('target', '_blank');
				node.setAttribute("rel", "noopener noreferrer");
			break;
		}
		return node;
	});
})();