_me = obj_wysiwyg.prototype;
function obj_wysiwyg() {}

_me.__constructor = async function (opt) {
	var me = this;

	this.__opt = Object.assign({
		isEmail: false,
		classification: false,
		reply: false,
		chatgpt: false,
		onfocus: false,
		disable_html: false,
		readonly: false,
		forceEmbeddedImages: true
	}, opt || {});
	this.__aAvailableFontSizes = [9, 10, 13, 16, 18, 24, 32];
	this.__sDefaultFontSize = 13;
	this.__ownerDocument = this._main.ownerDocument;

	//1 is always, 2 is for startOffset: 0
	this.__allowTabElements = {
		'TD':1,
		'TH':1,
		'UL':1,
		'LI':2,
		'OL':2
	};

	this._tableStyles = [{
		label: getLang('COMPOSE::DOTTED_BORDER'),
		class: 'fr-table-border-style-dotted',
		styles: [{
			selector: '.fr-table-border-style-dotted',
			style: { 'border-style': 'dotted!important' }
		}, {
			selector: '.fr-table-border-style-dotted td',
			style: { 'border': '1px dotted #000' }
		}]
	}, {
		label: getLang('COMPOSE::DASHED_BORDER'),
		class: 'fr-table-border-style-dashed',
		styles: [{
			selector: '.fr-table-border-style-dashed',
			style: { 'border-style': 'dashed!important' }
		}, {
			selector: '.fr-table-border-style-dashed td',
			style: { 'border': '1px dashed #000' }
		}]
	}, {
		label: getLang('COMPOSE::SOLID_BORDER'),
		class: 'fr-table-border-style-solid',
		styles: [{
			selector: '.fr-table-border-style-solid',
			style: { 'border-style': 'solid!important' }
		}, {
			selector: '.fr-table-border-style-solid td',
			style: { 'border': '1px solid #000' }
		}]
	}, {
		label: getLang('COMPOSE::COLLAPSED_BORDER'),
		class: 'fr-table-border-collapse-collapse',
		styles: [{
			selector: '.fr-table-border-collapse-collapse',
			style: { 'border-collapse': 'collapse' }
		}]
	}];
	this._tableCellStyles = [{
		label: getLang('COMPOSE::DOTTED_BORDER'),
		class: 'fr-table-cell-border-style-dotted',
		styles: [{
			selector: 'td.fr-table-cell-border-style-dotted',
			style: { 'border': '1px dotted #000' }
		}]
	}, {
		label: getLang('COMPOSE::DASHED_BORDER'),
		class: 'fr-table-cell-border-style-dashed',
		styles: [{
			selector: 'td.fr-table-cell-border-style-dashed',
			style: { 'border': '1px dashed #000' }
		}]
	}, {
		label: getLang('COMPOSE::SOLID_BORDER'),
		class: 'fr-table-cell-border-style-solid',
		styles: [{
			selector: 'td.fr-table-cell-border-style-solid',
			style: { 'border': '1px solid #000' }
		}]
	}];

	if(!this.__ownerDocument.head.querySelector('#font-awesome')) {
		this.__ownerDocument.head.appendChild(function() {
			var style = me.__ownerDocument.createElement('link');
			style.setAttribute('id', 'font-awesome');
			style.setAttribute('rel', 'stylesheet');
			style.setAttribute('type', 'text/css');
			style.setAttribute('href', 'https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.4.0/css/font-awesome.min.css');
			return style;
		}());
	}

	FroalaEditor.DefineIcon('imageSmall', {NAME: getLang('RICH::IMG_SMALL'), SVG_KEY: 'alignCenter'});
	FroalaEditor.RegisterCommand('imageSmall', {
		title: getLang('RICH::IMG_SMALL'),
		focus: true,
		undo: true,
		refreshAfterCallback: true,
		callback: function () {
			var activeImage = this.image.get()[0];
			activeImage.style.maxWidth = '';
			var w = activeImage.style.width || activeImage.getAttribute('width') || '',
				h = activeImage.style.height || activeImage.getAttribute('height') || '';

			w = !~w.indexOf('%') && parseFloat(w) || activeImage.naturalWidth,
			h = !~h.indexOf('%') && parseFloat(h) || activeImage.naturalHeight;

			activeImage.style.width = '';
			activeImage.style.height = '';

			if (w > 800) {
				activeImage.setAttribute('width', 800 + 'px');
				activeImage.setAttribute('height', 800 * (h / w) + 'px');
			} else if (h > 600) {
				activeImage.setAttribute('width', 600 * (w / h) + 'px');
				activeImage.setAttribute('height', 600 + 'px');
			} else if (w > 640) {
				activeImage.setAttribute('width', 640 + 'px');
				activeImage.setAttribute('height', 640 * (h / w) + 'px');
			} else if (h > 480) {
				activeImage.setAttribute('width', 480 * (w / h) + 'px');
				activeImage.setAttribute('height', 480 + 'px');
			}
			activeImage.click();
		}
	});

	FroalaEditor.DefineIcon('imageFit', {NAME: getLang('RICH::IMG_ADAPT'), SVG_KEY: 'fullscreen'});
	FroalaEditor.RegisterCommand('imageFit', {
		title: getLang('RICH::IMG_ADAPT'),
		focus: true,
		undo: true,
		refreshAfterCallback: true,
		callback: function () {
			var activeImage = this.image.get()[0];
			activeImage.setAttribute('width', '100%');
			activeImage.removeAttribute('height');
			activeImage.style.maxWidth = activeImage.naturalWidth + 'px';
			activeImage.style.width = '';
			activeImage.style.height = '';
			activeImage.click();
		}
	});

	FroalaEditor.DefineIcon('imageOriginal', {NAME: getLang('RICH::IMG_ORIGINAL'), SVG_KEY: 'imageSize'});
	FroalaEditor.RegisterCommand('imageOriginal', {
		title: getLang('RICH::IMG_ORIGINAL'),
		focus: true,
		undo: true,
		refreshAfterCallback: true,
		callback: function () {
			var activeImage = this.image.get()[0];
			activeImage.setAttribute('width', activeImage.naturalWidth + 'px');
			activeImage.setAttribute('height', activeImage.naturalHeight + 'px');
			activeImage.style.width = '';
			activeImage.style.height = '';
			activeImage.style.maxWidth = '';
			activeImage.click();
		}
	});

	FroalaEditor.DefineIcon('imageEdit', {NAME: getLang('RICH::IMAGE'), SVG_KEY: 'insertImage'});
	FroalaEditor.RegisterCommand('imageEdit', {
		title: getLang('RICH::IMAGE'),
		focus: true,
		undo: true,
		refreshAfterCallback: true,
		callback: function () {
			this.popups.hideAll();
			me.__initpopup('I', false, {
				image: this.image.get()[0]
			});
		}
	});

	if (this.__opt.isEmail) {
		FroalaEditor.PLUGINS.quote = function (editor) {
			Object.assign(FroalaEditor.POPUP_TEMPLATES, {
				'quote.popup': '[_BUTTONS_]'
			});
	
			return {
				showPopup: function showPopup () {
					var buttons = ['quote', me.__opt.classification && 'classify'].filter(Boolean);
					if (me.__opt.chatgpt) {
						buttons.push('|');
						buttons.push.apply(buttons, [me.__opt.reply && 'suggest_reply', 'make_overview', 'translate', 'fix_grammar', 'change_tone', 'improve_styling', 'make_bullet_points', 'make_shorter', 'make_longer'].filter(Boolean).map(function(action) {
							return 'chatgpt_' + action;
						}));
					}
					editor.popups.get('quote.popup') || editor.popups.create('quote.popup', {
						buttons: editor.button.buildList(buttons)
					});
					editor.popups.setContainer('quote.popup', editor.$tb);
					editor.popups.show('quote.popup');
					var scrollTop = editor.$html[0].scrollTop;
					var scrollLeft = editor.$html[0].scrollLeft;
					var bcr = me.__range.getBoundingClientRect();
					var top = Math.max(scrollTop, bcr.top - 40 + scrollTop);
					if (((top + 40) > (bcr.top + scrollTop)) && ((bcr.bottom + 48) < me.__eFrame.clientHeight)) {
						top = bcr.bottom + scrollTop + 8;
					}
					positionPopup('quote.popup', {
						x: Math.max(scrollLeft, bcr.left + bcr.width / 2 - (buttons.length * 16) + scrollLeft),
						y: top
					}).call(editor);
				},
				hidePopup: function hidePopup () {
					editor.popups.hide('quote.popup');
				}
			}
		}
		FroalaEditor.RegisterCommand('quote', {
			undo: true,
			focus: false,
			title: getLang('compose::quote'),
			callback: function () {
				this.popups.hideAll();
				var target = me.__doc().querySelector('.iw-signature') || me.__doc().querySelector('.iw-sent-via') || me.__doc().querySelector('.iw-reply-block') || me.__doc().body.firstChild;
				if (target && me.__range) {
					var clonedSelection = me.__range.cloneContents();
					[].forEach.call(clonedSelection.querySelectorAll('.iw-signature, .iw-reply-block'), function(iwblock) {
						iwblock.classList.remove('iw-signature');
						iwblock.classList.remove('iw-reply-block');
					});
					var reply = mkElement('div', {
						innerHTML: '<br/>'
					});

					var rtl = (GWOthers.getItem('MAIL_SETTINGS_DEFAULT', 'text_direction') === 'RTL' || gui._rtl);
					var quote = mkElement('td', {
						style: {
							padding: '12px',
							borderBottomRightRadius: '8px'
						}
					}, me.__doc(), clonedSelection);

					var table = mkElement('table', {
						class: 'iw-reply',
						style: {
							border: '1px solid',
							borderColor: 'rgba(128, 128, 128, 0.2)',
							borderRadius: '8px',
							marginBottom: '18px',
							borderSpacing: '0',
							overflow: 'hidden',
							width: '100%'
						}
					}, me.__doc(), [
						mkElement('tr', {
							contentEditable: 'false',
							style: {
								backgroundColor: 'rgba(128, 128, 128, 0.1)'
							}
						}, me.__doc(), [
							rtl && quote,
							mkElement('td', {
								textContent: '“',
								style: {
									fontSize: '50px',
									lineHeight: '50px',
									fontFamily: 'Times New Roman, Times, serif',
									color: '#979797',
									width: '24px',
									verticalAlign: 'top',
									padding: '12px',
									paddingRight: !rtl ? '0' : '12px',
									paddingLeft: rtl ? '0' : '12px',
									paddingTop: '4px',
									borderBottomLeftRadius: '8px'
								}
							}, me.__doc()),
							!rtl && quote
						].filter(Boolean)),
						mkElement('tr', {}, me.__doc(), [
							mkElement('td', {
								colspan: 2,
								style: {
									padding: '12px'
								}
							}, me.__doc(), [reply])
						])
					]);

					target.insertAdjacentElement('beforebegin', table);
					target.insertAdjacentHTML('beforebegin', '<div><br/></div>');

					me.__doc().defaultView.focus();
					var range = me.__doc().createRange();
					var sel = me.__doc().defaultView.getSelection();
					range.setStart(reply, 0);
					range.collapse(true);
					sel.removeAllRanges();
					sel.addRange(range);
				}
			}
		});
		['suggest_reply', 'make_overview', 'translate', 'fix_grammar', 'change_tone', 'improve_styling', 'make_bullet_points', 'make_shorter', 'make_longer'].map(function(action) {
			FroalaEditor.RegisterCommand('chatgpt_' + action, {
				focus: false,
				title: getLang('chatgpt::' + action),
				callback: function () {
					var act = me.__opt.chatgpt.menu.__aOptions.filter(function(a) {
						return a.id === action;
					})[0];
					me._parent.__toggleChatGPTPanel(true);
					act && act.callback();
					me._editor.popups.hideAll();
				}
			});
		});
		FroalaEditor.RegisterCommand('classify', {
			undo: true,
			focus: false,
			title: getLang('compose::add_classification'),
			callback: function() {
				me.__opt.classification();
			}
		});
	}

	await this.__initEditor({
		initialized: function() {
			var doc = me.__doc();
			me.__initialized = true;
			me._editor.toolbar.hide();
			me._editor.events.on('keydown', keydownEvn, true);
			me._editor.events.on('drop', dropEvn, true);
			// me._editor.fontSize.apply((parseInt(GWOthers.getItem('MAIL_SETTINGS_DEFAULT', 'font_size') || me.__sDefaultFontSize)) / 13 + 'rem');
			// me._editor.fontFamily.apply(GWOthers.getItem('MAIL_SETTINGS_DEFAULT', 'font_family'));
			me.__eFrame.parentElement.addEventListener('click', function(e) {
				if (e.target === me.__eFrame.parentElement) {
					e.preventDefault();
					me._editor.events.focus(true);
				}
			}, false);
			doc.addEventListener('contextmenu', function(e) {
				gui.__exeEvent('click', e);
			}, false);

			if (me._main.classList.contains('no-margin')) {
				doc.body.style.setProperty('margin', 0, 'important');
				doc.body.style.setProperty('padding', '0 8px', 'important');
			}

			doc.addEventListener('mouseup', function() {
				setTimeout(function() {
					me.__exeEvent('selectionChanged', me, doc.getSelection());
				}, 5);
				me._gui.__exeEvent('mouseup');
			});
			doc.addEventListener('keyup', function() {
				me.__exeEvent('selectionChanged', me, doc.getSelection());
			});
		},
		'popups.show.image.edit': positionPopup('image.edit'),
		'popups.show.table.edit': positionPopup('table.edit'),
		'buttons.refresh': function() {
			return false;
		},
		'click': function(event) {
			me.__opt.onfocus && me.__opt.onfocus(true);
			if (me.__rangeState) {
				me._unhighlight(true);
			}
			gui.__exeEvent('click', event);
		},
		'keyup': keyupEvn,
		'keypress': keypressEvn,
		'paste.before': function(e) {
			var text = e.clipboardData.getData('text/html') ? false : e.clipboardData.getData('text/plain');
			if (text) {
				text = text.entityify().split(/\r?\n/).map(function(row) {
					return '<div>' + (row.replace(/(?: {2,})|(?:^ )/g, function(spaces) {
						spaces = spaces.split('');
						for (var i = 0; i < spaces.length; i = i + 2) {
							spaces[i] = '&nbsp;'
						}
						return spaces.join('');
					}).replace(/\t/g, '&nbsp; &nbsp; ') || '&nbsp;') + '</div>';
				}).join('');
				me._editor.opts.htmlUntouched = true;
				me._editor.html.insert(text);
				me._editor.opts.htmlUntouched = false;
				afterPaste();
				return false;
			}
		},
		'image.beforeUpload': function() {
			return false;
		},
		'paste.after': afterPaste,
		'dragover': dragoverEvn,
		'dragenter': dragenterEvn,
		'dragstart': dragstartEvn,
		'dragend': dragendEvn,
		'commands.after': function(cmd) {
			~['bold', 'underline', 'italic', 'align', 'indent'].indexOf(cmd) && me.select._value('enabled');
		},
		'contentChanged': function() {
			clearTimeout(me.__contentChangedTimeout);
			me.__contentChangedTimeout = setTimeout(function() {
				// table width to px
				[].forEach.call(me.__doc().querySelectorAll('table, td'), function(el) {
					if(el.style.width.match(/%$/) && el.style.width !== '100%') {
						if(el.tagName === 'TD') {
							if(parseFloat(el.style.width) > 100) {
								el.style.width = '100%';
							}
							return;
						}
						el.style.width = el.clientWidth + 'px';
						el.style.marginRight = null;
					}
				});
				[].forEach.call(me.__doc().querySelectorAll('img'), function(img) {
					['width', 'height'].forEach(function(prop) {
						if (!img.getAttribute(prop)) {
							var value = img.style[prop];
							if (value) {
								img.setAttribute(prop, value);
								img.style[prop] = '';
							}
						}
					});
				});
				me.__exeEvent('contentChanged', me);
			}, 50);
		},
		focus: function() {
			me.__opt.onfocus && me.__opt.onfocus(true);
			var selection = me._getSelection();
			var classification = me.__doc().querySelector('.classification');
			if (!selection.rangeCount || !classification) {
				return;
			}
			var range = selection.rangeCount && selection.getRangeAt(0);
			if (range && !range.startOffset && !range.endOffset && range.startContainer === me.__doc().body) {
				range.setStartAfter(classification);
				range.setEndAfter(classification);
			}
		}
	});

	this._add_destructor('__removeDetachListeners');

	function positionPopup(id, options) {
		options = options || {};
		return function () {
			var popup = this.popups.get(id)[0];
			if (options.x || options.y) {
				popup.style.top = options.y + 'px';
				popup.style.left = options.x + 'px';
			}

			switch(id) {
				case 'image.edit':
					popup.style.marginTop = '0px';
					popup.style.marginLeft = '0px';
					break;
				case 'table.edit':
					var range = me.__doc().getSelection().getRangeAt(0);
					if (((range || {}).commonAncestorContainer || {}).closest && range.commonAncestorContainer.closest('.iw-reply')) {
						popup.style.display = 'none';
					}
					break;
				default:
					var html = this.$html[0];
					popup.style.marginTop = -html.scrollTop + 'px';
					popup.style.marginLeft = -html.scrollLeft + 'px';
			}
		};
	}

	//// FONTS ////
	this.__fonts = {};
	var aFonts = {'0': getLang('SETTINGS::DEFAULT')};
	var aTmp = dataSet.get('storage', ['FONTS', 'ITEMS']);

	for (var i in aTmp) {
		if (aTmp[i].VALUES.FAMILY.VALUE) {
			aFonts[aTmp[i].VALUES.FAMILY.VALUE] = aTmp[i].VALUES.NAME.VALUE;
			this.__fonts[aTmp[i].VALUES.FAMILY.VALUE] = [aTmp[i].VALUES.NAME.VALUE, aTmp[i].VALUES.FAMILY.VALUE.toLowerCase().split(',')];
		}
	}

	this.font._fill(aFonts);
	this.font._onchange = function () {
		var val = this._value();
		if (val != 0) {
			me.__exec('fontFamily.apply', [val]);
		}
	};
	this.font._obeyEvent('show', [function (e, args) {
		[].forEach.call(args.owner.block._main.querySelectorAll('a'), function (a) {
			a.style.fontFamily = a.getAttribute('rel');
		});
	}]);

	if (GWOthers.getItem('RESTRICTIONS', 'disable_dropbox') != 0) {
		this.__ownerDocument.getElementById(this._pathName + '/dropbox').setAttribute('hidden', '');
	}

	// Allow bidirectional text with rtl/ltr switch
	if (GWOthers.getItem('MAIL_SETTINGS_DEFAULT', 'text_direction_switch') == 1)
		addcss(this._main, 'bidirectional');


	this.__oldFcolor = '#000000';
	this.__oldBcolor = '#FFFFFF';
	this.__oldCcolor = '#000000'; // table border color
	this.__disabled = false;

	this.__coded = false;
	this.__output_format = false; //Use font, size and direction container

	this.__currentStyle = {};

	this.__currentSelectionElements = [];

	function mouseEvn(e) {
		if (e.type === 'click') {
			me.spell && me.spell._destruct();
			me._onclick && me._onclick(e);
			me.__checkMenu(e, 5);
			me.cmenu && me.cmenu._destruct();
			
			if (e.target.tagName === 'A' && (e.ctrlKey || e.metaKey)) {
				window.open(e.target.href, '_blank');
			}
		}
	}

	function dropEvn(e) {
		if (gui.frm_main.__filedrag === true) {
			return false;
		}

		if (me._ondrop) {
			return me._ondrop(e);
		}
	}

	function keypressEvn(e) {
		if(me.__activeImage && me.__activeImage.box) {
			var img = me.__activeImage.original;
			me.__img_removeEdit();

			var s = me._getSelection();
			if (s.rangeCount > 0)
				s.removeAllRanges();
			var range = me.__doc().createRange();
			range.selectNode(img);
			s.addRange(range);
		}
		if (me._onkeypress)
			me._onkeypress(e.originalEvent);
	}

	function keyupEvn(e){
		if(me.__activeImage && me.__activeImage.box) {
			var img = me.__activeImage.original;
			me.__img_removeEdit();

			var s = me._getSelection();
			if (s.rangeCount > 0)
				s.removeAllRanges();
			var range = me.__doc().createRange();
			range.selectNode(img);
			s.addRange(range);
		}
		e = e.originalEvent || e;
		me.__checkMenu(e);

		if (me._onkeyup) {
			e.data = e.data || {};
			e.data.caret = getCaretOffset(me.__doc().body);
			return e.data.caret && me._onkeyup(e);
		}
	};

	function keydownEvn(e){
		if (e.keyCode == 116){
			e.preventDefault();
			e.stopPropagation();
			return;
		}

		if (me.onkeydown) {
			var result = me.onkeydown(e);
			if(result !== void 0) {
				return result;
			}
		}

		var s, cac;

		if(me.__activeImage && me.__activeImage.box) {
			var img = me.__activeImage.original;
			me.__img_removeEdit();

			s = me._getSelection();
			if (s.rangeCount > 0)
				s.removeAllRanges();
			var range = me.__doc().createRange();
			range.selectNode(img);
			s.addRange(range);
		}
		switch(e.keyCode) {
			// case 9:
			// 	var r = me._getRange();

			// 	//Do not catch TAB in selected elements
			// 	if (r.startContainer && e.originalEvent){

			// 		var tmp = r.startContainer;
			// 		while(tmp.nodeType === 3){
			// 			tmp = r.startContainer.parentElement || r.startContainer.parentNode;
			// 		}
			// 		var tag = tmp.tagName;

			// 		switch(me.__allowTabElements[tag]){
			// 			case 2:
			// 				if (r.startOffset > 0)
			// 					break;
			// 			case 1:
			// 				e.originalEvent.stopPropagation();
			// 				return true;
			// 		}
			// 	}

			// 	if (me.__tabIndex_dock) {
			// 		if (e.originalEvent.shiftKey)
			// 			me.__tabIndex_dock._tabIndexPrev(me);
			// 		else
			// 			me.__tabIndex_dock._tabIndexNext(me);
			// 	}
			// 	return false;

			case 13: // Enter
				return true;
			case 8: // Backspace
				s = me._getSelection();
				var pes = (s.anchorNode || {}).previousElementSibling;
				if (s.isCollapsed && s.anchorOffset === 0 && pes && pes.classList.contains('classification')) {
					e.preventDefault();
					return false;
				}
				cac = s.getRangeAt(0).commonAncestorContainer;
				if (cac && cac.nodeType !== 3 && cac.querySelector('.classification')) {
					e.preventDefault();
					return false;
				}
				return true;
			case 46: // Del
				s = me._getSelection();
				if (!s.rangeCount) {
					return;
				}
				var nes = (s.anchorNode || {}).nextElementSibling;
				if (s.isCollapsed && s.anchorOffset === 0 && nes && nes.classList.contains('classification')) {
					e.preventDefault();
					return false;
				}
				cac = s.getRangeAt(0).commonAncestorContainer;
				if (cac && cac.nodeType !== 3 && cac.querySelector('.classification')) {
					e.preventDefault();
					return false;
				}
				return true;
			case 32:  // space
			case 49:  // exclamation mark
			case 188: // comma
			case 190: // dot
			case 191: // question mark
				if (GWOthers.getItem('MAIL_SETTINGS_DEFAULT', 'autocapitalization') == 0) {
					break;
				}
				var caretPosition = getCaretOffset(me.__doc().body);
				var content = me.__doc().body.textContent;
				var lastWord = content.substr(0, caretPosition.offset).match(/\w+$/);
				if (!lastWord) {
					break;
				}
				var dotSpaceOrEmpty = content.substr(0, lastWord.index).match(/^$|[.?!]\s*$/);
				if (!dotSpaceOrEmpty) {
					break;
				}

				me._replace(caretPosition.container, capitalizeFirstLetter(lastWord[0]), caretPosition.containerOffset - lastWord[0].length, caretPosition.containerOffset);
				break;
			case 27: // Esc
				if(me._onesc)
					me._onesc();
				if(e.preventDefault)
					e.preventDefault();
				return false;
		}

		if (me._onkeydown)
			return me._onkeydown(e);
	};

	function getCaretOffset(element) {
		var caretOffset = 0;
		var doc = element.ownerDocument || element.document;
		var win = doc.defaultView || doc.parentWindow;
		var sel, range, preCaretRange;
		if (win.getSelection) {
			sel = win.getSelection();
			if (sel.rangeCount > 0) {
				range = sel.getRangeAt(0);
				preCaretRange = range.cloneRange();
				preCaretRange.selectNodeContents(element);
				preCaretRange.setEnd(range.endContainer, range.endOffset);
				caretOffset = preCaretRange.toString().length;
			}
		}
		return range && {
			offset: caretOffset,
			container: range.endContainer,
			containerOffset: range.endOffset,
			range: range
		}
	}

	function capitalizeFirstLetter(word) {
		return word[0].toUpperCase() + word.slice(1);
	}

	function dragoverEvn(e) {
		e.originalEvent.preventDefault();
	}

	function dragenterEvn(e) {
		e.originalEvent.preventDefault();
	}

	function dragstartEvn() {
		gui.frm_main.__filedrag = false;
	}

	function dragendEvn() {
		gui.frm_main.__filedrag = true;
	}

	function afterPaste() {
		if (me.__doc().body.querySelector('img')) {
			me.select._value('enabled');
		}
		[].forEach.call(me.__doc().body.querySelectorAll('font'), function (font) {
			!font.innerText && font.parentNode.removeChild(font);
		});
		[].forEach.call(me.__doc().body.querySelectorAll('.iw-highlight'), function (highlight) {
			highlight.classList.remove('iw-highlight');
		});
		[].forEach.call(me.__doc().body.querySelectorAll('b'), function (b) {
			b.insertAdjacentHTML('beforebegin', b.outerHTML.replace(/<(\/?)b/g, '<$1strong'));
			b.parentElement.removeChild(b);
		});
		return false;
	}

	this.__doc().addEventListener('click', mouseEvn, false);

	this._getAnchor('header').onmousedown = function (e) {
		var elm = e.target;

		if (elm.tagName !== 'A')
			elm = elm.parentNode;
		if (elm.tagName !== 'A' || !elm.id)
			return false;

		var id = elm.id.substr(me._pathName.length);

		switch (id) {
			case '/undo':
			case '/redo':
				me.__exec('commands.' + id.replace('/', ''));
				me.__checkMenu(false, 5);
				break;
			case '/spell':
				if (!me.__coded) {
					me.__spell();
				}
				break;
			case '/format':
				if (me._getAnchor('format_toolbar').classList.contains('hidden')) {
					me._showToolbar('format');
				} else {
					me._hideToolbars();
				}
				break;
			case '/insert':
				if (me._getAnchor('insert_toolbar')){
					if (me._getAnchor('insert_toolbar').classList.contains('hidden')) {
						me._showToolbar('insert');
					} else {
						me._hideToolbars();
					}
				}
				break;
			case '/removeFormat':
				if (!me.__disabled) {
					me.__exec('commands.clearFormatting');
				}
				break;
			case '/bold':
			case '/italic':
			case '/underline':
			case '/strikeThrough':
			case '/subscript':
			case '/superscript':
				if (!me.__disabled) {
					me.__exec('commands.' + id.replace('/', ''));
				}
				break;
			case '/direction':
				if (me.__disabled) {
					break;
				}
				// Get current cursor position
				var range = me._getRange();
				if (range) {
					range.collapse(true);
					elm = range.startContainer;
				} else
					elm = me.__doc().body;

				// Find text content container
				if (elm.nodeType == 3)
					elm = elm.parentElement || elm.parentNode;

				// Find first appropriate block style element
				var block = {p: true, h1: true, h2: true, h3: true, h4: true, h5: true, h6: true, div: true, ol: true, ul: true, table: true, body: true};
				while (elm.parentNode && !block[elm.nodeName.toLowerCase()])
					elm = elm.parentNode;
				if (elm.nodeName == 'HTML')
					elm = me.__doc().body;

				// If applied to the body element change default direction
				if (elm.nodeName == 'BODY')
					me._rtl = !me._rtl;

				// Set text direction
				switch (elm.dir) {
					case 'ltr':
						elm.dir = 'rtl';
						break;
					case 'rtl':
						elm.dir = 'ltr';
						break;
					default:
						elm.dir = me._rtl ? 'ltr' : 'rtl';
				}

				break;
		}

		e.stopPropagation();
		e.preventDefault();
	};

	this._getAnchor('header').onclick = function (e) {
		if (me.__disabled) {
			return false;
		}
		var elm = e.target;

		if (elm.tagName !== 'A')
			elm = elm.parentNode;
		if (elm.tagName !== 'A' || !elm.id)
			return false;

		var id = elm.id.substr(me._pathName.length);

		if (!me.cmenu || me.cmenu._destructed) {

			(async function() {
				var aCData = [];
				var bottom = false;

				switch (id) {
					case '/image':
						var guest = sPrimaryAccountGUEST || (window.TeamChatAPI && TeamChatAPI.teamChatOnly());
						bottom = true;
						var containsImage = false;
						try {
							const clipboardContents = await navigator.clipboard.read();
							for (const item of clipboardContents) {
								containsImage = containsImage || item.types.some(function(type) { return !type.indexOf('image/') });
							}
						} catch {
							//
						}

							var dgw = GWOthers.getItem('RESTRICTIONS', 'disable_gw_types') || '';
							aCData = [
							!me._disableInsertImageFromComputer && ((GWOthers.getItem('RESTRICTIONS', 'disable_attach_item') || 0) < 1) && {
								title: 'RICH::INSERT_FROM_COMPUTER',
								css: 'ico2 img upload',
								arg: [me, '__insert_image_from_computer']
							},
							!guest && sPrimaryAccountGW && ((GWOthers.getItem('RESTRICTIONS', 'disable_attach_item') || 0) < 1) && !~dgw.indexOf('f') && {
								title: 'RICH::INSERT_FROM_FILES',
								css: 'ico2 img files',
								arg: [me, '__insert_image_from_files']
							},
							{
								title: 'RICH::INSERT_VIA_URL',
								css: 'ico2 img link',
								arg: [me, '__insert_image_via_url']
							},
							containsImage && {
								title: 'RICH::PASTE_IMAGE_FROM_CLIPBOARD',
								css: 'ico2 img clipboard',
								arg: [me, '__insert_image_from_clipboard']
							}
						].filter(Boolean);
						break;
					case '/link':
						me.__initpopup('L');
						break;
					case '/hr':
						me.__exec('commands.insertHR');
						break;
					case '/dropbox':
						me.__dropboxHandler();
						break;
					case '/paste_text':
						me.__initpopup('P');
						break;
					case '/paragraph':
						if(me.__coded || me.__disabled) {
							break;
						}
						aCData.push(
							{title: 'RICH::PARAGRAPH', css: 'paragraph p' + (!me.__currentStyle.HEAD ? ' active' : ''), arg: [me, '_paragraphFormat', ['p']], disabled: me.__disabled},
							{text: getLang('RICH::HEADING') + ' 1', css: 'paragraph h1' + (me.__currentStyle.HEAD === 1 ? ' active' : ''), tag: 'h1', arg: [me, '_paragraphFormat', ['h1']], disabled: me.__disabled},
							{text: getLang('RICH::HEADING') + ' 2', css: 'paragraph h2' + (me.__currentStyle.HEAD === 2 ? ' active' : ''), tag: 'h2', arg: [me, '_paragraphFormat', ['h2']], disabled: me.__disabled},
							{text: getLang('RICH::HEADING') + ' 3', css: 'paragraph h3' + (me.__currentStyle.HEAD === 3 ? ' active' : ''), tag: 'h3', arg: [me, '_paragraphFormat', ['h3']], disabled: me.__disabled},
							{text: getLang('RICH::HEADING') + ' 4', css: 'paragraph h4' + (me.__currentStyle.HEAD === 4 ? ' active' : ''), tag: 'h4', arg: [me, '_paragraphFormat', ['h4']], disabled: me.__disabled},
							{text: getLang('RICH::HEADING') + ' 5', css: 'paragraph h5' + (me.__currentStyle.HEAD === 5 ? ' active' : ''), tag: 'h5', arg: [me, '_paragraphFormat', ['h5']], disabled: me.__disabled},
							{text: getLang('RICH::HEADING') + ' 6', css: 'paragraph h6' + (me.__currentStyle.HEAD === 6 ? ' active' : ''), tag: 'h6', arg: [me, '_paragraphFormat', ['h6']], disabled: me.__disabled}
						);
						break;
					case '/table':
						var label = mkElement('div', {textContent: getLang('RICH::CREATE_TABLE', [0, 0])});
						var trs = [];
						for(var i = 1; i <= 8; i++) {
							var tds = [];
							for(var j = 1; j <= 10; j++) {
								tds.push(mkElement('td', {
									'data-r': i,
									'data-c': j,
									onclick: function() {
										me.__closeInsertTooltip();
										me._insTable({
											border: 1,
											rows: +this.getAttribute('data-r'),
											columns: +this.getAttribute('data-c')
										});
									},
									onmouseover: function() {
										[].forEach.call(this.parentNode.parentNode.querySelectorAll('td'), function(td) {
											if(+td.getAttribute('data-r') <= +this.getAttribute('data-r') && +td.getAttribute('data-c') <= +this.getAttribute('data-c')) {
												td.classList.add('active');
											} else {
												td.classList.remove('active');
											}
										}, this);
										label.innerText = getLang('RICH::CREATE_TABLE', [this.getAttribute('data-c'), this.getAttribute('data-r')]);
									}
								}));
							}
							trs.push(mkElement('tr', {'data-r': i}, false, tds));
						}
						var tableElement = mkElement('table', {className: 'createTable'}, false, trs);
						aCData.push(
							{element: mkElement('div', {}, false, [label, tableElement])},
							{title: 'RICH::CUSTOM_TABLE', css: 'ico2 icotable', arg: [me, '__initpopup', ['T']], disabled: me.__disabled}
						);
						break;

					case '/align':
						if (me.__disabled) {
							break;
						}
						aCData.push(
							{title: 'RICH::LEFT', css: 'ico2 img icoleft', arg: [me, '__exec', ['align.apply', ['left']]]},
							{title: 'RICH::CENTER', css: 'ico2 img icocenter', arg: [me, '__exec', ['align.apply', ['center']]]},
							{title: 'RICH::RIGHT', css: 'ico2 img icoright', arg: [me, '__exec', ['align.apply', ['right']]]},
							{title: 'RICH::JUSTIFY', css: 'ico2 img icojustify', arg: [me, '__exec', ['align.apply', ['justify']]]}
						);
						break;

					case '/ordered':
						if (me.__disabled) {
							break;
						}
						aCData.push(
							{title: 'RICH::NUMBEREDLIST', css: 'ico2 img icoordered' + (me.__currentStyle.ORDERED ? ' active' : ''), arg: [me, '__exec', ['lists.format', ['OL']]]},
							{title: 'RICH::BULLETEDLIST', css: 'ico2 img icounordered' + (me.__currentStyle.UNORDERED ? ' active' : ''), arg: [me, '__exec', ['lists.format', ['UL']]]},
							{title: 'RICH::LEFTINDENT', css: 'ico2 img icooutdent', arg: [me, '__exec', ['commands.outdent']], keep: true},
							{title: 'RICH::RIGHTINDENT', css: 'ico2 img icoindent', arg: [me, '__exec', ['commands.indent']], keep: true}
						);
						break;

					case '/lineHeight':
						if (me.__disabled) {
							break;
						}
						aCData.push(
							{title: 'RICH::LINEHEIGHT_DEFAULT', css: 'ico2 img icolineheight', arg: [me, '__exec', ['lineHeight.apply', ['']]]},
							{title: 'RICH::LINEHEIGHT_1', css: 'ico2 img icolineheight1', arg: [me, '__exec', ['lineHeight.apply', [1]]]},
							{title: 'RICH::LINEHEIGHT_1_5', css: 'ico2 img icolineheight15', arg: [me, '__exec', ['lineHeight.apply', [1.5]]]},
							{title: 'RICH::LINEHEIGHT_2', css: 'ico2 img icolineheight2', arg: [me, '__exec', ['lineHeight.apply', [2]]]}
						);
						break;
				}

				if (aCData.length) {
					e.stopPropagation();
					e.preventDefault();

					addcss(elm, 'active');
					me.cmenu = await me._gui._create('cmenu', 'obj_context', '', 'obj_rich_menu');
					me.cmenu._onclose = function () {
						removecss(elm, 'active');
					};

					await me.cmenu._fill(aCData);

					var pos = getSize(elm);
					me.cmenu._place(pos.x + pos.w / 2, pos.y + (bottom ? pos.h : 0), '', bottom ? 3 : 2);
				}
			})();
		}

		if (elm.href) {
			return false;
		}
	};

	me.size._obeyEvent('onchange', [function(){
		var val = me.size._value();
		val && me.__exec('fontSize.apply', [val / 13 + 'rem']);

	}]);

	me.size._obeyEvent('onkeyup', [function(e){
		var val = me.size._value();
		val && me.__exec('fontSize.apply', [val / 13 + 'rem'], (e.which || e.keyCode) !== 13);
		me.size.block && me.size.block._destruct();
	}]);

	me._getAnchor('color').onclick = function (e) {
		me.__clickColor(e);
	};
	me._getAnchor('bgcolor').onclick = function (e) {
		me.__clickColor(e);
	};

	//Mode Select
	this.select._obeyEvent('onchange', [function () {
		switch (me.select._value()) {
			case 'enabled':
				if (me.__coded)
					me.__code();

				try {
					me.__doc().body.dir = gui._rtl == undefined ? 'auto' : ((gui._rtl || GWOthers.getItem('MAIL_SETTINGS_DEFAULT', 'text_direction') === 'RTL') ? 'rtl' : 'ltr');
				} catch {
					//
				}

				// Insert paragraph element for direction change
				if ((GWOthers.getItem('MAIL_SETTINGS_DEFAULT', 'text_direction') === 'RTL' || gui._rtl) && !me._value()) {
					me.__exec('format.apply', ["p"]);
					// Firefox inserts br element without reason, remove it
					if (me.__doc().body.firstChild && me.__doc().body.firstChild.nodeName === 'BR')
						me.__doc().body.removeChild(me.__doc().body.firstChild);
				}

				me._disable(false);
				break;

			case 'disabled':
				if (me.__coded)
					me.__code();

				try {
					me.__doc().body.dir = gui._rtl == undefined ? 'auto' : ((gui._rtl || GWOthers.getItem('MAIL_SETTINGS_DEFAULT', 'text_direction') === 'RTL') ? 'rtl' : 'ltr');
				} catch {
					//
				}

				me._disable(true);
				break;

			case 'code':
				if (me.__spelled)
					me.select._value('enabled');
				else
					me.__code();
		}
	}]);

	this.__checkMenu(false, 5);

	if (true === this.__opt.disable_html) {
		this.select._value('disabled');
	}

	this._obeyEvent('selectionChanged', [this, '__handleSelectionChanged']);
	gui._obeyEvent('ondetach', [this, '_ondetach']);
};

_me.__insert_image_from_computer = async function() {
	if (this.__opt.forceEmbeddedImages) {
		var elm = mkElement('input', {
			type: 'file',
			accept: '*.jpg;*.jpeg;*.gif;*.png'
		});
	
		elm.addEventListener('change', function(e) {
			for (var i = 0; i < e.target.files.length; i++) {
				var file = e.target.files[i];
				var reader = new FileReader();
				reader.onloadend = function() {
					this.__exec('html.insert', [mkElement('img', {
						id: 'clipboard-' + unique_id(),
						style: {
							maxWidth: '100%'
						},
						src: reader.result
					}).outerHTML, true], false, function() {
						this.__exec('undo.saveStep');
					}.bind(this));
				}.bind(this);
				reader.readAsDataURL(file);
			};
		}.bind(this));
		elm.click();
		return;
	}

	var tmp_upload = await this._gui._create('tmp_upload', 'obj_upload');
	tmp_upload._setFileTypes('*.jpg;*.jpeg;*.gif;*.png', getLang('UPLOAD::IMAGES'));

	tmp_upload._onuploadend = function (aAttach) {
		for (var i in aAttach) {
			aAttach[i].removed = true;
			aAttach[i].fullpath = aAttach[i].folder + '/' + aAttach[i].id;
			this.__oUpload && this.__oUpload._add(aAttach[i]);

			var opt = {
				id: 'img-' + unique_id(),
				src: sPrimaryAccountClient + 'server/download.php?' + buildURL({
					dlsess: dataSet.get('main', ['dlsess']),
					class: 'file',
					fullpath: aAttach[i].fullpath
				}),
				style: {
					maxWidth: '100%'
				}
			};

			this.__exec('html.insert', [mkElement('img', opt).outerHTML, true], false, function() {
				this.__exec('undo.saveStep');
			}.bind(this));
		}
		tmp_upload._destruct();
	}.bind(this);
	tmp_upload._click();
};

_me.__insert_image_from_files = function() {
	var sFolder = Mapping.getDefaultFolderForGWType('F');
	if (!dataSet.get('folders', [sPrimaryAccount, sFolder])) {
		sFolder = '';
	}

	this._gui._create('insert_item', 'frm_insert_item', '', 'frm_insert_item_nobottomdiv', [this, function (aItems) {
		var aItemsInfo = {
			aid: aItems[0].aid,
			fid: aItems[0].fid,
			iid: aItems[0].id,
			values: []
		};
		WMItems.list(aItemsInfo, '', '', '', [function (aData) {
			var attachments = aData[aItems[0].aid][aItems[0].fid][aItems[0].id].ATTACHMENTS;
			var attachment = false;
			for (var i in attachments) {
				if (attachments[i].values.ATTDESC === aItems[0].title) {
					attachment = i;
					break;
				}
			}

			var src = sPrimaryAccountClient + 'server/download.php?' + buildURL({
				dlsess: dataSet.get('main', ['dlsess']),
				class: 'attachment',
				fullpath: aItems[0].fullpath + '/' + attachment
			});

			if (this.__opt.forceEmbeddedImages) {
				return getRemoteFileContent(src, function(blob) {
					var reader = new FileReader();
					reader.onloadend = function() {
						this.__exec('html.insert', [mkElement('img', {
							id: 'clipboard-' + unique_id(),
							style: {
								maxWidth: '100%'
							},
							src: reader.result
						}).outerHTML, true], false, function() {
							this.__exec('undo.saveStep');
						}.bind(this));
					}.bind(this);
					reader.readAsDataURL(blob);
				}.bind(this), 'blob');
			}

			if (this.__oUpload && this.__oUpload.__idtable) {
				this.__oUpload.__idtable.push({
					removed: true,
					name: aItems[0].title,
					attachment: attachment,
					id: aItems[0].id,
					size: aItems[0].size,
					class: aItems[0].type || (aItems[0].embedded ? 'item' : 'itemlink'),
					fullpath: aItems[0].fullpath
				});
			}

			var opt = {
				id: 'clipboard-' + unique_id(),
				src: src,
				style: {
					maxWidth: '100%'
				}
			};
			this.__exec('html.insert', [mkElement('img', opt).outerHTML, true], false, function() {
				this.__exec('undo.saveStep');
			}.bind(this));
		}.bind(this)]);
	}], sPrimaryAccount, sFolder, void 0, this.__oUpload, void 0, ['F','X','I'], 'F');
};

_me.__insert_image_from_clipboard = async function() {
	var tmp_upload = await this._gui._create('tmp_upload', 'obj_upload');
	try {
		const clipboardContents = await navigator.clipboard.read();
		for (const item of clipboardContents) {
			for (var i in item.types) {
				if (!item.types[i].indexOf('image/')) {
					const blob = await item.getType(item.types[i]);

					if (this.__opt.forceEmbeddedImages) {
						var reader = new FileReader();
						reader.onloadend = function() {
							this.__exec('html.insert', [mkElement('img', {
								id: 'clipboard-' + unique_id(),
								style: {
									maxWidth: '100%'
								},
								src: reader.result
							}).outerHTML, true], false, function() {
								this.__exec('undo.saveStep');
							}.bind(this));
						}.bind(this);
						reader.readAsDataURL(blob);
						return;
					}

					return tmp_upload.file.__ondropfile([new File([blob], 'clipboard.' + item.types[i].split('/').pop())], [function (_, __, oResponse) {
						oResponse.removed = true;
						oResponse.fullpath = oResponse.folder + '/' + oResponse.id;
						this.__oUpload && this.__oUpload._add(oResponse);
			
						var opt = {
							id: 'img-' + unique_id(),
							src: sPrimaryAccountClient + 'server/download.php?' + buildURL({
								dlsess: dataSet.get('main', ['dlsess']),
								class: 'file',
								fullpath: oResponse.fullpath
							}),
							style: {
								maxWidth: '100%'
							}
						};
			
						this.__exec('html.insert', [mkElement('img', opt).outerHTML, true], false, function() {
							this.__exec('undo.saveStep');
						}.bind(this));
						tmp_upload._destruct();
					}.bind(this)]);
				}
			}
		}
	} catch {
		//
	}
};

_me.__insert_image_via_url = function() {
	gui._create('code', 'frm_input', '', '', [function(url) {
		if (!url) {
			return;
		}
		var opt = {
			id: 'img-' + unique_id(),
			src: url,
			style: {
				maxWidth: '100%'
			}
		};
		this.__exec('html.insert', [mkElement('img', opt).outerHTML, true], false, function() {
			this.__exec('undo.saveStep');
		}.bind(this));
	}.bind(this)], 'RICH::INSERT_VIA_URL', '', 'https://');
};

_me.__removeDetachListeners = function(){
	this._disobeyEvent('selectionChanged', [this, '__handleSelectionChanged']);
	gui._disobeyEvent('ondetach', [this, '_ondetach']);
	this._editor && this._editor.destroy && this._editor.destroy();
};

_me.__handleSelectionChanged = function(context, selection) {
	if (context !== this) {
		return;
	}
	this.__range = false;
	this.__selection = false;
	if (!selection || !selection.rangeCount) {
		if (this.__opt.isEmail) {
			this._editor.quote.hidePopup();
		}
		return;
	}
	var range = selection.getRangeAt(0);
	if (!range || range.collapsed) {
		if (this.__opt.isEmail) {
			this._editor.quote.hidePopup();
		}
		return;
	}
	this.__selection = selection;
	this.__range = range;

	if (this.__opt.isEmail) {
		this._editor.quote.showPopup();
	}
}

_me.__initEditor = async function(events) {
	this.__ownerDocument = this._main.ownerDocument;
	var me = this;
	var scrollableContainer = this._getAnchor('frame');
	this.__froalaEvents = events || this.__froalaEvents;

	//supported languages
	var languages = {
		ar:'ar',bs:'bs',cs:'cs',da:'da',de:'de',el:'el',en:'en_gb',es:'es',et:'et',fa:'fa',fi:'fi',fr:'fr',he:'he',hr:'hr',hu:'hu',
		id:'id',it:'it',ja:'ja',ko:'ko',ku:'ku',me:'me',nb:'nb',nl:'nl',pl:'pl',pt:'pt_br',ro:'ro',ru:'ru',sk:'sk',
		sr:'sr',sv:'sv',th:'th',tr:'tr',uk:'uk',vi:'vi',cn:'zh_cn'
	};
	var lang = languages[GWOthers.getItem('LAYOUT_SETTINGS', 'language') || 'en'] || GWOthers.getItem('LAYOUT_SETTINGS', 'language');
	if (lang !== 'en'){
		try {
			await storage.library('languages/' + lang, 'froala');
		} catch {}
	}

	if (this._editor) {
		this._editor.destroy();
	}

	var pasteAllowedStyleProps = ['width', 'height', 'font-family', 'font-size', 'font-weight', 'white-space', 'vertical-align', 'text-align', 'border-collapse', 'border-spacing'];
	if (!dataSet.get('main', ['night_mode_enabled'])) {
		pasteAllowedStyleProps.push('color');
	}
	['', 'top', 'right', 'bottom', 'left'].forEach(function(dir) {
		['', 'color', 'width', 'style'].forEach(function(prop) {
			pasteAllowedStyleProps.push(['border', dir, prop].filter(Boolean).join('-'));
		});
	});
	['image', 'position', 'repeat', 'size', 'origin'].concat(dataSet.get('main', ['night_mode_enabled']) ? [''] : ['', 'color']).forEach(function(prop) {
		pasteAllowedStyleProps.push(['background', prop].filter(Boolean).join('-'));
	});

	this._editor = new FroalaEditor(scrollableContainer, {
		enter: FroalaEditor.ENTER_DIV,
		scrollableContainer: scrollableContainer.parentElement,
		useClasses: false,
		key: 'pe1G2wF1H2B3D2A6A6D6oCe1ZSc2XHe1Cd1f1KIWCWMJHXCLSwD1D1D1A1F1I4B10B1D6B5==',
		// height: '100%',
		iframe: true,
		charCounterCount: false,
		toolbarButtons: [],
		spellcheck: true,
		language: lang,
		direction: GWOthers.getItem('MAIL_SETTINGS_DEFAULT', 'text_direction') === 'RTL' ? 'rtl' : gui._rtl ? 'rtl' : 'ltr',
		disableRightClick: false,
		//linkAutoPrefix: '', // disable auto-prefixing with http://
		linkEditButtons: [],
		pasteDeniedAttrs: [],
		pasteAllowedStyleProps: pasteAllowedStyleProps,
		imageOutputSize: true,
		imageEditButtons: ['imageSmall', 'imageFit', 'imageOriginal', '-', 'imageEdit', 'imageRemove', 'imageLink', '-', 'linkOpen', 'linkEdit', 'linkRemove'],
		tableInsertHelper: false,
		// tableEditButtons: ['tableRows', 'tableColumns', 'tableCells', 'tableStyle', '-', 'tableCellVerticalAlign', 'tableCellHorizontalAlign', 'tableCellBackground', 'tableCellStyle', '-', 'tableRemove'],
		tableStyles: this._tableStyles.reduce(function(acc, cur) {
			acc[cur.class] = cur.label;
			return acc;
		}, {}),
		tableCellStyles: this._tableCellStyles.reduce(function(acc, cur) {
			acc[cur.class] = cur.label;
			return acc;
		}, {}),
		iframeDefaultStyle: [].concat(me._tableStyles, me._tableCellStyles).map(function(style) {
			return style.styles.map(function(style) {
				return style.selector + '{' + Object.keys(style.style).map(function(prop) {
					return prop + ':' + style.style[prop];
				}).join(';') + '}';
			}).join('');
		}).join(''),
		iframeStyleFiles: ['font.css', 'froala_editor.css', 'froala_plugins_table.css', 'obj_rich_body.css'].filter(Boolean).map(function (file) {
			return getCssPath(file); }),
		events: this.__froalaEvents,
		htmlAllowedTags: ['a', 'abbr', 'address', 'area', 'article', 'aside', 'audio', 'b', 'base', 'bdi', 'bdo', 'blockquote', 'br', 'button', 'canvas', 'caption', 'center', 'cite', 'code', 'col', 'colgroup', 'datalist', 'dd', 'del', 'details', 'dfn', 'dialog', 'div', 'dl', 'dt', 'em', 'embed', 'fieldset', 'figcaption', 'figure', 'footer', 'form', 'h1', 'h2', 'h3', 'h4', 'h5', 'h6', 'header', 'hgroup', 'hr', 'i', 'iframe', 'img', 'input', 'ins', 'kbd', 'keygen', 'label', 'legend', 'li', 'link', 'main', 'map', 'mark', 'menu', 'menuitem', 'meter', 'nav', 'noscript', 'object', 'ol', 'optgroup', 'option', 'output', 'p', 'param', 'pre', 'progress', 'queue', 'rp', 'rt', 'ruby', 's', 'samp', 'script', 'style', 'section', 'select', 'small', 'source', 'span', 'strike', 'strong', 'sub', 'summary', 'sup', 'table', 'tbody', 'td', 'textarea', 'tfoot', 'th', 'thead', 'time', 'title', 'tr', 'track', 'u', 'ul', 'var', 'video', 'wbr'],
		wordPasteModal: false,
		imageDefaultAlign: (GWOthers.getItem('MAIL_SETTINGS_DEFAULT', 'text_direction') === 'RTL' || gui._rtl) ? 'right' : 'left',
		imageDefaultDisplay: 'block',
		imageDefaultMargin: 0,
		imageDefaultWidth: 0,
		imageUpload: false,
		imageUploadRemoteUrls: false,
		pasteDeniedTags: ['audio'],
		fontSizeUnit: 'rem',
		tabSpaces: 4
	});
	FroalaEditor.LinkProtocols.push('conisio');

	var tlds = ['aaa','aarp','abb','abbott','abbvie','abc','able','abogado','abudhabi','ac','academy','accenture','accountant','accountants','aco','actor','ad','ads','adult','ae','aeg','aero','aetna','af','afl','africa','ag','agakhan','agency','ai','aig','airbus','airforce','airtel','akdn','al','alibaba','alipay','allfinanz','allstate','ally','alsace','alstom','am','amazon','americanexpress','americanfamily','amex','amfam','amica','amsterdam','analytics','android','anquan','anz','ao','aol','apartments','app','apple','aq','aquarelle','ar','arab','aramco','archi','army','arpa','art','arte','as','asda','asia','associates','at','athleta','attorney','au','auction','audi','audible','audio','auspost','author','auto','autos','aw','aws','ax','axa','az','azure','ba','baby','baidu','banamex','band','bank','bar','barcelona','barclaycard','barclays','barefoot','bargains','baseball','basketball','bauhaus','bayern','bb','bbc','bbt','bbva','bcg','bcn','bd','be','beats','beauty','beer','berlin','best','bestbuy','bet','bf','bg','bh','bharti','bi','bible','bid','bike','bing','bingo','bio','biz','bj','black','blackfriday','blockbuster','blog','bloomberg','blue','bm','bms','bmw','bn','bnpparibas','bo','boats','boehringer','bofa','bom','bond','boo','book','booking','bosch','bostik','boston','bot','boutique','box','br','bradesco','bridgestone','broadway','broker','brother','brussels','bs','bt','build','builders','business','buy','buzz','bv','bw','by','bz','bzh','ca','cab','cafe','cal','call','calvinklein','cam','camera','camp','canon','capetown','capital','capitalone','car','caravan','cards','care','career','careers','cars','casa','case','cash','casino','cat','catering','catholic','cba','cbn','cbre','cc','cd','center','ceo','cern','cf','cfa','cfd','cg','ch','chanel','channel','charity','chase','chat','cheap','chintai','christmas','chrome','church','ci','cipriani','circle','cisco','citadel','citi','citic','city','ck','cl','claims','cleaning','click','clinic','clinique','clothing','cloud','club','clubmed','cm','cn','co','coach','codes','coffee','college','cologne','com','commbank','community','company','compare','computer','comsec','condos','construction','consulting','contact','contractors','cooking','cool','coop','corsica','country','coupon','coupons','courses','cpa','cr','credit','creditcard','creditunion','cricket','crown','crs','cruise','cruises','cu','cuisinella','cv','cw','cx','cy','cymru','cyou','cz','dad','dance','data','date','dating','datsun','day','dclk','dds','de','deal','dealer','deals','degree','delivery','dell','deloitte','delta','democrat','dental','dentist','desi','design','dev','dhl','diamonds','diet','digital','direct','directory','discount','discover','dish','diy','dj','dk','dm','dnp','do','docs','doctor','dog','domains','dot','download','drive','dtv','dubai','dunlop','dupont','durban','dvag','dvr','dz','earth','eat','ec','eco','edeka','edu','education','ee','eg','email','emerck','energy','engineer','engineering','enterprises','epson','equipment','er','ericsson','erni','es','esq','estate','et','eu','eurovision','eus','events','exchange','expert','exposed','express','extraspace','fage','fail','fairwinds','faith','family','fan','fans','farm','farmers','fashion','fast','fedex','feedback','ferrari','ferrero','fi','fidelity','fido','film','final','finance','financial','fire','firestone','firmdale','fish','fishing','fit','fitness','fj','fk','flickr','flights','flir','florist','flowers','fly','fm','fo','foo','food','football','ford','forex','forsale','forum','foundation','fox','fr','free','fresenius','frl','frogans','frontier','ftr','fujitsu','fun','fund','furniture','futbol','fyi','ga','gal','gallery','gallo','gallup','game','games','gap','garden','gay','gb','gbiz','gd','gdn','ge','gea','gent','genting','george','gf','gg','ggee','gh','gi','gift','gifts','gives','giving','gl','glass','gle','global','globo','gm','gmail','gmbh','gmo','gmx','gn','godaddy','gold','goldpoint','golf','goo','goodyear','goog','google','gop','got','gov','gp','gq','gr','grainger','graphics','gratis','green','gripe','grocery','group','gs','gt','gu','gucci','guge','guide','guitars','guru','gw','gy','hair','hamburg','hangout','haus','hbo','hdfc','hdfcbank','health','healthcare','help','helsinki','here','hermes','hiphop','hisamitsu','hitachi','hiv','hk','hkt','hm','hn','hockey','holdings','holiday','homedepot','homegoods','homes','homesense','honda','horse','hospital','host','hosting','hot','hotels','hotmail','house','how','hr','hsbc','ht','hu','hughes','hyatt','hyundai','ibm','icbc','ice','icu','id','ie','ieee','ifm','ikano','il','im','imamat','imdb','immo','immobilien','in','inc','industries','infiniti','info','ing','ink','institute','insurance','insure','int','international','intuit','investments','io','ipiranga','iq','ir','irish','is','ismaili','ist','istanbul','it','itau','itv','jaguar','java','jcb','je','jeep','jetzt','jewelry','jio','jll','jm','jmp','jnj','jo','jobs','joburg','jot','joy','jp','jpmorgan','jprs','juegos','juniper','kaufen','kddi','ke','kerryhotels','kerryproperties','kfh','kg','kh','ki','kia','kids','kim','kindle','kitchen','kiwi','km','kn','koeln','komatsu','kosher','kp','kpmg','kpn','kr','krd','kred','kuokgroup','kw','ky','kyoto','kz','la','lacaixa','lamborghini','lamer','land','landrover','lanxess','lasalle','lat','latino','latrobe','law','lawyer','lb','lc','lds','lease','leclerc','lefrak','legal','lego','lexus','lgbt','li','lidl','life','lifeinsurance','lifestyle','lighting','like','lilly','limited','limo','lincoln','link','live','living','lk','llc','llp','loan','loans','locker','locus','lol','london','lotte','lotto','love','lpl','lplfinancial','lr','ls','lt','ltd','ltda','lu','lundbeck','luxe','luxury','lv','ly','ma','madrid','maif','maison','makeup','man','management','mango','map','market','marketing','markets','marriott','marshalls','mattel','mba','mc','mckinsey','md','me','med','media','meet','melbourne','meme','memorial','men','menu','merckmsd','mg','mh','miami','microsoft','mil','mini','mint','mit','mitsubishi','mk','ml','mlb','mls','mm','mma','mn','mo','mobi','mobile','moda','moe','moi','mom','monash','money','monster','mormon','mortgage','moscow','moto','motorcycles','mov','movie','mp','mq','mr','ms','msd','mt','mtn','mtr','mu','museum','music','mv','mw','mx','my','mz','na','nab','nagoya','name','navy','nba','nc','ne','nec','net','netbank','netflix','network','neustar','new','news','next','nextdirect','nexus','nf','nfl','ng','ngo','nhk','ni','nico','nike','nikon','ninja','nissan','nissay','nl','no','nokia','norton','now','nowruz','nowtv','np','nr','nra','nrw','ntt','nu','nyc','nz','obi','observer','office','okinawa','olayan','olayangroup','ollo','om','omega','one','ong','onl','online','ooo','open','oracle','orange','org','organic','origins','osaka','otsuka','ott','ovh','pa','page','panasonic','paris','pars','partners','parts','party','pay','pccw','pe','pet','pf','pfizer','pg','ph','pharmacy','phd','philips','phone','photo','photography','photos','physio','pics','pictet','pictures','pid','pin','ping','pink','pioneer','pizza','pk','pl','place','play','playstation','plumbing','plus','pm','pn','pnc','pohl','poker','politie','porn','post','pr','praxi','press','prime','pro','prod','productions','prof','progressive','promo','properties','property','protection','pru','prudential','ps','pt','pub','pw','pwc','py','qa','qpon','quebec','quest','racing','radio','re','read','realestate','realtor','realty','recipes','red','redstone','redumbrella','rehab','reise','reisen','reit','reliance','ren','rent','rentals','repair','report','republican','rest','restaurant','review','reviews','rexroth','rich','richardli','ricoh','ril','rio','rip','ro','rocks','rodeo','rogers','room','rs','rsvp','ru','rugby','ruhr','run','rw','rwe','ryukyu','sa','saarland','safe','safety','sakura','sale','salon','samsclub','samsung','sandvik','sandvikcoromant','sanofi','sap','sarl','sas','save','saxo','sb','sbi','sbs','sc','scb','schaeffler','schmidt','scholarships','school','schule','schwarz','science','scot','sd','se','search','seat','secure','security','seek','select','sener','services','seven','sew','sex','sexy','sfr','sg','sh','shangrila','sharp','shell','shia','shiksha','shoes','shop','shopping','shouji','show','si','silk','sina','singles','site','sj','sk','ski','skin','sky','skype','sl','sling','sm','smart','smile','sn','sncf','so','soccer','social','softbank','software','sohu','solar','solutions','song','sony','soy','spa','space','sport','spot','sr','srl','ss','st','stada','staples','star','statebank','statefarm','stc','stcgroup','stockholm','storage','store','stream','studio','study','style','su','sucks','supplies','supply','support','surf','surgery','suzuki','sv','swatch','swiss','sx','sy','sydney','systems','sz','tab','taipei','talk','taobao','target','tatamotors','tatar','tattoo','tax','taxi','tc','tci','td','tdk','team','tech','technology','tel','temasek','tennis','teva','tf','tg','th','thd','theater','theatre','tiaa','tickets','tienda','tips','tires','tirol','tj','tjmaxx','tjx','tk','tkmaxx','tl','tm','tmall','tn','to','today','tokyo','tools','top','toray','toshiba','total','tours','town','toyota','toys','tr','trade','trading','training','travel','travelers','travelersinsurance','trust','trv','tt','tube','tui','tunes','tushu','tv','tvs','tw','tz','ua','ubank','ubs','ug','uk','unicom','university','uno','uol','ups','us','uy','uz','va','vacations','vana','vanguard','vc','ve','vegas','ventures','verisign','versicherung','vet','vg','vi','viajes','video','vig','viking','villas','vin','vip','virgin','visa','vision','viva','vivo','vlaanderen','vn','vodka','volvo','vote','voting','voto','voyage','vu','wales','walmart','walter','wang','wanggou','watch','watches','weather','weatherchannel','webcam','weber','website','wed','wedding','weibo','weir','wf','whoswho','wien','wiki','williamhill','win','windows','wine','winners','wme','wolterskluwer','woodside','work','works','world','wow','ws','wtc','wtf','xbox','xerox','xihuan','xin','xxx','xyz','yachts','yahoo','yamaxun','yandex','ye','yodobashi','yoga','yokohama','you','youtube','yt','yun','za','zappos','zara','zero','zip','zm','zone','zuerich','zw'];

	if (!FroalaEditor.fixedURLDomains) {
		FroalaEditor.fixedURLDomains = true;
		FroalaEditor.URLRegEx = FroalaEditor.URLRegEx.replace('com', tlds.join('|'));
		FroalaEditor.LinkRegEx = FroalaEditor.LinkRegEx.replace('com', tlds.join('|'));
	}

	if (this.__opt.readonly)
		this._readonly(true);

	this.__eFrame = this._editor.$iframe[0];
	this.__doc = function() {
		return this._editor.iframe_document;
	}.bind(this);
	var ep = me.__eFrame.contentWindow.Element.prototype;
	if(!ep.matches) {
		ep.matches = window.Element.prototype.matches;
	}
	if(!ep.closest) {
		ep.closest = window.Element.prototype.closest;
	}

	this.__eFrame.contentWindow && this.__eFrame.contentWindow.addEventListener('scroll', function() {
		var html = me._editor.$html[0];
		[].forEach.call(me._main.querySelectorAll('.fr-image-resizer, .fr-popup'), function(elm) {
			elm.style.marginTop = -html.scrollTop + 'px';
			elm.style.marginLeft = -html.scrollLeft + 'px';
		});
		var popup = (me._editor.popups.get('image.edit') || [])[0];
		if (popup) {
			popup.style.marginTop = '0px';
			popup.style.marginLeft = '0px';
		}
	});

	// Create initial selection so that content can be pasted before clicking in window
	if (this.__doc().getSelection) {
		var s = this.__doc().getSelection();
		if (s && typeof s === "object" && s.selectAllChildren && s.collapseToStart) {
			try {
				s.selectAllChildren(this.__doc().body);
				s.collapseToStart();
			} catch {
				//
			}
		}
	}

	var base = document.head.querySelector('base');
	var base_href = base ? base.getAttribute('href') : (this.__ownerDocument.location.protocol + '//' + this.__ownerDocument.location.hostname + (this.__ownerDocument.location.port ? ':' + this.__ownerDocument.location.port : '') + this.__ownerDocument.location.pathname);
	var head = this.__doc().querySelector('head');
	head.appendChild(mkElement('meta', {'http-equiv': 'x-dns-prefetch-control'}, this.__doc()));
	head.insertBefore(mkElement('base', {href: base_href}, this.__doc()), head.firstChild);

	if (GWOthers.getItem('MAIL_SETTINGS_DEFAULT', 'html_message') != '0') {
		//Default Font
		var sBodyStyle = '';
		if (GWOthers.getItem('MAIL_SETTINGS_DEFAULT', 'font_family') != '0') {
			this.__font_family = GWOthers.getItem('MAIL_SETTINGS_DEFAULT', 'font_family');
			sBodyStyle = 'font-family: ' + this.__font_family + ';';
		}

		//Default Size
		var i = this.__aAvailableFontSizes.indexOf(parseInt(GWOthers.getItem('MAIL_SETTINGS_DEFAULT', 'font_size') || this.__sDefaultFontSize));
		this.__font_size = (-1 === i) ? this.__sDefaultFontSize : this.__aAvailableFontSizes[i];
		sBodyStyle += 'font-size: ' + this.__font_size / 13 + 'rem;';

		this.__doc().body.setAttribute('style', sBodyStyle);
	}

	this.__doc().body.classList.add('fr-element');
}

_me._replace = function(element, replacement, fromIndex, toIndex) {
	var doc = element.ownerDocument || element.document;
	var win = doc.defaultView || doc.parentWindow;
	var sel, range, preCaretRange;
	if (win.getSelection) {
		sel = win.getSelection();
		if (sel.rangeCount) {
			range = sel.getRangeAt(0);
			preCaretRange = range.cloneRange();
			preCaretRange.selectNodeContents(element);
			preCaretRange.setStart(element, fromIndex);
			preCaretRange.setEnd(element, toIndex);
			preCaretRange.deleteContents();
			if (!(replacement instanceof win.HTMLElement)) {
				replacement = doc.createTextNode(replacement);
			}
			preCaretRange.insertNode(replacement);

			sel.removeAllRanges();
			range = doc.createRange();
			range.selectNodeContents(replacement);
			range.collapse(false);
			sel = win.getSelection();
			sel.removeAllRanges();
			sel.addRange(range);
		}
	}
};

_me._readonly = function(readonly){
	if ((this.__opt.readonly = !!readonly)){
		this.__exec('edit.off', void 0, void 0, function() {
			this.__doc().body.contentEditable = !readonly;
			this.__doc().body.classList.remove('fr-disabled');
		}.bind(this));
		this._getAnchor('header').style.display = 'none';
	}
	else{
		this.__exec('edit.on', void 0, void 0, function() {
			this.__doc().body.contentEditable = !readonly;
			this.__doc().body.classList.remove('fr-disabled');
		}.bind(this));
		this._getAnchor('header').style.display = '';
	}
};

_me._showToolbar = function(type) {
	this._hideToolbars();

	switch(type) {
		case 'insert':
		case 'format':
			var disable_mailformat = +GWOthers.getItem('RESTRICTIONS', 'disable_mailformat');
			if ((isNaN(disable_mailformat) || disable_mailformat === 0) && true !== this.__opt.disable_html) {
				if(!this.__firstFormatToolbarToggle) {
					this.__firstFormatToolbarToggle = true;
					this.select._value('enabled');
				}
			}
			break;
	}
	this.__ownerDocument.getElementById(this._pathName + '/' + type).classList.add('active');
	this._main.querySelector('.' + type + '_toolbar').classList.remove('hidden');
};

_me._hideToolbars = function() {
	[].forEach.call(this._main.querySelectorAll('.toolbar'), function(elm) {
		elm.classList.add('hidden');
	});
	['insert', 'format', 'emoji'].forEach(function(type) {
		var el = this.__ownerDocument.getElementById(this._pathName + '/' + type);
		el && el.classList.remove('active');
	}, this);

	if (this.emoji && !this.emoji._destructed)
		this.emoji._destruct();
};

_me.__dropboxHandler = function () {
	if (!(GWOthers.getItem('EXTERNAL_SETTINGS', 'dropbox_app_key') || '').length) {
		gui.notifier._value({type: 'alert', args: {header: 'DROPBOX::ERRORALERT', text: 'DROPBOX::MISSINGKEY'}});
	} else if (typeof Dropbox === "undefined") {
		gui.notifier._value({type: 'alert', args: {header: 'DROPBOX::ERRORALERT', text: 'DROPBOX::UNAVAILABLE'}});
	} else {
		var me = this;
		Dropbox.choose({linkType: 'preview', success: function (files) {
			var links = [];
			for (var i in files)
				links.push('<a href="' + files[i].link.escapeXML(true) + '">' + files[i].name.escapeXML() + '</a>');
			me.__exec('html.insert', [links.join(', ')], false, function() {
				me.__exec('undo.saveStep');
			});
		}});
	}
};

_me._paragraphFormat = function (tag) {
	this.__exec('format.removeStyle', ['font-size']);
	this.__exec('paragraphFormat.apply', [tag]);
};

_me._placeholder = function (placeholder) {
	this._editor.opts.placeholderText = getLang(placeholder || '');
	setTimeout(function() {
		this.__exec('placeholder.refresh', [], true);
	}.bind(this), 5);
};

_me.__checkMenu = function(e, timeout) {
	clearTimeout(this.__checkMenuTimeout);
	var me = this;
	this.__checkMenuTimeout = setTimeout(function() {
		me.__checkMenuHandler(e);
	}, timeout || 250);
};

_me._parentElementTag = function(el, parentTagNames) {
	while(el.tagName !== 'BODY') {
		if(~parentTagNames.indexOf(el.tagName)) {
			return el;
		}
		el = el.parentNode;
	}
};

_me.__checkMenuHandler = function(e) {
	if (this._destructed || this.__coded || (e && (e.which || e.keyCode) === 13))
		return;

	// Parse HTML
	var buffer = {}, buffers = [], elms, r, tmp;

	r = this._getRange();

	this.__currentSelectionElements = [];
	if(r) {
		if (r.startContainer === r.endContainer) {
			if ('BODY' === r.startContainer.nodeName) {
				this.__currentSelectionElements.push(r.startContainer);
			} else {
				this.__currentSelectionElements.push(r.startContainer.parentNode);
			}
		} else {
			this.__traverseSelection(r.startContainer, r.endContainer);
		}
	}

	elms = this.__currentSelectionElements;

	var baseElm = mkElement('div', {
		textContent: 'test',
		style: {
			fontSize: '1rem',
			position: 'absolute',
			opacity: 0
		}
	}, this.__ownerDocument);
	document.body.appendChild(baseElm);
	var baseSize = parseFloat(this.__getStyle(baseElm, 'font-size'));
	document.body.removeChild(baseElm);

	for (var i in elms) {
		if(!elms[i]) {
			continue;
		}
		if (r.startContainer !== r.endContainer) {
			buffer = {};
		}

		//Bold
		if (!buffer.BOLD)
			buffer.BOLD = this.__testStyle(elms[i], 'font-weight', 'bold') || this._parentElementTag(elms[i], ['B', 'STRONG']);
		if (!buffer.ITALIC)
			buffer.ITALIC = this.__testStyle(elms[i], 'font-style', 'italic') || this._parentElementTag(elms[i], ['I', 'EM']);
		if (!buffer.UNDERLINE)
			buffer.UNDERLINE = this._parentElementTag(elms[i], ['U']);

		if (!buffer.STRIKETHROUGH)
			buffer.STRIKETHROUGH = this._parentElementTag(elms[i], ['STRIKE', 'S']);

		if (!buffer.SUBSCRIPT)
			buffer.SUBSCRIPT = this._parentElementTag(elms[i], ['SUB']);

		if (!buffer.SUPERSCRIPT)
			buffer.SUPERSCRIPT = this._parentElementTag(elms[i], ['SUP']);

		//Align
		if (!buffer.LEFT && !buffer.RIGHT && !buffer.CENTER && !buffer.JUSTIFY) {
			buffer.LEFT = this.__testStyle(elms[i], 'text-align', 'left');
			if (!buffer.LEFT) {
				buffer.RIGHT = this.__testStyle(elms[i], 'text-align', 'right');
				if (!buffer.RIGHT) {
					buffer.CENTER = this.__testStyle(elms[i], 'text-align', 'center');
					if (!buffer.CENTER) {
						buffer.JUSTIFY = this.__testStyle(elms[i], 'text-align', 'justify');

						tmp = elms[i].getAttribute('align');
						if (tmp)
							buffer[tmp.toUpperCase()] = true;
					}
				}
			}
		}

		//Lists
		if (!buffer.UNORDERED)
			buffer.UNORDERED = this._parentElementTag(elms[i], ['UL']);
		if (!buffer.ORDERED)
			buffer.ORDERED = this._parentElementTag(elms[i], ['OL']);

		//Headings
		var elm = elms[i];
		while(!buffer.HEAD && elm.tagName !== 'BODY') {
			var match = elm.tagName.match(/^H(\d)$/);
			if(match && match[1]) {
				buffer.HEAD = +match[1];
			}
			elm = elm.parentNode;
		}

		//Indent
		if (!buffer.INDENT) {
			tmp = this.__getStyle(elms[i], 'margin-left');
			buffer.INDENT = (tmp && tmp != 0 && tmp != '0px');
		}

		//Font
		if (!buffer.FAMILY)
			buffer.FAMILY = this.__getStyle(elms[i], 'font-family') || elms[i].getAttribute('face') || this.__font_family;

		if (elms[i].getAttribute('size'))
			buffer.SIZE = {1: '10', 2: '13', 3: '16', 4: '18', 5: '24', 6: '32'}[elms[i].getAttribute('size')];
		else {
			tmp = this.__getStyle(elms[i], 'font-size') || this.__font_size;
			if (tmp) {
				buffer.SIZE = parseFloat(tmp) / baseSize * 13;
			}
		}

		buffer.color = this.__getStyle(elms[i], 'color', this.__doc());
		if(buffer.color) {
			this.__oldFcolor = buffer.color;
		}
		buffer.bgcolor = this.__getStyle(elms[i], 'background-color', this.__doc());
		if(buffer.bgcolor) {
			this.__oldBcolor = buffer.bgcolor;
		}

		buffers.push(buffer);
	}

	buffer = this.__mergeStyles(buffers);

	var f = '0';
	if (buffer.FAMILY) {
		var aFamily = buffer.FAMILY.toLowerCase().replace(/"/g, '').split(','),
				iTmp1, iTmp2 = -1;

		for (var ifn in aFamily)
			for (var sfn in this.__fonts)
				if ((iTmp1 = inArray(this.__fonts[sfn][1], aFamily[ifn])) > -1 && (iTmp2 < 0 || iTmp1 < iTmp2)) {
					iTmp2 = iTmp1;
					f = sfn;
				}
	}
	buffer.FONT = f;
	this.font._value(buffer.FONT, true);
	this.size._value(buffer.SIZE, true);

	//Set menu
	tmp = this.__ownerDocument.getElementById(this._pathName + '/bold');
	if (buffer.BOLD)
		addcss(tmp, 'active');
	else
		removecss(tmp, 'active');

	tmp = this.__ownerDocument.getElementById(this._pathName + '/italic');
	if (buffer.ITALIC)
		addcss(tmp, 'active');
	else
		removecss(tmp, 'active');

	tmp = this.__ownerDocument.getElementById(this._pathName + '/underline');
	if (buffer.UNDERLINE)
		addcss(tmp, 'active');
	else
		removecss(tmp, 'active');

	tmp = this.__ownerDocument.getElementById(this._pathName + '/strikeThrough');
	if (buffer.STRIKETHROUGH)
		addcss(tmp, 'active');
	else
		removecss(tmp, 'active');

	tmp = this.__ownerDocument.getElementById(this._pathName + '/subscript');
	if (buffer.SUBSCRIPT)
		addcss(tmp, 'active');
	else
		removecss(tmp, 'active');

	tmp = this.__ownerDocument.getElementById(this._pathName + '/superscript');
	if (buffer.SUPERSCRIPT)
		addcss(tmp, 'active');
	else
		removecss(tmp, 'active');

	if ((tmp = this.__ownerDocument.getElementById(this._pathName + '/font')))
		tmp.innerHTML = this.__fonts[buffer.FONT] ? this.__fonts[buffer.FONT][0].escapeHTML() : getLang('RICH::FONT');

	tmp = this.__ownerDocument.getElementById(this._pathName + '/align');
	if (buffer.JUSTIFY)
		tmp.className = 'ico icojustify';
	else
	if (buffer.CENTER)
		tmp.className = 'ico icocenter';
	else
	if (buffer.RIGHT)
		tmp.className = 'ico icoright';
	else
		tmp.className = 'ico icoleft';


	tmp = this.__ownerDocument.getElementById(this._pathName + '/ordered');
	if (buffer.UNORDERED)
		tmp.className = 'ico icounordered';
	else
		tmp.className = 'ico icoordered';

	this._getAnchor('color').getElementsByTagName('SPAN')[0].style.backgroundColor = buffer.color;
	this._getAnchor('bgcolor').getElementsByTagName('SPAN')[0].style.backgroundColor = buffer.bgcolor;

	this.__currentStyle = buffer;

	tmp = this.__ownerDocument.getElementById(this._pathName + '/undo');

	this.__exec('undo.saveStep', [], true);
	if (this.__exec('undo.canDo', [], true))
		removecss(tmp, 'disabled');
	else
		addcss(tmp, 'disabled');

	tmp = this.__ownerDocument.getElementById(this._pathName + '/redo');
	if (this.__exec('undo.canRedo', [], true))
		removecss(tmp, 'disabled');
	else
		addcss(tmp, 'disabled');
};

//Dynamic text analyse
_me.__testStyle = function (elm, attr, styleValue) {
	var style = this.__getStyle(elm, attr, this.__doc());
	var font = this.__getStyle(elm, 'font', this.__doc());

	if (style || font)
		return (style.toLowerCase() == styleValue || font.toLowerCase().indexOf(styleValue.toLowerCase()) != -1) ? true : false;
	else
		return false;
};

_me.__getStyle = function (elm,styleProp,doc){
	return (doc || document).defaultView.getComputedStyle(elm,null).getPropertyValue(styleProp) || '';
};

////////////////// NEW //////////////////

_me._getSelection = function(){
	return window.getSelection ? this.__eFrame.contentWindow && this.__eFrame.contentWindow.getSelection() : this.__doc().selection;
};

_me._getRange = function(){
	var s = this._getSelection();
	if(!s || s.rangeCount === 0) { return }
	return (s.rangeCount > 0) ? s.getRangeAt(0) : s.createRange();
};

_me._selectRange = function(rng,s){
	if (window.getSelection) {
		s.removeAllRanges();
		s.addRange(rng);
	}
	else
		rng.select();
};

_me.__exec = function (cmd, args, bSkipFocus, callback) {
	if(!this.__initialized) {
		return setTimeout(this.__exec.bind(this, cmd, args, bSkipFocus, callback), 5);
	}

	var result, fn = this._editor;
	try {
		cmd = cmd.split('.');
		while(cmd.length) {
			fn = fn[cmd.shift()];
		}
		result = fn.apply(this._editor, args);
		if(!bSkipFocus) {
			this._focus(true);
			this.__checkMenu(false, 5);
		}
	} catch(e) {
		 console.warn(this._name, '__exec', cmd, e);
	}
	callback && callback();
	return result;
};

////////////////////////////////////////////////////////////////////////

_me.__code = function () {
	if (this.__coded) {
		this._disable(0, 'code');

		var v = '';
		if (this.__coded.parentNode) {
			v = this.__coded.value;
			this.__coded.parentNode.removeChild(this.__coded);
		}
		this.__coded = false;

		this._value(v);

		this._getAnchor('frame').style.display = '';
	} else {
		this._disable(1, 'code');

		this.__img_removeEdit();

		var txt = this.__doc().body.innerHTML.replace(/\r/gm, '').replace(/\n/gm, "\r\n");

		this._getAnchor('frame').style.display = 'none';

		var me = this;
		this.__coded = mkElement('textarea', {dir: "auto"});
		this.__coded.onblur = function (e) {
			if (me['_on' + e.type] && !me['_on' + e.type](e)) {
				e.preventDefault();
				e.stopPropagation();
			}
		};

		this._getAnchor('msiebox').appendChild(this.__coded);
		this.__coded.value = txt;
	}
};

_me.__getSpellLang = async function () {
	await storage.library('gw_others');
	return GWOthers.getItem('MAIL_SETTINGS_DEFAULT', 'spellchecker');
};

_me.__spell_uncheck = function (elm, doc) {

	if (elm && elm.tagName == 'SPAN'){
		elm = [elm];
	}
	else{
		elm = elm || this.__doc().body;
		elm = elm.querySelectorAll('span[fr-iw-spell]');
	}

	doc = doc || this.__doc();
	for (var i = elm.length; i--;){
		elm[i].parentNode.replaceChild(doc.createTextNode(elm[i].innerHTML), elm[i]);
	}
};

_me.__spell = async function () {

	var me = this;
	// Disable spellchecker
	if (this.__spelled) {
		if (this.__spelled == 2)
			return;
		else
			this.__spelled = 2;

		this.__spell_uncheck();

		this._onclick = null;

		this.__spelled = false;
		this._disable(this.__disable_status);
		removecss(this.__ownerDocument.getElementById(this._pathName + '/spell'), 'active');

		this.__doc().body.setAttribute('spellcheck','true');
		return;
	}

	var checklang = this.__getSpellLang();
	if (!checklang)
		return;

	this.__doc().body.setAttribute('spellcheck','false');

	this.__spellwords = [];
	this.__spelled = 2;

	// Enable spellchecker
	this.__disable_status = this.__disabled;

	var arr = [],
		str = me.__doc().body.innerHTML;//this._value(null, false, true);

	//prepare text for Aspell
	var sOld = str.removeTags(' ').unescapeHTML();
	//var sOld = createTextVersion(str).unescapeHTML();
	sOld = sOld.replace(/([.,…„;&:"`“”[\]{}()~—=_!¿?|\\/< >]+)/gm, ' ');

	await storage.library('wm_spellchecker');
	var iqspell = new wm_spellchecker(),
		aStr = await iqspell.get({type: 'check', lang: checklang, input: sOld});

	if (Is.Empty(aStr)) {
		this.__spelled = false;
		return;
	}

	var tmp = '', istart = 0, iend = 0, ilen = str.length,
		tmpIndex, tmpString, tmpLength,
		regexp = /^([.,…„:"'`‘“”’[\]{}()~\s=_!¿?<>|\\/]+)$/g;

	while (true) {

		iend = str.indexOf('<', istart);

		if (iend < 0)
			iend = ilen;
		else
		if (iend == 0) {
			istart = str.indexOf('>');
			if (istart < 0)
				break;
			istart++;
			continue;
		}

		tmp = str.substring(istart, iend);

		//nahradit
		if (tmp.trim()) {
			for (var j in aStr) {

				tmpLength = aStr[j].length;

				while (true) {
					tmpIndex = tmp.indexOf(aStr[j], tmpIndex);
					if (tmpIndex < 0)
						break;

					tmpString = '';
					if (tmpIndex > 0)
						tmpString += tmp.charAt(tmpIndex - 1);

					if (tmpIndex + tmpLength < (iend - istart))
						tmpString += tmp.charAt(tmpIndex + tmpLength);

					if (tmpString.length == 0 || tmpString.match(regexp))
						arr.push([istart + tmpIndex, tmpLength, aStr[j]]);

					tmpIndex += tmpLength;
				}
			}
		}

		if (iend == ilen)
			break;

		istart = str.indexOf('>', iend);
		istart = istart > 0 ? istart + 1 : iend;
	} //while end

	if (count(arr)) {

		function sortarr(a, b) {
			return a[0] - b[0];
		}
		arr.sort(sortarr);

		var subcount = 0,
			sublen = '<span fr-iw-spell="true"></span>'.length;

		for (var i in arr) {
			str = str.substring(0, arr[i][0] + subcount) + '<span fr-iw-spell="true">' + str.substr(arr[i][0] + subcount, arr[i][1]) + '</span>' + str.substring(arr[i][0] + arr[i][1] + subcount);
			subcount += sublen;
		}

		this._disable(true);

		//DISABLE RICHAREA
		addcss(this.__ownerDocument.getElementById(this._pathName + '/spell'), 'active');

		this._onclick = async function (e) {
			var elm = e.target;

			// Skip if click not on faulty word or if not left clicking
			if (!(elm.tagName === 'SPAN' && elm.hasAttribute('fr-iw-spell')) || e.button != 0 && this.__ownerDocument.documentMode != 8)
				return true;

			var aMenu = [],
					plain = elm.innerHTML.removeTags();

			if (elm.id) {
				aMenu.push({text: me.__spellwords[elm.id].entityify(), arg: [me, '__swapword', [elm, me.__spellwords[elm.id]], true]});
				if (me.__spellwords[elm.id] != plain)
					aMenu.push({text: plain.entityify(), arg: [me, '__swapword', [elm, elm.innerHTML]]});
			} else {
				elm.id = me.__spellwords.length;
				me.__spellwords[elm.id] = plain;
				aMenu.push({text: plain.entityify(), arg: [me, '__swapword', [elm, elm.innerHTML]]});
			}

			try {
				var aSuggest = await iqspell.get({type: 'suggest', lang: checklang, input: me.__spellwords[elm.id]});
				aSuggest = aSuggest[aSuggest[0]];

				if (!Is.Empty(aSuggest))
					aMenu.push({"title": '-'});

				var j = 0;
				for (var i in aSuggest) {
					if (j > 15)
						break;
					aMenu.push({text: aSuggest[i].entityify(), arg: [me, '__swapword', [elm, aSuggest[i], true]]});
					j++;
				}
			} catch (er) {
				 console.log(this._name || false, er);
			}

			me.spell = await this._gui._create('spellcheck', 'obj_context', '');
			await me.spell._fill(aMenu);

			var pos2 = getSize(elm);

			me.spell._place(pos2.x + (pos2.w / 2), pos2.y + pos2.h, '', 1);

			return false;
		};

		this.__spelled = true;
		// this._value(str, true);
		me.__doc().body.innerHTML = str;
	} else{
		this.__spelled = false;
		this.__doc().body.setAttribute('spellcheck','true');
	}
};

_me.__swapword = function (elm, str, ok) {
	if (elm) {
		elm.innerHTML = str;
		elm.setAttribute('fr-iw-spell', ok?'false':'true');
	}
};

_me.__closeInsertTooltip = function() {
	var elm = this.__ownerDocument.getElementById(this._pathName + '/insert');
		elm && elm.classList.remove('active');
		elm = this._getAnchor('insert_toolbar');
		elm && this._getAnchor('insert_toolbar').classList.add('hidden');
};

_me.__initpopup = async function (type, skipDestruct, options) {
	var me = this;

	me.__exec('selection.save', [], true);

	if (this.popup && !skipDestruct)
		this.popup._destruct();

	if (gui.focus)
		gui.focus._suppress = true;


	if (~['B', 'F', 'C'].indexOf(type)) {
		return await this._gui._create(
			'color_picker', 'frm_color_picker', '', '',
			'RICH::' + (type === 'C' ? 'BORDERCOLOR' : (type === 'B' ? 'BGCOLOR' : 'COLOR')),
			this['__old' + type + 'color'],
			[function (sColor) {
				if (sColor !== void 0) {
					me[type === 'C' ? '_setBorderColor' : (type === 'B' ? '_setBColor' : '_setFColor')](sColor);
				}
			}]
		);
	}


	var popup = await this._gui._create('rich_popup', 'obj_popup_tab', '', 'noblur obj_rich_popup obj_rich_popup_' + type);
	popup._size(300, 200, true);
	popup._modal(true);
	popup._resizable(false);
	popup._dockable(false);
	popup._add_destructor('__removeSelection');
	popup.__removeSelection = function() {
		me.__exec('selection.restore', [], true);
	};

	if (!skipDestruct)
		this.popup = popup;

	// Create 'OK' button
	await popup._create('btn_ok', 'obj_button', 'footer', 'ok noborder color1');
	popup.btn_ok._value('FORM_BUTTONS::OK');

	// Create 'CANCEL' button
	await popup._create('btn_cancel', 'obj_button', 'footer', 'cancel noborder');
	popup.btn_cancel._value('FORM_BUTTONS::CANCEL');
	popup.btn_cancel._onclick = function () {
		this._parent._destruct();
		if (gui.focus)
			gui.focus._suppress = false;
	};

	switch (type) {
		case 'P':
			popup._title('RICH::PASTEW');
			await popup._draw('obj_rich_paste', 'main');
			popup._size(450, 250, true);
			popup.btn_ok._onclick = function () {
				me.__closeInsertTooltip();
				me.__exec('html.insert', [this._parent.input._value().entityify().replace(/\n/g, '<br>\n').replace(/\t/g, '    ').replace(/\s{2}/gm, ' &nbsp;').replace(/\n/g, ''), true], false, function() {
					me.__exec('undo.saveStep');
				});
				this._parent._destruct();
				if (gui.focus)
					gui.focus._suppress = false;
			};
			break;
		case 'T':
			popup._title('RICH::TABLE');
			await popup._draw('obj_rich_table', 'main');
			popup._size(520, 'auto', true);
			popup._border_color = '000000';
			popup._getAnchor('color_picker').onclick = function (e) {
				me.__clickColor(e);
			};
			popup._getAnchor('color_picker').getElementsByTagName('SPAN')[0].style.backgroundColor = this.__oldCcolor;
			popup.btn_ok._onclick = function () {
				me.__closeInsertTooltip();
				me._insTable({"padding": (!this._parent.padding._checkError || !this._parent.padding._checkError.length ? this._parent.padding._value() : 0),
					"spacing": (!this._parent.spacing._checkError || !this._parent.spacing._checkError.length ? this._parent.spacing._value() : 0),
					"border": this._parent.border._value(),
					"color": me.__oldCcolor.replace('#', ''),
					"columns": (!this._parent.columns._checkError || !this._parent.columns._checkError.length ? this._parent.columns._value() : 4),
					"rows": (!this._parent.rows._checkError || !this._parent.rows._checkError.length ? this._parent.rows._value() : 4)});

				this._parent._destruct();
				if (gui.focus)
					gui.focus._suppress = false;
			};
			break;

		case 'I':
			if (!options.image) {
				return me.__closeInsertTooltip();;
			}
			popup._title('RICH::IMAGE');
			await popup._draw('obj_rich_image', 'main', {
				image: options.image
			});

			popup.alt._value(options.image.getAttribute('alt'));
			popup.border._value(options.image.getAttribute('border'));
			popup.spacing._value(options.image.getAttribute('hspace'));
			var match;
			['width', 'height'].forEach(function(m) {
				if((match = options.image.style[m].match(/^([\d.]+)(px|%)?$/) || (options.image.getAttribute(m) || '').match(/^([\d.]+)(px|%)?$/))) {
					popup[m]._value(match[1]);
					popup[m + '_unit']._value({px: 0, '%': 1}[match[2] || 'px']);
				}
			});

			popup.btn_ok._onclick = function () {
				me.__closeInsertTooltip();

				var border = this._parent.border._value(),
					spacing = parseInt(this._parent.spacing._value(), 10),
					width = parseFloat(this._parent.width._value()),
					height = parseFloat(this._parent.height._value());

				width = width ? width + ['px', '%'][this._parent.width_unit._value()] : (options.image.style.width || parseFloat(options.image.getAttribute('width')) || options.image.parentNode.style.width || parseFloat(options.image.parentNode.getAttribute('width')));
				height = height ? height + ['px', '%'][this._parent.height_unit._value()] : (options.image.style.height || parseFloat(options.image.getAttribute('height')) || options.image.parentNode.style.height || parseFloat(options.image.parentNode.getAttribute('height')));

				var opt = {
					id: 'img-' + unique_id(),
					src: options.image.getAttribute('src'),
					alt: this._parent.alt._value(),
					border: border,
					hspace: spacing,
					vspace: spacing,
					style: {}
				};

				if (!width && !height){
					opt.style = 'max-width: 100%;';
				} else {
					if (width){
						opt.style.width = width;
					}
					if (height){
						opt.style.height = height;
					}
				}

				var img = mkElement('img', opt);

				var original = options.image;
				me.__img_removeEdit();

				var range = me.__doc().createRange();
				var selection = me.__doc().defaultView.getSelection();
				var index = [].slice.call(original.parentNode.children).indexOf(original);
				range.setStart(original.parentNode, index);
				range.setEnd(original.parentNode, index + 1);
				selection.removeAllRanges();
				selection.addRange(range);
				original.parentNode.removeChild(original);

				me.__exec('html.insert', [img.outerHTML, true], false, function() {
					me.__exec('undo.saveStep');
				});

				this._parent._destruct();
				if (gui.focus)
					gui.focus._suppress = false;
			};
			popup._size(550, 'auto', true);

			break;
		case 'L':

			//read previous link value
			var s = this._getSelection(),
					surl = '',
					slabel = '',
					sstyle = '',
					r, a;

			if(s && s.getRangeAt && s.rangeCount) {
				r = s.getRangeAt(0);
			}

			try {
				a = s.anchorNode && this._parentElementTag(s.anchorNode, ['A']);
				if (s && s.anchorNode && a) {
					surl = a.getAttribute('href');
					slabel = a.textContent;
					sstyle = a.getAttribute('style');
				}
				else
				if (r){

					// if (r.startContainer !== r.endContainer){
					// 	slabel = r.startContainer.textContent.substring(r.startOffset) + r.endContainer.textContent.substring(0,r.endOffset);
					// }
					// else{
					// 	slabel = s.anchorNode.parentNode.textContent;
					// 	if (r.startOffset !== r.endOffset){
					// 		slabel = slabel.substring(r.startOffset,r.endOffset);
					// 	}
					// }

					//Trim trailing whitespace from selection & value
					slabel = s.toString();
					var oTrim = /\s+$/g.exec(slabel);
					if (oTrim && oTrim.index>0){
						r.setEnd(r.endContainer, r.endOffset + oTrim.index - slabel.length);
						slabel = s.toString();
					}
				}
			} catch (r) {
				 console.log(this._name || false, r);
			}

			popup._title('RICH::ADDLINK');
			await popup._draw('obj_rich_link', 'main');

			if(a) {
				await popup._create('btn_remove', 'obj_button', 'footer', 'simple color2 x_btn_right');
				popup.btn_remove._value('FORM_BUTTONS::REMOVE');
				popup.btn_remove._onclick = function() {
					me.__closeInsertTooltip();
					me.__exec('link.remove');
					popup._destruct();
				};
			}

			popup.input._value(surl);
			popup.label._value(slabel);
			if(!popup.input._value()) {
				popup.input._focus();
			}

			popup.label.__eIN.addEventListener('change', function (e) {
				if(!e.target.value.indexOf('http') && !popup.input._value()) {
					popup.input._value(e.target.value);
				}
			});

			popup.input._onsubmit = function () {
				this._parent.btn_ok._onclick();
			};

			popup.label._onsubmit = function () {
				this._parent.btn_ok._onclick();
			};

			popup.input._onkeyup = function () {
				if(!slabel) {
					popup.label._value(this._value());
				}
			};

			popup.label._onkeyup = function () {
				slabel = this._value();
			};

			popup.btn_ok._onclick = function () {
				me.__closeInsertTooltip();

				var v = this._parent.input._value().trim();

				//Extend selection to parent anchor
				if (a) {

					if (s.isCollapsed) {

						if (s.rangeCount > 0)
							s.removeAllRanges();

						var range = me.__ownerDocument.createRange();
						range.selectNode(a);
						s.addRange(range);
					}

					//Remove old link
					me.__exec('link.remove');
				}

				//Add new link
				if (v) {

					var tmp = mkElement('A', {href:v});

					//register new protocol
					var sProtocol = tmp.protocol.slice(0,-1);
					if (!~FroalaEditor.LinkProtocols.indexOf(sProtocol))
						FroalaEditor.LinkProtocols.push(sProtocol);

					var marker = me.__doc().querySelector('.fr-marker');
					if (!a && (!me.__selection || me.__selection.getRangeAt(0).collapsed)) {
						marker.insertAdjacentElement('beforebegin', mkElement('a', {
							href: v,
							textContent: slabel || v,
							target: '_blank',
							rel: 'nofollow'
						}))
					} else {
						me.__exec('link.insert', [v, slabel || v, {'target': '_blank', 'rel': 'nofollow', style: sstyle || ''}], true);
					}
				}
				popup._destruct();
				if (gui.focus)
					gui.focus._suppress = false;
			};
			popup._size(400, 'auto', true);

			break;
	}
};

// Note, this method returns the Window object, not an element...
_me._getFocusElement = function () {
	return this.__eFrame.contentWindow;
};

_me._focus = function (bNow, bTop) {

	if (!this.__eFrame.offsetParent || this.__eFrame.offsetParent.tagName === 'BODY')
		return false;

	var elm = this.__doc().getElementsByTagName("body")[0];
	// Set focus (cursor) to rich text area
	setTimeout(function () {
		elm.focus();
	}, 0);
	// If requested, set cursor to top of text area
	if (bTop) {
		var sel;
		try {
			sel = this.__eFrame.contentWindow.getSelection();
		} catch {
			sel = this.__doc().selection.createRange();
		}
		if (sel && elm)
			sel.collapse(elm, 0);
	}

	return true;
};

_me._disable = function (b, css) {
	this.font._disabled(b);
	this.size._disabled(b);

	if (this._getAnchor('insert_toolbar'))
		[].forEach.call(this._getAnchor('insert_toolbar').querySelectorAll('span a:not(.icopastew)'), function(a) {
			a.classList[b ? 'add' : 'remove']('disabled');
		});

	if (b) {
		if (this.__spelled && this.__spelled !== 2)
			this.__disable_status = true;

		if (this.__coded && !css)
			this.__code();

		this.__disabled = true;

		addcss(this._main, 'disabled', css);
	} else {
		if (this.__spelled && this.__spelled !== 2)
			this.__disable_status = false;
		else {
			this.__disabled = false;

			removecss(this._main, 'disabled', css);
		}
	}
};

_me._value = function (v, bSkipSpell, bForceHTML, callback) {
	var aStyles = [], aLinks = [], dir = GWOthers.getItem('MAIL_SETTINGS_DEFAULT', 'text_direction') || "ltr";

	if (Is.String(v)) {

		if (!bSkipSpell && this.__spelled)
			this.__spell();

		removecss(this.__doc().body, 'placeholder');

		//Sanitize
		v = v.replace(/&ldquo;/g, '“');
		v = v.replace(/<!--\[if[\w\W]*?\[endif\]-->/g, ''); // strip conditional comments
		v = v.replace(/<style[\w\W]*?<\/style>/g, function(match) { // cut styles
			aStyles.push(match.replace(/(onload|onerror)=".*?"/g, ''));
			return '';
		});
		v = v.replace(/\s*<link(.*?)\/?>\s*/g, function(link) {
			aLinks.push(link.replace(/(onload|onerror)=".*?"/g, '').trim());
			return '';
		});
		aStyles = aStyles.filter(function(style) {
			return style !== '<style></style>';
		});
		v = v.replace(/(style="[^"]*?:)\n([^"]*?")/g, '$1$2'); // fix multiline inline styles
		v = DOMPurify.sanitize(v);

		v = v.replace(/<br\s*\/?>\s+/g, '<br>');

		//link security fix
		//v = NewMessage.linkFix(v);

		if (this.__coded)
			this.__coded.value = v;
		else {
			if(this.__disabled && !this.__spelled) {
				v = v.replace(/\n/g, '<br>');
			}

			// this._editor.opts.htmlUntouched = true;
			this.__exec('html.set', [v], true, function() {
				// this._editor.opts.htmlUntouched = false;
				aStyles.length && this.__doc().body.insertAdjacentHTML('beforeend', aStyles.join('')); // paste styles
				aLinks.length && this.__doc().body.insertAdjacentHTML('beforeend', aLinks.join('')); // paste styles

				function imageErrorHandler(e) {
					if (!~(e.target.src || '').indexOf('/teamchatapi/http.download')) {
						e.target.src = location.origin + '/teamchatapi/http.download?token=' + sPrimaryAccountTeamchatToken + '&url=' + encodeURIComponent(e.target.src.unentityify());
						e.target.removeEventListener('error', imageErrorHandler, false);
					}
				}
				[].forEach.call(this.__doc().querySelectorAll('img'), function(img) {
					img.addEventListener('error', imageErrorHandler, false);
				});

				if (this.__doc().onfocus)
					this.__doc().onfocus();
				callback && callback();
			}.bind(this));
		}
	} else {
		var sBody = '';
		if (this.__coded)
			sBody = this.__coded.value;
		else {

			this.__img_removeEdit();

			dir = this.__doc().body.getAttribute('dir') || dir;

			[].concat(this._tableStyles, this._tableCellStyles).forEach(function(style) {
				style.styles.forEach(function(style) {
					[].forEach.call(this.__doc().body.querySelectorAll(style.selector), function(el) {
						for(var i in style.style) {
							el.style.setProperty(i, style.style[i]);
						}
					});
				}, this);
			}, this);

			//sBody = this.__exec('html.get', [], true); // causes "Error: A security problem occurred." on some links
			sBody = this.__doc().body.innerHTML;
			var tmp = document.createElement('template');
				tmp.innerHTML = sBody;

			[].forEach.call(tmp.content.querySelectorAll('img'), function(img) {
				try {
					if (~(img.src || '').indexOf('/teamchatapi/http.download')) {
						var url = new URL(img.src);
						url = parseURL(url.search).url;
						img.src = url;
					}
				} catch {
					//
				}
			});

			if (!bSkipSpell && this.__spelled) {
				this.__spell_uncheck(tmp.content, document);

				if (this.__disable_status && !bForceHTML) {
					sBody = createTextVersion(tmp.innerHTML, {
						linkProcess: function(href, linkText) {
							return linkText || href;
						},
						imgProcess: function() {
							return '';
						}
					});
				}
			} else if (this.__disabled && !bForceHTML) {
				sBody = createTextVersion(tmp.innerHTML, {
					linkProcess: function(href, linkText) {
						return linkText || href;
					},
					imgProcess: function() {
						return '';
					}
				});
			} else {
				sBody = tmp.innerHTML;
			}
		}

		sBody = DOMPurify.sanitize(sBody);

		//Default Body style
		if (this.__output_format) {
			if(this.__opt.isEmail) {
				var xtmp = document.createElement('template');
					xtmp.innerHTML = sBody;
				if (xtmp.content.firstElementChild && xtmp.content.firstElementChild.className !== 'iw_mail') {
					var sBodyStyle = '';
					if (this.__font_family)
						sBodyStyle = 'font-family: ' + this.__font_family + ';';

					if (this.__font_size)
						sBodyStyle += 'font-size: ' + this.__font_size / 13 + 'rem;';

					sBody = '<div class="iw_mail" dir="' + dir.toLowerCase() + '"' + (sBodyStyle ? ' style="' + sBodyStyle + '"' : '') + '>' + sBody + '</div>';
				}
			}
		}

		sBody = (sBody === '<br>' || sBody === NewMessage.crlf) ? '' : sBody;
		return sBody.trim();
	}
};

_me._insAdjacentHTML = function(elm){
	if (elm){
		elm.insertAdjacentHTML.apply(elm, [].slice.call(arguments,1));
		this._editor.size.syncIframe();
	}
};

_me._insTable = function (aData) {
	var me = this,
	html = '<span>&nbsp;</span><table style="width:' + (aData.columns * 30) + 'px; border: ' + aData.border + 'px #' + (aData.color || '000000') + '"' + (aData.padding ? ' cellpadding="' + aData.padding + '"' : '') + (aData.spacing ? ' cellspacing="' + aData.spacing + '"' : '') + '>';
	for (var i = 0; i < aData.rows; i++) {
		html += '<tr>';
		for (var j = 0; j < aData.columns; j++)
			html += '<td></td>';
		html += '</tr>';
	}
	html += '</table><span>&nbsp;</span>';

	this.__exec('html.insert', [html, true], false, function() {
		me.__exec('undo.saveStep');
	});
};

_me.__clickColor = function (e) {
	var elm = e.target;

	if (elm.tagName === 'A') {
		var id = elm.id.substr(elm.id.indexOf('#'));
		this.__initpopup(id === '#color_picker' ? 'C' : (id === '#color' ? 'F' : 'B'), true);
	}
};

_me._setFColor = function (color) {
	if(color) {
		var selection = this._getSelection();
		if(selection && selection.focusNode && selection.focusNode.nodeType === 3 && selection.focusNode.parentNode.nodeName === 'A') {
			selection.focusNode.parentNode.style.color = color;
		} else {
			this.__exec('format.applyStyle', ['color', color]);
		}
	} else {
		this.__exec('format.removeStyle', ['color']);
	}
};

_me._setBColor = function (color) {
	if(color) {
		this.__exec('colors.background', [color]);
	} else {
		this.__exec('format.removeStyle', ['background-color']);
	}
};

_me._setBorderColor = function (color) {
	gui.rich_popup._getAnchor('color_picker').getElementsByTagName('SPAN')[0].style.backgroundColor = this.__oldCcolor = color;
};

///////////////////// EDIT IMAGE ///////////////////////

_me.__img_removeEdit = function (bRemove) {
	var out;
	if (this.__activeImage) {
		if (this.__activeImage.box && this.__activeImage.box.parentNode)
			if (bRemove)
				this.__activeImage.box.parentNode.removeChild(this.__activeImage.box);
			else {
				this.__img_applyEdit();
				this.__activeImage.box.parentNode.replaceChild(this.__activeImage.original, this.__activeImage.box);

				out = this.__activeImage.original;
			}

		delete this.__activeImage;
	}

	return out;
};

_me.__img_applyEdit = function () {
	var elm = this.__activeImage.original;

	if (this.__activeImage && elm) {

		//Adaptive
		switch(this.__activeImage.mode){
			case 'adopt':
				elm.style.maxWidth = '100%';
				elm.style.width = 'auto';
				elm.style.height = 'auto';
				break;

			case 'native':
				elm.style.maxWidth = '';
				elm.style.width = 'auto';
				elm.style.height = 'auto';
				break;

			//Size
			default:
				elm.style.maxWidth = '';
				elm.style.width = this.__activeImage.w + 'px';
				elm.style.height = this.__activeImage.h + 'px';

				if (this.__activeImage.abs) {
					elm.style.top = this.__activeImage.abs.t + 'px';
					elm.style.left = this.__activeImage.abs.l + 'px';
				}
		}
	}
};

_me.__img_dispatch = function () {
	gui._disobeyEvent('mousemove', [this, '__img_resize']);
	gui._disobeyEvent('mousemove', [this, '__img_move']);
	return false;
};
_me.__img_move = function (e, info, arg) {
	if (arg.abs) {
		//X
		this.__activeImage.abs.l = arg.abs.l + gui.__X - arg.x;
		this.__activeImage.box.style.left = this.__activeImage.abs.l + 'px';

		//Y
		this.__activeImage.abs.t = arg.abs.t + gui.__Y - arg.y;
		this.__activeImage.box.style.top = this.__activeImage.abs.t + 'px';
	}
};
_me.__img_resize = function (e, info, arg) {
	if (this.__activeImage) {
		var c = arg.h / arg.w,
				abs = 0;

		switch (arg['type']) {
			case 't':
				this.__activeImage.h = arg.h - (e.clientY - arg.y);
				abs = 3;
				break;
			case 'b':
				this.__activeImage.h = arg.h + e.clientY - arg.y;
				break;
			case 'lm':
				this.__activeImage.w = arg.w - (e.clientX - arg.x);
				abs = 3;
				break;
			case 'rm':
				this.__activeImage.w = arg.w + e.clientX - arg.x;
				break;

			case 'lt':
				if (arg.x - e.clientX < arg.y - e.clientY) {
					this.__activeImage.h = arg.h - (e.clientY - arg.y);
					this.__activeImage.w = this.__activeImage.h / c;
				} else {
					this.__activeImage.w = arg.w - (e.clientX - arg.x);
					this.__activeImage.h = this.__activeImage.w * c;
				}
				abs = 3;
				break;
			case 'rt':
				if (e.clientX - arg.x > arg.y - e.clientY) {
					this.__activeImage.h = arg.h - (e.clientY - arg.y);
					this.__activeImage.w = this.__activeImage.h / c;
				} else {
					this.__activeImage.w = arg.w + e.clientX - arg.x;
					this.__activeImage.h = this.__activeImage.w * c;
				}
				abs = 1;
				break;
			case 'lb':
				if (arg.x - e.clientX > e.clientY - arg.y) {
					this.__activeImage.h = arg.h + (e.clientY - arg.y);
					this.__activeImage.w = this.__activeImage.h / c;
				} else {
					this.__activeImage.w = arg.w - (e.clientX - arg.x);
					this.__activeImage.h = this.__activeImage.w * c;
				}
				abs = 2;
				break;
			case 'rb':
				if (e.clientX - arg.x > e.clientY - arg.y) {
					this.__activeImage.h = arg.h + e.clientY - arg.y;
					this.__activeImage.w = this.__activeImage.h / c;
				} else {
					this.__activeImage.w = arg.w + e.clientX - arg.x;
					this.__activeImage.h = this.__activeImage.w * c;
				}
				break;
		}

		this.__activeImage.box.style.width = this.__activeImage.w + 'px';
		this.__activeImage.box.style.height = this.__activeImage.h + 'px';

		if (abs && arg.abs) {
			if (abs & 1) {
				this.__activeImage.abs.t = arg.abs.t + arg.h - this.__activeImage.h;
				this.__activeImage.box.style.top = this.__activeImage.abs.t + 'px';
			}
			if (abs & 2) {
				this.__activeImage.abs.l = arg.abs.l + arg.w - this.__activeImage.w;
				this.__activeImage.box.style.left = this.__activeImage.abs.l + 'px';
			}
		}
	}

};

/**
 * Traverses html nodes from given start node to end node and saves all tree leaves (text node parents) of the traversed tree section to this.__currentSelectionElements
 *
 * @param {Node} currentNode - Traversal of html tree begins with this node
 * @param {Node} endNode     - Traversal ends at this node
 * @param {Node} [fromChild] - In case we traverse up to parent provide from which child node
 *
 * @returns {undefined}
 */
_me.__traverseSelection = function (currentNode, endNode, fromChild) {
	// We are at tree leaf (text node) - we know parent node of text node or BR node which holds information about the style of the text
	// Add this parent node to stack of selected nodes
	if ((Node.TEXT_NODE === currentNode.nodeType && '' !== currentNode.nodeValue.trim()) || 'BR' === currentNode.nodeName) {
		this.__currentSelectionElements.push(currentNode.parentNode);
	}

	// In case end node of selection was reached stop traversing
	// In case the end node has some children, they must be added to stack (and when we return from children, don't traverse them again - fromChild param)
	if (currentNode === endNode && (0 === currentNode.childNodes.length || fromChild)) {
		return;
	}

	// Current node has children - traverse them
	// In case we already return from children, don't traverse them again - fromChild param
	if (currentNode.childNodes.length > 0 && !fromChild) {
		this.__traverseSelection(currentNode.firstChild, endNode);
		return;
	}

	// Current node has next sibling - traverse it
	if (currentNode.nextSibling) {
		this.__traverseSelection(currentNode.nextSibling, endNode);
		return;
	}

	// Current node has no next sibling or children so return back to parent and provide "fromChild" param to tell next cycle to not traverse children again
	this.__traverseSelection(currentNode.parentNode, endNode, currentNode);
};

/**
 * Accepts multiple sets of styles (font, weight, decoration ...) and create result set where only styles which are common for given sets are present.
 *
 * @param {Array} styles - Set of styles for particular element
 *
 * @returns {Object} Result set
 */
_me.__mergeStyles = function (styles) {
	var	result = {},
		i,
		property;

	if (styles.length > 0) {
		result = styles[0];
	}

	for (i = 1; i < styles.length; i++) {
		for (property in styles[i]) {
			if (styles[i][property] !== styles[0][property]) {
				result[property] = undefined;
			}
		}
	}

	return result;
};

_me._emoji = function(){

	if (this.__emoji) return;
	this.__emoji = true;

	var tmp = mkElement('A', {
		className: 'ico icosmile',
		id: this._pathName + '/emoji'
	});
	gui.tooltip._add(tmp, getLang('SMILES::SMILES'), {
		y: function() {
			return getSize(tmp).y - 28
		}
	});

	var me = this;

	tmp.addEventListener('click', function (e) {
		if(this.classList.contains('active')) {
			me._hideToolbars();
		} else {
			me._showToolbar('emoji');

			// Create Smileys
			me._create('emoji', 'obj_smilebox', 'emoji_toolbar', '', [
				function (smile) {
					var html = '<span class="emoji" alt="' + (smile.label || '').entityify() + '" style="font-size: 20px">' + smile.emoji + '</span> ';
					me.__exec('html.insert', [html, true], true, function() {
						me.__exec('undo.saveStep');
					});
				}
			], [function() {
				me.emoji._main.querySelector('.picmo__header').appendChild(mkElement('div', {
					className: 'close',
					onclick: function() {
						me._hideToolbars();
					}
				}))
			}]);
		}

		e.stopPropagation();
		e.preventDefault();
	});

	this._getAnchor('additional').appendChild(tmp);
};

_me._onbeforedetach = function(callback) {
	this._unhighlight(true);
	this.__highlighter = null;
	this.___value = this._value();
	this._editor.destroy();
	this._editor = null;
	this.__initialized = false;
	callback();
};

_me._ondetach = async function(context) {
	if (this._destructed || this._gui !== context) {
		return;
	}
	await this.__initEditor();
	this._value(this.___value);
};

_me._highlightSelection = function() {
	this.__rangeState = rangy.saveRange(this.__range);
	this.__rangeState2 = rangy.saveRange(this.__range);
	if (!this.__highlighter) {
		this.__highlighter = rangy.createHighlighter(this.__doc());
		this.__highlighter.addClassApplier(rangy.createClassApplier("iw-highlight", {
		}));
	}
	this.__highlighter.highlightSelection('iw-highlight');
	var selection = this.__doc().defaultView.getSelection();
	selection.removeAllRanges();
	this.__exeEvent('selectionHighlighted');
};

_me._unhighlight = function(bSkipHighlight) {
	if (!this.__highlighter) {
		return;
	}

	var selection = this.__doc().defaultView.getSelection();
	if (this.__rangeState) {
		var range = rangy.restoreRange(this.__rangeState);
		selection.removeAllRanges();
		selection.addRange(range.nativeRange);
		this.__rangeState = null;
	}

	this.__highlighter.unhighlightSelection();

	if (this.__rangeState2) {
		range = rangy.restoreRange(this.__rangeState2);
		selection.removeAllRanges();
		if (!bSkipHighlight) {
			selection.addRange(range.nativeRange);
			this.__range = range.nativeRange;
		}
		this.__rangeState2 = null;
	}

	this.__exeEvent('selectionUnhighlighted');
};

_me._selectElement = function(selector) {
	var range = new Range();
	var selection = this.__doc().defaultView.getSelection();
	if (selector) {
		var element = this.__doc().querySelector(selector);
		if (element) {
			if (element.tagName === 'BODY') {
				range.setStartBefore(element.firstElementChild);
				range.setEndAfter(element.lastElementChild);
			} else {
				range.setStartBefore(element);
				range.setEndAfter(element);
			}
		}
	}
	selection.removeAllRanges();
	selection.addRange(range);
	this.__range = range;
	this.__exeEvent('selectionChanged', this, selection);
	return selection;
};

_me._replaceSelection = function(sHtml) {
	if (!this.__range) {
		return;
	}

	var eHtml = this.__doc().createElement("div");
	eHtml.innerHTML = sHtml;

	this._unhighlight();
	var contents = mkElement('div', {}, false, this.__range.cloneContents());
	this.__range.deleteContents();

	var child;
	if ((contents.children.length === 0 || contents.childNodes.length !== contents.children.length) && eHtml.children.length === 1) {
		while((child = eHtml.firstChild.lastChild)) {
			this.__range.insertNode(child);
		}
	} else {
		var lastTag;
		while((child = eHtml.lastChild)) {
			if (child.nodeType === 3) {
				eHtml.removeChild(eHtml.lastChild);
				continue;
			}
			var currentTag = child.tagName;
			if (currentTag === 'P') {
				child = mkElement('div', {
					innerHTML: child.innerHTML
				});
				eHtml.removeChild(eHtml.lastChild);
				if (lastTag === 'P') {
					this.__range.insertNode(mkElement('div', {}, false, [
						mkElement('br')
					]));
				}
			}
			this.__range.insertNode(child);
			lastTag = currentTag;
		}
	}

	this._unhighlight(true);
};

_me._insertAdjacentHTML = function(eElement, sPosition, sHtml) {
	this._unhighlight(true);
	eElement.insertAdjacentHTML(sPosition, sHtml);
};

_me._showSignatureButton = function(bShow, oHelpers) {
	if (!bShow) {
		this.__addSignatureButton && this.__addSignatureButton.parentElement.removeChild(this.__addSignatureButton);
		return;
	}

	this.__signatureHelpers = oHelpers || {
		set: function(id) {
			this.__signatureID = id;
		}.bind(this),
		get: function() {
			return this.__signatureID === void 0 ? '*' : this.__signatureID;
		}.bind(this)
	};

	//Signature
	this.__addSignatureButton = mkElement('A',{className:'ico icosign'});
	gui.tooltip._add(this.__addSignatureButton, getLang('SIGNATURE::SIGNATURE'), {
		y: function() {
			return getSize(this.__addSignatureButton).y - 28
		}.bind(this)
	});
	var me = this;
	this.__addSignatureButton.onclick = async function(e){

		if (!me.__coded && (!this.__cmenu || this.__cmenu._destructed)){
			var elm = this;

			//Contextmenu
			var aFill = me.__genSignature();
			if (aFill){

				e.preventDefault();
				e.stopPropagation();

				addcss(this,'active');

				this.__cmenu = await me._gui._create('cmenu','obj_context', '', 'height_200');
				this.__cmenu._onclose = function(){
					removecss(elm,'active');
				};

				await this.__cmenu._fill(aFill);

				var pos = getSize(this);
				this.__cmenu._place(pos.x+pos.w/2,pos.y+pos.h,'',2);
			}
			//Toggle
			else{
				if (me.__signatureHelpers.get() == '*' && me._getSignature() == false)
					await me._gui._create('settings','frm_settings','','','mail_settings','signature');
				else
					me._addSignature(me.__signatureHelpers.get() == '*'?0:'*');
			}
		}
	};
	this._getAnchor('additional').appendChild(this.__addSignatureButton);
};

_me._getSignature = function(id) {
	var aSign = dataSet.get('storage',['SIGNATURE','ITEMS']),
		signature = '';
	id = id || '0';

	if (id != '*')
		for (var i in aSign)
			if ((aSign[i].VALUES.ID && aSign[i].VALUES.ID.VALUE == id) || (id == '0' && !aSign[i].VALUES.ID)){
				if (aSign[i].VALUES.TEXT){
					signature = aSign[i].VALUES.TEXT.VALUE;

					//convert old signature
					if (signature.indexOf('<')<0)
						signature = signature.replace(/(\r\n)|(\n)/gm,'<br>');

					signature = (GWOthers.getItem('MAIL_SETTINGS_DEFAULT', 'sign_separator')>0?'<div class="separator">-- </div>':'') + signature;
				}
				break;
			}

	return 	signature;
};

// translate HTML via Froala engine (some cleanup is performed there)
_me.__translateHTML = function (sHTML){
	var aStyles = [];
	sHTML = (sHTML || '').replace(/<style[\w\W]*?<\/style>/g, function(match) {
		aStyles.push(match.replace(/(onload|onerror)=".*?"/g, ''));
		return '';
	});
	aStyles = aStyles.filter(function(style) {
		return style !== '<style></style>';
	});

	return mkElement('div', {
		innerHTML: this.__exec('clean.html', [sHTML, true], true) + aStyles.join('')
	}, this.__doc()).innerHTML.trim();
};

_me._addSignature = function (id){

	var signature = this.__translateHTML(this._getSignature(id)),
		elm = this.__doc().querySelector('div.iw-signature'),
		bFound = false, tmp;

	if (elm){
		if (Is.Defined(this.__signatureHelpers.get())){

			var rx = /[\r\n]+|(<br>|&nbsp;)+$/g,
				old = this.__translateHTML(this._getSignature(this.__signatureHelpers.get())).replace(rx, ''),
				act = this.__translateHTML(elm.innerHTML).replace(rx, ''),
				p;

			//textContent metch because of Froala's code processing (can be switched back to act == old after 2.8.7)
			if (mkElement('div', {innerHTML:act}).textContent.replace(/\s+/g,'') == mkElement('div', {innerHTML:old}).textContent.replace(/\s+/g,'')){
				bFound = true;
				elm.innerHTML = signature;
			}
			else
			if ((p = act.lastIndexOf(old))>-1){

				removecss(elm, 'iw-signature');

				if (signature.length){
					bFound = true;
					elm.innerHTML = this.__translateHTML(act.substr(0,p) + '<div class="iw-signature">' + signature + '</div>' + act.substr(p+old.length));
				}
			}
			//Remove all class="signature"
			else{
				elm = null;
			}
		}
		else{
			bFound = true;
			elm.innerHTML = signature; // + '&nbsp;'
		}
	}

	//signature cleanup
	[].forEach.call(this.__doc().querySelectorAll('div.iw-signature'), function(div){
		if (div !== elm)
			removecss(div, 'iw-signature');
	});

	//detect <block style=""><br></block>
	function isCRLF (node){
		return node.childNodes.length === 1 && node.childNodes[0].tagName == 'BR';
	};

	//Blank signature, remove <div class="iw-signature">
	if (signature.length == 0){
		if (bFound && elm && elm.parentNode){

			//Remove surrounding newlines
			if ((tmp = elm.previousElementSibling) && isCRLF(tmp))
				tmp.parentNode.removeChild(tmp);

			if ((tmp = elm.nextElementSibling) && isCRLF(tmp) && (!tmp.nextElementSibling || !hascss(tmp.nextElementSibling, 'iw-reply-block')))
				tmp.parentNode.removeChild(tmp);

			//remove signature
			elm.parentNode.removeChild(elm);
		}
	}
	else
	if (!bFound){

		var quote = this.__doc().body.querySelector('div.classification.end[rel="main"]') || this.__doc().body.querySelector('div.iw-sent-via') || this.__doc().body.querySelector('div.iw-reply-block');

		//Insert Signature before Quoted message
		if (quote){
			if ((tmp = quote.previousElementSibling) && isCRLF(tmp))
				tmp.insertAdjacentHTML('beforebegin', NewMessage.crlf + NewMessage.crlf + '<div class="iw-signature">'+ signature +'</div>'); //'&nbsp;</div>'
			else
				quote.insertAdjacentHTML('beforebegin', NewMessage.crlf + NewMessage.crlf + '<div class="iw-signature">'+ signature +'</div>' + NewMessage.crlf);
		}
		//Insert Signature at the bottom
		else {
			this.__doc().body.insertAdjacentHTML('beforeend', NewMessage.crlf + NewMessage.crlf + '<div class="iw-signature">'+ signature +'</div>');
		}
	}

	if (this.__opt.forceEmbeddedImages) {
		[].forEach.call(this.__doc().body.querySelectorAll('.iw-signature img'), function(img) {
			if (!img.src.match(/data:image\/.*?;base64,/)) {
				getRemoteFileContent(img.src, function(blob) {
					var reader = new FileReader();
					reader.readAsDataURL(blob);
					reader.onloadend = function() {
						img.src = reader.result;
					}
				}, 'blob');
			}
		});
	}

	this.__signatureHelpers.set(id);
	if (GWOthers.getItem('MAIL_SETTINGS_DEFAULT', 'remember_last_used_signature') > 0) {
		dataSet.add('cookies', ['last_used_signature'], id);
	}

	this.__exec('placeholder.refresh', [], true);
	this._editor.size.syncIframe();
	this._focus();
};

_me.__genSignature = function() {
	//Signature select
	var out = [],
		aTmp = dataSet.get('storage',['SIGNATURE','ITEMS']),
		signatureID = this.__signatureHelpers.get();

	for (var i in aTmp)
		if (aTmp[i].VALUES.ID && aTmp[i].VALUES.NAME)
			out.push({text:aTmp[i].VALUES.NAME.VALUE, handler:[this,'_addSignature','',aTmp[i].VALUES.ID.VALUE], css:'ico2'+ (signatureID == aTmp[i].VALUES.ID.VALUE?' check':'')});

	if (out.length){
		out.push(
			{title:'-'},
			{title:'SETTINGS::DEFAULT', handler:[this,'_addSignature','','0'], css:'ico2'+(!signatureID || signatureID == '0'?' check':'')},
			{title:'SIGNATURE::NONE', handler:[this,'_addSignature','','*'], css:'ico2'+(signatureID == '*'?' check':'')}
		);
		return out;
	}
	else
		return false;
};