_me = obj_view_filter.prototype;
function obj_view_filter(){};

_me.__constructor = async function(){
	var	me = this,
		i, type, anchor, aFilter, elm, sInitPage, sActiveFolder, sType, tips, a, tip;

	this.__aTypes = ['D','M','C','E','J','N','F','T','B', 'I', 'Y', 'X','W','K','DA','DS'];
	this._telemetry = 'full';

	var opt = {
		conference: !sPrimaryAccountGUEST && window.sPrimaryAccountCONFERENCE,
		alfresco: Alfresco && Alfresco.enabled(),
		main: this._parent._name == 'frm_main'
	};

	await this._draw('obj_view_filter', 'main', opt); // render all first, hide disabled later

	this.__update();

	//Load last filter
	aFilter = ((window.TeamChatAPI && TeamChatAPI.teamChatOnly() && 'I,Y') || Cookie.get(['filter_tree']));
	sInitPage = (sPrimaryAccountGUEST || (window.TeamChatAPI && TeamChatAPI.teamChatOnly())) ? '' : GWOthers.getItem('LAYOUT_SETTINGS', 'initial_page');

	if (!aFilter){
		if (sInitPage === 'h' || sInitPage === 'i'){
			aFilter = 'M';
		}
		else
		if (sInitPage === 'r'){
			aFilter = 'M';

			sActiveFolder = Cookie.get(['last_folder']);
			if (sActiveFolder){
				sType = WMFolders.getType(Path.split(sActiveFolder));
				if (sType && sType !== 'X')
					aFilter = sType;
			}
		}
	}
	else
	if (Is.String(aFilter)){
		if (sInitPage == 'i' && aFilter.indexOf('M') < 0) {
			aFilter = 'M';
		}
		if ((aFilter = aFilter.split(','))) {
			for (i in aFilter) {
				if ((elm = this._getAnchor(aFilter[i]))) {
					addcss(elm, 'active');
				}
			}
		}
	}

	//Extended version for frm_main sibling only
	if (opt.main){

		this._listen('active_folder');
		this._listen('folders');

		// Right click to open default new item of that type
		this._main.oncontextmenu = async function(e){
			var elm = e.target;

			if (elm.tagName == 'I')
				elm = elm.parentNode;

			if (elm.tagName == 'A'){
				var sType = elm.id.substring(me._pathName.length+1);

				switch(sType){
					case 'D':
					case 'S':
					case 'H':
					case 'A':
					case 'B':
					case 'I':
						break;
					case 'F':
						gui.frm_main.upload._click();
						break;
					case 'W':
						await storage.library('wm_conference');
						wm_conference.create(function (conference) {
							conference.join();
						}, {
							subject: 'Conference'
						});
						break;
					case 'M':
						NewMessage.compose();
						break;
					case 'N':
						if (gui.frm_main._dashboardLoaded() && gui.frm_main.dashboard._hasCapability('notes') && dataSet.get('dashboard', ['config', 'dashboard_notes_enabled']) == 1) {
							gui.frm_main.dashboard._newNoteWindow();
							break;
						}
					case 'E':
						if (gui.frm_main._dashboardLoaded() && gui.frm_main.dashboard._hasCapability('calendar')) {
							gui.frm_main.dashboard._newEventWindow();
							break;
						}
					default:
						Item.create(sType);
				}
			}

			e.stopPropagation();
			e.preventDefault();
		};

		// Mouse over will display custom tooltip
		var lmb = '<span class="mouse_button left"></span>';
		var rmb = '<span class="mouse_button right"></span>';
		tips = {
			D: getLang('MAIN_MENU::SHOW_DASHBOARD'),
			M: lmb + getLang('MAIN_MENU::OPEN_EMAILS') + '<br/>' + rmb + getLang('EMAIL::NEW_EMAIL'),
			E: lmb + getLang('MAIN_MENU::OPEN_CALENDAR') + '<br/>' + rmb + getLang('EVENT_VIEW::NEWAPPOINTMENT'),
			C: lmb + getLang('MAIN_MENU::OPEN_CONTACTS') + '<br/>' + rmb + getLang('CONTACT::NEW'),
			F: lmb + getLang('MAIN_MENU::OPEN_FILES_DOCUMENTS') + '<br/>' + rmb + getLang('MAIN_MENU::NEW_UPLOAD'),
			T: lmb + getLang('MAIN_MENU::OPEN_TASKS') + '<br/>' + rmb + getLang('TASK::NEW'),
			N: lmb + getLang('MAIN_MENU::OPEN_NOTES') + '<br/>' + rmb + getLang('NOTE::NEW'),
			I: getLang('MAIN_MENU::OPEN_TEAMCHAT'),
			W: lmb + getLang('MAIN_MENU::OPEN_CONFERENCES') + '<br/>' + rmb + getLang('IM::CONFERENCE'),
			K: getLang('COMMON_FOLDERS::ALFRESCO'),
			DA: getLang('MAIN_MENU::OPEN_MARKETPLACE'),
			DS: getLang('MAIN_MENU::OPEN_SETTINGS')
		};
		a = this._main.querySelectorAll('a');
		for(i = a.length - 1; i >= 0; i--) {
			if (!a[i]) {
				continue;
			}

			tip = tips[a[i].id.substring(this._pathName.length+1)];
			if (!tip) {
				continue;
			}
			var x = '+40';
			if (gui._rtl) {
				x = '-' + (tip.length * 6 + 36);
			}
			gui.tooltip._add(a[i], tip, {
				x: x,
				y: '+5',
				css: 'filter',
				html: true,
				type: 'block'
			});
		}

		//Registr Drop
		if (gui.frm_main && gui.frm_main.dnd) {
			gui.frm_main.dnd.registr_drop(this,['item','folder','jabber','favorite','folder']);
		}
	}

	a = this._main.querySelectorAll('a');
	for(i = a.length - 1; i >= 0; i--) {
		a[i].onclick = a[i].onkeydown = function(e) {
			e.preventDefault();
			var id = this.id.substring(me._pathName.length+1);
			me.__filter(id, false, false, 100);
		};
	}

	await this._create('scrollbar', 'obj_scrollbar');
	this.scrollbar._scrollbar(this._getAnchor('scroll'), this._getAnchor('scroll_container'));
};

_me.__openEvents = function (){
	gui.frm_main._selectView({aid:sPrimaryAccount,fid:'__@@VIRTUAL@@__/__@@EVENTS@@__'});
};

_me.__filter = function(id, bSkipPostmessage, bSkipSelectView, iSelectViewTimeout, oFolder){
	gui.frm_main.bar.folders.inp_search._value('', true);
	gui.frm_main.bar.folders.__filter = '';
	var oTree = gui.frm_main.bar.folders,
		aActive = oTree._getActive(),
		view = '',
		defaultFolder = Mapping.getDefaultFolderForGWType(id),
		fid;

	if (id === 'QL') {
		defaultFolder = 'SPAM_QUEUE/Blacklist';
	}

	// Temporary solution to ask user if upload should be cancelled
	var dashboard_view = false;
	var args = arguments;
	if (gui.frm_main.main && gui.frm_main.main.upload && gui.frm_main.main.upload._uploading) {
		gui._create('stop_upload','frm_confirm','','',[function(){
			if (gui.frm_main.main.upload)
				gui.frm_main.main.upload._reset();

			this.__filter.apply(this, args);
		}.bind(this)],'ALERTS::ALERT','CONFIRMATION::STOPUPLOAD');
		return false;
	} else {
		switch(id) {
			case 'D': // dashboard
			case 'DA': // dashboard apps
			case 'DS': // dashboard settings
				!bSkipPostmessage && /*gui.frm_main._dashboardLoaded() && */gui.frm_main.dashboard._navigate({
					to: {D: 'desktop', DA: 'apps', DS: 'settings'}[id]
				});
				if (iSelectViewTimeout) {
					setTimeout(function() {
						gui.frm_main._selectView({aid: sPrimaryAccount, fid: '__@@VIRTUAL@@__/__@@DASHBOARD@@__'}, 'dashboard_view', {view: 'dashboard_view'});
					}, iSelectViewTimeout);
				} else {
					gui.frm_main._selectView({aid: sPrimaryAccount, fid: '__@@VIRTUAL@@__/__@@DASHBOARD@@__'}, 'dashboard_view', {view: 'dashboard_view'});
				}
				oTree._filter_folder([id]);
				dashboard_view = true;
				break;
			case 'M': // mail
			case 'Q': // quarantine
			case 'QL':
				oTree._filter_folder(['M','R','Q','QL']);
				break;
			case 'I': // TC
				oTree._filter_folder(['I','Y']);
				break;
			case 'C':
				oTree._filter_folder(['C']);
				break;
			// case 'E': // events
			case 'F': // files
			case 'N': // notes
				var destination = {
					N: 'notes',
					F: 'files',
					E: 'calendar',
				}
				fid = defaultFolder;
				var dashboard_enabled = dataSet.get('dashboard', ['config', 'dashboard_enabled']) && dataSet.get('dashboard', ['config', 'dashboard_' + destination[id] + '_enabled']) == 1;
				if ((/*!gui.frm_main._dashboardLoaded() || */!dashboard_enabled) && view === 'dashboard_view') {
					if (id === 'E') {
						view = 'workweek_view';
					} else {
						view = 'list_wide';
					}
				} else if (/*gui.frm_main._dashboardLoaded() && */dashboard_enabled && gui.frm_main.dashboard._hasCapability(destination[id])) {
					!bSkipPostmessage && gui.frm_main.dashboard._navigate({
						to: destination[id],
						options: oFolder ? {
							aid: oFolder.aid,
							fid: Path.slash(oFolder.fid)
						} : void 0
					});
					if (iSelectViewTimeout) {
						setTimeout(function() {
							gui.frm_main._selectView({aid: sPrimaryAccount, fid: fid}, 'dashboard_view', {view: 'dashboard_view'});
						}, iSelectViewTimeout);
					} else {
						gui.frm_main._selectView({aid: sPrimaryAccount, fid: fid}, 'dashboard_view', {view: 'dashboard_view'});
					}
					Cookie.set(['filter_tree'], id);
					dashboard_view = true;
				}
			default:
				if (id !== 'G') {
					oTree._filter_folder([id]);
				}
		}
	}

	var bActive = false,
		aActiveFilters = [];

	for(var i in this.__aTypes) {
		if (oTree._sFilterFolderType[this.__aTypes[i]]){
			if (this._getAnchor(this.__aTypes[i])) {
				addcss(this._getAnchor(this.__aTypes[i]),'active');
				this._getAnchor(this.__aTypes[i]).scrollIntoView({behavior: "smooth", block: "nearest", inline: "nearest"});
			}
			aActiveFilters.push(this.__aTypes[i]);
			bActive = true;
		} else {
			removecss(this._getAnchor(this.__aTypes[i]),'active');
		}
	}

	if (dashboard_view) {
		delete gui.frm_main.search._onsearch;
		gui.frm_main.search._setFolder({aid: sPrimaryAccount, fid: defaultFolder});
		return;
	}

	//Jump __@@EVENTS@@__ -> Default Calendar
	if (id === 'E' && (!oTree._sFilterFolderType['E'] || aActiveFilters.length>1) && sPrimaryAccount == aActive[0] && '__@@VIRTUAL@@__/__@@EVENTS@@__' == aActive[1]){
		gui.frm_main._selectView({aid:sPrimaryAccount,fid:defaultFolder},'',true);
		oTree._setActive(sPrimaryAccount+'/'+defaultFolder);
	}

	//Save to Cookie
	Cookie.set(['filter_tree'],aActiveFilters.join(','));

	if (bSkipSelectView) {
		return;
	}

	if (!bActive){
		delete oTree._sFilterFolderType;
		oTree._fill();
	}
	else{

		var last = Path.split(Cookie.get(['last', id]));
		if (!dataSet.get('folders', last) || (GWOthers.getItem('LAYOUT_SETTINGS', 'remember_folder_per_type') == 0)) {
			last = false;
		}

		switch (id) {
			case 'M':
				gui.frm_main._selectView({aid: last[0] || sPrimaryAccount, fid: last[1] || 'INBOX'});
				gui.__exeEvent('folderSelected', {aid: last[0] || sPrimaryAccount, fid: last[1] || 'INBOX'});
				break;

			case 'W':
				gui.frm_main._selectView({aid: sPrimaryAccount, fid: '__@@VIRTUAL@@__/__@@MEETINGS@@__'});
				gui.__exeEvent('folderSelected', {aid: sPrimaryAccount, fid: '__@@VIRTUAL@@__/__@@MEETINGS@@__'});
				break;

			case 'B':
				var trash = Path.split(GWOthers.get('DEFAULT_FOLDERS','storage').VALUES.trash);
				if (dataSet.get('folders', trash)) {
					gui.frm_main._selectView({aid: sPrimaryAccount, fid: trash[1]});
					gui.__exeEvent('folderSelected', {aid: sPrimaryAccount, fid: trash[1]});
				} else {
					gui.frm_main._selectView({aid: sPrimaryAccount, fid: '__@@GWTRASH@@__'});
					gui.__exeEvent('folderSelected', {aid: sPrimaryAccount, fid: '__@@GWTRASH@@__'});
				}
				break;

			case 'I':
				this._recent('I', false);
				aActive = Path.split(dataSet.get('active_folder'));
				if (WMFolders.getType(aActive) != 'I'){
					last = Path.split(Cookie.get(['last','I']));
					if (last[0] == sPrimaryAccount && last[1] && WMFolders.getType([sPrimaryAccount, last[1]]) == 'I'){
						gui.frm_main._selectView({aid:sPrimaryAccount, fid:last[1]}, 'room_view');
						gui.__exeEvent('folderSelected', {aid: sPrimaryAccount, fid: last[1]});
					}
					else{
						fid = null;
						var f = dataSet.get('folders',[sPrimaryAccount]);

						for (var n in f){
							if (f[n].TYPE == 'I'){
								fid = n;
								break;
							}
							else
							if (!fid && f[n].TYPE == 'Y') {
								fid = n;
							}
						}

						if (!fid) {
							dataSet.add('folders',[sPrimaryAccount, '__@@VIRTUAL@@__/__@@PRIVATE_ROOMS@@__'], {
								TYPE: 'Y',
								NAME: getLang('FOLDER_TYPES::GROUPCHAT')
							});
							fid = '__@@VIRTUAL@@__/__@@PRIVATE_ROOMS@@__';
						}
						gui.frm_main._selectView({aid:sPrimaryAccount,fid:fid}, 'room_view');
						gui.__exeEvent('folderSelected', {aid: sPrimaryAccount, fid: fid});
					}
				}
				break;

			case 'E':
				if (dataSet.get('folders',[sPrimaryAccount,'__@@VIRTUAL@@__/__@@EVENTS@@__'])){
					this.__openEvents();
					return false;
				} else if (defaultFolder) {
					var folders = {};
						folders[defaultFolder] = true;

					dataSet.add('folders',[sPrimaryAccount,'__@@VIRTUAL@@__/__@@EVENTS@@__','VIRTUAL','FOLDERS'], folders);
					WMFolders.add({aid: sPrimaryAccount, name: '__@@VIRTUAL@@__/__@@EVENTS@@__', type: 'E', virtual:{ folders: folders }}, 'folders', '', [this,'__openEvents']);
					return false;
				}

			default:
				if (last || (defaultFolder !== false && WMFolders.getType([sPrimaryAccount, defaultFolder]) == id)) {
					gui.frm_main._selectView({aid: last[0] || sPrimaryAccount, fid: last[1] || defaultFolder}, view);
					gui.__exeEvent('folderSelected', {aid: last[0] || sPrimaryAccount, fid: last[1] || defaultFolder});
				}
		}
	}

	//Focus Datagrid
	if (gui.frm_main && gui.frm_main.main && gui.frm_main.main.list){
		gui.frm_main.main.list._focus();
	}
};

_me._recent = function(sAnchor, i){
	var elm = this._getAnchor(sAnchor);
	if (elm){

		elm = elm.querySelector('I');

		if (elm){
			if (i)
				elm.innerHTML = i;
			else
				elm.parentNode.removeChild(elm);
		} else if (i) {
			elm = mkElement('I');
			elm.innerHTML = i;
			this._getAnchor(sAnchor).appendChild(elm);
		}
	}
};

_me.__update = function(sDName){
	var aDisabled = {};
	var dashboardLoaded = dataSet.get('dashboard', ['config', 'dashboard_enabled']) && gui.frm_main.dashboard && !gui.frm_main.dashboard.__isDown;//gui.frm_main._dashboardLoaded();

	var dgw = (sPrimaryAccountGW ? (GWOthers.getItem('RESTRICTIONS', 'disable_gw_types') || '') : 'cetfn').split('');

	// Show allowed types only
	if (sPrimaryAccountGUEST) {
		dgw = 'mcetfn'.split('');
	}
	for (i in dgw) {
		aDisabled[dgw[i].toLowerCase()] = true;
	}

	if (!sPrimaryAccountCHAT || !sPrimaryAccountGW) {
		aDisabled.i = true;
	}

	if (!dashboardLoaded) {
		frm_dashboard.__apps.forEach(function(app) {
			if (app.dashboard_only) {
				aDisabled[app.folderType.toLowerCase()] = true;
			}
		});
	}

	var allFolders, groupwareTypes, searchedTypes, i, anchor;

	//Recent
	switch(sDName){
		case 'folders':

			//Mail
			this._recent('M', parseInt(dataSet.get('folders',[sPrimaryAccount,'INBOX','RECENT']) || 0,10));

			if (sPrimaryAccountCHAT && sPrimaryAccountGWSUPPORT) {
				removecss(this._getAnchor('I'), 'hidden');
			} else {
				addcss(this._getAnchor('I'), 'hidden');
			}

			// Groupware folders - show/hide which are relevant: 'E'vents, 'C'ontacts, 'F'iles, 'T'asks, 'N'otes
			allFolders = dataSet.get('folders', [sPrimaryAccount]);
			groupwareTypes = ['E', 'C', 'F', 'T', 'N', 'M'];
			searchedTypes = {
				M: false,
				E: false,
				C: false,
				F: false,
				T: false,
				N: false,
				D: dashboardLoaded,
				DA: dashboardLoaded && GWOthers.getItem('RESTRICTIONS', 'dashboard_marketplace_enabled') == 1,
				DS: dashboardLoaded && gui.frm_main.dashboard && gui.frm_main.dashboard._hasCapability('settings')
			};
			for (i in allFolders) {
				if (i === '__@@VIRTUAL@@__/__@@EVENTS@@__') {
					continue;
				}
				if (groupwareTypes.indexOf(allFolders[i].TYPE) !== -1) {
					sPrimaryAccountGW = 1;
					searchedTypes[allFolders[i].TYPE] = true;
				}
			}
			for (i in searchedTypes) {
				anchor = this._getAnchor(i);
				if (searchedTypes[i] && !aDisabled[i.toLowerCase()]) {
					removecss(anchor, 'hidden');
				} else {
					addcss(anchor, 'hidden');
				}
			}
			if (!sPrimaryAccountGWSUPPORT) {
				addcss(this._getAnchor('W'), 'hidden');
			} else {
				removecss(this._getAnchor('W'), 'hidden');
			}

			removecss(this._main, 'hidden');
			if (this._main.querySelectorAll('a:not(.hidden)').length < 2) {
				addcss(this._main, 'hidden');
			}

			// IM and VOIP (webrtc) are done differently
			break;
	}
};

/* Drag and Drop */
_me._active_dropzone = function(v){
	//if (v && Is.Empty(this.__trgets)){
	if (v){

		if (v.type == 'item'){

			//Access Right for REMOVE Item
			var sLockID = dataSet.get('items',[v.value[0].aid, v.value[0].fid, v.value[0].iid,'EVNLOCKOWN_ID']),
				bDelete = (!sLockID || sLockID == sPrimaryAccountGWID) && WMFolders.getAccess({aid:v.value[0].aid, fid:v.value[0].fid}, 'remove');

			this.__trgets = {};

			var itmtype = WMFolders.getType(v.value[0]),
				aa = this._main.querySelectorAll('a'),
				stype;

			if (itmtype != 'QL')
				for (var i = aa.length-1; i>-1; i--){
					stype = aa[i].id.substr(this._pathName.length+1);

					if (stype!= 'A' && (stype!= 'B' || bDelete))
						this.__trgets[stype] = getSize(aa[i]);
				}
		} else {
			this.__trgets = {'B':getSize(this._getAnchor('B'))};

			if (v.type === 'folder' && WMFolders.getType(v.value[0]) === 'F') {
				this.__trgets.D = getSize(this._getAnchor('D'));
			}
		}

		if (this.__trgets['B'])
			addcss(this._getAnchor('B'),'delete');
	}
	else
		removecss(this._getAnchor('B'),'delete');
};

_me._ondragover = function(v){
	var out = '';
	if (v.y){
		var itmtype = WMFolders.getType(v.value[0]);

		for(var i in this.__trgets){
			if (itmtype!=i && this.__trgets[i].y<v.y && this.__trgets[i].y+this.__trgets[i].h>v.y){
				out = i;
				addcss(this._getAnchor(i),'hover');
			}
			else
				removecss(this._getAnchor(i),'hover');
		}
	}

	this.__lastDrop = out;

	return out?true:false;
};

_me._ondragout = function(){
	for(var i in this.__trgets)
		removecss(this._getAnchor(i),'hover');
};

_me._ondrop = async function(v){
	if (!this.__lastDrop) {
		return;
	}
	var iids = [], i;
	switch(this.__lastDrop) {
		case 'B':
			switch(v.type){
				case 'folder':
					var val = v.value[0];
					if (val){
						if (WMFolders.getRights(val,'remove') && !dataSet.get('folders',[val.aid,val.fid,'DEFAULT'])){
							await storage.library('obj_context_folder');

							if (v.ctrl)
								window.obj_context_folder.__deleteFolder(val.aid,val.fid);
							else
								window.obj_context_folder.prototype._onclick(null,null,null,{method:'delete_folder',aid:val.aid,fid:val.fid});
						}
						else
							gui.notifier._value({type: 'alert', args: {header: '', text: 'CONTEXT_FOLDER::CANTDELETE'}});
					}
					break;

				case 'item':
					var ids = [];
					for (i in v.value){
						if (Is.Defined(ids[0])){
							if (ids[0] == v.value[i].aid && ids[1] == v.value[i].fid)
								ids[2].push(v.value[i].iid);
						 }
						 else
						 	ids = [v.value[i].aid,v.value[i].fid,[v.value[i].iid]];
					}

					if (ids.length)
						Item.remove(ids,v.ctrl);

					break;

				case 'jabber':
					if (v.value && gui.frm_main.im && gui.frm_main.im._is_active()){
						if (v.ctrl)
							gui.frm_main.im._removeUsr(v.value.map(function(v) {
								return v.id;
							}));
						else
						if (v.value.length>1)
							gui.frm_main.im._oncontext('','','',{method:'user_remove'});
						else
							gui.frm_main.im._oncontext('','','',{method:'user_remove',id:v.value.map(function(v) {
								return v.id;
							})});
					}
					break;

				case 'favorite':
					if (v.value && v.value[0].aid && v.value[0].fid && gui.frm_main.bar._fav)
						gui.frm_main.bar._fav.__remove('','','',v.value[0]);
			}
			break;

		case 'D':
			switch (v.type) {
				case 'item':
					if (WMFolders.getType(v.value[0]) !== 'F') {
						return;
					}
					for (i in v.value){
						iids.push(v.value[i].iid)
					}
					iids.forEach(function(iid) {
						gui.frm_main.dashboard._pinItem({
							aid: v.value[0].aid,
							fid: v.value[0].fid,
							iid: iid,
							type: 'file'
						});
					});
					break;

				case 'folder':
					gui.frm_main.dashboard._pinItem({
						aid: v.value[0].aid,
						fid: v.value[0].fid,
						type: 'folder'
					});
			}
			break;

		default: 
			if (v.type == 'item') {
				for (i in v.value){
					iids.push(v.value[i].iid)
				}

				Item.__convertToFolder(sPrimaryAccount, this.__lastDrop == 'M'?'INBOX':Mapping.getDefaultFolderForGWType(this.__lastDrop), v, gui.frm_main.main.list, gui.frm_main.main.list && gui.frm_main.main.list.__getNext(iids));
			}
	}
};