_me = obj_vdock.prototype;
function obj_vdock() { };

_me.__constructor = async function () {
	this._docked = [];
	this._active = [];

	var me = this;

	var resizeTimeout;
	var iframe = mkElement('iframe');
	this._main.parentNode.insertAdjacentElement('beforeend', iframe);
	iframe.contentWindow.onresize = function() {
		if (resizeTimeout) {
			clearTimeout(resizeTimeout);
			resizeTimeout = false;
		}
		resizeTimeout = setTimeout(function() {
			me.__checkSize();
		}, 50);
	};

	this.movingObj = null;
	this.movingTimeout = false;
	this.moved = false;
	this.preventClick = false;
	this.x = 0;

	gui._obeyEvent('mousemove',[this,'__mousemove']);
	gui._obeyEvent('mouseup',[this,'__mouseup']);
};

_me.__checkSize = function () {
	if (this._onchange) {
		this._onchange(this._docked.length);
	}

	setTimeout(function() {
		if (this._main.scrollWidth > this._main.clientWidth && this._active.length > 1) {
			this._active[0]._dock();
			this.__checkSize();
		}
	}.bind(this), 5);
	
};

_me._close = async function (Obj) {
	if (Obj._close && await Obj._close(true) == true)
		return;

	this._remove(Obj);
};

_me._remove = function (Obj, bForce) {
	if (inArray(this._docked, Obj) < 0 || (!bForce && Obj._undock && Obj._undock(this) === false))
		return;

	Obj.__dock.parentNode.removeChild(Obj.__dock);
	this._docked.splice(this._docked.indexOf(Obj), 1);
	Obj.__dock = null;

	this.__checkSize();
};

_me.__mousemove = function(e) {
	if (this.movingObj) {
		e.preventDefault();
		this.movingObj.__dock.style.transform = 'translateX(' + (e.clientX - this.x) + 'px)';
		this.moved = true;
	}
};

_me.__mouseup = function(e) {
	if (this.movingObj) {
		var maxDock, minDock;
		var newPosition = this._docked.filter(function(docked) {
			if (!minDock || minDock.__dock.__order > docked.__dock.__order) {
				minDock = docked;
			}
			if (!maxDock || maxDock.__dock.__order < docked.__dock.__order) {
				maxDock = docked;
			}
			if (docked !== this.movingObj) {
				var brc = docked.__dock.getBoundingClientRect();
				return brc.left < e.clientX && brc.right > e.clientX;
			}
		}, this)[0];
		if (newPosition) {
			var oldOrder = this.movingObj.__dock.__order;
			var newOrder = newPosition.__dock.__order;
			this.movingObj.__dock.__order = oldOrder > newOrder ? newOrder - 1 : newOrder + 1;
		} else {
			var brcMin = minDock && minDock.__dock.getBoundingClientRect();
			var brcMax = maxDock && maxDock.__dock.getBoundingClientRect();
			if (brcMin) {
				if (gui._rtl) {
					if (e.clientX > brcMin.right) {
						this.movingObj.__dock.__order = 1;
					} else if (e.clientX < brcMax.left) {
						this.movingObj.__dock.__order = maxDock.__dock.__order + 1;
					}
				} else {
					if (e.clientX < brcMin.left) {
						this.movingObj.__dock.__order = 1;
					} else if (e.clientX > brcMax.right) {
						this.movingObj.__dock.__order = maxDock.__dock.__order + 1;
					}
				}
			}
		}
		this.__reorder();
		this.movingObj.__dock.style.transform = '';
		this.movingObj.__dock.classList.remove('moving');
		this.movingObj = null;
		if (this.moved) {
			this.preventClick = true;
		}
	}
	clearTimeout(this.movingTimeout);
};

_me.__reorder = function() {
	this._docked.sort(function(a, b) {
		return ((a.__dockOrder || 1) - (b.__dockOrder || 1)) || ((a.__dock.__order || 99) - (b.__dock.__order || 99));
	}).forEach(function(docked, i) {
		docked.__dock.style.order = i * 2 + 2;
		docked.__dock.__order = i * 2 + 2;
	});
};

_me._add = function(Obj, sTitle, sClass, bUnshift) {
	if (!~this._docked.indexOf(Obj)) {
		this._docked.push(Obj);

		var header = mkElement('div', {
			className: 'header',
			onclick: function(Obj, e) {
				if (this.preventClick) {
					this.preventClick = false;
					return;
				}
				if (!Obj._onDockedHeaderClick || Obj._onDockedHeaderClick(e) !== false) {
					e.preventDefault();
					e.stopPropagation();
					this._remove(Obj);
				}
			}.bind(this, Obj)
		}, false, [
			Obj.__dock_ico = mkElement('div', {
				className: 'ico'
			}),
			Obj.__dock_title = mkElement('div', {
				className: 'title',
			}),
			Obj.__closable && mkElement('div', {
				className: 'close icon',
				onclick: function(Obj, e) {
					e.preventDefault();
					e.stopPropagation();
					Obj.__destructing = true;
					this._close(Obj);
				}.bind(this, Obj)
			})
		].filter(Boolean));

		header.addEventListener('auxclick', function(Obj, e) {
			gui.__preventMiddleClick = true;
			if (e.button === 1) {
				e.preventDefault();
				e.stopPropagation();
				e.stopImmediatePropagation();
				Obj.__destructing = true;
				this._close(Obj);
			}
			setTimeout(function() {
				gui.__preventMiddleClick = false;
			}, 50);
		}.bind(this, Obj));

		header.onmousedown = function(e) {
			if (!Obj.__dockMovable) {
				return;
			}
			e.preventDefault();
			this.moved = false;
			this.movingTimeout = setTimeout(function() {
				this.movingObj = Obj;
				this.movingObj.__dock.classList.add('moving');
				this.x = e.clientX;
			}.bind(this), 100);
		}.bind(this);

		Obj.__dock = mkElement('div', {}, false, [
			header,
			mkElement('div', { className: 'body' })
		]);
		Obj.__dock.__header = header;

		this._main.appendChild(Obj.__dock);
	}

	if (bUnshift) {
		Obj.__dock.__order = -1;
	}
	this.__reorder();

	Obj.__dock.className = ['ico_' + (Obj._iconType || Obj._type), Obj._type, sClass, Obj.__closable && 'closable'].filter(Boolean).join(' ');
	this._setTitle(Obj, sTitle || Obj.__dock.__header.title || '');

	this.__checkSize();

	return Obj.__dock;
};

_me._setTitle = function(Obj, title) {
	Obj.__dock.__header.title = title;
	Obj.__dock_title.innerHTML = title.escapeHTML();
}
