function obj_upload_visits(){};

obj_upload_visits.prototype = {
	__constructor: async function(aData, onclick, locations) {
		this._aData = aData;
		this.__onclick = onclick;
		this.__locations = locations;
		this._placeholder('UPLOAD_DETAIL::NO_HISTORY');
	},

	_request: function() {
		this.__loading = 1;

		var aItemsInfo = {
			smarts: this.__aRequestData.folder.iid,
			limit: 10,
			offset: 0
		};

		if (this._queue) {
			if (this._response(this._queue)) {
				return;
			}
			this._queue = false;
		}

		if (this.__aRequestData.offset) {
			aItemsInfo.offset = this.__aRequestData.offset;
		}

		TeamChatAPI.getSmartLinkData(aItemsInfo, {
			success: this._response,
			context: this
		});
	},

	_response: async function(aData) {
		aData[0].TotalVisits = 0;
		var i;
		for (i in aData[0].Locations) {
			aData[0].TotalVisits += aData[0].Locations[i].Visit;
		}
		
		for (var visit of (aData[0].Visits || [])) {
			var sep = this.__separatorFunction(visit.CreatedAt);
			if (this.__sep1.sep != sep){
				this._separator(sep);
				this.__sep1 = {sep: sep};
			}

			for (i in this.__locations) {
				var location = this.__locations[i];
				if (visit.Whois.City === location.City && visit.Whois.Capital === location.Capital) {
					visit.Location = location;
					break;
				}
			}

			if (!this.__aData[visit.ID]) {
				this.__aData[visit.ID] = await this._create('item', 'obj_upload_visit', this._row().anchor, '', visit, this.__onclick);
			}

			this.__aRequestData.offset++;
		}

		if (!await this.__check_count(Object.keys(this.__aData).length) || !(aData[0].Visits || []).length || (Object.keys(this.__aData).length === aData[0].TotalVisits)) {
			return true;
		}

		this.__loading = 0;
	},

	__separatorFunction: function(date) {
		var now = new IcewarpDate().startOf('day');
		date = new IcewarpDate(date).startOf('day');

		var days_back = 21; // default older
		if (date.isSame(now, 'day')) {
			days_back = 0; // today
		} else if (date.isSame(now.clone().subtract(1, 'days'), 'day')) {
			days_back = 1; // yesterday
		} else if (date.isSame(now.clone().subtract(2, 'days'), 'day')) {
			days_back = 2; // 2 days ago
		} else if (date.isSame(now, 'week')) {
			days_back = 3; // this week
		} else if (date.isSame(now.clone().subtract(7, 'days'), 'week')) {
			days_back = 7; // last week
		} else if (date.isSame(now.clone().subtract(14, 'days'), 'week')) {
			days_back = 14; // two weeks ago
		}
		return getLang('datagrid::days_back_' + days_back);
	}
};