function obj_upload_item(){}

/**
 * Extends html upload by select GW item dialog and attachment management
 *
 * @param {*} xNotUsed
 * @param {object} aPath		{aid:<string>,fid:<string>}
 * @param {array} aAllowedTypes
 * @param {string} sDefaultType
 */
obj_upload_item.prototype.__constructor = async function(xNotUsed, aPath, aAllowedTypes, sDefaultType){

	//init defaults
	this._setDefaultFolder(aPath || {aid:sPrimaryAccount, fid:Mapping.getDefaultFolderForGWType('F')});
	this._setGWTypes(aAllowedTypes);
	this._setDefaultGWType(sDefaultType);

	//do not reset idtable after each upload
	this.file._onuploadstart = function (files){
		if (this._onuploadstart)
			this._onuploadstart(files);
	}.bind(this);
};

//extend _upload by item select dialog
obj_upload_item.prototype._upload = function(aPath, sType){
	// In case "Attach from webclient" is disabled, just show browser upload dialog
	if ('1' === GWOthers.getItem('RESTRICTIONS', 'disable_attach_item')){
		this._click();
	}
	else{

		if (aPath)
			sType = sType || WMFolders.getType(aPath);
		else{
			aPath = this.__aDefaultFolder;
			sType = sType || this.__sDefaultType;
		}

		this._parent._gui._create('insert_item', 'frm_insert_item', '', 'frm_insert_item_nobottomdiv', [
			{file:this, __selectHandler:this._addItem.bind(this)},
			'__selectHandler'
		], aPath.aid, aPath.fid, '', this, false, this.__aAllowedTypes, sType);
	}
};

obj_upload_item.prototype._remove = function (id){

	if (!Is.Defined(id)){
		this.__idtable.forEach(function (file) {
			file.removed = true;
		});
	}
	else
	if (!this.__idtable.some(function (file) {
			if (file.id == id) {
				file.removed = true;
				return true;
			}
		})) {

		return false;
	}

	//update
	this._onchange && this._onchange(this.__idtable);
	this.__exeEvent('onchange', null, {
		"arg": this.__idtable,
		"owner": this
	});
	return true;
};

obj_upload_item.prototype._rename = function (id, description){
	if (this.__idtable.some(function (file) {
			if (file.id == id) {
				// if (!file.fullpath && !file.description)
				// 	file.name = description;
				// else
					file.description = description;

				return true;
			}
		})) {

		//update
		this._onchange && this._onchange(this.__idtable);
		this.__exeEvent('onchange', null, {
			"arg": this.__idtable,
			"owner": this
		});
		return true;
	}
	else
		return false;
};

obj_upload_item.prototype._addItem = function(aItems){

	//Select single item
	if (!this.file._getMultipleSelection())
		this.__idtable = [];

	var new_files = aItems.map(function(item){
		var fullpath = item.fullpath;
		if (!fullpath) {
			if (item.folder && item.id) {
				fullpath = item.folder + '/' + item.id;
			} else if (item.aid && item.fid && item.iid) {
				fullpath = item.aid + '/' + Path.slash(item.fid) + '/' + WMItems.__serverID(item.iid);
				if (~['I', 'K', 'F'].indexOf(WMFolders.getType(item))) {
					item.type = 'attachment';
					fullpath += '/' + item.name;
				}
			} else {
				fullpath = this._getFolder() + '/' + item.id;
			}
		}
		var att = {
			name: item.title,
			attachment: item.title,
			id: item.id || item.iid,
			aid: item.aid,
			fid: item.fid,
			iid: item.iid,
			partid: item.partid,
			size: item.size,
			class: item.type || (item.embedded ? 'item' : 'itemlink'),
			ticket: item.ticket,
			fullpath: item.fullpath,
			onclick: this._open.bind(this, item.id),
			_abort: function() {
				gui.__exeEvent('onuploadaborted', {
					file: att
				});
			}
		};
		return att;
	}, this).filter(function(item){
		return item.class === 'file' || !this.__idtable.some(function(idt){
			return idt.id === item.id && idt.partid === item.partid && !idt.removed;
		});
	}.bind(this));

	this.__idtable = this.__idtable.concat(new_files);

	//update
	this._onchange && this._onchange(this.__idtable);
	this.__exeEvent('onchange',null,{"arg":this.__idtable,"owner":this});

	if (this._onuploadstart)
		this._onuploadstart(new_files);
	gui.__exeEvent('onuploadstart', {owner: this.file, files: new_files, restore: true});

	[].forEach.call(new_files, function(file) {
		if (this._onuploadsuccess)
			this._onuploadsuccess(file);

		gui.__exeEvent('onuploadsuccess', {owner: this.file, file: file});
	}.bind(this));

	if (this._onuploadend)
		this._onuploadend(new_files);
	gui.__exeEvent('onuploadend', {owner: this.file, files: new_files});
};

obj_upload_item.prototype._value = function (v){
	if (Is.Object(v)){
		var bChange = false;
		if (Object.prototype.hasOwnProperty.call(v, 'values') || v.folder){
			if (v.folder)
				this._setFolder(v.folder);

			if (Object.prototype.hasOwnProperty.call(v, 'values')){
				this.__idtable = v.values;
				bChange = true;
			}
		}
		else{
			this.__idtable = v;
			bChange = true;
		}

		//update
		if (bChange){
			this._onchange && this._onchange(this.__idtable);
			this.__exeEvent('onchange',null,{"arg":this.__idtable,"owner":this});
		}
	}
	else
		return this.__idtable;
};

//for gw
obj_upload_item.prototype._getAddon = function (){
	return this._value().map(function(file){
		if (file.class == 'attachment'/* && !file.fullpath*/){
			if (file.removed)
				return {uid:file.id};
			else
			if (file.description && file.description != file.name)
				return {
					uid:file.id,
					values:{description:file.description}
				};
		}
		else
		if (!file.removed){
			var fullpath = file.fullpath;
			if (!fullpath) {
				if (file.aid && file.fid && file.iid) {
					fullpath = file.aid + '/' + Path.slash(file.fid) + '/' + WMItems.__serverID(file.iid);
					if (~['I', 'K', 'F'].indexOf(WMFolders.getType(file))) {
						file.class = 'attachment';
						fullpath += '/' + file.name;
					}
				} else if (file.folder && file.id) {
					fullpath = file.folder + '/' + file.id;
				} else if (this._getFolder && this._getFolder()) {
					fullpath = this._getFolder() + '/' + file.id;
				}
			}
			return {
				values: {
					class: file.class,
					description: file.description || file.name,
					size: file.size,
					fullpath: fullpath
				}
			};
		}
	}.bind(this)).filter(Boolean);
};

// for compose
obj_upload_item.prototype._setAttachments = function(v){
	if (v && v.attachments)
		for(var i in v.attachments)
			this._add(v.attachments[i].values, true);

	this._onchange && this._onchange(this.__idtable);
	this.__exeEvent('onchange',null,{"arg":this.__idtable,"owner":this});

	this._addFiles(v.attachments.map(function(att) {
		return att.values;
	}));
};

obj_upload_item.prototype._getAttachments = function(){
	return {attachments:this._value().map(function(file){
		if (file['class'] == 'attachment' && !file.fullpath){
			if (file.removed)
				return {uid:file.id};
		}
		else
		if (!file.removed){
			var fullpath = file.fullpath;
			if (!fullpath) {
				if (file.aid && file.fid && file.iid) {
					fullpath = file.aid + '/' + Path.slash(file.fid) + '/' + WMItems.__serverID(file.iid);
					if (~['I', 'K', 'F'].indexOf(WMFolders.getType(file))) {
						file.class = 'attachment';
						fullpath += '/' + file.name;
					}
				} else if (file.folder && file.id) {
					fullpath = file.folder + '/' + file.id;
				}
			}

			return Object.assign({}, file, {
				name: file['description'] || file['name'],
				fullpath: fullpath
			});
		}
	}).filter(Boolean)};
};

obj_upload_item.prototype._filteredValue = function (){
	return this._value().filter(function(file){
		return !file.removed;
	});
};

obj_upload_item.prototype._add = function(aArg, bNoChange){
	if (this._destructed)
		return;

	//Select single item
	if (!this.file._getMultipleSelection())
		this.__idtable = [];

	if (!aArg.fullpath) {
		aArg.folder = this.file._getFolder();
		aArg.id = Is.Defined(aArg.id)?aArg.id:this.__idtable.length;
	} else if (!aArg.folder || !aArg.id) {
		var fullpath = Path.split(aArg.fullpath, false, true);
		aArg.id = fullpath[2];
		aArg.folder = fullpath[1];
	}

	this.__idtable.push(aArg);

	//update
	if (!bNoChange){
		this._onchange && this._onchange(this.__idtable);
		this.__exeEvent('onchange',null,{"arg":this.__idtable,"owner":this});
	}
};

obj_upload_item.prototype._getName = function(id) {
	var f = this._getFile(id);
	if (f)
		return f.name;
};
obj_upload_item.prototype._getSize = function(id) {
	var f = this._getFile(id);
	if (f)
		return f.size;
};

obj_upload_item.prototype._getFile = function(id){
	for(var i = this.__idtable.length;i--;)
		if (this.__idtable[i].id == id)
			return Object.assign({}, this.__idtable[i], {fullpath:this.__idtable[i].fullpath || this._getFolder() + '/' + this.__idtable[i].id});
};

obj_upload_item.prototype._setGWTypes = function(a){
	this.__aAllowedTypes = a || ['F', 'I', 'X'];
};
obj_upload_item.prototype._setDefaultGWType = function(s){
	this.__sDefaultType = s || 'X';
};
obj_upload_item.prototype._setDefaultFolder = function(aPath){
	this.__aDefaultFolder = aPath;
};


obj_upload_item.prototype._open = async function(id){
	var file = this._getFile(id),
		sClass = file['class'] || 'file',
		name = file.description || file.name,
		ext = Path.extension(name),
		sFullPath = '',
		url;

	switch (sClass) {
		case 'link':
			file.ticket = await new Promise(function(resolve) {
				ShortURL.resolve({
					url: file.url,
					callback: function(oURL) {
						if (oURL.error) {
							return gui.notifier._value({type: 'alert', args: {header: '', text: 'ATTACHMENT::SMART_DOESNT_EXIST'}});
						}
						resolve(oURL.url);
					},
					filename: file.name
				});
			});
			break;
		case 'file':
			sFullPath = file.folder +'/'+ file.id;
			break;

		case 'item':
			sFullPath = file.fullpath || this._getFolder();
			if (file.attachment){
				sFullPath += '/' + encodeURIComponent(file.attachment);
				sClass = 'attachment';
			}
			else{
				var aPath = Path.split(sFullPath);
				if (WMFolders.getType([aPath[0],Path.basedir(aPath[1])]) == 'F')
					sClass = 'file_attachment';
			}
			break;

		case 'attachment':
			sFullPath = file.fullpath || (file.folder +'/'+ file.id);
			break;
	}

	url = url || (sPrimaryAccountClient + 'server/download.php?' + buildURL({'dlsess': dataSet.get('main', ['dlsess']), 'class': sClass, 'fullpath': sFullPath}));

	//Preview
	switch(ext){
		case "pdf":
			if (GWOthers.getItem('LAYOUT_SETTINGS','disable_pdf') == 1)
				return downloadItem(file.ticket || url, true);

			var pdf = await gui._create('pdf','frm_pdf');
			pdf._load(file.ticket || url, name);
			return true;

		case "mp3":
			if (gui.audio){
				gui.audio._value(file.ticket || url, name);
				return true;
			}
			break;

		default:

			if (Item.imageSupport(name)){
				var img = await gui._create('imgview','frm_imgview');
					await img._fill([{title:name, url:file.ticket || url}]);
					img._value(0);
				return true;
			}
			else
			if (Item.officeSupport(name)){
				var sURL = file.ticket || (url.indexOf('http') === 0 ? url : (document.location.origin + document.location.pathname + url));
				Item.officeOpen({EVNTITLE: name, iid: file.ticket ? '' : file.id, url: file.iid ? void 0 : sURL, autoreopen: false}, [this,'_download',[file.id, true]], Path.extension(name), file.ticket ? 'view' : '');
				return true;
			} else  {
				this._download(file.id, true);
				return true;
			}
	}

	return false;
};

obj_upload_item.prototype._download = function(id, bDownload) {

	if (bDownload || this._open(id) === false){

		var file = this._getFile(id),
			sClass = file['class'] || 'file',
			sFullPath = '';

		switch (sClass) {
			case 'file':
				sFullPath = file.folder +'/'+ file.id;
				break;

			case 'message':
				sFullPath = file.fullpath;
				break;

			case 'item':
				sFullPath = file.fullpath;
				if (file.attachment){
					sFullPath += '/' + file.attachment;
					sClass = 'attachment';
				}
				else{
					var aPath = Path.split(sFullPath);
					if (WMFolders.getType([aPath[0],Path.basedir(aPath[1])]) == 'F')
						sClass = 'file_attachment';
				}
				break;

			case 'attachment':
				sFullPath = file.fullpath || (file.folder +'/'+ file.id);
				break;
		}

		if (sFullPath) {
			return downloadItem(file.ticket || buildURL({
				'dlsess': dataSet.get('main', ['dlsess']),
				'class': sClass,
				'fullpath': sFullPath
			}), !!file.ticket);
		}
	}
};