_me = obj_upload_edit.prototype;
function obj_upload_edit(){};

_me.__constructor = async function(){
	var me = this;
    this.__idtable = [];

	this.file._setGWTypes(['M', 'C', 'F', 'E', 'J', 'N', 'T', 'X']);
	this.file._onchange = this.__fillDataGrid.bind(this);

	this.attachments.__sortColumn = 'name';
	await this.attachments._addColumns({
		ico:{width:40,css:'file_type',type:'static'},
		name:{title:"DATAGRID_ITEMS_VIEW::EVNFILENAME",width:100, mode:'%', encode: true, arg:{sort:'asc'}},
		size:{title:"DATAGRID_ITEMS_VIEW::EVNFILESIZE",width:100,css:'size',arg:{sort:'asc'}}
	});

	// If dropbox is allowed add functionality otherwise remove button
	if(GWOthers.getItem('RESTRICTIONS','disable_dropbox')>0)
		this.dropbox._destruct(); // Dropbox disabled, remove button
	else
		this.dropbox._onclick = function() {
			if(!(GWOthers.getItem('EXTERNAL_SETTINGS', 'dropbox_app_key') || '').length) // Dropbox but no app_key
				gui.notifier._value({type: 'alert', args: {header: 'DROPBOX::ERRORALERT', text: 'DROPBOX::MISSINGKEY'}});
			else if(typeof Dropbox == "undefined") // Dropbox failed loading
				gui.notifier._value({type: 'alert', args: {header: 'DROPBOX::ERRORALERT', text: 'DROPBOX::UNAVAILABLE'}});
			else
				Dropbox.choose({linkType: 'preview', success: function(files) {
					var aItems = [];
					for(var i in files)
						aItems.push({type: 'url', title: files[i].name, fullpath: files[i].link, size: files[i].bytes});
					me.file.__addItems(aItems);
				}});
		};

	this.attachments._ondblclick = function(e,elm,arg){
		if (arg && Is.Defined(arg.id)){
			me._save(arg.id, 'auto');
		}
	};

	this.attachments._oncontext = async function(e,elm,arg,sLineId){

		//Klikly jsme na místo bez položek?
		if (typeof sLineId == 'undefined') return;

		var cmenu = await me._gui._create("cmenu","obj_context",'','',me);

		var aMenu = [],
			idtbl = me.file._getFile(arg.id);

		var x = new RegExp(/\.eml$/ig);

		if (idtbl){
			if (idtbl['class'] == 'itemlink' || (idtbl['class'] == 'attachment' && (x.test(idtbl.name) || (sPrimaryAccountWebDAV && Item.officeSupport(idtbl.name))))){
				var bIWD =  dataSet.get('accounts', [sPrimaryAccount, 'OFFICE_SUPPORT']) == 'true';
				aMenu.push({
					title:'POPUP_ITEMS::OPEN',
					arg: [me,'_save',[sLineId,'force']],
					'nodes':[
						{"title":'DOCUMENT::OPENDOCUMENT','arg':[me,'_save',[sLineId,'edit']], disabled: !bIWD},
						{"title":'DOCUMENT::OPENDOCUMENTVIEW','arg':[me,'_save',[sLineId,'view']], disabled: !bIWD},
						{"title":'OFFICELAUNCHER::OFFICESUITE','arg':[me,'_save',[sLineId,'external']]}
					]
				});
			}
			else
			if (Path.extension(idtbl.name) == 'pdf'){
				aMenu.push({
					title:'POPUP_ITEMS::OPEN',
					arg: [me,'_save',[sLineId, 'force']]
				});
			}

			if (idtbl['class'] != 'itemlink'){
				aMenu.push(
					{"title":'ATTACHMENT::DOWNLOAD','arg':[me,'_save',[sLineId]]},
					{"title":'ATTACHMENT::DOWNLOAD_ALL','arg':[me,'_save',[]],disabled:me.__disable_save_all}
				);
			}
		}

		aMenu.push({"title":'ATTACHMENT::REMOVE','arg':[me.file,'_remove',[sLineId]],disabled:me.__disabled});

		await cmenu._fill(aMenu);
		cmenu._place(e.clientX,e.clientY);
	};

	this.remove._onclick = function() {
		var out = [],
			vd = me.attachments.__valueData;
		for (var i in vd)
			out.push(vd[i].id);

		me.__deleteItems(out);
	};

	////// FILE //////
	this.file._onuploadstart = function(){
		me.__disable_save_all = true;
		me.attachments._create('progress', 'obj_upload_info', '', 'bottom');

		if (me._onuploadstart)
			me._onuploadstart();
	};
	this.file._onuploadprogress = function(file, a, b){
		me.attachments.progress._value(file.name, a, b, [function(){file.xhr.abort()}]);
	};
	this.file._onuploadsuccess = function(){
		me.attachments.progress && me.attachments.progress._handler(null);
	};
	this.file._onuploadend = function (){
		me.__disable_save_all = false;
		me.attachments.progress && me.attachments.progress._destruct();

		if (me._onuploadend)
			me._onuploadend();
	};

	this._main.addEventListener('paste',function (e) {
		if(!me.file || !me.file.file || !me.file.file.__ondropfile) {
			return;
		}
		var items = (e.clipboardData || (e.originalEvent || {}).clipboardData || {}).items || (window.clipboardData || {}).files || [];
		for (var i = 0; i < items.length; i++) {
			if (items[i].getAsFile && items[i].type.indexOf('image') === 0) {
				var file = items[i].getAsFile();
				if (!file) {
					continue;
				}
				try {
					var type = items[i].type.split('/')[1];
					if (type === 'heif') {
						type = 'heic';
					}
					file = new File([file], 'clipboard-' + new IcewarpDate() + '.' + type, {
						type: items[i].type
					});
				} catch {
					//
				}
				me.file.file.__ondropfile([file]);
			}
		}
	});
};

_me._value = function(v){
	if (Is.Defined(v)){
		this.file._value(v);
	}
	else{
		var out = [],
			files = this.file._value();

		for (var i in files)
			if (!files[i]['fullpath'] && ~['attachment', 'P', 'itemlink', 'url'].indexOf(files[i]['class'])){
				if (files[i]['removed'])
					out.push({uid:files[i].id});
			}
			else
			if (!files[i]['removed']){
				out.push({values:{
					'class':files[i]['class'] || 'file',
					'description': files[i]['name'],
					'size': files[i]['size'] || 0,
					'fullpath': files[i]['fullpath'] || (files[i]['folder'] || this.file._getFolder()) + "/" + files[i]['id']}
				});
			}

		return out;
	}
};

_me.__fillDataGrid = function(){
	var aData = {},
		val = this.file._filteredValue();

	for (var i in val) {
		var ico = '';
		if (Item.imageSupport(val[i].name) || Path.extension(val[i].name) === 'heic') {
			ico = 'image';
		} else if (Item.videoSupport(val[i].name)) {
			ico = 'video';
		} else if (Item.editSupport(val[i].name)) {
			ico = 'note';
		} else if (Item.isDocument(val[i].name)) {
			ico = 'doc';
		} else if (Item.isSpreadsheet(val[i].name)) {
			ico = 'xls';
		} else if (Item.isPresentation(val[i].name)) {
			ico = 'ppt';
		} else if (Path.extension(val[i].name.toLowerCase()) === 'pdf') {
			ico = 'pdf';
		} else if (Item.audioSupport(val[i].name)) {
			ico = 'audio';
		}

		aData[i] = {
			id: val[i].id,
			data: {
				ico: ['', '', '', ico],
				name: val[i].name,
				size: [parseFileSize(val[i].size || 0), parseInt(val[i].size || 0)]
			},
			arg: {
				id: val[i].id,
				aid: val[i].aid,
				fid: val[i].fid,
				iid: val[i].iid,
			}
		};
	}

	this.attachments._serverSort(aData);
};

_me.__deleteItems = function(aIDs) {
	for (var i in aIDs)
	    this.file._remove(aIDs[i]);
};

_me._save = async function(id,sMode) {
	//Save ALL
	if (typeof id == 'undefined'){
		var aUrl = {'dlsess':dataSet.get('main',['dlsess']),'class':'allattachments','fullpath':this.file._getFolder()};
		downloadItem(buildURL(aUrl));
	}
	else{
		var file = this.file._getFile(id);
		if (file){
			var sClass = file['class'],
				sFullPath = '',
				aPath;

			switch (sClass) {
				case 'P':
					sClass = 'attachment';
				case 'file':
				case 'attachment':
					if (sMode){
						switch(Path.extension(file.name)){
							case 'eml':

								aPath = this.__splitFullPath(file.fullpath);
								aPath[2] = WMItems.__clientID(aPath[2] + '|' + aPath.pop());

								OldMessage.openwindow(aPath);
								return;

							case 'pdf':
								if(GWOthers.getItem('LAYOUT_SETTINGS','disable_pdf') == 1) {
									downloadItem(sPrimaryAccountClient + 'server/download.php?' + buildURL({'dlsess': dataSet.get('main', ['dlsess']), 'class': sClass, 'fullpath': file.fullpath}), true);
									return;
								} else {
									var	sPath = sPrimaryAccountClient + 'server/download.php?' + buildURL({'dlsess': dataSet.get('main', ['dlsess']), 'class': sClass, 'fullpath': file.fullpath});

									var pdf = await this._gui._create('pdf','frm_pdf');
									pdf._load(sPath, file.name);

									return;
								}

							default:
								aPath = this.__splitFullPath(file.fullpath);
								if (sPrimaryAccountWebDAV && file.ticket && Item.officeSupport(file.name)){
									Item.officeOpen({aid:aPath[0],fid:aPath[1],iid:aPath[2],attid:file.id}, [downloadItem,[file.ticket,true]], Path.extension(file.name));
									return;
								}
								return Item.previewItem(aPath, file.id);
						}
					}

				case 'url':
				case 'item':
					sFullPath = file['fullpath'] || ((file['folder'] || this.file._getFolder())+'/'+file['id']);
					if (file.attachment){
						sFullPath += '/' + file.attachment;
						sClass = 'attachment';
					}
					break;

				case 'itemlink':

					//Just Added (has it's original fullpath)
					if (file.fullpath){
						aPath = this.__splitFullPath(file.fullpath);
							aPath[2] = file.id;

						Item.openwindow(aPath);
					}

					return;
			}

			if (sFullPath) {
				var sUrl = buildURL({'dlsess': dataSet.get('main', ['dlsess']), 'class': sClass, 'fullpath': sFullPath});
				if (sClass=='url')
					open(sPrimaryAccountClient + 'server/download.php?' + sUrl, file.name);
				else
					downloadItem(sUrl);
			}
		}
	}
};
	_me.__splitFullPath = function(sPath) {
		var tmp = Path.split(sPath, false, true);
		tmp[3] = tmp[2];
		var fid = tmp[1].split('/');
		tmp[2] = fid.pop();
		tmp[1] = fid.join('/');

		return tmp;
	};

_me._disabled = function(b){
	if (Is.Defined(b)){
		this.__disabled = b?true:false;
		this.remove._disabled(this.__disabled);
		this.file._disabled(this.__disabled);
		this.dropbox && this.dropbox._disabled(this.__disabled);
	}
	else
		return this.__disabled;
};
