
_me = obj_upload_core.prototype;
function obj_upload_core(){};

_me.__constructor = async function(options){

	this.__options = options || {};
	this.__settings = {
		post_params: {
			sid: dataSet.get('main', ['sid']),
			swf: 1
		},
		queue_limit: 0,
		process_limit: 3
	};

	this._isUploading = false
	this.__queue = [];
	this.__value = [];
	this.__handlers = [];
	this.__xhr = null;

	this.__init();

	this._add_destructor('__destruct');
};

_me.__destruct = function(){
	//remove file-input from body
	if (this.__eIN && this.__eIN.parentNode)
		this.__eIN.parentNode.removeChild(this.__eIN);

	this._abort();
};

_me.__init = function(){

	var elm = mkElement('input', {
		'type': 'file',
		'accept': this.__eIN?this.__eIN.accept:'',
		'style':{display:'none'},
		'multiple':!this.__eIN || this.__eIN.multiple?'multiple':'',
		disabled: this.__disabled,
		'data-parent': ((this._parent || {})._parent || {})._pathName || ''
	});

	elm.addEventListener("change", function(e){
		if (e.target.files.length && this.__ondropfile)
			this.__ondropfile(e.target.files);
			elm.value = '';
	}.bind(this),false);

	this.__eIN && this.__eIN.parentElement.removeChild(this.__eIN);
	gui._main.appendChild(elm);

	this.__eIN = elm;
};

_me.__initFile = function (bDisabled){
	this._disabled(bDisabled);
};

/**
 * SYSTEM: server vrati info o folder
 **/
_me._setPostParam = function (sName,sVal){
	if (this.__settings && Is.Defined(sName)){
		if (Is.Defined(sVal))
			this.__settings.post_params[sName] = sVal;
		else
			delete this.__settings.post_params[sName];
	}
};

_me._setFolder = function (sFolder){
	this._setPostParam('folder',sFolder);
};
_me._getFolder = function (){
	return this.__settings.post_params['folder'];
};

/**
 * Extended features
 **/
 _me._setFileQueueLimit = function (i){
	this.__settings.queue_limit = Is.Number(i)?i:0;
};
_me._setProcessLimit = function (i){
	this.__settings.process_limit = Is.Number(i)?i:0;
};
_me._setMultipleSelection = function (b){
	if (b){
		this.__eIN.setAttribute('multiple');
		this._setFileQueueLimit();
	}
	else{
		this.__eIN.removeAttribute('multiple');
		this._setFileQueueLimit(1);
	}
};
_me._getMultipleSelection = function (){
	return !!this.__eIN.hasAttribute('multiple');
};
_me._setFileTypes = function (sTypes){
	if (sTypes)
		this.__eIN.setAttribute('accept', sTypes);
	else
		this.__eIN.removeAttribute('accept');
};

/**
 * Handle XHR Upload
 **/

_me.__ondropfile = function(files,aHandler){

	if ([].filter.call(files, Boolean).length){
		this._isUploading = true;

		// convert dataTransfer.files into Array
		files = [].filter.call(files, function(file) {
			if (file.size > 0){
				if (+dataSet.get('main', ['MBOX_QUOTA']) && (((dataSet.get('main', ['MBOX_USAGE']) * 1024) + file.size) > (dataSet.get('main', ['MBOX_QUOTA']) * 1024))) {
					gui.notifier._value({type: 'alert', args: {header: 'ALERTS::MAILBOX_QUOTA_LIMIT', text_plain: (file.name ? '\n'+ file.name : '').trim()}});
				} else if (sPrimaryAccountULIMIT && file.size > sPrimaryAccountULIMIT*1048576)
					gui.notifier._value({type: 'alert', args: {header: 'ATTACHMENT::UPLOAD', text: 'UPLOAD::ERROR1', args: [sPrimaryAccountULIMIT]}});
				else{
					file.ext = Path.extension(file.name);
					file.onclick = this.__options.onclick;
					file.retry = this._retry.bind(this, file);
					return true;
				}
			}
			else
				gui.notifier._value({type: 'alert', args: {text: 'NOTIFICATION::EMPTY_FILE'}});
		}, this)
		this.__queue = this.__queue.concat(files);

		if (files.length) {
			if (this._onuploadstart)
				this._onuploadstart(files);
			gui.__exeEvent('onuploadstart',{owner: this, files: files});

			for (var i = 0; i < (this.__settings.process_limit || 99); i++) {
				if (this.__handlers.length < this.__settings.process_limit) {
					this.__handleFile(aHandler);
				}
			}
		}
	}
};

_me._value = function(value) {
	if (value) {
		return this.__value = value;
	}

	return this.__value;
}

_me._restore = function() {
	this._isUploading = true;
	var files = [].concat(this.__value, this.__queue);
	if (this._onuploadstart) {
		this._onuploadstart(files);
	}

	gui.__exeEvent('onuploadstart', { owner: this, files: files, restore: true });

	if (!this.__handlers.length) {
		this.__handleFile(void 0, true);
	}
};

_me._retry = function(file) {
	this.__queue.push(file);

	if (!this.__handlers.length) {
		this.__handleFile();
	}
}

_me.__handleFile = function(aHandler, bRestore) {
	var file = this.__queue.shift();

	if (!file) {
		if (!this.__handlers.length) {
			this._isUploading = false;
			if (this._onuploadend)
				this._onuploadend(this.__value);

			gui.__exeEvent('onuploadend', { owner: this, files: this.__value, restore: bRestore });
		}
		return;
	}

	if (file.aborted) {
		return this.__onAbort(file, aHandler, bRestore);
	}

	this.__value.push(file);
	this.__handlers.push(file);

	// create HTTPRequest
	var xhr = new XMLHttpRequest();
		xhr.open("POST", "server/upload.php", true);

	file.xhr = xhr;

	file._abort = function() {
		xhr.abort();
		if (xhr.readyState === 0) {
			this.__onAbort(file, aHandler, bRestore);
		}
	}.bind(this);

	// create form
	if (window.FormData){
		var fd = new FormData();

		for (var sParam in this.__settings.post_params)
			fd.append(sParam, this.__settings.post_params[sParam]);

		fd.append("file", file);
	}

	// send HTTPRequest
	var me = this;
	xhr.upload.addEventListener("progress", function(evn) {
		if (me._onuploadprogress)
			me._onuploadprogress(file,evn.loaded,file.size,evn);

		try {
			if (evn.loaded > file.size) {
				evn.loaded = file.size;
			}
		} catch {
			//
		}
		gui.__exeEvent('onuploadprogress',{owner: me, file: file, completed: evn.loaded, size: file.size});
	}, false);


	xhr.upload.addEventListener("abort", this.__onAbort.bind(this, file, aHandler, bRestore), false);

	xhr.upload.addEventListener("error", function() {
		// me.__value.splice(me.__value.indexOf(file), 1);
		if (~me.__handlers.indexOf(file)) {
			me.__handlers.splice(me.__handlers.indexOf(file), 1);
		}

		if (me.onuploaderror)
			me.onuploaderror(file);

		gui.__exeEvent('onuploaderror',{owner: me, file: file});

		me.__handleFile(aHandler, bRestore);
	}, false);

	xhr.onreadystatechange = function() {
		if (this.readyState == 4) {
			if (~me.__handlers.indexOf(file)) {
				me.__handlers.splice(me.__handlers.indexOf(file), 1);
			}

			if ((this.status >= 200 && this.status <= 200) || this.status == 304) {
				if (this.responseText != ""){
					if (this.getResponseHeader("Content-Type").split(';')[0] == 'text/json'){

						var aResponse = JSON.parse(this.responseText);

						me._setFolder(aResponse.folder);

						var out = {
							folder:aResponse.folder,
							id:aResponse.id,
							name:file.name.normalize('NFC').replace(/[/\\:?"<>|~*]/g,'_'),
							size:file.size
						};
						file.data = out;
						file.folder = out.folder;
						file.id = out.id;

						if (aHandler)
							executeCallbackFunction(aHandler,aResponse,file,out);

						if (me._onuploadsuccess)
							me._onuploadsuccess(file);
						gui.__exeEvent('onuploadsuccess',{owner: me, file: file});

						//handle next...
						me.__handleFile(aHandler, bRestore);
					}
					//-- Error
					else{
						// me.__value.splice(me.__value.indexOf(file), 1);

						if (me.onuploaderror)
							me.onuploaderror(file);

						gui.__exeEvent('onuploaderror',{owner: me, file: file});
						
						me.__handleFile(aHandler, bRestore);

						var s, pos = this.responseText.indexOf(':');
						if (pos>-1){
							var i = parseInt(this.responseText.substr(pos+2),10);

							if (!Is.Number(i) || !(s = getLang('UPLOAD::ERROR'+i,'',true)))
                                s = this.responseText;
						}
						else
							s = this.responseText;

						gui.notifier._value({type: 'alert', args: {header: '', text_plain: s}});
					}
				}
			} else if (this.status !== 0) {
				// me.__value.splice(me.__value.indexOf(file), 1);

				if (me.onuploaderror)
					me.onuploaderror(file);

				gui.__exeEvent('onuploaderror',{owner: me, file: file});
				
				me.__handleFile(aHandler, bRestore);
			}
		}
	};

	xhr.send(fd);
};

_me.__onAbort = async function(file, aHandler, bRestore) {
	if (~this.__value.indexOf(file)) {
		this.__value.splice(this.__value.indexOf(file), 1);
	}
	if (~this.__handlers.indexOf(file)) {
		this.__handlers.splice(this.__handlers.indexOf(file), 1);
	}

	if (this._onuploadaborted)
		this._onuploadaborted(file);

	await gui.__exeEvent('onuploadaborted',{owner: this, file: file});
	file.aborted = true;
	this.__handleFile(aHandler, bRestore);
};

_me._abort = function(){
	//abort current xhr
	if (this.__xhr && this.__xhr.readyState<4)
		this.__xhr.abort();
};


_me._disabled = function(b){
	if (Is.Defined(b)){
		this.__disabled = !!b;
		this.__eIN.disabled = this.__disabled;
	}
	else
		return this.__disabled;
};
