function obj_upload_center() { }

obj_upload_center.prototype.__constructor = async function () {
	this.__files = [];

	this.__options = {
		preload: 10,
		notifyItem: ['U'],
		notifyType: ['item']
	};

	this.__aRequestArray = ['EVNFILENAME'];

	this._getAnchor('loading').innerHTML = getLang('CHAT::LOADING');

	gui._obeyEvent('onuploadstart', [this, '__onuploadstart']);
	gui._obeyEvent('onuploadaborted', [this, '__onuploadaborted']);
	gui._obeyEvent('onuploaderror', [this, '__onuploaderror']);
	gui._obeyEvent('onuploadcommit', [this, '__onuploadcommit']);

	gui.socket.api._obeyEvent('onnotify', [this, '__onnotify']);

	gui.frm_main.upload._dropzone(this._main, async function(){
		return await (new cTemplate()).tmp('dropzone', {title: getLang('ATTACHMENT::DROP_TITLE'), body: getLang('ATTACHMENT::DROP_BODY')});
	}, 'item small');

	//**** Drag and Drop ****
	var me = this;
	this.__dndtimer = '';
	this.___lastdragover;

	this.__body.onmousedown = function(e) {
		clearTimeout(me.__dndtimer);

		var elm = e.target;
		if (elm.tagName !== 'SECTION') {
			elm = elm.closest('section');
		}

		if (e.button > 1 || !elm) return;

		var id = elm.getAttribute('rel'),
			x = e.clientX,
			y = e.clientY,
			data = (me.__aData[id] || {}).data;

		if (!data || !data.aid) {
			return;
		}

		me.__dndtimer = setTimeout(function() {
			gui.frm_main.dnd.create_drag({
				type: 'item',
				value: [{
					aid: data.aid,
					fid: data.fid,
					iid: data.iid,
					name: data.EVNLOCATION,
					size: data.EVNCOMPLETE,
					fullpath: data.fullpath
				}],
				x: x,
				y: y,
				obj: this
			});
		}, 250);

		function onmouseup() {
			gui._main.removeEventListener('mouseup', onmouseup);
			clearTimeout(me.__dndtimer);
		};

		gui._main.addEventListener('mouseup', onmouseup);
	};
};

obj_upload_center.prototype._serverSort = async function (aFolder, bUpdate, aFilter) {
	if (((!aFolder && this.__aRequestData.folder) || compareObj(this.__aRequestData.folder, aFolder, true)) && (!Is.Object(aFilter) || (Is.Object(this.__aRequestData.filter) && !this.__aRequestData.filter.until && compareObj(this.__aRequestData.filter, aFilter, true)))) {
		if (this.__aRequestData.fetchnew) {
			return;
		}

		this.__aRequestData.fetchnew = true;
	} else {
		await this._clear();
			
		this.__aRequestData.folder = aFolder;
		this.__aRequestData.filter = aFilter;

		this.__loading = 0;
	}

	this.__sep = false;
	this.__lastSep = false;
	this.__separators = [];
	if (this.__files.length) {
		var filter = aFilter && (aFilter.sys_search || aFilter.search);
		var files = {};
		files[this.__aRequestData.folder.aid] = {};
		files[this.__aRequestData.folder.aid][this.__aRequestData.folder.fid] = this.__files.map(function(file) {
			return (!filter || ~file.name.indexOf(filter)) && file;
		}, this).filter(Boolean);
		this._response(files, true);
	}

	this._fetch();
};

obj_upload_center.prototype._request = function (bUpdate) {
	this.__loading = 1;

	var aSearch = [];

	if (this.__aRequestData.filter) {
		if (this.__aRequestData.filter.sys_search)
			aSearch.push('(' + this.__aRequestData.filter.sys_search + ')');

		if (this.__aRequestData.filter.search)
			aSearch.push('("' + this.__aRequestData.filter.search.quoteMeta() + '")');
	}

	var aFilter = {
		limit: this.__options.preload,
		sort: 'EVNSTARTDATE desc, EVNSTARTTIME desc',
		search: aSearch.join(' ')
	};

	if (this.__aRequestData.offset)
		aFilter.offset = this.__aRequestData.offset;

	var aItemsInfo = {
		aid: this.__aRequestData.folder.aid,
		fid: this.__aRequestData.folder.fid,
		values: [],
		filter: aFilter
	};

	//Blank request to check count
	if (bUpdate) {
		if (!this._refresh()) {
			WMItems.list(aItemsInfo, '', '', '', [function (aData) {
				aData = aData[this.__aRequestData.folder.aid];
				if ((aData = aData[this.__aRequestData.folder.fid]))
					this.__check_count(parseInt(aData['/']));

			}.bind(this)]);
		}
	} else { //Request
		WMItems.list(aItemsInfo, '', '', '', [this, '_response']);
	}
};

obj_upload_center.prototype._response = async function (aData, bUpdate, bSkipTime, row) {
	if (this._destructed) return;

	if ((aData = aData[this.__aRequestData.folder.aid]) && (aData = aData[this.__aRequestData.folder.fid])) {

		// if (!this.__check_count(parseInt(aData['/'])))
		// 	return;

		// this.__aRequestData.offset = aData['/'] == '0' ? '' : parseInt(aData['$']);

		delete aData['/'];	//count
		delete aData['#'];
		delete aData['$'];	//offset
		delete aData['@'];	//attributes

		var c = 0;
		for (var iid in aData) {
			c++;

			//skip duplicities
			if (!this.__aData[iid]) {
				var sep, sepelm;
				if (aData[iid].EVNSTARTDATE) {
					sep = IcewarpDate.julian(aData[iid].EVNSTARTDATE);
				} else if (aData[iid].EVN_CREATED) {
					sep = IcewarpDate.unix(aData[iid].EVN_CREATED);
				}
	
				if (sep && !bUpdate && (!this.__sep1.sep || !sep.isSame(this.__sep1.sep, 'date'))) {
					sepelm = this._separator(CalendarFormatting.normalWithWeekDay(sep));
	
					this.__sep1 = {sep:sep, elm: sepelm};
	
					if (!this.__sep2.sep)
						this.__sep2 = {sep:sep, elm: sepelm};
				}
				
				await this.__item(aData[iid], bUpdate, row);
			}

			if (bUpdate) {
				if (this.__sep2 && this.__sep2.sep && sep.isSame(this.__sep2.sep, 'date') && this.__sep2.elm && this.__sep2.elm.elm.parentNode) {
					this.__sep2.elm.elm.parentNode.removeChild(this.__sep2.elm.elm);
				}
				sepelm = obj_list_load.prototype._separator.call(this, CalendarFormatting.normalWithWeekDay(sep), '', true);
				this.__sep2 = {sep:sep, elm: sepelm};
			}
		}

		if (!bSkipTime) {
			if (c == this.__options.preload)
				this.__loading = 0;
			else {
				this.__loading = 2;
			}

			this.__aRequestData.offset = (this.__aRequestData.offset || 0) + c;
		}

		if (this._oncount)
			this._oncount(Is.Empty(this.__aData) ? 0 : 1);
	}

	this.__body.onscroll();

	if (!bUpdate || this.__aRequestData.fetchnew)
		this._fetch();
};

obj_upload_center.prototype.__item = async function (aData, bTop, row) {
	aData.iid = WMItems.__clientID(aData.EVN_ID || unique_id());
	if (aData.EVNSTARTDATE) {
		aData.datetime = IcewarpDate.julian(aData.EVNSTARTDATE, aData.EVNSTARTTIME);
	} else if (aData.EVN_CREATED) {
		aData.datetime = IcewarpDate.unix(aData.EVN_CREATED);
	}

	var aOptions = { progress: { bar: true }, time: true, shareable: !!aData.EVN_ID, toolbar: true };

	try {
		aData.name = aData.name || aData.EVNTITLE;
	} catch {
		//
	}
	if (aData.meta) {
		var meta = aData.meta || aData.EVN_METADATA;
		if (typeof meta === 'string') {
			try {
				meta = JSON.parse(meta);
			} catch {
				//
			}
		}
		aOptions.type = meta.type;
		switch(aOptions.type) {
			case 'im':
				aData.meta = meta.name;
				break;
		}
	}

	if (aData.EVNFOLDER) {
		aData.fid = aData.EVNFOLDER = aData.EVNFOLDER.replace(/^@@trash@@/, '__@@GWTRASH@@__');
		var aFolder = dataSet.get('folders', [sPrimaryAccount, Path.slash(aData.EVNFOLDER)]) || {};
		aData.meta = aData.meta || WMFolders.getFolderName({aid: sPrimaryAccount, fid: aData.EVNFOLDER});
		switch(aFolder.TYPE) {
			case 'F': 
				aOptions.type = 'documents';
				break;
			case 'I':
				aOptions.type = 'teamchat';
		}
	}
	if (aData.EVNFOLDER && aData.EVN_ID) {
		aData.fullpath = sPrimaryAccount + '/' + aData.EVNFOLDER + '/' + WMItems.__serverID(aData.EVN_ID) + '/' + (aData.EVNLOCATION || aData.name);
	}
	if (aData.EVNTHUMBNAILTICKET) {
		aData.preview = aData.EVNTHUMBNAILTICKET;
	}

	row = row || this._row('', '', aData.iid, bTop);

	this.__aData[aData.iid] = {
		data: aData,
		anchor: row.anchor,
		obj: await this._create('attachment', 'obj_attachment', row.anchor, '', aData, aOptions)
	}

	if (this._oncount)
		this._oncount(Is.Empty(this.__aData) ? 0 : 1);
};

obj_upload_center.prototype._updateTimes = function () {
	for (var i in this.__aData) {
		this.__aData[i].obj._updateTime();
	}
};

obj_upload_center.prototype.__onuploadstart = function (data) {
	setTimeout(function() {
		[].forEach.call(data.files, function (file) {
			if (Is.InstanceOf(file, 'File') || Is.InstanceOf(file, 'FakeFile')) {
				if (~this.__files.indexOf(file)) {
					return;
				}
				file.EVN_CREATED = new IcewarpDate().unix();
				this.__files.unshift(file);
				var aData = {};
				aData[sPrimaryAccount] = {};
				aData[sPrimaryAccount][this.__aRequestData.folder.fid] = {};
				aData[sPrimaryAccount][this.__aRequestData.folder.fid][WMItems.__clientID(file.id)] = file;
				this._response(aData, true, true);
			}
		}, this);
	}.bind(this), 5);
};

obj_upload_center.prototype.__onuploadaborted = function (data) {
	for (var i in this.__aData) {
		if (this.__aData[i].obj.__file === data.file) {
			this._remove(this.__aData[i].anchor);
			delete this.__aData[i];
			this.__files.splice(this.__files.indexOf(data.file), 1);
			if (this._oncount) {
				this._oncount(Is.Empty(this.__aData) ? 0 : 1);
			}
			break;
		}
	}
};

obj_upload_center.prototype.__onuploaderror = function () {
	
};

obj_upload_center.prototype.__onuploadcommit = function (aData) {
	if (!aData.id) {
		return;
	}
	this.__files = this.__files.filter(function(file) {
		return file.id !== aData.id;
	}, this);
	if (aData.data.name) {
		for (var i in this.__aData) {
			if (this.__aData[i].data.id === aData.id) {
				var obj = this.__aData[i].obj;
					obj._destruct();

				var data = this.__aData[i].data;
					data.id = data.EVN_ID = aData.data.id;
					data.folder = data.EVNFOLDER = data.fid = aData.data.folder;
					data.aid = sPrimaryAccount;
				var row = this.__aData[i];
				delete this.__aData[i];

				aData = {};
				aData[sPrimaryAccount] = {};
				aData[sPrimaryAccount][this.__aRequestData.folder.fid] = {};
				aData[sPrimaryAccount][this.__aRequestData.folder.fid][WMItems.__clientID(data.id)] = data;
				this._response(aData, true, true, row);
				break;
			}
		}
	}
};

obj_upload_center.prototype.__onnotify = function(data) {
	if (!data.ITEM || data.EMAIL !== sPrimaryAccount || data.TYPE !== 'item') {
		return;
	}
	if ((data.ACTION || '').toLowerCase() === 'delete') {
		for (var i in this.__aData) {
			var obj = this.__aData[i].obj;
			if (WMItems.__serverID(obj.__file.EVN_ID) === data.ITEM && Path.slash(obj.__file.EVNFOLDER) === data.FOLDER) {
				if (data['FOLDER-ID']) {
					delete this.__aData[i].data.meta;
					this.__aData[i].data.EVNFOLDER = data['FOLDER-ID'];
					obj._destruct();
					this.__item(this.__aData[i].data, false, {
						anchor: this.__aData[i].anchor
					});
				} else {
					obj._destruct();
					if (this._oncount) {
						this._oncount(Is.Empty(this.__aData) ? 0 : 1);
					}
				}
			}
		}
	} else if (data.FOLDER !== '@@trash@@' && data['ITEM-TYPE'] === 'F' && ~['update', 'add'].indexOf(data.ACTION)) {
		WMItems.list({aid: sPrimaryAccount, fid: data.FOLDER, iid: data.ITEM}, '', '', '', [function(data) {
			if (data && data[sPrimaryAccount] && data[sPrimaryAccount][data.FOLDER]) {
				data[sPrimaryAccount][this.__aRequestData.folder.fid] = data[sPrimaryAccount][data.FOLDER];
				this._response(data, true, true);
			}
		}.bind(this)])
	}
}