/**
 * 	File upload object
 *  It has no visible representation in DOM
 **/
_me = obj_upload.prototype;
function obj_upload(){};

obj_upload.__instances = {};
obj_upload._instance = async function(context, id, options, sType) {
	if (this.__instances[id]) {
		return this.__instances[id];
	}

	options = options || {};
	options.__instanceId = id;
	options.context = context;

	var instance = await gui._create('_upload', sType || 'obj_upload', '', '', options);
	instance._add_destructor('__removeInstance');
	return this.__instances[id] = instance;
}

_me.__removeInstance = function() {
	delete obj_upload.__instances[this.__options.__instanceId];
};

_me.__constructor = async function(options){
	var me = this;

	this.__options = options || {};
	this.__upload_buffer = [];
	this.__idtable = [];

	await this._create('file','obj_upload_core', '', '', options);

	this.file._onuploadstart = function (files){
		me.__idtable = [];
		me._uploading = true;

		if (me._onuploadstart)
			me._onuploadstart(files);

		me.file.__eIN.value = '';
	};

	this.file._onuploadprogress = function(file,a,b,xhr){
		if (me._onuploadprogress)
			me._onuploadprogress(file,a,b,xhr);
	};

	this.file._onuploadaborted = function(file){
		if (me._onuploadaborted)
			me._onuploadaborted(file);
	};

	//File added
	// HTTP
	// .. [id](string) = 4b1z719aa80f0
	// .. [name](string) = 156.jpg
	// .. [size](string) = 17933
	// .. [folder](string) = 2009-12-08-4b1z71962660d
	this.file._onuploadsuccess = function(file){
		var out = file.data || file;
		out['class'] = 'file';

		if (!this._getMultipleSelection())
			me.__idtable = [];

		out.name = sanitizeFilename(out.name);
		me.__idtable.push(out);

		if (me._onuploadsuccess)
			me._onuploadsuccess(file);

		//update
		me._onchange && me._onchange(me.__idtable);
		me.__exeEvent('onchange',null,{"arg":me.__idtable,"owner":me});
	};

	//Upload skoncil
	this.file._onuploadend = function (event, bForce){
		delete this.__uploadNotification;
		me._uploading = false;
		if (me._onuploadend)
			me._onuploadend(me.__idtable, bForce, this);
	};

	//DropZone Anchor
	this._add_destructor('__destructor');
};

_me._getAttachments = function() {
	return this.file._value().map(function(att) {
		var file = att.data || att;
		if (!file.fullpath && file.folder) {
			file.fullpath = file.folder + '/' + file.id;
		}
		if (att instanceof File) {
			file.file = att;
		}
		return file;
	});
};

_me._setAttachments = function(files) {
	this._addFiles(files);
};

_me._setPostParam = function (sName,sVal){
	if (this.file._setPostParam)
		this.file._setPostParam(sName,sVal);
};

_me._getFolder = function (){
	return this.file && this.file._getFolder();
};
_me._setFolder = function (sFolder){
	this.file._setFolder(sFolder);
};

_me._restore = function() {
	this.file._restore();
}
_me._addFiles = function(files) {
	[].forEach.call(files, function(file) {
		file.onclick = this.__options.onclick;
		file._abort = this.file.__onAbort.bind(this.file, file);
	}.bind(this));

	this.file.__value = this.file.__value.concat(files);
	if (this._onuploadstart)
		this._onuploadstart(files);
	gui.__exeEvent('onuploadstart', {owner: this.file, files: files, restore: true});

	[].forEach.call(files, function(file) {
		if (this._onuploadsuccess)
			this._onuploadsuccess(file);

		gui.__exeEvent('onuploadsuccess', {owner: this.file, file: file, restore: true});
	}.bind(this));

	if (this._onuploadend)
		this._onuploadend(files);
	gui.__exeEvent('onuploadend', {owner: this.file, files: files, restore: true});
};

_me._setFileQueueLimit = function (i){
	this.file._setFileQueueLimit(i);
};
_me._setMultipleSelection = function (b){
	this.file._setMultipleSelection(b);
};
_me._setFileTypes = function (sTypes, sDescription){
	this.file._setFileTypes(sTypes, sDescription);
};

_me._disabled = function(b){
	if (Is.Defined(b))
		this.file._disabled(b);
	else
		return this.file._disabled();
};

_me._value = function (v){
	if (Is.Object(v)){
		if (v.folder)
			this._setFolder(v.folder);
		if (v.values)
			this.__idtable = v.values;
	}
	else
		return {
			folder:this._getFolder(),
			values:this.__idtable
		};
};

_me._getAddon = function (){
	return this._value().values.map(function(file){
		var fullpath = file.fullpath;
		if (!fullpath) {
			if (file.folder && file.id) {
				fullpath = file.folder + '/' + file.id;
			} else if (file.aid && file.fid && file.iid) {
				fullpath = file.aid + '/' + Path.slash(file.fid) + '/' + WMItems.__serverID(file.iid);
				if (~['I', 'K', 'F'].indexOf(WMFolders.getType(file))) {
					file.class = 'attachment';
					fullpath += '/' + file.name;
				}
			} else {
				fullpath = this._getFolder() + '/' + file.id;
			}
		}
		return {
			values: {
				class: file.class,
				description: file.description || file.name,
				size: file.size,
				fullpath: fullpath
			}
		};
	});
};

_me._click = function() {
	if (!this.file.__eIN || (this.file._disabled && this._disabled()))
		return;

	// move input to correct gui to be able to click on it
	var _gui = gui;
	if (this.__options.context) {
		_gui = this.__options.context._gui;
	}
	if (this.file.__eIN.ownerDocument !== _gui) {
		_gui._main.appendChild(this.file.__eIN);
	}

	this.file.__eIN.click();
};

//will be overwritten by children
_me._upload = function(){
	this._click();
};

_me._reset = function(bFolder){
	this.__idtable = [];
	this.file._abort();
	this.file.__eIN.value = '';
	if (bFolder)
		this._setFolder('');
};
/**
 * Drag & Drop Upload HTML 5
 * 29.6.2011 15:44:38
 * @import: dropzone.js
 **/
_me.__ondropfile = function(aFiles,aHandler){
	if (window.FormData && this.file.__ondropfile)
		this.file.__ondropfile(aFiles,aHandler);
};