function obj_troubleshooting() {};

obj_troubleshooting.prototype.__constructor = async function () {
	this._render();
};

obj_troubleshooting.prototype._render = async function () {
	var ts = Cookie.get(['troubleshooting']);
	if (ts && ts.timestamp && (ts.timestamp * 1000 < +new Date())) {
		auth.deleteTroubleshooting(ts.session); // remove outdated troubleshooting session
		ts = false;
	}

	await this._clean();

	if (ts) {
		var link = location.origin + location.pathname + '?sid=' + ts.session;
		await this._draw('obj_troubleshooting', '', {
			link: link,
			validity: getLang('troubleshooting::helper2', [new IcewarpDate(new Date(ts.timestamp * 1000)).format('D/M/Y HH:mm:ss')])
		});

		this._getAnchor('link').onclick = this.copy._onclick = function () {
			toClipboard({
				'text/plain': link
			});
		}.bind(this);
	} else {
		await this._draw('obj_troubleshooting');
	}

	(this.generate || {})._onclick = function () {
		auth.troubleshootingSession(this.validity._value(), [this, '_render']);
	}.bind(this);

	(this.remove || {})._onclick = function () {
		auth.deleteTroubleshooting(ts.session, [this, '_render']);
	}.bind(this);
};
