_me = obj_tree_list.prototype;
function obj_tree_list() {};

_me.__constructor = async function () {
	var me = this;
	this._rowHeight = 48;	//should be in /skin
	this._search_query = '';
	this._norefresh = false;

	this.__eBody = this._getAnchor('body');

	await this._create('scrollbar', 'obj_scrollbar');
	this.scrollbar._scrollbar(this.__eBody, this.__eBody.parentElement);

	this.__eBody.onclick = function(e){
		var elm = e.target,
			room = '';

		if (elm === this.__eBody) return;
		while(!(room = elm.getAttribute('data-room'))){
			elm = elm.parentElement;
			if (elm == this.__eBody)
				break;
		}

		if (room){
			this.__clickOnRow(e, room);
		}

	}.bind(this);

	this.__eBody.oncontextmenu = function(e){
		var elm = e.target,
			room = '';

		if (elm === this.__eBody) return;
		while(!(room = elm.getAttribute('data-room'))){
			elm = elm.parentElement;
			if (elm == this.__eBody)
				break;
		}

		if (room){
			this.__contextMenuForRow(e, room, elm);
			// e.stopPropagation();
		}

	}.bind(this);

	//SEARCH
	this.inp_search._onkeyup = function(e){
		var v = this.inp_search._value();

		//Esc
		if (e.keyCode == 27){
			if (v === '') {
				// this._focus();
			}else{
				this.inp_search._value('');
			}

			v = false;
		}

		window[v.length?'addcss':'removecss'](this._main,'search');
		this.__search(v);

	}.bind(this);

	this.inp_search._onblur = function(){
		if (!this.inp_search._value()) removecss(this._main,'search');
	}.bind(this);


	//LISTENERS
	dataSet.on('active_folder', null, this.__setActiveRow, this)
		.on('cookies', ['recent'], this._prepareData, this);
	this._add_destructor('__removeListeners');

	this._listen('folders');

	this.__eBody.onmousedown = function(e){
		if (me.__dndtimer)
			window.clearTimeout(me.__dndtimer);

		if (e.button>1) return;
		var elm = e.target,
			room = '';

		if (elm === this.__eBody) return;

		while(!(room = elm.getAttribute('data-room'))){
			elm = elm.parentElement;
			if (elm == this.__eBody)
				return;
		}

		var roomPath = Path.split(room);
		me.__dndtimer = setTimeout(function(){
			gui.frm_main.dnd.create_drag({
				type: 'folder',
				value: [{
					aid: roomPath[0],
					fid: roomPath[1],
					size: roomPath[1].split('/')[0]
				}],
				x: e.clientX,
				y: e.clientY,
				obj: this
			});
		}, 250);
	};

	this.__eBody.onmouseup = function(){
        window.clearTimeout(me.__dndtimer);
	};
};

	_me.__clickOnRow = function (e, room) {
		if (hascss(e.target, 'close')){
			this.__removeRecent(room);
		}
		else{
			var roomPath = Path.split(room);
			gui.frm_main._selectView({aid: roomPath[0], fid: roomPath[1]});
		}
	};
	_me.__contextMenuForRow = async function (e, room, elm) {
		e.preventDefault();
		var cmenu = await gui._create("cmenu", "obj_context_folder", '', '', this),
			roomPath = Path.split(room);
		room = roomPath[1];
		var rights = WMFolders.getRights({aid: sPrimaryAccount, fid: room});

		var bIsFavorite = (dataSet.get('cookies', ['favorites']) || []).some(function(fav) {
			return fav.arg.aid === roomPath[0] && fav.arg.fid === roomPath[1];
		}.bind(this));

		await cmenu._fill([
			bIsFavorite && {title:'POPUP_FOLDERS::REMOVE_FAVORITES', arg: {aid: sPrimaryAccount, fid: room, method: 'remove_favorite'}, css: 'ico2 fav_folder'},
			!bIsFavorite && {title:'POPUP_FOLDERS::ADD_FAVORITES', arg: {aid: sPrimaryAccount, fid: room, method: 'add_favorite'}, css: 'ico2 fav_folder'},
			{'title': 'FORM_BUTTONS::RENAME', css:'ico2 edit_folder','arg': {aid: sPrimaryAccount, fid: room, ftype: 'I', method: 'rename_folder'}, disabled: !rights.edit_folder},
			{'title': 'FORM_BUTTONS::UNSUBSCRIBE', css:'ico2 archive_folder', 'arg': {aid: sPrimaryAccount, fid: room, ftype: 'I', method: 'unsubscribe', callback: function (folder_info) {

						gui.frm_main.bar.top.switch.__unsubscribeRoom(elm, {aid: sPrimaryAccount, fid: room}, folder_info, [this,'__update']);	// check response handler!!

					}.bind(this)}},
			rights.owner ? {'title': 'POPUP_FOLDERS::MEMBERS', css:'ico2 color1 members','arg': {aid: sPrimaryAccount, fid: room, method: 'manage_members'}} : false,
			!sPrimaryAccountGUEST?{'title':'POPUP_FOLDERS::CLONE_ROOM','arg':{'aid':sPrimaryAccount,'fid':room,'method':'clone'}, css:'ico2 clone_room', 'disabled':!rights.write}:false,
			!sPrimaryAccountGUEST?{'title':'IM::SEND_MAIL_TO_ALL','arg':{'aid':sPrimaryAccount,'fid':room,'method':'sendEmailToAllMembers'}, css:'ico2 from_template'}:false,
			{'title':'-'},
			{'title': 'POPUP_FOLDERS::DELETE_ROOM', css:'ico2 color2 delete_folder', 'arg': {aid: sPrimaryAccount, fid: room, method: 'delete_folder'}, disabled: !rights.remove}
		].filter(Boolean));
		cmenu._place(e.clientX, e.clientY);
		cmenu._add_destructor('__onclose');
		cmenu.__onclose = function() {
			this._active();
		}.bind(this);
		this._active(elm);
	};

_me._active = function (eActive) {
	this.__active && removecss(this.__active, 'active2');
	this.__active = eActive;
	this.__active && addcss(this.__active, 'active2');
};

_me.__removeListeners = function () {
	dataSet.off('active_folder', null, this.__setActiveRow)
	 	.off('cookies', ['recent'], this._prepareData);
};

/**
 * Check if Teamchat-service is running
 *
 * @returns Boolean
 */
_me._teamChatOnline = function(){
	var folders = dataSet.get('folders', [sPrimaryAccount]);
	for(var i in folders) {
		if(~['I', 'Y'].indexOf(folders[i].TYPE)) {
			return true;
		}
	}
	return false;
};

_me.__recentSort = function (a,b){
	var tmpA = a.recent>0?1:0,
		tmpB = b.recent>0?1:0;

	return (tmpB - tmpA) || (b.activity - a.activity);
};

_me._prepareData = function(){

	// set from obj_context_folder.rename_folder
	if (this._norefresh) return;

	var aData = {},
		ds = dataSet.get('folders',[sPrimaryAccount]),
		recent = Cookie.get(['recent']) || [],
		active = dataSet.get('active_folder');

	var new_recent = recent.concat(Object.keys(ds).map(function(folder) {
		return ds[folder].TYPE === 'I' ? sPrimaryAccount + '/' + folder : false;
	}).filter(Boolean)).filter(function(room){
		var path = Path.split(room),
			parts = path[1].split('/'),
			folder = ds[path[1]];

		if (folder && folder.TYPE == "I" && folder.SYNC == '1' && !aData[room]) {
			aData[room] = {
				isRecent: !!~recent.indexOf(room),
				room: room,
				name: folder.NAME || parts.pop(),
				group: parts.shift(),
				recent: folder.RECENT || 0,
				activity: folder.GROUPCHAT_LASTACTIVITY || 0,
				active: active === room
			};

			return true;
		}
	}).filter(function(room) {
		return !!~recent.indexOf(room);
	});

	var tc_room_exists;
	for(var i in ds) {
		if (ds[i].TYPE === 'I') {
			tc_room_exists = true;
			break;
		}
	}

	//Update cookie
	if (tc_room_exists && recent.length !== new_recent.length && this._teamChatOnline()){
		Cookie.set(['recent'], new_recent);
		return; //to avoid double refresh
	}

	//Merge old and new data (keep sort)
	if (this._aData){

		var tmp = this._aData.map(function(room){
			var data = aData[room.room];
			if (data) {

				if (data.active && room.activity<data.activity){
					return false;
				}

				if (room.recent>=data.recent){
					delete aData[room.room];
					return data;
				}
			}

			return false;

		}).filter(Boolean);

		this._aData = Object.values(aData).sort(this.__recentSort).concat(tmp);
	}
	else{
		//sort recent rooms to the top, only once
		this._aData = Object.values(aData).sort(this.__recentSort);
	}

	this._fill();

	//scroll to view
	if (this.__value != active){
		this.__value = active;
		this._scrollToRoom(active);
	}
};

_me._scrollToRoom = function(room){
	var row = this.__eBody.querySelector('[data-room="' + room + '"]');
	if (row && row.scrollIntoViewIfNeeded){
		return row.scrollIntoViewIfNeeded();
	}

	this.__eBody.scrollTop = 0;
};

_me._getFocusElement = function(){
	return this._main;
};
_me._focus = function(){
	// return this._main.focus();
};

_me._fill = function(aData){

	aData = aData || this._aData || [];

	var rows = {}, //already rendered row elements
		data_rows = aData.map(function(room){return room.room}); //rooms in aData

	//remove old rows
	[].forEach.call(this.__eBody.querySelectorAll('div[data-room]'), function(elm){
		var room = elm.getAttribute('data-room');
		if (!~data_rows.indexOf(room)){
			//animated remove
			elm.removeAttribute('data-room');
			addcss(elm, 'shrink');
			setTimeout(function(){
				elm && elm.parentNode && elm.parentNode.removeChild(elm);
			},300);
		}
		else
			rows[room] = elm;
	});

	window[aData.length?'removecss':'addcss'](this._main, 'empty');

	//Any search?
	var qs = (this._search_query || '').toLowerCase();

	var rendered_rows = (qs.length?aData.filter(function (room) {
		if (!~room.name.toLowerCase().indexOf(qs)){
			//hide filtered rows
			if (rows[room.room]) {
				rows[room.room].style.display = 'none';
			}

			return false;
		}

		return true;
	}):aData.filter(function(room) {
		if (!room.isRecent && rows[room.room]) {
			rows[room.room].style.display = 'none';
		}
		return room.isRecent;
	})).map(function (room, i) {
		var row;

		//Row already exist
		if (rows[room.room]) {
			row = rows[room.room];
			row.innerHTML = '';
			row.style.display = 'block';
		}
		//Create new row envelope
		else {
			row = mkElement('div', {
				'class': 'recent-row',
				'data-room': room.room,
				'id': this._pathName + '/' + room.room //do we need it?
			});

			this.__eBody.appendChild(row);
		}

		//update content
		this.__createRowBody(row, room);

		//set current position
		row.style.transform = 'translateY(' + (i * this._rowHeight) + 'px)';
		row.style.zIndex = 10 + i;

	}.bind(this));

	if (rendered_rows.length) {
		removecss(this._main, 'noitems');
	} else {
		addcss(this._main, 'noitems');
	}

};

_me._rename = async function(arg){
	if (this.rename) this.rename._onclose();
	this._norefresh = true;

	var sLiId	= this._pathName+'/'+arg.aid + (arg.fid?'/'+arg.fid:''),
		hDiv = document.getElementById(sLiId).getElementsByTagName('DIV')[0];

	// hide link
	addcss(hDiv,'edit');

	// create editDiv anchor and ID to hDiv
	var sAnchor = sLiId + '#editDiv';
	this._anchors['editDiv'] = sAnchor;
	hDiv.id = sAnchor;

	// get value
	var nPos = arg.fid.lastIndexOf('/'),
		sParentName = arg.fid.substring(0,nPos),
		sFolderName = dataSet.get("folders", [arg['aid'],arg['fid'], 'NAME']) || arg.fid.substring(nPos + 1);

	// create obj_input in this' editDiv anchor
	var rename = await this._create('rename','obj_input','editDiv');
		rename._restrict('![/\\\\:?"<>|~]+','','^.{1,255}$');
		rename.__eIN.setAttribute('maxlength', 255);

		// cancel "onclick" propagation to obj_tree
		rename.__eIN.onclick = function(e){
			e.preventDefault();
			e.stopPropagation();
		};

		rename._value(sFolderName);
		rename._setRange(0,sFolderName.length);

		rename._onsubmit = function(){
			if (this._checkError && this._checkError.length) return;

			var snew = (this._value() || '').trim();
			var sold = sFolderName;

			if (sold == snew){
				this._onclose();
				return;
			}

			var sNewFolderID = (sParentName ? sParentName + '/' : '') + snew;
			obj_context_folder.__moveFolder(arg.aid, arg.fid, sNewFolderID);

			this._onclose();
		};

		rename._onclose = function(e){

			if (this.rename._destructed) return false;

			this.rename._destruct();
			removecss(hDiv,'edit');

			// aby se zase prekresloval tree
			this._norefresh = false;
			if (!e || this._updateBuffer)
				this.__update(this._listener_data);
		}.bind(this);

		rename._onblur = rename._onclose;

	// remove anchor immediately (better solution)
	delete this._anchors['editDiv'];
};

_me.__createRowBody = function(row, room){

	//body
	row.appendChild(mkElement('div', {class: "body"},null,[
		mkElement('div', {class: "room-name", text:room.name}),
		mkElement('div', {class: "group-name", text:room.group})
	]));

	//control
	var control = mkElement('div', {
			class: "control"
		},
		null,
		mkElement('div', {
			class: "close"
		})
	);
	if (+room.recent>0){
		control.appendChild(mkElement('div', {class: "bubble", text:room.recent}));
		addcss(row, 'unread');
	}
	else
		removecss(row, 'unread');

	row.appendChild(control);

	window[room.active?'addcss':'removecss'](row,'active');
};

_me.__removeRecent = function (room) {
	var recent = Cookie.get(['recent']) || [];

	if (recent.length && this._teamChatOnline()){
		Cookie.set(['recent'], recent.filter(function(v){
			return v !== room;
		}));
	}
};

_me.__setActiveRow = function (room) {

	//update DOM
	[].forEach.call(this.__eBody.querySelectorAll('[data-room]'), function (row) {
		removecss(row,'active');
	});

	var row = this.__eBody.querySelector('[data-room="' + room + '"]');
	if (row) {

		//update this._aData
		this._aData.map(function(v){
			v.active = v.room === room;
			return v;
		});

		addcss(row,'active');

		if (this.__value != room){
			this.__value = room;
			// this._scrollToRoom(room);
		}
	}
};

_me.__search = function (query) {
	query = query || false;
	if (this._search_query !== query){
		this._search_query = query || false;
		this._fill();

		//scroll to top
		if (this._search_query){
			this._scrollToRoom();
		}
	}
};

_me.__update = function () {
	if (this._teamChatOnline()) {
		if (this.__applyFoldersUnreadSnapshot())
			this.__saveFoldersUnreadSnapshot();
		else
			this._prepareData();
	}
};

_me.__saveFoldersUnreadSnapshot = function () {
	var ds = dataSet.get('folders', [sPrimaryAccount]),
		oSnapshot = {};

	for (var sFolder in ds) {
		if (Object.prototype.hasOwnProperty.call(ds, sFolder) && 'I' === ds[sFolder]['TYPE']) {
			oSnapshot[sFolder] = {'recent' : parseInt(ds[sFolder]['RECENT'])};
		}
	}

	Cookie.set(['recent_folders_snapshot'], oSnapshot);
};

_me.__applyFoldersUnreadSnapshot = function () {

	var ds = dataSet.get('folders', [sPrimaryAccount]),
		oSnapshot = Cookie.get(['recent_folders_snapshot']),
		aRecent = Cookie.get(['recent']) || [],
		aFoldersWithNewPosts = [],
		bUpdate = false;

	for (var sFolder in ds) {
		// Skip invalid properties and non-teamchat room folders
		if (Object.prototype.hasOwnProperty.call(ds, sFolder) &&  'I' === ds[sFolder]['TYPE']) {
			if (
				(!Is.Object(oSnapshot) && parseInt(ds[sFolder]['RECENT']) > 0) || // Case when snapshot wasn't taken yet - fill all rooms with unread posts
				(Is.Object(oSnapshot) && (!Object.prototype.hasOwnProperty.call(oSnapshot, sFolder) || parseInt(ds[sFolder]['RECENT']) > oSnapshot[sFolder]['recent'])) // Case when new room appeared || new posts appeared in existing room
			) {
				aFoldersWithNewPosts.push(sPrimaryAccount + '/' + sFolder);
			}
		}
	}

	aFoldersWithNewPosts.forEach(function(path){
		if (!~aRecent.indexOf(path)) {
			aRecent.unshift(path);
			bUpdate = true;
		}
	});

	bUpdate && Cookie.set(['recent'], aRecent);

	return bUpdate;
};
