_me = obj_threads_item.prototype;
function obj_threads_item(){};

_me.__constructor = async function(aData) {
	await storage.library('obj_groupchat_item');
	await this._fill(aData);

	setTimeout(function(){
		if (this._main)
			addcss(this._main, 'anim')
	}.bind(this), 200);
};

_me._fill = async function(aData){
	await this._clean();

	this.__aData = aData || this.__aData || {};

	if (this.__aData.skeleton) {
		if (this.__aData.gpt) {
			this.__aData.label = 'asd';
			this.__aData.updated_at = new IcewarpDate();
			this.__aData.messages = [{}];
		} else {
			this.__aData.EVN_ID = 'skeleton';
			this.__aData.EVNCLASS = 'I';
			this.__aData.COMCOUNT = Math.floor(Math.random() * 2);
			this.__aData.EVN_CREATED = new IcewarpDate();
			this.__aData.EVN_METADATA = 'core_reactions_data=%26thumbsup%3D' + Math.floor(Math.random() * 2);
			this.__aData.EVNNOTE = '';
			this.__aData.EVNOWNEREMAIL = 'a';
			this.__aData.EVNOWNERNAME = 'a';
			this.__aData.COMMENT = this.__aData.COMCOUNT && {
				EVNCLASS: 'I',
				EVN_CREATED: new IcewarpDate(),
				EVN_METADATA: 'core_reactions_data=%26thumbsup%3D' + Math.floor(Math.random() * 2),
				EVNNOTE: '',
				EVNOWNEREMAIL: 'a',
				EVNOWNERNAME: 'a'
			};
		}
	}

	this.__aData.iid = WMItems.__clientID(this.__aData.EVN_ID);

	var fid = this.__aData.EVNFOLDER;
	await this._draw('obj_threads_item', 'main');

	var lr = this.__aData.COMMENT || {};
	await this._create('post', this.__aData.gpt ? 'obj_chatgpt_item' : obj_groupchat_item.__comTypes[this.__aData.EVNCLASS], 'post', 'thread_post', this.__aData, '', {
		room: WMFolders.getFolderName({
			aid: this.__aData.aid,
			fid: fid ? WMChat.getFid(fid) : this.__aData.fid
		}) || 'Unknown',
		last_change: this.__getTime(IcewarpDate.unix(lr.EVN_MODIFIED || lr.EVN_CREATED || this.__aData.TCTLASTTIME || this.__aData.EVN_MODIFIED)),
		fulldate: true,
		followed_thread_post: true,
		disable_controls: true
	});
};

_me._updateItem = function(oldItem, newItem) {
	this.post = newItem;
};

_me.__updateTime = function(){
	if (this._main.parentNode && !this.__aData.skeleton && this.post && this.post._getAnchor('last_change')){
		var lr = this.__aData.COMMENT || {};
		this.post._getAnchor('last_change').textContent = this.__getTime(this.__aData.updated_at ? new IcewarpDate(this.__aData.updated_at) : IcewarpDate.unix(lr.EVN_MODIFIED || lr.EVN_CREATED || this.__aData.EVN_MODIFIED || this.__aData.EVN_CREATED));
	}
};

_me.__getTime = function (date) {
	var diff = Math.floor((new Date() - date) / 1000);
	if (diff < 10) {
		return getLang('NOTIFICATION::NOW');
	} else if (diff < 60) {
		return getLang(diff === 1 ? 'NOTIFICATION::SECOND_AGO' : 'NOTIFICATION::SECONDS_AGO', [diff]);
	} else if (diff < 60 * 60) {
		var minutes = Math.floor(diff / 60);
		return getLang(minutes === 1 ? 'NOTIFICATION::MINUTE_AGO' : 'NOTIFICATION::MINUTES_AGO', [minutes]);
	} else if (diff < 60 * 60 * 12) {
		var hours = Math.floor(diff / 60 / 60);
		return getLang(hours === 1 ? 'NOTIFICATION::HOUR_AGO' : 'NOTIFICATION::HOURS_AGO', [hours]);
	} else {
		return CalendarFormatting.normalWithTime(new IcewarpDate(date));
	}
};

_me.__update = function(bOK){
	if (bOK == true){

		var fid = this.__aData.EVNFOLDER;
		fid = fid ? WMChat.getFid(fid) : this.__aData.fid;

		WMItems.list({aid:this.__aData.aid, fid:fid, iid:this.__aData.iid},'','','',[function(aData){
			if (aData && (aData = aData[this.__aData.aid]) && (aData = aData[fid]) && (aData = aData[this.__aData.iid])){
				//merge for missing gcc-values
				this._fill(Object.assign(this.__aData, aData));
			}
			// delete
			else
				this._parent._remove(this._anchor, this.__aData.iid);

		}.bind(this)]);
	}
};

_me._data = function(iid, aData, sCall, aArgs){
	if (Is.Object(aData)) {
		var comment = false;
		if (aData.COMMENT) {
			comment = true;
			this.__aData.COMMENT = Object.assign(this.__aData.COMMENT || {}, aData.COMMENT);
		}
		if (aData.COMCOUNT) {
			this.__aData.COMCOUNT = aData.COMCOUNT;
			this.__aData.META_COMMENTS = this.__aData.META_COMMENTS || {};
			this.__aData.META_COMMENTS.count = aData.COMCOUNT;
		}

		if (~['reaction-deleted', 'reaction'].indexOf(aData.ACTION || aData.COMMENT.ACTION)) {
			var tdata = this.__aData;
			var data = aData;
			if (comment) {
				tdata = this.__aData.COMMENT;
				data = aData.COMMENT;
			}
			var meta = parseURL(tdata.EVN_METADATA);
			var reactions = parseURL(meta.core_reactions_data);
			var authors_reactions = parseURL(meta.core_reactions_authors_data);

			if (data.REAVALUE !== void 0) {
				if (authors_reactions[sPrimaryAccount]) {
					reactions[authors_reactions[sPrimaryAccount]]--;
				}
				authors_reactions[sPrimaryAccount] = data.REAVALUE;
			}
			if (data.ACTION === 'reaction') {
				reactions[data.NOTIFY_REACTIONS] = (+reactions[data.NOTIFY_REACTIONS] || 0) + 1;
			} else {
				reactions[data.NOTIFY_REACTIONS] = (+reactions[data.NOTIFY_REACTIONS] || 1) - 1;
			}

			for (var i in reactions) {
				if (reactions[i] == 0) {
					delete reactions[i];
				}
			}

			delete data.ACTION;
			delete data.REAVALUE;
			delete data.NOTIFY_REACTIONS;

			meta.core_reactions_authors_data = buildURL(authors_reactions);
			meta.core_reactions_data = buildURL(reactions);
			tdata.EVN_METADATA = buildURL(meta);
		}

		// delete aData.COMMENT;
		if (comment) {
			Object.assign(this.__aData.COMMENT, tdata);
		} else {
			Object.assign(this.__aData, tdata);
		}
	}

	if (sCall && Is.Function(this[sCall]))
		this[sCall].apply(this, aArgs || []);
};