_me = obj_threads.prototype;
function obj_threads(){};

_me.__constructor = async function() {
	await storage.library('obj_groupchat');
	this.__options.notifyItem = ['Q','R','Y','I','Z','-'];
	this.__options.autoscroll = true;
	this.__options.preload = 5;
	this.__options.active = false;
	this.__lastReplies = {};
	this.__getCommentTimeouts = {};

	this._getAnchor('unread_threads').onclick = function() {
		this._getAnchor('main').scrollTop = 0;
	}.bind(this);
};

_me._onscroll = function() {
	if (this._getAnchor('main').scrollTop > 50) {
		addcss(this._main, 'refresh');
	} else {
		removecss(this._main, 'refresh', 'unread_threads', 'scrollbtn');
	}
};

_me._active = function(b){
	if (Is.Boolean(b)){

		if (this.__updTime)
			clearInterval(this.__updTime);

		if (b){
			this.__updTime = setInterval(this.__updateTime.bind(this), 10000);
			this.__updateTime();
		}

		this.__options.active = b;
	}
	else
		return this.__options.active;
};

	_me.__updateTime = function () {
		this._getChildObjects().forEach(function(obj) {
			obj.__updateTime && obj.__updateTime();
		});
	};

_me._request = function(bUpdate){
	if (this.__aRequestData.folder){
		this.__loading = 1;

		var aSearch = [];

		if (this.__aRequestData.filter){
			if (this.__aRequestData.filter.sys_search)
				aSearch.push('(' + this.__aRequestData.filter.sys_search + ')');

			if (this.__aRequestData.filter.search)
				aSearch.push('("' + this.__aRequestData.filter.search.quoteMeta() + '")');
		}

		var aFilter = {
			limit: this.__options.preload,
			sort: 'TCTLASTTIME desc',
			search: aSearch.join(' ')
		};

		if (this.__aRequestData.offset)
			aFilter.offset = this.__aRequestData.offset;

		var aItemsInfo = { aid: this.__aRequestData.folder.aid, fid: this.__aRequestData.folder.fid, values: obj_groupchat.aRequestArray, filter: aFilter };

		//Blank request to check count
		if (bUpdate){
			if (!this._refresh()){
				WMItems.list(aItemsInfo,'','','',[function(aData){
					aData = aData[this.__aRequestData.folder.aid];
					if ((aData = aData[this.__aRequestData.folder.fid]))
						this.__check_count(parseInt(aData['/']));

				}.bind(this)]);
			}
		}
		//Request
		else
			return WMItems.list(aItemsInfo,'','','',[this, '_response']);
	}
};

_me._response = async function(aData, bUpdate, bSkipTime){

	if (this._destructed) return;

	if (this.__skeletons) {
		await this._clean();
		[].slice.call(this.__body.childNodes).reverse().forEach(function(elm){
			elm.parentNode.removeChild(elm);
		});
		this.__skeletons = false;
	}

	if ((aData = aData[this.__aRequestData.folder.aid]) && (aData = aData[this.__aRequestData.folder.fid])){

		this.__aRequestData.offset = aData['/']=='0'?'':parseInt(aData['$']);

		delete aData['/'];	//count
		delete aData['#'];
		delete aData['$'];	//offset
		delete aData['@'];	//attributes

		var c = 0;
		for (var iid in aData){
			c++;

			var lastReply = {};
			for (var i in aData[iid]) {
				if (i.indexOf('LAST') === 0) {
					lastReply[i.replace(/^LAST/, '')] = aData[iid][i];
					lastReply.aid = lastReply.aid || aData[iid].aid;
					lastReply.fid = lastReply.fid || aData[iid].fid;
				}
			}
			aData[iid].COMMENT = aData[iid].TCTLASTID === aData[iid].EVN_ID ? {} : this.__lastReplies[iid] = Object.assign(this.__lastReplies[iid] || {}, lastReply);
			//skip duplicities
			if (!this.__aData[iid])
				await this.__item(aData[iid]);
		}

		if (!bSkipTime){
			if (c == this.__options.preload)
				this.__loading = 0;
			else
				this.__loading = 2;

			this.__aRequestData.offset += c;
		}

		if (this._oncount)
			this._oncount(Is.Empty(this.__aData)?0:1);
	}
	//clear on error
	else
	if (!aData && Is.Empty(this.__aData)){
		await this._clear(true);

		if (this._oncount)
			this._oncount(0);
		return;
	}

	if (!bUpdate || this.__aRequestData.fetchnew)
		this._fetch();
};

_me.__render_skeletons = function() {
	while (this._getAnchor('main').scrollHeight < this._getAnchor('main').clientHeight) {
		this._create('item', 'obj_threads_item', this._row().anchor, 'skeleton', {skeleton: true});
	}
};

_me.__item = async function(aData, bTop){
	aData.EVN_CREATED = +aData.EVN_CREATED;
	aData.iid = WMItems.__clientID(aData.EVN_ID);

	switch(aData.EVNCLASS){
	case 'I':
	case 'Q':
	case 'R':
	case 'S':
	case 'F':
	case 'Y':
	case 'Z':
	case 'E':
		var row = this._row('', '', aData.iid, bTop);

		this.__aData[aData.iid] = {
			data: aData,
			anchor: row.anchor,
			obj: await this._create('item', 'obj_threads_item', row.anchor,'', aData)
		}

		if (this._oncount)
			this._oncount(Is.Empty(this.__aData)?0:1);

		//Bind Top animation
		if (bTop){
			addcss(row.elm,'anim-top');
			setTimeout(function(){
				removecss(row.elm, 'anim-top');
			}, 400);
		}

		break;
	}

};

_me._add_message = function(aPath, oCustomData) {
	//Move to TOP
	if (this.__aData[aPath.iid]){
		this._move_message(aPath.iid);
	}
	else{
		aPath.values = obj_groupchat.aRequestArray;
		WMItems.list(aPath,'','','',[function(aData){
			//Move to TOP
			if (this.__aData[aPath.iid]){
				this._move_message(aPath.iid);
			}
			//Insert New
			else{
				aData = aData[aPath.aid];
				if (aData && (aData = aData[aPath.fid]) && (aData = aData[aPath.iid])){
					Object.assign(aData, oCustomData || {});
					if (this.__lastReplies[WMItems.__clientID(aPath.iid)]) {
						aData.COMMENT = Object.assign(aData.COMMENT || {}, this.__lastReplies[WMItems.__clientID(aPath.iid)]);
					}
					this.__item(aData, true);
				}
			}

		}.bind(this)]);
	}
};

_me._add_comment = function(aPath, comcount) {
	var fid = aPath.fid + '/' + WMItems.__serverID(aPath.iid);

	clearTimeout(this.__getCommentTimeouts[fid]);
	this.__getCommentTimeouts[fid] = setTimeout(function() {
		WMItems.list({
			aid: aPath.aid,
			fid: fid,
			filter: {
				limit: 1,
				sort: 'EVN_ID desc',
				reset_unread: false
			},
			values: obj_groupchat.aRequestArray
		}, '', '', '', [function(aData) {
			aData = aData[aPath.aid][fid];
			var i;
			for (i in aData) {
				if (i.indexOf('*') === 0) {
					break;
				}
			}
			if (!i) {
				return;
			}

			this.__lastReplies[aPath.iid] = aData[i];

			if (this.__aData[aPath.iid]) {
				this.__aData[aPath.iid].obj._data(aPath.iid, {
					COMMENT: this.__lastReplies[aPath.iid],
					COMCOUNT: comcount || (+(((this.__aData[aPath.iid].data || {}).META_COMMENTS || {}).count || 0) + 1)
				}, '_fill');
				this._move_message(aPath.iid);
			} else {
				this._add_message({ aid: aPath.aid, fid: aPath.fid, iid: aPath.iid });
			}
		}.bind(this)]);
	}.bind(this), 50);
};

_me._move_message = function(iid, aData){
	var obj = (this.__aData[iid] || {})['obj'];
	if (obj){

		//Move top top in aData :)
		var tmp = {};
			tmp[iid] = null;
		this.__aData = Object.assign(tmp, this.__aData, aData);

		//Move in DOM with animation
		var elm = obj._main.parentElement;
		if (elm && this._getAnchor('main').children[0] !== elm){
			//clone original
			var eClone = elm.cloneNode(true);
			//animate clone
			addcss(eClone,'anim-move');
			//switch clone with original
			this.__body.replaceChild(eClone, elm);
			//animate node
			addcss(elm,'anim-top');
			//insert node to the top
			this.__body.insertBefore(elm, this.__body.firstChild);

			//remove animations from node & remove clone
			setTimeout(function(){
				try{removecss(elm, 'anim-top');}catch{
					//
				}
				try{eClone.parentNode.removeChild(eClone);}catch{
					//
				}
			}, 1400);
		}
	}
};

_me.__unread = function() {
	if (this._getAnchor('main').scrollTop > 50) {
		addcss(this._main, 'unread_threads');
		this._getAnchor('unread_threads').textContent = getLang('CHAT::UNREAD_THREADS');
	}
};

_me._onnotify = function(aData){
	var iid = WMItems.__clientID(aData.COMEVNID || aData.ITEM || ''), folder;
	if (!iid) {
		return;
	}

	switch(aData.ACTION){
		//All modes
		case 'update':
			folder = WMFolders._getFolderByRelativePath(aData.EMAIL, aData.FOLDER) || {};
			if (this.__aData[iid] && this.__aData[iid].obj && this.__aData[iid].obj.__update) {
				this.__aData[iid].obj.__update(true);
			} else if (folder.AUTOFOLLOW == '1') {
				if (aData['ORIGINATOR-EMAIL'] !== sPrimaryAccount) {
					this.__unread();
				}
				this._add_message({aid: sPrimaryAccount, fid: WMChat.getFid(aData.FOLDER), iid: iid});
			}
			break;

		case 'comment':
			if (aData.COMISFOLLOWED == '1') {
				if (aData['ORIGINATOR-EMAIL'] !== sPrimaryAccount) {
					this.__unread();
				}
				this._add_comment({aid: sPrimaryAccount, fid: WMChat.getFid(aData.FOLDER), iid: iid}, aData.BODY);
			}
			break;

		case 'unfollow':
		case 'delete':
			if (this.__aData[iid]) {
				this._remove(this.__aData[iid].anchor, iid);
			}
			break;

		case 'follow':
			if (!this.__aData[iid]){
				this._add_message({aid: sPrimaryAccount, fid: WMChat.getFid(aData.FOLDER), iid: iid}, {
					COMMENT: this.__lastReplies[iid]
				});
			}
			break;

		case 'add':
			if (aData['ORIGINATOR-EMAIL'] !== sPrimaryAccount) {
				this.__unread();
			}
			folder = WMFolders._getFolderByRelativePath(aData.EMAIL, aData.FOLDER) || {};
			if (aData.COMEVNID) {
				// this._add_comment({aid: sPrimaryAccount, fid: WMChat.getFid(aData.FOLDER), iid: iid});
			} else if (folder.AUTOFOLLOW == '1') {
				this._add_message({aid: sPrimaryAccount, fid: WMChat.getFid(aData.FOLDER), iid: iid});
			}
			break;

		case 'reaction':
		case 'reaction-deleted':
			var lr = false,
				obj = this.__aData[iid];
			
			for(var i in this.__lastReplies) {
				if (WMItems.__clientID(this.__lastReplies[i].EVN_ID) === iid) {
					lr = true;
					obj = this.__aData[WMItems.__clientID(this.__lastReplies[i].EVNCOMEVNID)]
					break;
				}
			}

			if ((aData.ACTION == 'reaction-deleted' && aData.BODY == '') || !Is.Defined(aData.BODY) || !obj || !obj.obj) {
				return;
			}

			var aOut = {
				NOTIFY_REACTIONS: aData.BODY,
				ACTION: aData.ACTION
			};

			//Update item if notification come from the same account, but different client (To update REAVALUE)
			if (!(aData.SERVICE && (aData['ORIGINATOR-EMAIL'] === sPrimaryAccount || aData['ORIGINATOR-EMAIL'] === dataSet.get('main', ['user'])) && aData['ORIGINATOR-DEVICEID'] !== dataSet.get('main', ['device_id'])) && Is.Defined(aData.REAVALUE)){
				aOut.REAVALUE = aData.REAVALUE;
			}

			obj.obj._data(iid, lr ? { COMMENT: aOut } : aOut, '_fill');

			break;
	}
};

_me._onremove = function(iAnchor, sData_id){
	//remove from aData
	if (this.__aData && this.__aData[sData_id]) {
		delete this.__aData[sData_id];
	}

	if (this._oncount)
		this._oncount(Is.Empty(this.__aData)?0:1);
};
