_me = obj_text_mentions.prototype;
function obj_text_mentions(){};

_me.__constructor = async function(){
	this._limit = 10;
	this._min = 1;
	this.__direction = 'up';
	this.__initialized = false;

	this.__folder = {};
	this.__mentions = {};

	this.__initEditor();
	gui._obeyEvent('settings_changed', [this, '__initEditor']);
	gui._obeyEvent('ondetach', [this, '_ondetach']);
	this._add_destructor('__destructor');
};

_me.__initEditor = function(sEditorType) {
	var me = this;
	this.__editorType = sEditorType || GWOthers.getItem('CHAT', 'editor_type') || GWOthers.getDefaultValues('CHAT').EDITOR_TYPE;
	this.__editorTextarea = this.__editorType === 'textarea';

	var eIN = this.__eIN;
	if (this.__editorTextarea) {
		if (this.__editor) {
			eIN.value = this.__editor.getMarkdown().replace(/\\r\\n/g, '\n');
			this.__editor.destroy();
			this.__editor = null;
			this._main.appendChild(eIN);
			this._main.classList.remove('auto-height');
			this._placeholder(this.__placeholder);
			this.__resize();
			this._readonly(this.__eIN.readOnly);
		}
		this.__initialized = true;
	} else {
		if (!this.__editor) {
			this.__editor = new toastui.Editor({
				el: this._main,
				height: 'auto',
				initialEditType: this.__editorType,
				usageStatistics: false,
				events: {
					keydown: function(_, e) {
						return eIN.onkeydown(e);
					},
					keyup: function(_, e) {
						eIN.onkeyup(e);
						me.__exeEvent('selectionChanged', me, me.__doc().getSelection());
					},
					focus: function(_, e) {
						me._getFocusElement()._focused = true;
						eIN.onfocus(e);
					},
					blur: function(_, e) {
						me._getFocusElement()._focused = false;
						eIN.onblur(e);
					},
					load: function() {
						me.__initialized = true;
					},
					change: function() {
						me.__exeEvent('contentChanged', me);
						if (!me._value()) {
							me._placeholder(me.__placeholder);
						}
					}
				},
				placeholder: this.__placeholder,
				initialValue: eIN.value,
				hideModeSwitch: true,
				autofocus: false
			});
		}

		this._readonly(this.__eIN.readOnly);
		this.__editor.mdEditor.view.directPlugins = this.__editor.wwEditor.view.directPlugins = [{
			spec: {},
			props: {
				handleKeyDown: function(ui, e) {
					if (e.key === 'Enter') {
						var selection = me.__doc().defaultView.getSelection();
						var range = selection.rangeCount && selection.getRangeAt(0);
						var startContainer = range && range.startContainer;
						if (startContainer && (startContainer.parentElement.closest('li') || (startContainer.tagName === 'DIV' ? startContainer : startContainer.parentElement.closest('div')).querySelector('.toastui-editor-md-list-item')) && !e.ctrlKey) {
							return false;
						}

						if (!e.shiftKey && (me.suggest || (GWOthers.getItem('CHAT','enter_send') == 1))) {
							return true;
						}
					}
				}
			}
		}];

		this.__editor.mdEditor.clipboard.onpaste = this.__eIN.onpaste;
		this.__editor.wwEditor.view.dom.addEventListener('paste', this.__eIN.onpaste, true)

		if (this.__editor.isMarkdownMode() ? this.__editorType === 'wysiwyg' : this.__editorType === 'markdown') {
			this.__editor.changeMode(this.__editorType, true);
		}

		this.__doc = function() {
			try {
				return this.__editor.getCurrentModeEditor().view.dom.ownerDocument;
			} catch {
				return eIN.ownerDocument;
			}
		}.bind(this);
		this.__editor.getCurrentModeEditor().view.dom.addEventListener('mouseup', function() {
			setTimeout(function() {
				me.__exeEvent('selectionChanged', me, me.__doc().getSelection());
			}, 5);
		});
	}
};

_me.__destructor = function() {
	this.__editor && this.__editor.destroy();
	gui._disobeyEvent('ondetach', [this, '_ondetach']);
	gui._disobeyEvent('settings_changed', [this, '__initEditor']);
};

_me._exec = function(command, options) {
	if (command === 'codeBlock') {
		var placeholder = this.__placeholder;
		this._placeholder('');
		this.__placeholder = placeholder;
	}

	return this.__editor && this.__editor.exec(command, options);
};

_me._value = function(v) {
	if (this.__editorTextarea) {
		return obj_text.prototype._value.apply(this, arguments).replace(/\r\n/g, '\n');
	}

	if (v === void 0) {
		var text = this.__editor.getMarkdown().replace(/^(<br>\n?)+$/, '');
		if (!this.__editor.isMarkdownMode()) {
			text = text.replace(/(?<!\\)<br\s?>/g, '  ').replace(/(?:=?(['"])?)([A-Za-z]{3,5}:\/\/[^\s<>]+?)([.,]\s|[\s<>]|$)/g, function(match, quote, uri, suffix) {
				if (quote) {
					return uri;
				}
				uri = uri.replace(/\\_/g, '_');
				return uri + suffix;
			});
		}
		return text;
	}

	this.__editor.setMarkdown(v, false);
};

_me._getFocusElement = function() {
	if (this.__editorTextarea) {
		return obj_form_generic.prototype._getFocusElement.apply(this, arguments);
	}

	return this.__editor.getCurrentModeEditor().view.dom;
};

_me._focus = function() {
	if (this.__editorTextarea) {
		return obj_form_generic.prototype._focus.apply(this, arguments);
	}

	return this.__editor.focus();
};

_me._placeholder = function(v) {
	if (v !== void 0) {
		this.__placeholder = v;
	}

	if (this.__editorTextarea) {
		return obj_text.prototype._placeholder.apply(this, arguments);
	}

	if (v === void 0) {
		return this.__editor.placeholder;
	}

	this.__editor.setPlaceholder(v);
};

_me._getCartPos = function() {
	if (this.__editorTextarea) {
		return obj_text.prototype._getCartPos.apply(this, arguments);
	}

	var index;

	var selection = this.__editor.getSelection();
	var lines = this._value().split('\n');
	if (this.__editor.isMarkdownMode()) {
		index = selection[1][1] - 1;
		for (var i = 0; i < selection[1][0] - 1; i++) {
			index += lines[i].length + 1;
		}
	} else {
		index = selection[1] - 1;
	}

	return index;
};

_me._setRange = function(iStart, iEnd) {
	if (this.__editorTextarea) {
		return obj_text.prototype._setRange.apply(this, arguments);
	}

	if (iEnd === void 0) {
		iEnd = iStart;
	}

	var selection;
	var iStartLine = 0, iEndLine = 0;
	if (this.__editor.isMarkdownMode()) {
		var lines = this._value().split('\n');
		for (var i = 0; i < lines.length; i++) {
			if (iStart - lines[i].length - 1 > 0) {
				iStart -= lines[i].length + 1;
				iStartLine = i;
			}
			if (iEnd - lines[i].length - 1 > 0) {
				iEnd -= lines[i].length + 1;
				iEndLine = i;
			}
		}
		selection = [
			[iStartLine + 1, iStart + 1],
			[iEndLine + 1, iEnd + 1]
		];
	} else {
		selection = [iStart + 1, iEnd + 1];
	}
	
	return this.__editor.setSelection.apply(this.__editor, selection);
};

_me._insertText = function(sText) {
	if (this.__editorTextarea) {
		var iPos = this._getCartPos();
		var value = this._value();
		var text = (iPos > 0 ? (value.charAt(iPos - 1) === ' ' ? '' : ' ') : '') + sText.trim() + (value.charAt(iPos) === ' ' ? '' : ' ');

		this._value(value.substr(0, iPos) + text + value.substr(iPos));
		return this._setRange(iPos + text.length);
	}

	return this.__editor.insertText(sText);
};

_me._getSelectedText = function(iStart, iEnd) {
	if (iEnd === void 0 || (iStart >= iEnd)) {
		iEnd = iStart + 1;
	}
	if (this.__editorTextarea || this.__editor.isMarkdownMode()) {
		return this._value().substring(iStart, iEnd);
	}

	return this.__editor.getSelectedText(iStart, iEnd);
};

_me._replaceSelection = function(sText, iStart, iEnd) {
	if (this.__editorTextarea || (this.__editor.isMarkdownMode() && iStart !== void 0 && iEnd !== void 0)) {
		var value = this._value();
		var selectionStart = iStart === void 0 ? this.__eIN.selectionStart : iStart;
		var selectionEnd = iEnd === void 0 ? this.__eIN.selectionEnd : iEnd;
		this._value(value.slice(0, selectionStart) + sText + value.slice(selectionEnd));
		if (this.__editorTextarea) {
			this.__eIN.selectionStart = this.__eIN.selectionEnd += selectionStart + sText.length;
		} else {
			this._setRange(selectionStart + sText.length);
			this._unhighlight(true);
		}
		return;
	}

	if (iStart !== void 0 && iEnd !== void 0) {
		return this.__editor.replaceSelection(sText, iStart, iEnd);
	}

	return obj_wysiwyg.prototype._replaceSelection.call(this, sText);
};

_me._selectElement = function() {
	var range = new Range();
	var root = this.__editor.getCurrentModeEditor().view.dom;
	var selection = root.ownerDocument.defaultView.getSelection();
	range.setStartBefore(root.firstElementChild);
	range.setEndAfter(root.lastElementChild);
	selection.removeAllRanges();
	selection.addRange(range);
	this.__range = range;
	this.__exeEvent('selectionChanged', this, selection);
	return selection;
};

_me._highlightSelection = function() {
	var view = this.__editor.getCurrentModeEditor().view;
	view.editable = false;
	this.__rangeState = rangy.saveRange(this.__range);
	this.__rangeState2 = rangy.saveRange(this.__range);
	if (!this.__highlighter) {
		this.__highlighter = rangy.createHighlighter(this.__doc());
		this.__highlighter.addClassApplier(rangy.createClassApplier("iw-highlight", {}));
	}
	this.__highlighter.highlightSelection('iw-highlight');
	var selection = this.__doc().defaultView.getSelection();
	selection.removeAllRanges();
	this.__exeEvent('selectionHighlighted');
};

_me._unhighlight = function(bSkipHighlight) {
	if (!this.__highlighter) {
		return;
	}

	var view = this.__editor.getCurrentModeEditor().view;
	var selection = this.__doc().defaultView.getSelection();
	if (this.__rangeState) {
		var range = rangy.restoreRange(this.__rangeState);
		selection.removeAllRanges();
		selection.addRange(range.nativeRange);
		this.__rangeState = null;
	}

	this.__highlighter.unhighlightSelection();

	if (this.__rangeState2) {
		range = rangy.restoreRange(this.__rangeState2);
		selection.removeAllRanges();
		if (!bSkipHighlight) {
			selection.addRange(range.nativeRange);
			this.__range = range.nativeRange;
		}
		this.__rangeState2 = null;
	}

	this.__exeEvent('selectionUnhighlighted');
	if (view) {
		view.editable = true;
	}
};

_me._readonly = function(b) {
	if (this.__editorTextarea) {
		return obj_text.prototype._readonly.apply(this, arguments);
	}

	if (b !== void 0) {
		this.__eIN.readOnly = b;

		if (this.__editor.mdEditor.view) {
			this.__editor.mdEditor.view.dom.contentEditable = !b;
		}
		if (this.__editor.wwEditor.view) {
			this.__editor.wwEditor.view.dom.contentEditable = !b;
		}
	}

	return this.__eIN.readOnly;
};

// parse suggest caption
_me.__caption = function() {
	return getLang('CHAT::MENTIONS_SUGGEST', [mkElement('b', {text:'"'+ (this.__last_qdata.length>1?this.__last_qdata.substr(1):getLang('COMMON::ALL')) +'"'}).outerHTML]);
};

// get string for suggestion
_me._qdata = function(){
	var iStart = 0, iEnd = 0, s,
		cart = this._getCartPos();

	//start (search for @ only 16 chars before)
	for(var i = cart; i>=0 && cart-i<16; i--){

		s = this._getSelectedText(i);

		if (s == ']')
			return '';
		else
		if (s == '@'){

			//skip already suggested @[...
			if ((s = this._getSelectedText(i+1)) && s == "[")
				return '';

			//mandatory blank space
			if (i>0 && (s = this._getSelectedText(i-1)) && (/\s/g).test(s) === false)
				return '';

			iStart = i;
			iEnd = cart;
			break;
		}
	}

	this.__last_pos = [iStart, iEnd, (iStart || iEnd) ? this._getSelectedText(iStart, iEnd + 1) : '', this._value()];
	return this.__last_pos[2];
};

_me._query = function(v){
	var fid = this.__folder.fid;
	if (!fid) {
		return this.__hide();
	}
	if (!dataSet.get('folders', [this.__folder.aid, fid])) {
		var fids = fid.split('/');
		fids.pop();
		fids = fids.join('/');
		if (dataSet.get('folders', [this.__folder.aid, fids])) {
			fid = fids;
		}
	}
	this.__fid = fid;

	if (this.__folder && this.__folder.aid && fid && this._value() === this.__last_pos[3]){
		this.__last_qdata = v;

		var aFilter = {
				search: v.substr(1),
				sort: 'FRTISGUEST DESC, FRTNAME, FRTEMAIL',
				limit: this._limit
			};

		if (v.length>1)
			aFilter.startswith = 1;

		WMItems.list({'aid':this.__folder.aid,'fid':'__@@GROUP@@__/' + fid,'values':[],'filter':aFilter},'','','',[this,'_parse', [v]]);
	}

};

_me._parse = function(sWord, aData){
	if (this.__last_qdata === sWord && this._value() === this.__last_pos[3]){

		if (aData && (aData = aData[this.__folder.aid]) && (aData = aData['__@@GROUP@@__/' + this.__fid])){
			var out = [];
			if(~getLang('CHAT::ALL_MEMBERS').toLowerCase().indexOf(sWord.replace(/^@/, '').toLowerCase())) {
				out.push({value: getLang('CHAT::ALL_MEMBERS'), email: '@all@', css: 'avatar'});
			}
			for(var iid in aData)
				if (aData[iid].FRTEMAIL)
					out.push({value:MailAddress.createEmail(aData[iid].FRTNAME, aData[iid].FRTEMAIL, true), name:aData[iid].FRTNAME, email:aData[iid].FRTEMAIL, css:'avatar', prefix: obj_avatar.getAvatarHTML({
						email: aData[iid].FRTEMAIL,
						name: aData[iid].FRTNAME || aData[iid].FRTEMAIL,
						size: 32
					})});

			if (out.length)
				this.__show(out);
			else
				this.__hide();

			this.__sLastRequestString = sWord;
			this.__sLastSuggest = sWord;
		}
		else
			this.__hide();
	}

};

_me._qvalue = function(v){
	var old = this._value();

	if (Is.Object(v) && v.email && old === this.__last_pos[3]){

		var s = v.email,
			a = s.toLowerCase().split('@');

		if (a[1] && a[1] == dataSet.get('main',['domain']))
			s = a[0];

		//Add Mention
		this._mention(v);

		this._qdata(old);
		this._replaceSelection('@[' + s + ']', this.__last_pos[0], this.__last_pos[1] + 1);
	}
};

_me._mention = function(v){
	if (Is.Defined(v)){
		if (Is.Object(v))
			this.__mentions[v.email] = v.name || v.email;
		else
			this.__mentions = {};
	}
	else
		return this.__mentions;
};

//	@param: v, object, {name:'admin', email:'admin@demo.com'}
_me._addMention = function(v){
	var email = v.email,
		a = email.toLowerCase().split('@');

	if (a[1] && a[1] === dataSet.get('main',['domain']))
		email = a[0];

	this._mention(v);

	var old = (this._value() || '').trim();
	this._value((old?old + ' ':'') + '@['+email+'] ');
	this._setRange(this._value().length);
};

_me.__suggest = function(){
	if (!this.__showTime || !this.__mentions_enabled) return;

	if (this._destructed){
		this.__hide();
		return;
	}

	this.__input_value = this._value();

	var v = this._qdata(this.__input_value).trim();
	if (!this.__bAllowEmpty && (!v || v.length<this._min)) {
		this.__hide();
		return;
	}

	if (this.__sLastSuggest !== v){
		this.__show([{loader: true}]);
		this._query(v);
		this.__sLastSuggest = v;
	}
	else
	if (!this.suggest && !this._destructed && this._parse)
		this._parse();
};

_me._ondetach = function(context) {
	if (this._destructed || this._gui !== context) {
		return;
	}
	this.__initEditor();
};