_me = obj_tch_control.prototype;
function obj_tch_control(){};

_me.__constructor = async function(buttons, aData){
	this.__state = 'hidden';

	this.__buttons = (buttons || []).filter(Boolean);
	await this._draw('obj_tch_control', 'main', { buttons: this.__buttons });

	[].forEach.call(this._main.querySelectorAll('[tooltip]'), function(el) {
		var tooltip = el.getAttribute('tooltip');
		gui.tooltip._add(el, tooltip);
	});

	this._main.onclick = async function(e){
		e.stopPropagation();
		var elm = e.target;
		if (elm != this._main && !hascss(elm, 'disabled')) {
			var rel = elm.getAttribute('rel'),
				obj, fresh = false,
				button = this.__buttons.filter(function(button) {
					return button.id === rel;
				})[0];

			switch(rel){
				case 'like':
					if (!this.smiles || this.smiles._destructed){
						this.smiles = await this._gui._create('smiles', 'obj_minismile', '','',[function(sReaction){
							var callback = button.callback.slice();
							pushParameterToCallback(callback, sReaction);
							executeCallbackFunction(callback);
						}]);

						fresh = true;
					}

					obj = this.smiles;
					obj._active(aData.REAVALUE);
					break;

				case 'pin':
					if (!this.pins || this.pins._destructed){
						this.pins = await this._gui._create('pins', 'obj_minipin', '','',[function(sType){
							var callback = button.callback.slice();
							pushParameterToCallback(callback, sType);
							executeCallbackFunction(callback);
						}]);

						fresh = true;
					}
					obj = this.pins;

					//Activate Pin
					var linkextras;
					if ((aData.GPINOWNEMAIL && aData.GPINOWNEMAIL !== sPrimaryAccount) || (aData.EVNLINKEXTRAS && (linkextras = parseURL(aData.EVNLINKEXTRAS)) && linkextras.AccountEmail))
						addcss(obj._main.querySelector('.public'), 'disabled');

					window[aData.GPINWHEN?'addcss':'removecss'](obj._main.querySelector('.public'), 'active');
					window[aData.PINWHEN?'addcss':'removecss'](obj._main.querySelector('.private'), 'active');

					break;

				default:
					// addcss(elm, 'active');
					button && executeCallbackFunction(button.callback, elm);
					// removecss(elm, 'active');
					return;
			}

			// ALL BUBBLES ARE THE SAME!

			//close the bubbles
			['smiles','pins'].forEach(function(s){
				if (rel != s && this[s] && !this[s]._destructed && this[s].__state == 'visible')
					this[s]._hide(true);
			}.bind(this));

			// init bubble
			if (fresh){
				obj._modal(true);

				obj._onclose = function(){
					obj._hide();
					this._hide(true);
				}.bind(this);

				obj._onstate = function(s){
					if (s == 'visible')
						addcss(elm, 'active');
					else
						removecss(elm, 'active');
				};
			}
			else
			if (obj.__state == 'visible'){
				obj._hide(true);
				return;
			}

			addcss(elm, 'active');

			//place bubble
			var pos = getSize(elm);
			obj._show();

			obj._place({left: 'auto', right: Math.max(8, document.body.offsetWidth - pos.x - pos.w/2 - obj._main.offsetWidth/2) + 'px', top:(pos.y - pos.h - 2) + 'px'}); // - pos.w/2 + obj._main.offsetWidth/2
		}
	}.bind(this);
};

_me._hide = function(bForce){

	if (this.__state == 'visible'){

		for(var i = 0, a = ['smiles', 'pins', 'chatgpt']; a[i]; i++)
			if (this[a[i]] && !this[a[i]]._destructed && this[a[i]].__state == 'visible')
				if (bForce)
					this[a[i]]._hide(true);
				else
					return false;

		removecss(this._main, 'show');
		this.__state = 'hidden';

		if (this._onhide)
			this._onhide();
	}

	return true;
};

_me._show = function(){
	if (this.__state == 'hidden' && this.__buttons.length) {
		addcss(this._main, 'show');
		this.__state = 'visible';
	}
	return this;
};