_me = obj_tags.prototype;
function obj_tags() { };

_me.__constructor = async function (oOptions) {
	var me = this;
	this.__autosave = false;
	this.__saving = false;

	oOptions = Object.assign({
		adamFix: true
	}, oOptions || {});
	await this._create('tag', 'obj_tag_suggest', '', '', {
		reversed: true,
		adamFix: oOptions.adamFix
	});
	this.tag._placeholder(getLang('TAGS::ADD_TAG'));
	this.tag.__etag.ondblclick = function() {};
	this.tag._bEditSuggest = false;
	this.tag.__bAllowEmpty = true;

	this.tag._onclick = this.tag._oncontext = async function (aTag, e) {
		this.cmenu = await gui._create('cmenu', 'obj_context', '', '', me);
		var aMenu = [
			{
				text: '',
				element: mkElement('div', {
					className: 'tag_colors'
				}, '', ['#F07D88', '#55ABE5', '#A895E2', '#E18B00', '#5FBE7D', '#E1F100'].map(function (color) {
					return mkElement('div', {
						className: 'tag_color' + ((aTag.tag.bgcolor || '').toUpperCase() === color ? ' active' : ''),
						style: 'background: ' + color,
						onclick: function() {
							me.__changeColor(aTag, color);
						}
					});
				}))
			},
			{
				title: 'TAGS::CUSTOM_COLOR',
				arg: [me, '__customColor', [aTag]],
				css: 'ico2 colorpicker'
			},
			{
				title: 'FORM_BUTTONS::RENAME',
				arg: [me.tag, '_editTag', [aTag.elm, aTag]],
				css: 'ico2 edit2'
			},
			{
				title: 'TAGS::SEARCH_BY',
				arg: [function () {
					gui.frm_main.search._value('+tag:"' + aTag.tag.tag + '"');
				}],
				css: 'ico2 search'
			},
			{
				title: 'TAGS::REMOVE_TAG',
				arg: [me.tag, '_removeTag', [aTag.elm]],
				css: 'color2 ico2 delete'
			},
		];

		await gui.cmenu._fill(aMenu);
		var bcr = aTag.elm.getBoundingClientRect();
		gui.cmenu._place(bcr.left + bcr.width / 2, bcr.bottom, false, 2);
		e.preventDefault();
		e.stopPropagation();
		e.stopImmediatePropagation();
	};

	this.tag._onTagRename = function(aTag, sName) {
		var tag = dataSet.get('tags', [aTag.tag.tag]);

		if (aTag.tag.tag === sName || !tag) {
			return;
		}
		var id = tag.ID;
		aTag.tag.tag = tag.TAGNAME = sName;
		if (!dataSet.get('tags', [sName])) {
			tag.NEW = true;
			dataSet.add('tags', [sName], tag, true);
		}

		var bImap = WMFolders.getType([me.__aid, me.__fid, me.__iid[0]]) === 'M';

		WMItems.add([sPrimaryAccount, '__@@TAGS@@__', [id]], {
			values:{
				TAGNAME: sName,
				TAGCOLOR: tag.TAGCOLOR || '#ffffff',
				TAGIMAP: +bImap
			}
		}, '', '', '', [function () {
			gui.__exeEvent('tagUpdate', dataSet.get('tags', [aTag.tag.tag]));
			setTimeout(function () {
				me.__saving = false;
				me.__iid.forEach(function(iid) {
					dataSet.update('items', [me.__aid, me.__fid, iid, me.__tagColumn]);
				}, this);
				gui.frm_main._selectView({aid: me.__aid, fid: me.__fid});
			}, 100);
			if (gui.frm_main._dashboardLoaded()) {
				gui.frm_main.dashboard._updateTag({
					ID: id,
					TAGCOLOR: tag.TAGCOLOR || '#ffffff',
					TAGNAME: sName
				})
			}
		}]);
	};
};

_me._setId = async function (aIds) {
	(this.__iid || []).forEach(function(iid) {
		dataSet.off('items', [this.__aid, this.__fid, iid, this.__tagColumn], this.__handleTagChange, this);
	}, this);

	this.__aid = aIds[0];
	this.__fid = aIds[1];
	this.__iid = Array.isArray(aIds[2]) ? aIds[2] : [aIds[2]];

	var folderType = WMFolders.getType([this.__aid, this.__fid, this.__iid[0]]);
	this.__tagColumn = 'EVNTYPE';
	switch (folderType) {
		case 'C':
			this.__tagColumn = 'ITMCATEGORY';
			break;
		case 'M':
			this.__tagColumn = 'TAGS';
			break;
	}

	this.__tags = false;
	this.__iid.forEach(function(iid) {
		if (this.__tags === false) {
			this.__tags = (dataSet.get('items', [this.__aid, this.__fid, iid]) || {})[this.__tagColumn] || '';
		} else {
			this.__tags = ((dataSet.get('items', [this.__aid, this.__fid, iid]) || {})[this.__tagColumn] || '').split(/\s?,\s?/).filter(value => this.__tags.includes(value)).join(',');
		}
	}, this);

	delete this.tag._onchange;
	this.tag._value(this.__tags);

	if (WMFolders.getRights([this.__aid, this.__fid, this.__iid[0]]).owner || WMFolders.getAccess([this.__aid, this.__fid, this.__iid[0]]).modify) {
		await this.tag._readonly(false);
		var timeout;
		this.tag._onchange = function (value) {
			clearTimeout(timeout);
			timeout = setTimeout(function() {
				if (this.__autosave && !this.__saving && this.__unique(value) !== this.__unique(this.__tags)) {
					var bNewTag = value.split(/\s?,\s?/).some(function(v) {
						return !dataSet.get('tags', [v]) || dataSet.get('tags', [v, 'NEW']);
					});
					var data = { values: {} };
					data.values[this.__tagColumn] = value;

					var count = this.__iid.length;
					this.__iid.forEach(function(iid) {
						WMItems.add([this.__aid, this.__fid, iid], data, 'items', '', '', [
							async function (iid, bOK) {
								if (bOK) {
									dataSet.add('items', [this.__aid, this.__fid, iid, this.__tagColumn], value);
								}
								if (!--count) {
									this.__tags = value;
									if (dataSet.get('active_folder') === this.__aid + '/' + this.__fid) {
										dataSet.add('temp', ['includeIds'], this.__iid);
									}
									if (bNewTag) {
										await gui.frm_main._loadTags();
										gui.frm_main._selectView({aid: this.__aid, fid: this.__fid});
									}
								}
							}.bind(this, iid)
						]);
					}, this);
				}
			}.bind(this), 50);
		}.bind(this);
	} else {
		await this.tag._readonly(true);
	}

	this.__iid.forEach(function(iid) {
		dataSet.on('items', [this.__aid, this.__fid, iid, this.__tagColumn], this._handleTagChange, this);
	}, this);
};

_me._handleTagChange = function(sTags) {
	if (!this._destructed && this.tag) {
		this.tag._value(sTags);
	}
};

_me._save = function() {
	var value = this.tag._value();
	var count = this.__iid.length;
	this.__iid.forEach(function(iid) {
		var orig = ((dataSet.get('items', [this.__aid, this.__fid, iid]) || {})[this.__tagColumn] || '').split(/\s?,\s?/);
		for (var i in orig) {
			if (~this.__tags.split(/\s?,\s?/).indexOf(orig[i]) && !~value.split(/\s?,\s?/).indexOf(orig[i])) {
				delete orig[i];
			}
		}
		orig = this.__unique(orig.concat(value.split(/\s?,\s?/)).join(','));

		var data = { values: {} };
		data.values[this.__tagColumn] = orig;

		WMItems.add([this.__aid, this.__fid, iid], data, 'items', '', '', [
			async function (iid, bOK) {
				if (bOK) {
					dataSet.add('items', [this.__aid, this.__fid, iid, this.__tagColumn], orig);
				}
				if (!--count) {
					await gui.frm_main._loadTags();
					gui.frm_main._selectView({aid: this.__aid, fid: this.__fid});
				}
			}.bind(this, iid)
		]);
	}, this);
};

_me._autosave = function (v) {
	if (v) {
		this.__autosave = v;
	} else {
		return this.__autosave;
	}
};

_me.__unique = function (tags) {
	return tags.split(/\s?,\s?/).sort().filter(function (v, i, a) {
		return a.indexOf(v) === i;
	}).join(',');
};

_me.__changeColor = function (aTag, sColor) {
	if (sColor !== aTag.tag.bgcolor) {
		this.__saving = true;
		dataSet.add('tags', [aTag.tag.tag, 'TEXTCOLOR'], colors.fast_contrast(sColor), true);
		dataSet.add('tags', [aTag.tag.tag, 'TAGCOLOR'], sColor);

		var bImap = WMFolders.getType([this.__aid, this.__fid, this.__iid[0]]) === 'M';

		var id = dataSet.get('tags', [aTag.tag.tag, 'ID']);
		WMItems.add([sPrimaryAccount, '__@@TAGS@@__', [id]], {
			values: {
				TAGCOLOR: sColor,
				TAGNAME: aTag.tag.tag,
				TAGIMAP: +bImap
			}
		}, '', '', '', [function () {
			gui.__exeEvent('tagUpdate', dataSet.get('tags', [aTag.tag.tag]));
			if (!this.__autosave) {
				return;
			}
			setTimeout(function () {
				this.__saving = false;
				this.__iid.forEach(function(iid) {
					dataSet.update('items', [this.__aid, this.__fid, iid, this.__tagColumn]);
				}, this);
				gui.frm_main._selectView({aid: this.__aid, fid: this.__fid});
			}.bind(this), 100);
			if (gui.frm_main._dashboardLoaded()) {
				gui.frm_main.dashboard._updateTag({
					ID: id,
					TAGCOLOR: sColor,
					TAGNAME: aTag.tag.tag
				})
			}
		}.bind(this)]);
	}
};

_me.__customColor = function (aTag) {
	this._gui._create('color_picker', 'frm_color_picker', '', '', 'TAGS::CUSTOM_COLOR', aTag.tag.bgcolor || '#ffffff', [function (sColor) {
		if (sColor !== void 0) {
			this.__changeColor(aTag, sColor);
		}
	}.bind(this)]);
};

_me._value = function (v) {
	this.__saving = true;
	var result = this.tag._value(v);
	this.__saving = false;
	return result;
};

_me._readonly = async function (v) {
	return await this.tag._readonly(v);
};