_me = obj_tag_suggest.prototype;
function obj_tag_suggest() { };

/**
 * @brief: CONSTRUCTOR
 * @date : 29.1.2013
 **/
_me.__constructor = async function () {
	this.__activeFirst = true;

	this._min = 1;
	this.__minWidth = 250;
	this._limit = 15;
	this._folder;

	this.__centerSuggest = this.plus.__eIN;

	this.__hints = [];

};

///////////////////////////////////////////

_me.__caption = function() {
	return getLang('TAGS::SUGGESTIONS');
};

_me._qdata = function (v) {

	var cart = this._getCartPos(),
		end = false, word = [0, 0];

	for (var i = 0, l = v.length; i < l; i++) {
		switch (v.charAt(i)) {
			case ',':
				if (cart <= i)
					end = true;
				else
					word = [i + 1, i + 1];

				break;

			default:
				word[1] = i + 1;
		}

		if (end) break;
	}

	v = v.substring(word[0], word[1]);
	this.__last_pos = [word[0], word[1], v];
	return v;
};


_me._qvalue = function (v) {
	if (Is.Object(v))
		v = v.value;

	if (typeof v != 'undefined') {
		var inp = this._getFocusedInput();
		if (inp) {

			var old = inp._value();
			this._qdata(old);
			inp._value(old.substr(0, this.__last_pos[0]) + v + old.substr(this.__last_pos[1]));

			this.__inpBlur('',{owner:inp});
		}
	}
};

_me._query = function (v) {
	//SQL query
	var aFilter = {
		search: '+tag:"'+v.trim() + '"',
		sort: 'TAGNAME',
		nocount: 1,
		limit: this._limit
	};

	if (Is.Object(this._folder))
		aFilter.folder = this._folder.fid;

	// offline
	var data = {};
	data[sPrimaryAccount] = {};
	data[sPrimaryAccount]['__@@TAGS@@__'] = {
		'#': 1
	};

	var tags = dataSet.get('tags');
	for (var i in tags) {
		if (~i.toLowerCase().indexOf(v.trim().toLowerCase())) {
			data[sPrimaryAccount]['__@@TAGS@@__'][i] = tags[i];
		}
	}
	this._parse(v, data);

	// online
	WMItems.list({ aid: sPrimaryAccount, fid: '__@@TAGS@@__', 'values': ['TAGNAME', 'TAGCOUNT'], filter: aFilter }, '', '', '', [this, '_parse', [v]]);
};

_me._parse = function (sWord, aData) {
	if (this._input_value() == sWord) {
		aData = aData[sPrimaryAccount]['__@@TAGS@@__'];
		if (aData && parseInt(aData['#'], 10) > 0) {
			delete aData['/'];
			delete aData['#'];
			delete aData['$'];
			delete aData['@'];

			var aOut = [];
			for (var id in aData)
				if (aData[id].TAGNAME)
					aOut.push({
						value: aData[id].TAGNAME,
						prefix: '<span class="tag" style="background-color:' + (aData[id].TAGCOLOR || '#ffffff') + ';color:' + (aData[id].TEXTCOLOR || colors.fast_contrast(aData[id].TAGCOLOR || '#ffffff') || '#000000') + '">',
						postfix: '</span>',
						hint: getLang('TAGS::HINT', [aData[id].TAGCOUNT || 0])
					});

			if (!Is.Array(aOut) || !aOut.length)
				this.__hide();
			else
				this.__show(aOut);
		}

		this.__sLastRequestString = sWord;
		this.__sLastSuggest = sWord;
	} else {
		this.__show();
		this.__sLastRequestString = '';
	}
};