_me = obj_tag.prototype;
function obj_tag(){}

/**
 * @brief: CONSTRUCTOR
 * @date : 29.1.2013
 **/
_me.__constructor = async function(oOptions){
	var me = this;

	this.__tags = [];
	this.__tagFocus = null;
	this.__plus_placeholder = '';
	this.__collapse_limit = 2;
	this._bEditSuggest = true;
	this.__bAllowEmpty = false;

	this.__separator = ',';

	this.__oOptions = Object.assign({
		reversed: false,
		adamFix: false // button instead of initial input

	}, oOptions || {});
	await this._draw('obj_tag', '', this.__oOptions);

	this.__etag = this._getAnchor('tag');
	this.__etag.onclick = async function(e){
		if (await me._readonly() || this.__collapsed) {
			return true;
		}

		var elm = e.target;

		switch(elm.tagName) {
			case 'SPAN':

				me._focusTag(elm);
				me._onclick && me._onclick(me.__tags.filter(function(tag) {
					return tag.elm === elm;
				})[0], e);
				if (me._scrollbar){
					e.preventDefault();
					e.stopPropagation();
				}

				break;

			case 'EM':
				me._focusNextTag(elm);
				me._removeTag(elm.parentNode, e);
				break;

			case 'B':
				if ((elm = elm.parentNode)){
					me._focusTag(elm);

					if (me._onexpand) {me._onexpand(elm)}

					me.__exeEvent('onexpand',e,{'owner':me, elm:elm});

					e.preventDefault();
					e.stopPropagation();
				}

				break;
		}
	};


	this.__etag.ondblclick = function(e){
		switch(e.target.tagName) {
			case 'SPAN':
				me._editTag(e.target);
				break;
		}
	};

	this.__etag.oncontextmenu = function(e){
		if (e.target.tagName === 'SPAN') {
			me._focusTag(e.target);
			me._oncontext && me._oncontext(me.__tags.filter(function(tag) {
				return tag.elm === e.target;
			})[0], e);
		}
	};


	this._main.onclick = function(e){
		if (e.target.tagName != 'INPUT') {me._focus()}
	};

	await this._readonly(false);
};

_me._value = function(v, bCollapse, sCollapsedLang){
	var i;

	if (Is.Defined(v)){
		this.__tags = [];
		bCollapse = bCollapse && this.plus;

		//cancel edit, clean up
		this._editTag();
		[].forEach.call(this.__etag.querySelectorAll('span'), function(tag) {
			tag.parentElement.removeChild(tag);
		});

		//fill new values
		var aVal = this._decode(v), c = 0;
		for (i in aVal){
			//collapse part 1
			if (bCollapse && c && !this.__collapsed){
				aVal[i].css = (aVal[i].css?' ':'') + 'collapsed';
			}

			this._addTag(aVal[i]);
			c++;
		}

		if (this.__collapsed){
			this._expandInput();
		} else
		//collapse part 2
		if (bCollapse && c>this.__collapse_limit){
			this.__collapsed = true;
			addcss(this._main, 'collapsed');
			this._placeholder(getLang(sCollapsedLang || 'CHAT::REACTIONS_BUBBLE', [--c]), true);

			this.plus._obeyEvent('onfocus',[function(){
				this._expandInput();
				return false;
			}.bind(this)]);
		}

		if (this._onchange){
			var iHash = this.__hashCode(this.__etag.innerHTML);
			if (this.__lastHash !== iHash){
				this._onchange(this._value(), this.__tags);
				this.__lastHash = iHash;
			}
		}
		this.plus && this.plus._value('');
	} else{
		var a = this.__etag.getElementsByTagName('SPAN'),
			aTags = [];

		for (i = 0; i<a.length; i++) {aTags.push(a[i].getAttribute('val'))}

		return this._encode(aTags);
	}
};

_me.__hashCode = function(str) {
	var hash = 0, i, chr;
	if (str.length === 0) return hash;
	for (i = 0; i < str.length; i++) {
		chr   = str.charCodeAt(i);
		hash  = ((hash << 5) - hash) + chr;
		hash |= 0;
	}
	return hash;
};

_me._expandInput = function(){
	if (this.__collapsed){
		[].map.call(this._main.querySelectorAll('SPAN.tag.collapsed'), function(a){
			removecss(a,'collapsed');
		});

		this._placeholder(this._placeholder());
		this.__collapsed = false;
		removecss(this._main, 'collapsed');
	}
};

_me._readonly = async function(b){

	if (Is.Defined(b)){
		if (!(this.__readonly = b?true:false)){

			removecss(this._main,'readonly');
			if (this.__oOptions.adamFix) {
				removecss(this._main, 'enabled');
			} else {
				addcss(this._main, 'enabled');
			}
			if (!this.plus) {
				if (this.__oOptions.adamFix) {
					await this._create('plus_button', 'obj_button', {
						target: 'tag',
						first: true
					}, 'ico plus add transparent');
					this.plus_button._onclick = function() {
						addcss(this._main, 'enabled');
						this._focus();
					}.bind(this);
					this.plus_button._value(this._placeholder());
					this.plus_button.__eIN.setAttribute('tabindex', -1);
				}

				await this._create('plus','obj_input_dynamic',{
					target: 'tag',
					first: true
				},'ico plus');
				this._placeholder(this._placeholder());
				this.plus._value('');
				this.plus.__eIN.setAttribute('tabindex', -1);
				this.plus.__eIN.setAttribute('data-1p-ignore', '');
				this.__centerSuggest = this.plus.__eIN;

				//For obj_tag
				this.plus._obeyEvent('onkeydown', [this,'__inpKey'], true);
				this.plus._obeyEvent('onblur', [this,'__inpBlur'], true);

				//For obj_suggest
				this.plus._obeyEvent('onfocus',[this,'__inpEvent_plus']);
				this.plus._obeyEvent('onblur',[this,'__inpEvent_plus']);
				this.plus._obeyEvent('onkeyup',[this,'__inpEvent_plus']);
				this.plus._obeyEvent('click',[this,'__inpEvent_plus']);

				//bubble evn
				var me = this;
				this.plus._onkeydown = function(e){
					if (me._onkeydown && me._onkeydown(e) === false) {return false}

					me.__exeEvent('onkeydown', e);
				};
				this.plus._onsubmit = function(e){ if (me._onsubmit) {return me._onsubmit(e)} };
			}
		} else{
			addcss(this._main,'readonly');
			removecss(this._main, 'enabled');
			this._focusTag(null);

			if (this.plus) {
				this.plus._destruct();
				this.plus_button && this.plus_button._destruct();
			}
		}
	} else {
		return this.__readonly;
	}
};

_me._placeholder = function(s, bTmp){
	if (Is.String(s)){
		if (!bTmp) {this.__plus_placeholder = s}
		this.plus && this.plus._placeholder(s);
		this.plus_button && this.plus_button._text(s);
	} else {return this.__plus_placeholder}
};

_me._disabled = async function(b){
	return await this._readonly(b);
};

_me._getFocusedInput = function(){
	return this.edit || this.plus;
};

_me._getFocusElement = function (){
	var o = this._getFocusedInput();
	if (o) {return o.__eIN}
};
_me._focus = function(){
	if (this.plus) {
		this._focusTag(null);
		this.__tagFocus = this.plus._main;
		return this.plus._focus();
	}
};

_me._getCartPos = function(){
	var inp = this._getFocusedInput();
	return inp && inp._getCartPos?inp._getCartPos():0;
};

_me._focusTag = function(elm){
	if (typeof elm != 'undefined' && (!this.__readonly || elm == null)){

		if (this.__tagFocus && this.__tagFocus.parentNode){
			if (this.__tagFocus === elm) {
				return;
			} else {
				removecss(this.__tagFocus, 'active');
			}
		}

		if (elm != null){
			addcss(elm,'active');
			this.__tagFocus = elm;

			//Scroll to
			if (elm && this._scrollbar){
				var ec = this._getAnchor('container'),
					p1 = getSize(ec),
					p2 = getSize(elm);

				if (p2.y<p1.y) {ec.scrollTop -= p1.y-p2.y} else
				if (p2.y+p2.h>p1.y+p1.h) {ec.scrollTop += p2.y+p2.h - p1.y-p1.h}
			}
		}
	}

	if (this.__tagFocus != null && !this.__tagFocus.parentNode) {
		this.__tagFocus = null;
	}

	return this.__tagFocus;
};

_me._focusNextTag = function(elm){
	elm = elm || this._focusTag();

	if (elm && (elm = (elm.nextSibling || this.__etag.firstElementChild))) {
		if (elm === this.plus._main) {
			return this._focus();
		} else {
			return this._focusTag(elm);
		}
	} else {
		return this._focus();
	}
};
_me._focusPrevTag = function(elm){
	elm = elm || this._focusTag();

	if (elm && (elm = (elm.previousSibling || this.__etag.lastElementChild))) {
		if (elm === this.plus._main) {
			return this._focus();
		} else {
			return this._focusTag(elm);
		}
	} else {
		return this._focus();
	}
};


// @Input format: {tag:<tag>[, label:<text>, css:<className>, bgcolor:<#FFFFFF>, color:<#FFFFFF>]}
_me._addTag = function(aTag, elm){
	if (aTag.tag) {
		if (this._onBeforeAdd && this._onBeforeAdd(aTag) === false) {
			return;
		}

		if (!elm){
			if (this.__tags.some(function(tag) {
				return tag.tag.tag === aTag.tag;
			})) {
				return;
			}

			elm = mkElement('SPAN',{
				className:'tag',
				id: aTag.id,
				'data-tag': aTag.ID
			});
			this.__etag.appendChild(elm);

			this.__tags.push({
				elm: elm,
				tag: aTag
			});
		} else {
			elm.className = 'tag';
			this.__tags.filter(function(tag) {
				return tag.elm === elm;
			})[0].tag = aTag;
		}

		if (aTag.css) {addcss(elm, aTag.css)}

		if (aTag.err) {addcss(elm,'error')}

		if (elm.querySelector('i')) {
			elm.removeChild(elm.querySelector('i'));
		}
		elm.appendChild(mkElement('i', {
			textContent: (aTag.label || aTag.tag)
		}));
		elm.setAttribute('val', aTag.tag);

		if (aTag.expand){
			addcss(elm,'expand');
			elm.appendChild(mkElement('B'));
		}

		if (elm.querySelector('em')) {
			elm.removeChild(elm.querySelector('em'));
		}
		if (!this.__readonly) {elm.appendChild(mkElement('EM'))}

		elm.style.backgroundColor = aTag.bgcolor || '';
		elm.style.color = aTag.color || '';

		if (this._onchange){
			this._onchange(this._value(), this.__tags);
		}

		this.__exeEvent('onchange',null,{'owner':this});
	}
};

_me._removeTag = function(elm, e) {
	elm.parentNode && elm.parentNode.removeChild(elm);
	this.__tags = this.__tags.filter(function(tag) {
		return tag.elm !== elm;
	});

	if (this._onchange) {this._onchange(this._value(), this.__tags);}
	this.__exeEvent('onchange', e, {owner: this});
}

/////////////////////////////////////////

// Listen to events for inherited objects
_me.__onkeydown = function(){};

_me.__inpEvent = function(e,arg){
	if (e.type == 'focus'){
		this._focus();
		this.__hasFocus = true;
		addcss(this._main, 'focus');
	}/* else
	if (e.type == 'blur'){
		this._focusTag(null);
		this.__hasFocus = false;
		removecss(this._main, 'focus');
	}*/

	this.__exeEvent('on'+e.type,e,arg);
};
_me.__inpEvent_plus = function(e,arg){
	if (e.type == 'keyup' && (this.__bAllowEmpty || this.plus._value().length)) {
		this._focusTag(null);
	}

	this.__inpEvent(e,arg);
};

// Input Handling
_me.__inpBlur = function(e,arg){
	if (this.edit && arg.owner === this.edit) {
		this.edit._onsubmit();
	} else {
		this.__inpKey({
			keyCode: 13
		}, arg);
	}
};

_me.__inpKey = function(e,arg){
	var elm;
	switch(e.keyCode){
		//F2 Edit
		case 113:
			if (this.plus._value() == '' && (elm = this._focusTag())) {this._editTag(elm)}

			e.preventDefault();
			e.stopPropagation();

			break;
		//Backspace
		case 8:
			if (this.plus._value() == '' && (elm = this._focusTag()) && elm !== this.plus._main) {
				this._focusPrevTag(elm);
				this._removeTag(elm);
			}

			if (this._onchange) {
				this._onchange(this._value(), this.__tags);
			}
			this.__exeEvent('onchange',null,{'owner':this});
			break;

		//delete
		case 46:
			if (this.plus._value() == '' && (elm = this._focusTag()) && elm !== this.plus._main) {
				this._focusNextTag(elm);
				this._removeTag(elm);
			}

			if (this._onchange) {
				this._onchange(this._value(), this.__tags);
			}
			this.__exeEvent('onchange',null,{'owner':this});
			break;

		//Enter
		case 13:
			var v = this.plus._value();
			if (v){
				this.plus._value('');
				this._focus();

				var a = this._decode(v);
				for (var i in a) {this._addTag(a[i])}
			}
			break;

		//esc
		case 27:

			//close suggest
			if (this.suggest) {this.__hide()} else
			//clear input
			if (arg.owner._value().length) {arg.owner._value('')}
			//bubble up
			else {break}

			e.preventDefault();
			e.stopPropagation();

			break;

		//left
		case 37:
			if (this.plus._value() == ''){

				e.preventDefault();
				e.stopPropagation();

				this._focusPrevTag();
			}

			break;

		//right
		case 39:
			if (this.plus._value() == ''){

				e.preventDefault();
				e.stopPropagation();

				this._focusNextTag();
			}

			break;

		//Home
		case 36:
		//End
		case 35:
			if (!e.shiftKey && !e.ctrlKey && !e.metaKey){
				this._focusTag(null);
				this.plus._focus();
			}
			break;
	}
	this._onkeyup && this._onkeyup(e);
};

///////////////////////////////////////////

_me._editTag = async function(elm, aTag){
	if (await this._readonly() || this.__collapsed) {return}

	if (this.edit){

		var v = this.edit._value();
		elm = this.edit._main.parentNode;

		await this.edit._destruct();

		if (this.suggest) {this.__hide()}

		if (elm){
			this._onTagRename && aTag && this._onTagRename(aTag, v);
			//edit
			if (v){

				removecss(elm,'edit');
				elm.removeAttribute('id');

				var a = this._decode(v);
				for (var i in a){
					this._addTag(a[i], elm);
					elm = '';
				}
			} else
			//remove
			if (elm.parentNode) {elm.parentNode.removeChild(elm)}

			this._focus();

			if (this._onchange) {this._onchange(this._value(), this.__tags)}
			this.__exeEvent('onchange',null,{'owner':this});
		}
	} else
	if (elm){
		elm.innerHTML = '';
		elm.id = this._pathName +'/'+ unique_id();
		this._anchors.edit = elm.id;
		addcss(elm,'edit');

		var me = this;
		await this._create('edit','obj_input_dynamic','edit','noborder edit');

		this.edit.__maxWidth = parseInt(getComputedStyle(this.edit._main.parentElement).getPropertyValue('max-width') || 400, 10);

		this.edit._onsubmit = function(){
			delete me.edit._onblur;
			me._editTag(elm, aTag);
			me._focusTag(null);
		};
		this.edit._onblur = function(){
			me._editTag(elm, aTag);
		};

		this.edit._onclose  = function (e){
			this._value(elm.getAttribute('val'));
			me.edit._onsubmit();

			e.preventDefault();
			e.stopPropagation();
		};

		//For obj_suggest
		if (this._bEditSuggest) {
			// this.edit._obeyEvent('onfocus',[this,'__inpEvent']);
			this.edit._obeyEvent('onblur',[this,'__inpEvent']);
			this.edit._obeyEvent('onkeyup',[this,'__inpEvent']);
			this.edit._obeyEvent('onkeydown',[this,'__onkeydown']);
			this.edit._obeyEvent('click',[this,'__inpEvent']);

			this.edit._onkeydown = function(e){

				//Tab button behavior
				if (e.keyCode == 9){
					me._editTag();

					if (e.shiftKey) {me._focusPrevTag()} else {me._focusNextTag()}

					me._editTag(me._focusTag());
				} else
				if (me._onkeydown && me._onkeydown(e) === false) {return false} else {me.__exeEvent('onkeydown', e)}
			};
		}

		this.edit._value(elm.getAttribute('val'));
		this.edit._focus();
	}
};



///////////////////////////////////////////
// decode input
// @Output format: {tag:<tag>[css:<className>,bgcolor:<#FFFFFF>,color:<#FFFFFF>]}
_me._decode = function(v){

	var aIN = v.split(this.__separator),
		aOut = [];

	for (var i in aIN) {
		if (aIN[i] && aIN[i].trim && (aIN[i] = aIN[i].trim())){
			aOut.push({tag:aIN[i]});
		}
	}

	return aOut;
};

//encode output
_me._encode = function(a){
	var aOut = [],
		aUnq = {};

	//Tags are Unique
	for (var i in a) {
		if (a[i] && a[i].trim && (a[i] = a[i].trim()) && !aUnq[a[i]]){
			aOut.push(a[i]);
			aUnq[a[i]] = true;
		}
	}

	return aOut.join(this.__separator);
};

_me._setSeparator = function(separator) {
	this.__separator = separator;
	return this;
}