_me = obj_system.prototype;
function obj_system() { };

_me.__constructor = async function () {
	await storage.library('short_url');
	var me = this;
	this.__filter = '';

	dataSet.obey(this, '_listener1', 'folders', true);
	dataSet.obey(this, '_listener2', 'active_folder', true);
	this._add_destructor('__disobey_ds');

	//**** Drag and Drop ****
	this.__dndtimer = '';
	this.___lastdragover;
	this._getAnchor('list').onmousedown = function(e){
		window.clearTimeout(me.__dndtimer);

		if (e.button>1) return;
		var elm = e.target;

		while(!elm.classList.contains('folder')) {
			elm = elm.parentElement;
			if (elm === me._main) {
				return;
			}
		}

		//fire the event :)
		var x = e.clientX,
			y = e.clientY;
		me.__dndtimer = setTimeout(function(){
			gui.frm_main.dnd.create_drag({
				type: 'folder',
				value: [{
					aid: elm.getAttribute('data-aid'),
					fid: elm.getAttribute('data-fid')
				}],
				x: x,
				y: y,
				obj: this
			});
		}, 250);
	};

	this._getAnchor('list').onmouseup = function(){
		window.clearTimeout(me.__dndtimer);
	};

	gui.frm_main.dnd.registr_drop(this, ['item', 'attachment']);
};

_me.__disobey_ds = function () {
	dataSet.disobey(this, '_listener1');
	dataSet.disobey(this, '_listener2');
};

_me._fill = function (sActiveFolder) {
	sActiveFolder = (sActiveFolder || dataSet.get('active_folder')).replace(sPrimaryAccount + '/', '');
	var sFolderType = WMFolders.getType({aid: sPrimaryAccount, fid: sActiveFolder});
	if (sFolderType === 'G') {
		sFolderType = this.__folderType;
	}
	this.__folderType = sFolderType;
	var aDFolders = GWOthers.get('DEFAULT_FOLDERS', 'storage')['VALUES'];
	var aFolders = [];
	switch(sFolderType) {
		case 'M':
		case 'Q':
		case 'QL':
			aFolders = [
				{ fid: 'INBOX', icon: 'inbox default' },
				{ fid: aDFolders.sent.replace(sPrimaryAccount + '/', ''), icon: 'sent' },
				{ fid: '__@@SNOOZED@@__', label: getLang('COMMON_FOLDERS::SNOOZED'), icon: 'snoozed disable_dnd', static: true },
				{ fid: aDFolders.drafts.replace(sPrimaryAccount + '/', ''), icon: 'drafts' },
				// { fid: '__@@NOTIFICATIONS@@__', label: getLang('COMMON_FOLDERS::NOTIFICATIONS'), icon: 'notifications' },
				// { fid: '__@@SOCIAL@@__', label: getLang('COMMON_FOLDERS::SOCIAL'), icon: 'social' },

				{ fid: 'Spam', icon: 'spam' },
				{ fid: 'Quarantine', icon: 'quarantine' },
				{ fid: aDFolders.trash.replace(sPrimaryAccount + '/', ''), icon: 'trash' },
				{ fid: 'SPAM_QUEUE/Blacklist', icon: 'blacklist'},
				{ fid: 'SPAM_QUEUE/Whitelist', icon: 'whitelist'}
			];
			break;
		case 'F':
			aFolders = [
				{ fid: Mapping.getDefaultFolderForGWType(sFolderType), icon: 'F default' },
				{ fid: Mapping.getDefaultFolderForGWType('D'), label: getLang('COMMON_FOLDERS::DASHBOARD'), icon: 'dashboard' },
				{ fid: Path.split(GWOthers.getItem('DEFAULT_FOLDERS', 'SMARTATTACH'))[1], label: getLang('COMMON_FOLDERS::UPLOAD'), icon: 'upload' },
				{ fid: '__@@GWTRASH@@__', label: getLang('COMMON_FOLDERS::GW-TRASH'), icon: 'recovery', filter: {
					defaultfilter: 'itmclass:"' + sFolderType + '"'
				} }
			];
			break;
		default:
			if (sFolderType === 'E') {
				aFolders.push({ fid: '__@@VIRTUAL@@__/__@@EVENTS@@__', icon: 'E default' });
				var aFols = dataSet.get('folders', [sPrimaryAccount]);
				for (var i in aFols) {
					if (aFols[i].TYPE === 'E' && aFols[i].VIRTUAL && i !== '__@@VIRTUAL@@__/__@@EVENTS@@__') {
						aFolders.push({ fid: i, label: aFols[i].NAME, icon: 'E' });
					}
				}
			} else if (Mapping.getDefaultFolderForGWType(sFolderType)) {
				aFolders.push({ fid: Mapping.getDefaultFolderForGWType(sFolderType), icon: sFolderType + ' default' });
			}
			aFolders.push({ fid: '__@@GWTRASH@@__', label: getLang('COMMON_FOLDERS::GW-TRASH'), icon: 'recovery', filter: {
				defaultfilter: 'itmclass:"' + ({C: 'C,L'}[sFolderType] || sFolderType) + '"'
			} });
	}

	var list = this._getAnchor('list');
	while(list.firstChild) {
		list.removeChild(list.lastChild);
	}

	aFolders.filter(Boolean).forEach(function(folder) {
		var aFolder = dataSet.get('folders', [sPrimaryAccount, folder.fid]);
		if (!folder.static && !aFolder) {
			return;
		}
		aFolder = aFolder || {};
		var item = mkElement('div', {
			className: 'folder folder_' + (folder.icon) + (sActiveFolder === folder.fid ? ' active' : ''),
			onclick: this._selectFolder.bind(this, folder),
			'data-aid': sPrimaryAccount,
			'data-fid': folder.fid
		}, false, [
			mkElement('div', {
				textContent: folder.label || aFolder.NAME || folder.fid.split('/').pop()
			}),
			(+aFolder.RECENT > 0 || +aFolder.COUNT > 0) && mkElement('span', {
				textContent: (aFolder.DEFAULT === 'D' || folder.fid === '__@@SNOOZED@@__') ? +aFolder.COUNT : (+aFolder.RECENT || +aFolder.COUNT)
			}),
		].filter(Boolean));

		item.oncontextmenu = this._oncontextmenu.bind(this, folder.fid, item);

		list.appendChild(item);
	}, this);

	this._filter();
};

_me._selectFolder = async function(folder) {
	var fid = folder.fid;
	var aFilter = folder.filter || {};
	var aFolder = dataSet.get('active_folder');
	var sFolType = WMFolders.getType({aid: sPrimaryAccount, fid: fid});

	if (aFolder != sPrimaryAccount + '/' + fid && dataSet.get('folders', [sPrimaryAccount, fid]) || folder.static) {
		var folders = ((gui.frm_main.bar.slide || [])[1] || {}).folders;
		if (folders) {
			await folders._setActive(sPrimaryAccount + '/' + fid, true);
		}
		var filter = {
			search: (gui.frm_main.search.__lastQueryClient[sFolType] || ''),
			defaultfilter: aFilter.defaultfilter
		};
		if (~filter.search.indexOf('+folders:"')) {
			filter.search = filter.search.replace(/\+folders:".*?"/, '').trim();
			if (filter.search.replace(/is:unread/, '').trim()) {
				delete gui.frm_main.main.list.__lastSearchFolder;
				delete gui.frm_main.main.list.__lastSearchAccount;
				gui.frm_main.search.__lastQueryClient[sFolType] = filter.search;
			}
		}
		gui.frm_main._selectView({aid: sPrimaryAccount, fid: fid, ftype: sFolType}, '', filter);
	}

	gui.__exeEvent('folderSelected', {aid: sPrimaryAccount, fid: fid, ftype: sFolType});
};

_me._oncontextmenu = async function(fid, elm, e) {
	e.preventDefault();
	var args = {aid: sPrimaryAccount, fid: fid};
	var aMenu = obj_tree_folder_context.__createFolderMenu.call(this, args),
		sFolType = WMFolders.getType(args);

	if (aMenu.length) {
		var cmenu = await gui._create('cmenu', 'obj_context_folder', '', '', this);
			await cmenu._fill(aMenu);
			cmenu._place(e.clientX, e.clientY);
			cmenu._add_destructor('__onclose');
			cmenu.__onclose = function() {
				this._active();
			}.bind(this);
			this._active(elm);

		if (sFolType === 'Y') {
			args.fid = args.fid.replace('/TeamChat', '');
			if (~(dataSet.get('folders', [args.aid, args.fid]).RIGHTS || '').indexOf('a')) {
				WMFolders.list(args, '', '', [async function (data) {
					if (cmenu && !cmenu._destructed){
						data = data[args.aid][args.fid];
						args.owner_id = dataSet.get('folders', [args.aid, args.fid + '/TeamChat', 'OWNER']);
						await cmenu._create('storage', 'obj_storage_usage', 'storage', '', data.QUOTA, data.SIZE, args);
					}
				}]);
			}
		}
	}
};

_me._active = function (eActive) {
	this.__active && removecss(this.__active, 'active2');
	this.__active = eActive;
	this.__active && addcss(this.__active, 'active2');
};

_me._filter = function (sFilter) {
	if (sFilter !== void 0) {
		this.__filter = sFilter;
	}
	[].forEach.call(this._getAnchor('list').querySelectorAll('.folder'), function(folder) {
		removecss(folder, 'hidden');
		if (this.__filter && !~folder.textContent.indexOf(this.__filter)) {
			addcss(folder, 'hidden');
		}
	}.bind(this));
};

_me.__update = function () {
	if (!this._destructed) {
		this._fill();
	}
};

_me._ondragover = function(v) {
	if (this.___lastdragover) {
		this.___lastdragover.classList.remove('dragover');
	}

	this.___lastdragover = [].filter.call(this._getAnchor('list').querySelectorAll('.folder'), function(folder) {
		var size = getSize(folder);
		return v.y >= size.y && v.y <= size.y + size.h;
	})[0];

	if (!this.___lastdragover) {
		return;
	}

	if (this.___lastdragover.classList.contains('disable_dnd')) {
		this.___lastdragover = '';
		return false;
	}

	this.___lastdragover.classList.add('dragover');
};

_me._ondragout = function() {
	if (this.___lastdragover) {
		removecss(this.___lastdragover, 'dragover');
		this.___lastdragover = '';
	}
};

_me._ondrop = function(v) {
	if (!this.___lastdragover) {
		return;
	}
	
	var list = gui.frm_main.main.list;
	var acc = this.___lastdragover.getAttribute('data-aid');
	var fol = this.___lastdragover.getAttribute('data-fid');

	switch(v.type) {
		case 'item':
			var iids = v.value.map(function(v) {
				return WMItems.__clientID(v.iid);
			});

			if (WMFolders.getType([acc, fol]) === 'G') {
				Item.remove([v.value[0].aid, v.value[0].fid, iids], false, false, list, list && list.__getNext(iids));
			} else {
				Item.__convertToFolder(acc, fol, v, list, list && list.__getNext(iids));
			}
		break;


		case 'attachment':
			for (var i in v.value) {
				var aData = clone(v.value[i], true);
				var shortURL = ShortURL.matches(aData.url || '');
				if (shortURL) {
					ShortURL.resolve({
						url: aData.url,
						callback: function(oURL, error) {
							if (error) {
								return gui.notifier._value({type: 'alert', args: {header: '', text: 'ATTACHMENT::SMART_DOESNT_EXIST'}});
							}
							aData.fullpath = oURL.url;
							if (WMFolders.getType([acc, fol]) === 'G') {
								Item.remove([aData.aid, aData.fid, iids], false, false, list, list && list.__getNext(iids));
							} else {
								obj_tree_folder_drag.prototype.__uploadAttachment(aData, {aid: acc, fid: fol});
							}

						}.bind(this),
						filename: aData.name
					});
				} else {
					if (WMFolders.getType([acc, fol]) === 'G') {
						Item.remove([aData.aid, aData.fid, iids], false, false, list, list && list.__getNext(iids));
					} else {
						obj_tree_folder_drag.prototype.__uploadAttachment(aData, {aid: acc, fid: fol});
					}
				}
			}
	}
};