_me = obj_sound.prototype;
function obj_sound() { };

/*
 *	Object to play audio that will be used multiple times
 *	(for example system notification audio)
 *
 *	Audio object will be kept with url
*/

_me.__constructor = async function () {
	// Audio file name definitions
	this.__sounds = {
		mail: 'msg.mp3',
		chat: 'chat.mp3',
		im: 'im.mp3',
		im_out: 'im_out.mp3'
	};

	// Holder for audio elements
	this.__audio = {};
};

_me._play = async function (sName) {
	// Check if we have a file to play for this sound
	var sound = this.__sounds[sName];
	if (sound) {

		sound = GWOthers.getItem('SOUND', sName) || ('client/inc/sound/' + sound);
		// Create audio element
		if (!this.__audio[sName]) {
			this.__audio[sName] = new Audio();
			this.__audio[sName].__loaded = false;
			this.__audio[sName].src = sound;
			this.__audio[sName].oncanplaythrough = async function () {
				this.__loaded = true;
				try { await this.play() } catch {
					//
				}
			};
			this.__audio[sName].onended = function () {
				delete this.__audio[sName];
			}.bind(this);
		}

		// Play sound
		if (this.__audio[sName] && this.__audio[sName].__loaded && this.__audio[sName].paused) {
			try { await this.__audio[sName].play() } catch {
				//
			}
		}
	}
};
