_me = obj_smilebox.prototype;
function obj_smilebox() {}

_me.__constructor = async function(aResponse, aOnLoad) {
	var me = this;

	var i18n = {};
	var lang = getLang('smiles');
	for (var i in lang) {
		i18n[i.toLowerCase()] = lang[i];
	}
	var customPath = './client/skins/default/images/smiles/people/';
	var picker = picmo.createPicker({
		rootElement: this._main,
		emojiData: picmoData,
		messages: picmoMessages,
		emojiSize: '20px',
		emojisPerRow: 12,
		showPreview: false,
		showSearch: false,
		initialCategory: 'recents',
		theme: dataSet.get('main', ['night_mode_enabled']) ? 'darkTheme' : 'lightTheme',
		i18n: i18n,
		custom: ['Feels Good', 'Finna Die', 'Go Berserk', 'God Mode', 'Hurt Real Bad', 'Rage 1', 'Rage 2', 'Rage 3', 'Rage 4', 'Suspect', 'Troll Face'].map(function(emoji) {
			return { emoji: ':' + emoji.replace(/\s/g, '').toLowerCase() + ':', label: emoji, url: customPath + emoji.replace(/\s/g, '').toLowerCase() + '.png', tags: emoji.split(' ') };
		})
	});

	picker.addEventListener('emoji:select', function(emoji) {
		executeCallbackFunction(aResponse, emoji);
	});
	picker.addEventListener('data:ready', function() {
		if (~window.navigator.userAgent.indexOf('Win')) {
			var io = new IntersectionObserver(function(entries) {
				entries.forEach(function(entry) {
					if (entry.intersectionRatio) {
						entry.target.innerHTML = twemoji.parse(entry.target.textContent, {
							base: './client/skins/default/images/',
							folder: 'twemoji',
							ext: '.svg'
						}).unescapeHTML();
						io.unobserve(entry.target);
					}
				});
			}, {
				root: this._main.querySelector('.picmo__emojiArea')
			});
			[].forEach.call(this._main.querySelectorAll('.picmo__emojiButton span'), function(emoji) {
				io.observe(emoji);
			});
		}
		executeCallbackFunction(aOnLoad);
	}.bind(this));

	if (this._gui !== gui) {
		[].some.call(document.styleSheets, function(styleSheet) {
			return [].some.call(styleSheet.rules, function(rule) {
				if (rule.selectorText === '.picmo__picker.picmo__picker') {
					me._gui._main.ownerDocument.head.appendChild(styleSheet.ownerNode.cloneNode(true));
					return true;
				}
			});
		});
	}
};