_me = obj_slider.prototype;

function obj_slider() {}

_me.__constructor = async function (aValues) {
	var isIE = document.documentMode || (/Edge/).test(navigator.userAgent);
	this.__slider = this._getAnchor('slider');
	this.__slider.addEventListener(isIE ? 'change' : 'input', function() {
		this._value(this._aValues[this.__slider.value]);
	}.bind(this));
	this._fill(aValues);
	
	this._getAnchor('before').addEventListener('click', function() {
		var v = this._value();
		for(var i in this._aValues) {
			if(this._aValues[i] == v) {
				this._value(this._aValues[i - 1]);
				break;
			}
		}
	}.bind(this));
	this._getAnchor('after').addEventListener('click', function() {
		var v = this._value();
		for(var i in this._aValues) {
			if(this._aValues[i] == v) {
				this._value(this._aValues[+i + 1]);
				break;
			}
		}
	}.bind(this));
	this._main.className += isIE ? ' IE' : '';
};

_me._value = function (v, bNoSave) {
	if (!Is.Defined(v)) {
		return this.__value;
	}

	if (this.__value == v) {
		return;
	}

	for(var i in this._aValues) {
		if(this._aValues[i] == v) {
			this.__slider.value = i;
			this.__value = v;

			if (this._onchange)
				this._onchange(v, bNoSave);
			this.__exeEvent('onchange', null, {
				"owner": this
			});
			break;
		}
	}
};

_me._fill = function (aValues) {
	if (aValues) {
		this._aValues = aValues;
		this.__slider.setAttribute('min', 0);
		this.__slider.setAttribute('max', this._aValues.length - 1);
	} else {
		return this._aValues;
	}
};