_me = obj_slide_panel.prototype;
function obj_slide_panel(){};

_me.__constructor = async function(oOptions) {
    this.__options = Object.assign({
        scrollable: false
    }, oOptions);

    if (this.__options.scrollable) {
        await this._draw('obj_slide_panel');
        await this._create('scrollbar','obj_scrollbar');
		this.scrollbar._scrollbar(this._getAnchor('container'), this._main);

        if (gui.frm_main && gui.frm_main.dnd){
            gui.frm_main.dnd.registr_drop(this, ['item', 'folder']);
        }
    }
}

_me._active_dropzone = function() {
    this._main.keep = true;
    return this._main;
}

_me._ondragover = function(){
	var me = this;

	if (!this.__dragON){
		this.__dragON = true;

		gui._obeyEvent('wheel',[this,'__wheel']);

		this.__objPos = getSize(this._getAnchor('container'));
		this.__dragscrollloop = window.setInterval(function(){
			if (me.__objPos){
				var delta;
				if (((delta = gui.__Y - me.__objPos.y)<51 && (delta -= 50)) || ((delta = gui.__Y - me.__objPos.y - me.__objPos.h)>-51 && (delta += 50)))
					me._getAnchor('container').scrollTop += Math.floor(delta/4);
			}
		},50);
	}
};

_me._ondragout = function(){
	gui._disobeyEvent('wheel',[this,'__wheel']);
	this.__dragON = false;

	if (this.__dragscrollloop){
		window.clearInterval(this.__dragscrollloop);
		this.__dragscrollloop = '';
	}
};

_me._ondrop = function(){
	gui._disobeyEvent('wheel',[this,'__wheel']);
	this.__dragON = false;
};

_me.__wheel = function(e){
	this._getAnchor('container').scrollTop += e.delta * 20;
};

_me._onactive = function(){};

_me._ondeactive = function(){};