_me = obj_search.prototype;
function obj_search() { };

_me.__constructor = async function (aFolder, oOptions) {
	var me = this;
	this.__lastQuery = {};
	this.__lastQueryClient = {};
	this.__aFolder = aFolder || {};
	this.__oOptions = Object.assign({
		preferredPosition: 'bottom'
	}, oOptions || {});

	var afterRender = this.__oOptions.afterRender;
	delete this.__oOptions.afterRender;

	var sFolderType = WMFolders.getType(this.__aFolder);
	if (dataSet.get('folders', [this.__aFolder.aid, this.__aFolder.fid, 'ARCHIVE'])) {
		sFolderType = 'A';
	}
	var config = this.__getConfig(sFolderType);

	this._main.setAttribute('foldertype', sFolderType);
	var customTagStyles = {};
	var tags = this.__getTags();
	tags.forEach(function(tag) {
		customTagStyles[tag.value] = tag.custom_style;
	});

	this.search = new SearchWizard({
		preferredPosition: this.__oOptions.preferredPosition,
		id: config.id,
		input: this.__eIN,
		onSubmit: function (server_query, client_query) {
			me.__lastQuery[me._main.getAttribute('foldertype')] = server_query;
			me.__lastQueryClient[me._main.getAttribute('foldertype')] = client_query;

			me._onsearch && me._onsearch(server_query, '', client_query);
			me.__exeEvent('onsearch', null, {
				sql: server_query,
				owner: me
			});
			if (server_query.replace(/\+folders:".*?"/, '').replace('+is:"genuine"', '').trim()) {
				me._main.classList.add('active');
			} else {
				me._main.classList.remove('active');
			}
		},
		i18n: {
			placeholder_empty: config.i18n.placeholder_empty,
			placeholder: getLang('SEARCH::PLACEHOLDER'),
			show_more: getLang('SEARCH::SHOW_MORE'),
			required: getLang('SEARCH::KEYWORD_REQUIRED'),
			optional: getLang('SEARCH::KEYWORD_OPTIONAL'),
			excluded: getLang('SEARCH::KEYWORD_EXCLUDED'),
			select_value: getLang('SEARCH::SELECT_VALUE'),
		},
		customStyles: {
			tag: customTagStyles
		},
		keywords: config.keywords,
		components: config.components,
		afterRender: function(popup) {
			me.popup = popup.DOMElement;
			afterRender && afterRender(me.popup);
			[].forEach.call(me.popup.querySelectorAll('.c-wizard-component--shortcuts .tag'), function(tag) {
				tag.addEventListener('contextmenu', async function(e) {
					e.preventDefault();

					gui.cmenu && await gui.cmenu._destruct();
					await gui._create("cmenu", "obj_context", '', '', me);
					await gui.cmenu._fill([{
						title: 'TAGS::REMOVE_TAG',
						arg: [me, '__deleteTag', [e.target.getAttribute('data-id')]]
					}]);
					gui.cmenu._place(e.clientX, e.clientY);
					gui.cmenu._main.style.zIndex = 1 + getComputedStyle(me.popup).zIndex;
				});
			});
			gui.cmenu = gui.cmenu || {
				_destruct: function() {
					delete gui.cmenu;
					me.search && me.search.hide();
				}
			}
		}
	});

	this.__blurHandler = this._blurHandler.bind(this);
	addEventListener('blur', this.__blurHandler, false);
	gui._obeyEvent('resize', [this, '__resizeHandler']);

	this.__closeWizard = this._closeWizard.bind(this);
	this._gui._main.addEventListener('click', this.__closeWizard, true);

	this._add_destructor('__destructor');
};

_me._disabled = function(disable) {
	if (disable === void 0) {
		return this._main.classList.contains('disabled');
	}

	this._main.classList[disable ? 'add' : 'remove']('disabled');
};

_me._closeWizard = function(e) {
	if (e && e.target && this._main.contains(e.target)) {
		return;
	}
	this.search && this.search.hide();
};

_me.__deleteTag = function(id) {
	WMItems.remove({
		aid: sPrimaryAccount,
		fid: '__@@TAGS@@__',
		iid: [id]
	}, 'items', '', 'folders', [function (bOK) {
		if (bOK) {
			var tags = dataSet.get('tags');
			for (var i in tags) {
				if (tags[i].ID === id) {
					delete tags[i];
					dataSet.add('tags', '', tags);
					break;
				}
			}
		}
	}])
}

_me.__resizeHandler = function() {
	if (!this.popup) {
		return;
	}
	var size = getSize(this._main);
	this.popup.style.setProperty('--left', size.x);
	this.popup.style.setProperty('--right', document.body.clientWidth - size.x - size.w);
};

_me._blurHandler = function() {
	setTimeout(function() {
		[].some.call(document.querySelectorAll('iframe'), function(frame) {
			if (document.activeElement === frame) {
				this.search.hide();
				return true;
			}
		}.bind(this));
	}.bind(this));
};

_me.__destructor = function () {
	removeEventListener('blur', this.__blurHandler, false);
	gui._disobeyEvent('resize', [this, '__resizeHandler']);
	this.search.disable();
	this._gui._main.removeEventListener('click', this.__closeWizard, true);
};

_me._value = function (sValue, includeMeta) {
	if (sValue === void 0) {
		return this.search.getQuery(includeMeta);
	} else {
		this.search.updateConfig({
			query: sValue
		});
	}
};

_me._focus = function() {
	this.search.focus();
};

_me._setFolder = function (aFolder, sSubType) {
	this.__aFolder = aFolder;
	var sFolderType = WMFolders.getType(aFolder);
	if (dataSet.get('folders', [this.__aFolder.aid, this.__aFolder.fid, 'ARCHIVE']) || dataSet.get('folders', [this.__aFolder.aid, (this.__aFolder.fid || '').split('/')[0], 'ARCHIVE'])) {
		sFolderType = 'A';
	}

	this.__updateRecent([dataSet.get('main', ['domain']).split('.').reverse().join('.'), sPrimaryAccount, sFolderType].filter(Boolean).join('.'));

	this.search.updateConfig(this.__getConfig(sFolderType, sSubType));

	this._main.setAttribute('foldertype', sFolderType);
};

_me.__getConfig = function (sFolderType, sSubType) {
	var keywords = this.__getFolderTypeKeywords(sFolderType, sSubType);

	return {
		id: [dataSet.get('main', ['domain']).split('.').reverse().join('.'), sPrimaryAccount, sFolderType].filter(Boolean).join('.'),
		keywords: keywords,
		components: this.__getFolderTypeComponents(sFolderType, keywords),
		i18n: {
			placeholder_empty: this.__getFolderTypePlaceholder(sFolderType)
		},
		query: this.__getDefaultQuery(sFolderType)
	};
};

_me.__getDefaultQuery = function(sFolderType, bServerQuery) {
	var defaultQuery = this[bServerQuery ? '__lastQuery' : '__lastQueryClient'][sFolderType] || '';

	if (sFolderType === 'A') { // archive
		if (!dataSet.get('main', ['disable_genuine'])) {
			defaultQuery += ' +is:"genuine"';
		}
	} else {
		defaultQuery = defaultQuery.replace(/\+is:"genuine"/, '');
	}
	return defaultQuery.trim();
};

_me.__updateRecent = function(id) {
	try {
		var queries = JSON.parse(localStorage.getItem('searchWizard')|| '{}') || {};
		queries[id] = (queries[id] || []).map(function(query) {
			return query.replace(/=xoxp-.*?&/g, '=' + (sPrimaryAccountTeamchatToken || 'xoxp-') + '&');
		});
		localStorage.setItem('searchWizard', JSON.stringify(queries));
	} catch {
		//
	}
};

_me.__folderTypeKeywords = {
	title: {},
	folder: {},
	subject: {},
	body: {},
	with: {
		similar: ['from', 'to', 'cc', 'bcc'],
		meta: true,
		image: true
	},
	from: {
		similar: ['with', 'to', 'cc', 'bcc'],
		meta: true,
		image: true
	},
	to: {
		similar: ['with', 'from', 'cc', 'bcc'],
		meta: true,
		image: true
	},
	cc: {
		similar: ['with', 'from', 'to', 'bcc'],
		meta: true,
		image: true
	},
	bcc: {
		similar: ['with', 'from', 'to', 'cc'],
		meta: true,
		image: true
	},
	name: {},
	sms: {},
	smaller: {
		type: 'number',
		placeholder: getLang('SEARCH::SIZE_IN_KB')
	},
	greater: {
		type: 'number',
		placeholder: getLang('SEARCH::SIZE_IN_KB')
	},
	priority: {
		type: 'number',
		placeholder: getLang('SEARCH::SIZE_IN_KB')
	},
	fulltext: {},
	email: {},
	company: {},
	department: {},
	note: {},
	description: {},
	location: {},
	after: {
		type: 'date',
		unique: ['after', 'last'],
	},
	aftertime: {
		type: 'datetime',
		unique: ['aftertime'],
	},
	before: {
		type: 'date',
		unique: ['before', 'last'],
	},
	beforetime: {
		type: 'datetime',
		unique: ['beforetime'],
	},
	creationdate: {
		type: 'date',
		unique: ['creationdate'],
	},
	last: {
		type: 'number',
		unique: ['before', 'after', 'last'],
	},
	is: {
		type: 'enum',
		values: {
			read: {
				unique: ['read', 'unread']
			},
			unread: {
				unique: ['read', 'unread']
			},
			flagged: {
				unique: ['flagged', 'unflagged']
			},
			unflagged: {
				unique: ['flagged', 'unflagged']
			},
			answered: {
				unique: ['answered', 'unanswered']
			},
			unanswered: {
				unique: ['answered', 'unanswered']
			},
			public: {
				unique: ['private', 'public']
			},
			private: {
				unique: ['private', 'public']
			},
			done: {},
			free: {
				unique: ['free', 'busy']
			},
			busy: {
				unique: ['free', 'busy']
			},
			spam: {
				unique: ['spam', 'genuine'],
				hidden: true,
			},
			genuine: {
				unique: ['spam', 'genuine'],
				hidden: true,
			}
		}
	},
	color: {
		type: 'enum',
		unique: ['color'],
		values: {
			'1': {
				unique: ['1', '2', '3', '5', '8', 'A', 'Y']
			},
			'2': {
				unique: ['1', '2', '3', '5', '8', 'A', 'Y']
			},
			'3': {
				unique: ['1', '2', '3', '5', '8', 'A', 'Y']
			},
			'5': {
				unique: ['1', '2', '3', '5', '8', 'A', 'Y']
			},
			'8': {
				unique: ['1', '2', '3', '5', '8', 'A', 'Y']
			},
			'A': {
				unique: ['1', '2', '3', '5', '8', 'A', 'Y']
			},
			'Y': {
				unique: ['1', '2', '3', '5', '8', 'A', 'Y']
			}
		}
	},
	has: {
		type: 'enum',
		values: {
			tag: {},
			attachment: {},
			phone: {},
		}
	},
	tag: {},
	yoda: {},
	folders: {
		type: 'enum',
		hidden: true,
		values: {
			current: {
				label: getLang('search::folders_current'),
				unique: ['current', 'all', 'subtree']
			},
			all: {
				label: getLang('search::folders_all'),
				unique: ['current', 'all', 'subtree']
			},
			subtree: {
				label: getLang('search::folders_subfolders'),
				unique: ['current', 'all', 'subtree']
			}
		}
	}
};

_me.__getFolderTypeKeywords = function (sFolderType, sSubType) {
	var keys = [],
		keywords = {};

	switch (sFolderType) {
		case 'G':
			keys = ['title', 'after', 'before', 'folder'];
			break;
		case 'A':
		case 'M':
		case 'Q':
		case 'QL':
			var aFolder = dataSet.get('folders', [this.__aFolder.aid, this.__aFolder.fid]) || {};

			keys = [
				'subject', 'body', 'yoda',
				'with', 'from', 'to',
				'after', 'before', 'last',
				'smaller', 'greater', 'priority',
				'is:read', 'is:unread',
				'is:flagged', 'is:unflagged',
				'is:answered', 'is:unanswered',
				'is:spam', 'is:genuine',
				'has:attachment'/*, 'has:tag'*/, 'tag',
				'color:1','color:2','color:3','color:5','color:8','color:A','color:Y',
				'folders:all', 'folders:subtree'
			];

			if (!aFolder.RSS) {
				keys.push('cc');
				keys.push('bcc');
				keys.push('sms');
			}
			break;
		case 'C':
			keys = ['name', 'email', 'company', 'department', 'note', 'tag', 'has:phone'];
			break;
		case 'N':
			keys = ['title', 'description', 'tag'];
			break;
		case 'F':
			keys = ['smaller', 'greater', 'title', 'description', 'after', 'before', 'tag'];
			if (!this.__oOptions.virtual) {
				keys.push('folders:all', 'folders:subtree');
			}
			break;
		case 'T':
			keys = ['title', 'description', 'after', 'before', 'tag'];
			break;
		case 'E':
			keys = ['title', 'description', 'after', 'before', 'location', 'is:free', 'is:busy', 'tag'];
			break;
		case 'I':
			switch(sSubType) {
				case 'members':
					keys = ['name', 'email'];
					break;
				default:
					keys = ['from', 'title', 'after', 'before'];
			}
	}

	keys.forEach(function (key) {
		var label;
		if (~key.indexOf(':')) {
			key = key.split(':');
			label = getLang('SEARCH::KEYWORD_' + key[0], [], 2);
			keywords[key[0]] = keywords[key[0]] || {
				type: this.__folderTypeKeywords[key[0]].type,
				hidden: this.__folderTypeKeywords[key[0]].hidden,
				unique: this.__folderTypeKeywords[key[0]].unique,
				values: {},
			}
			if (label) {
				keywords[key[0]].label = label;
			}
			keywords[key[0]].values[key[1]] = this.__folderTypeKeywords[key[0]].values[key[1]];
			label = getLang('SEARCH::VALUE_' + key[0] + '_' + key[1], [], 2);
			if (label) {
				keywords[key[0]].values[key[1]].label = label;
			}
		} else {
			keywords[key] = this.__folderTypeKeywords[key];
			label = getLang('SEARCH::KEYWORD_' + key, [], 2);
			if (label) {
				keywords[key].label = label;
			}
		}
	}, this);

	return keywords;
}

_me.__folderTypePlaceholders = {
	M: 'SEARCH::IN_EMAILS',
	C: 'SEARCH::IN_CONTACTS',
	N: 'SEARCH::IN_NOTES',
	F: 'SEARCH::IN_FILES',
	T: 'SEARCH::IN_TASKS',
	E: 'SEARCH::IN_CALENDARS',
	I: 'SEARCH::IN_TEAMCHAT'
};

_me.__getFolderTypePlaceholder = function (sFolderType) {
	if (~['J', 'W'].indexOf(sFolderType)) {
		sFolderType = 'E';
	}
	var room;
	if (sFolderType === 'I') {
		room = dataSet.get('folders', [this.__aFolder.aid, this.__aFolder.fid, 'NAME']) || this.__aFolder.fid.split('/').pop();
	}
	return getLang(this.__folderTypePlaceholders[sFolderType] || 'SEARCH::PLACEHOLDER', [room]);
};

_me.__getFolderTypeComponents = function (sFolderType, keywords) {
	var date = {
		class: 'date',
		label: getLang('SEARCH::DATE'),
		shortcuts: keywords.last && [
			{
				label: getLang('CALENDAR::TODAY'), callback: function () {
					this.search.addQuery('last:"1"');
				}.bind(this)
			},
			{
				label: getLang('CALENDAR::LAST_DAYS', [7]), callback: function () {
					this.search.addQuery('last:"7"');
				}.bind(this)
			},
			{
				label: getLang('CALENDAR::LAST_DAYS', [14]), callback: function () {
					this.search.addQuery('last:"14"');
				}.bind(this)
			},
		],
		fields: [
			keywords.after && {
				label: getLang('SEARCH::KEYWORD_AFTER'), keyword: 'after', onCreate: function () {
					// custom calendar?
				}
			},
			keywords.aftertime && {
				label: getLang('SEARCH::KEYWORD_AFTER'), keyword: 'aftertime', onCreate: function () {
					// custom calendar?
				}
			},
			keywords.before && {
				label: getLang('SEARCH::KEYWORD_BEFORE'), keyword: 'before', onCreate: function () {
					// custom calendar?
				}
			},
			keywords.beforetime && {
				label: getLang('SEARCH::KEYWORD_BEFORE'), keyword: 'beforetime', onCreate: function () {
					// custom calendar?
				}
			}
		].filter(Boolean)
	};

	var people = keywords.from && {
		label: getLang('SEARCH::PEOPLE'),
		class: 'people',
		keyword: keywords.with ? 'with' : 'from',
		keywords: ['with', 'from', 'to', 'cc', 'bcc'],
		callback: function (query, maxItems, callback) {
			var fid = (sFolderType === 'I' || sPrimaryAccountGUEST) ? '__@@GROUP@@__/' + this.__aFolder.fid : '__@@ADDRESSBOOK@@__';
			WMItems.list({
				aid: sPrimaryAccount,
				fid: fid,
				values: (sFolderType === 'I' || sPrimaryAccountGUEST) ? [] : ['ITMTITLE', 'ITMCLASS', 'ITMCLASSIFYAS', 'ITMFIRSTNAME', 'ITMMIDDLENAME', 'ITMSURNAME', 'ITMSUFFIX', 'LCTEMAIL1', 'LCTEMAIL2', 'LCTEMAIL3', 'LCTTYPE'],
				filter: {
					search: ((sFolderType === 'I' || sPrimaryAccountGUEST) ? '' : 'addressbook:') + '"' + query.replace(/"/g,'\\"') + '"',
					limit: maxItems * 2,
					nocount: 1,
					groupbyemail: GWOthers.getItem('MAIL_SETTINGS_GENERAL', 'GROUP_CONTACTS_BY_EMAIL') == '1',
					includesentfolderemails: GWOthers.getItem('MAIL_SETTINGS_DEFAULT', 'SUGGEST_SENT_FOLDER_EMAILS') == '1',
				}
			}, '', '', '', [function (response) {
				var result = [];

				response = response[sPrimaryAccount][fid];
				for (var i in response) {
					if (~i.indexOf('*') && response[i].ITMCLASS !== 'L') {
						var email = response[i].LCTEMAIL1 || response[i].FRTEMAIL;
						if (!email || !email.trim()) {
							continue;
						}
						result.push('"' + email + '"{"label":"' + (response[i].ITMCLASSIFYAS || response[i].FRTNAME || '').replace(/"/g, '\\"') + '","image":"' + obj_avatar.getAvatarURL(email, void 0, false).replace(/&no=\d+/, '') + '","hidden_keyword":"+with"}');

						if (result.length === maxItems) {
							break;
						}
					}
				}
				callback(result);
			}]);
		}.bind(this),
		timeout: 250,
		render: function (data) {
			var avatar = obj_avatar.getAvatarHTML({ email: data.value, name: data.meta.label || data.value, size: 32 });
			return `<div class="result">
				${avatar}
				<div>
					<div class="label">${(data.meta.label || '').escapeHTML()}</div>
					<div class="value">${(data.value || '').escapeHTML()}</div>
				</div>
			</div>`;
		},
		maxItems: 5,
	};

	var fields = [];
	Object.keys(keywords).forEach(function(keyword) {
		Object.keys((keywords[keyword] || {}).values || {}).forEach(function(value) {
			fields.push({ keyword: keyword, value: value });
		});
	});

	var tags = {
		class: 'tags',
		label: getLang('SEARCH::TAGS'),
		shortcuts: this.__getTags.bind(this),
		shortcutsFilter: function(shortcut, query) {
			return ~shortcut.value.toLowerCase().indexOf(query.toLowerCase());
		},
		maxShortcuts: 5,
		showAllShortcutsLabel: getLang('SEARCH::SHOW_ALL_SHORTCUTS_LABEL')
	};

	var searchIn = [];
	switch (sFolderType) {
		case 'A':
		case 'M':
		case 'Q':
			fields = [];
			if (sFolderType === 'M' && !dataSet.get('folders', [this.__aFolder.aid, this.__aFolder.fid, 'SPAM']) && !this.__oOptions.virtual) {
				fields.push({ keyword: 'folders', value: 'all' });
				fields.push({ keyword: 'folders', value: 'subtree' });
			}
			if (sFolderType === 'A' && !this.__oOptions.virtual) {
				fields.push({ keyword: 'folders', value: 'all' });
				fields.push({ keyword: 'folders', value: 'subtree' });
				fields.push({ keyword: 'is', value: 'genuine' });
			}
			searchIn = ['from', 'to', 'subject', 'body', 'cc', 'bcc'];

			fields.push({ keyword: 'has', value: 'attachment' });

			break;

		case 'QL':
			people = false;
			date = false;
			tags = false;
			fields = [];
			searchIn = false;
	}

	var size = (sFolderType === 'F') && {
		class: 'size',
		label: getLang('SEARCH::SIZE'),
		fields: [
			keywords.smaller && {
				label: getLang('SEARCH::KEYWORD_SMALLER_THAN') + ':', keyword: 'smaller'
			},
			keywords.greater && {
				label: getLang('SEARCH::KEYWORD_GREATER_THAN') + ':', keyword: 'greater'
			},
		].filter(Boolean)
	};

	return [
		people,
		{
			type: "recent",
			class: "recent",
			label: getLang('SEARCH::RECENT'),
			maxItems: 5,
		},
		{
			type: "keywords",
			class: "keywords",
			label: getLang('SEARCH::SEARCH_IN'),
			keywords: searchIn && (searchIn.length ? searchIn : Object.keys(keywords).map(function(key) {
				if (!keywords[key].type) {
					return key;
				}
			}).filter(Boolean)),
			fields: fields.map(function(field) {
				field.label = getLang('SEARCH::' + field.keyword + '_' + field.value);

				if (field.keyword === 'folders') {
					if (field.value === 'all') {
						var uid = Path.basedir(this.__aFolder.fid.replace('~', '')).split('/')[0];
						if (sFolderType === 'A') {
							field.label = getLang('SEARCH::' + field.keyword + '_' + field.value + '_archives');
						} else if (!this.__aFolder.fid.indexOf('~')) {
							field.label = getLang('SEARCH::' + field.keyword + '_' + field.value + '_of', [dataSet.get('accounts', [uid, 'USERNAME']) || uid]);
						} else if (dataSet.get('folders', [this.__aFolder.aid, uid, 'PUBLIC']) === 'true') {
							field.label = getLang('SEARCH::' + field.keyword + '_' + field.value + '_in', [uid]);
						}
					} else if (field.value === 'subtree') {
						field.label = getLang('SEARCH::FOLDERS_SUBFOLDERS', [WMFolders.getFolderPath(this.__aFolder)]);
					}
				}
				return field;
			}, this),
			maxItems: 10,
		},
		date,
		size,
		keywords.tag && tags
	].filter(Boolean);
};

_me.__getTags = function() {
	var allTags = dataSet.get('tags'),
		tags = [];
	for (var i in allTags) {
		tags.push(allTags[i]);
	}
	tags.sort(function(tag1, tag2) {
		return tag2.TAGCOUNT - tag1.TAGCOUNT;
	});
	return tags.map(function(tag) {
		return {
			id: tag.ID,
			value: tag.TAGNAME,
			label: tag.TAGNAME,
			class_name: 'tag',
			custom_style: tag.TAGCOLOR ? (tag.TAGCOLOR ? 'background-color:' + tag.TAGCOLOR + '; ' : '') + 'color:' + colors.fast_contrast(tag.TAGCOLOR) : '',
			callback: function () {
				this.search.addQuery('tag:"' + tag.TAGNAME + '"');
			}.bind(this)
		}
	}, this);
};