function obj_room_status() {}

obj_room_status._STATUSES = {
	TYPING: 1,
	COMMENTING: 2,
	ONLINE: 3,
	BACKGROUND: 4,
	OFFLINE: 5
};

obj_room_status._WIDTH = 36;
obj_room_status._HEIGHT = 52;
obj_room_status._MAX_AVATARS = 10;

obj_room_status.prototype.__constructor = async function () {

	this._folder = {};

	if (gui.socket) {
		this.__users = {};
		this.__list = [];

		gui.socket.api._obeyEvent('onStatusChange', [this, '__notify']);

		this.__more = mkElement('div', {className: "user more"})
		this._main.appendChild(this.__more);

		this._add_destructor('__notify_off');
	}

	gui._obeyEvent('resize', [this, '_removeOffline']);
};

obj_room_status.prototype.__getMaxNumberOfAvatars = function () {
	if (!(this._main || {}).parentNode) {
		return 0;
	}

	return Math.min(Math.floor(this._main.parentNode.clientWidth / obj_room_status._WIDTH), obj_room_status._MAX_AVATARS);
};

obj_room_status.prototype._setFolder = function (aFolder) {

	if (this._folder.fid && (this._folder.aid != aFolder.aid || this._folder.fid != aFolder.fid)){

		this.__removeOfflineTimeout && clearTimeout(this.__removeOfflineTimeout);

		//cleanup
		this.__users = {};
		this.__list = [];

		while (this._main.firstChild) {
			this._main.removeChild(this._main.firstChild);
		}
		this._main.appendChild(this.__more);
	}

	this._folder = aFolder;
};

obj_room_status.prototype.__notify = function (users) {
	if (this._destructed)
		return false;

	if (!this._folder.fid)
		return;

	var folder = dataSet.get('folders', [this._folder.aid, this._folder.fid]);
	if (users && users[0] && users[0].FOLDER !== Path.backslash(folder.RELATIVE_PATH))
		return;

	users.forEach(function (user) {
		if (user.STATUSEMAIL === sPrimaryAccount || user.STATUSEMAIL === dataSet.get('main', ['user'])) {
			return;
		}

		var email = user.STATUSEMAIL,
			device = user.DEVICEID,
			status = +user.STATUSID || 5;

		if (status === obj_room_status._STATUSES.OFFLINE) {
			this._removeUser(email, device);
		} else {
			this._addUser(email, device, status);
		}
	}, this);

	this._reOrder();
	this._removeOffline();
};

obj_room_status.prototype.__notify_off = function(){
	if (gui.socket)
		gui.socket.api._disobeyEvent('onStatusChange', [this, '__notify']);
};

obj_room_status.prototype._reOrder = function () {
	setTimeout(function () {
		var i = 0;
		this.__list = this.__list.filter(function(item) {
			return item.dom;
		});
		this.__list.slice(0, this.__getMaxNumberOfAvatars()).forEach(function (item) {
			var is_offline = true;
			for (var j in item.statuses) {
				if (item.statuses[j] !== obj_room_status._STATUSES.OFFLINE) {
					is_offline = false;
					break;
				}
			}
			if (!is_offline) {
				item.dom.style.transform = "translateX(" + (gui._rtl ? -i : i) * obj_room_status._WIDTH + "px) translateY(" + obj_room_status._HEIGHT + "px)";
				i++;
				item.dom.style.opacity = 1;
			} else {
				item.dom.style.opacity = 0;
			}
		});
		var min = Math.min(this.__list.length, this.__getMaxNumberOfAvatars());
		this.__list.slice(this.__getMaxNumberOfAvatars()).forEach(function (item) {
			item.dom.style.opacity = 0;
			item.dom.style.transform = "translateX(" + min * obj_room_status._WIDTH + "px) translateY(" + obj_room_status._HEIGHT + "px)";
		});
	}.bind(this), 5);
};
obj_room_status.prototype._removeOffline = function () {
	this.__removeOfflineTimeout && clearTimeout(this.__removeOfflineTimeout);
	this.__removeOfflineTimeout = setTimeout(function () {
		this.__list.filter(function (item) {
			var is_offline = true;
			for(var i in item.statuses) {
				if (item.statuses[i] !== obj_room_status._STATUSES.OFFLINE) {
					is_offline = false;
					break;
				}
			}
			return is_offline;
		}).forEach(function (item) {
			if (item.dom) {
				item.dom.parentElement.removeChild(item.dom);
				delete this.__users[item.email];
				var index = this.__list.indexOf(item);
				~index && this.__list.splice(index, 1);
			}
		}, this);

		this._moreUsers();
	}.bind(this), 500);
};
obj_room_status.prototype._getIndex = function (status) {
	if (!this.__list.length) {
		return 0;
	}
	for (var i = 0; i < this.__list.length; i++) {
		var global_status = obj_room_status._STATUSES.OFFLINE;
		for(var j in this.__list[i].statuses) {
			global_status = Math.min(global_status, this.__list[i].statuses[j]);
		}
		if (global_status >= status) {
			return i;
		}
	}
	return this.__list.length;
};
obj_room_status.prototype._moreUsers = function () {
	if (this.__list.length > this.__getMaxNumberOfAvatars()) {
		var amount = Math.min(this.__list.length, this.__getMaxNumberOfAvatars() - 1);
		this.__more.textContent = '+' + (this.__list.length - amount);
		this.__more.style.transform = "translateX(" + amount * obj_room_status._WIDTH + "px) translateY(" + obj_room_status._HEIGHT + "px)";
		this.__more.style.opacity = 1;
		this.__more.setAttribute('title', this.__list.slice(amount).map(function(user) { return user.email }).join("\n"));
	} else {
		this.__more.style.opacity = 0;
	}
};

obj_room_status.prototype._moveUser = function (email, status) {
	var index = this.__list.indexOf(this.__users[email]);
	~index && this.__list.splice(index, 1);
	index = this._getIndex(status);
	this.__list.splice(index, 0, this.__users[email]);
};

obj_room_status.prototype._addUser = function (email, device, status) {
	this.__users[email] = this.__users[email] || {
		email: email,
		statuses: {}
	};
	if (!this.__users[email].dom) {
		this.__users[email].dom = this._createUser(email);
		this._main.appendChild(this.__users[email].dom);
	}

	if (this.__users[email].statuses[device] !== status) {
		this.__users[email].dom.classList[status === obj_room_status._STATUSES.TYPING ? 'add' : 'remove']('typing');
		this._moveUser(email, status);
	}

	this.__users[email].statuses[device] = status;
};
obj_room_status.prototype._removeUser = function (email, device) {
	this.__users[email] = this.__users[email] || { email: email, statuses: {} };
	this.__users[email].statuses[device] = obj_room_status._STATUSES.OFFLINE;
	var index = this.__list.indexOf(this.__users[email]);
	~index && this.__list.splice(index, 1);
	
	var status = obj_room_status._STATUSES.OFFLINE;
	for(var i in this.__users[email].statuses) {
		status = Math.min(status, this.__users[email].statuses[i]);
	}
	index = this._getIndex(status);
	this.__list.splice(index, 0, this.__users[email]);
};
obj_room_status.prototype._createSpinner = function () {
	var spinner = mkElement('div', {class: "spinner"});
	for (var i = 1; i <= 3; i++) {
		spinner.appendChild(mkElement('div', {class: "bounce" + i}));
	}
	return spinner;
};

obj_room_status.prototype._createUser = function (user_email) {
	var div = mkElement('div', {class: "user", title: user_email});
	div.appendChild(obj_avatar.getAvatarElement({
		email: user_email,
		name: dataSet.get('xmpp', ['roster', user_email, 'name']) || user_email,
		size: 32
	}));
	div.appendChild(this._createSpinner());
	return div;
};