function obj_resizer() { };
_me = obj_resizer.prototype;
obj_resizer.cache = {};

_me.__constructor = async function (oOptions) {
	this.__options = Object.assign({
		x: void 0,
		offsetX: 0,
		minWidth: 0,
		maxWidth: void 0,
		y: void 0,
		offsetY: 0,
		minHeight: 0,
		maxHeight: void 0,
		cacheId: void 0,
		onresize: function () { }
	}, oOptions);

	this._main.ondragstart = function () {
		return false;
	};

	this._main.onmousedown = function (e) {
		e.preventDefault();
		e.stopPropagation();

		this._main.classList.add('active');

		gui._obeyEvent('mousemove', [this, '__resize']);
		gui._obeyEvent('mouseup', [this, '__mouseup']);
	}.bind(this);

	var iframe = mkElement('iframe', {
		className: 'resizer_frame'
	});
	this._main.parentElement.appendChild(iframe);

	iframe.contentWindow.onresize = function () {
		this.__resize();
	}.bind(this);

	if (this.__options.cacheId) {
		var cache = obj_resizer.cache[this.__options.cacheId] = obj_resizer.cache[this.__options.cacheId] || {
			x: this.__options.x,
			y: this.__options.y
		};
		this.__options.x = cache.x;
		this.__options.y = cache.y;
	}

	if (this.__options.x !== void 0) {
		this._main.classList.add('x');
	} else if (this.__options.y !== void 0) {
		this._main.classList.add('y');
	}

	this.__resize();
};

_me.__resize = function (e) {
	var parentbcr = this._main.parentElement.getBoundingClientRect();

	this.__options.width = this.__options.width || this._main.clientWidth;
	this.__options.height = this.__options.height || this._main.clientHeight;

	e = e || {
		clientX: parentbcr.left + this.__options.x + this.__options.offsetX + this.__options.width / 2,
		clientY: parentbcr.top + this.__options.y + this.__options.offsetY + this.__options.height / 2
	};

	var x;
	if (this.__options.x !== void 0) {
		x = e.clientX - parentbcr.left;
		if (gui._rtl) {
			if (x > parentbcr.width - this.__options.minWidth - this.__options.offsetX) {
				x = parentbcr.width - this.__options.minWidth - this.__options.offsetX;
			} else if (this.__options.maxWidth && x > this.__options.maxWidth) {
				x = this.__options.maxWidth;
			} else if (x < 0) {
				x = 0;
			}
			x = parentbcr.width - x;
		} else {
			if (x < this.__options.minWidth + this.__options.offsetX) {
				x = this.__options.minWidth + this.__options.offsetX;
			} else if (this.__options.maxWidth && x > this.__options.maxWidth) {
				x = this.__options.maxWidth;
			} else if (x > parentbcr.width) {
				x = parentbcr.width;
			}
		}
		this._main.style[gui._rtl ? 'right' : 'left'] = x - this.__options.width / 2 + 'px';
		x = x - this.__options.offsetX;
		obj_resizer.cache[this.__options.cacheId].x = this.__options.x = x - this.__options.width / 2;
	}

	var y;
	if (this.__options.y !== void 0) {
		y = e.clientY - parentbcr.top;
		if (y < this.__options.minHeight + this.__options.offsetY) {
			y = this.__options.minHeight + this.__options.offsetY;
		} else if (this.__options.maxHeight && y > this.__options.maxHeight) {
			x = this.__options.maxHeight;
		} else if (y > parentbcr.height) {
			y = parentbcr.height;
		}
		this._main.style.top = y - this.__options.height / 2 + 'px';
		y = y - this.__options.offsetY;
		obj_resizer.cache[this.__options.cacheId].y = this.__options.y = y - this.__options.height / 2;
	}

	this.__options.onresize(x, y, e);
};

_me.__mouseup = function () {
	this._main.classList.remove('active');

	gui._disobeyEvent('mousemove', [this, '__resize']);
	gui._disobeyEvent('mouseup', [this, '__mouseup']);
};
