function obj_rdock_upload_detail(){};
obj_rdock_upload_detail.prototype = {
	__constructor: async function(){
		this._title('UPLOAD_DETAIL::TITLE');

		this._getAnchor('back').addEventListener('click', function() {
			this.__path = null;
			gui.frm_main.rslide._value('upload');
		}.bind(this), false);

		await this._create('download', 'obj_button', 'header_info', 'ico transparent download');
		this.download.__eIN.setAttribute('tabIndex', -1);
		await this._create('settings', 'obj_button', 'header_info', 'ico transparent settings');
		this.settings.__eIN.setAttribute('tabIndex', -1);

		
		gui._obeyEvent('changedId', [this, '__changedIdHandler'])
		this._add_destructor('__destructor');
	},

	_init: function(aData){
		this.__destructTimer && clearTimeout(this.__destructTimer);

		this.__path = {aid: sPrimaryAccount, fid: Path.slash(aData.fid), iid: aData.iid};
		Cookie.set(['rdock_upload_detail'], this.__path);

		//Refresh only new for item
		if (!this.detail || !this.detail.__aData || this.detail.__aData.fid !== this.__path.fid || this.detail.__aData.iid !== this.__path.iid){

			WMItems.list(this.__path, '', '', '', [function(aData) {
				if ((aData = (aData || {})[this.__path.aid]) && (aData = aData[this.__path.fid]) && (aData = aData[WMItems.__clientID(this.__path.iid)])) {
					if (!aData || !aData.EVNURL) {
						this.__path = null;
						return gui.frm_main.rslide._value('upload');
					}
					//Title
					this._getAnchor('header_title').textContent = aData.EVNTITLE;
					this._getAnchor('header2').textContent = parseFileSize(aData.EVNCOMPLETE);

					//Body
					TeamChatAPI.getSmartLinkData({ smarts: aData.EVNURL.split('/').pop() }, {
						success: function(response) {
							aData.smartLinkData = response;
							this._create('detail', 'frm_upload_detail', 'body', '', aData);
						},
						error: function() {
							this.__path = null;
							gui.frm_main.rslide._value('upload');
						},
						context: this
					});

					this.download._onclick = function() {
						downloadItem(buildURL({dlsess: dataSet.get('main', ['dlsess']), class: 'attachment', fullpath: sPrimaryAccount + '/' + (aData.EVNFOLDER || this.__path.fid) + '/' + aData.EVN_ID + '/' + aData.EVNLOCATION}));
					}.bind(this);

					this.settings._onclick = function() {
						Item.collaborate([this.__path.aid, aData.EVNFOLDER || this.__path.fid, aData.EVN_ID]);
					}.bind(this);
				}
			}.bind(this)]);
		}
	},

	// tab methods
	_onactive: function(){
		this.__destructTimer && clearTimeout(this.__destructTimer);

		if (!this.detail){
			var aPath = Cookie.get(['rdock_upload_detail']);
			if (Is.Object(aPath) && (!this.__path || (aPath.aid !== this.__path.aid || aPath.fid !== this.__path.fid || aPath.iid !== this.__path.iid))) {
				this._init(aPath);
			}
		}
	},

	//Autodestruct detail after 10s
	_ondeactive: function(){
		this.__destructTimer = setTimeout(function(){
			if (this.detail && !this.detail._destructed)
				this.detail._destruct();
		}.bind(this), 100);
	},

	__changedIdHandler: function(data) {
		if (!this.__path || (WMItems.__clientID(this.__path.iid) !== WMItems.__clientID(data.oldId))) {
			return;
		}
		this.__path = null;
		gui.frm_main.rslide._value('upload');
	},

	__destructor: function() {
		gui._disobeyEvent('changedId', [this, '__changedIdHandler'])
	}
};