function obj_rdock_upload() {};
obj_rdock_upload.prototype = {
	__constructor: async function () {
		this.__isActive = false;
		this.__uploading = false;

		// search
		await this._create('inp_search','obj_input_search','header3', 'obj_input_100 obj_rdock-search');
		this.inp_search._placeholder(getLang('UPLOAD::FIND_PH'));
		this.inp_search._onclose = function(){
			this._value('');
			this._parent.upload._search('');
		};
		this.inp_search.__lastValue = '';
		this.inp_search._onsubmit = function(){
			var sValue = this._value();
			if (this.__lastValue !== sValue) {
					this.__lastValue = sValue;
				this._parent.upload._search(sValue);
			}
		};
		this.inp_search.__eIN.setAttribute('tabindex', -1);

		this._title('MAIN_MENU::UPLOAD_CENTER');

		await this._create('upload', 'obj_upload_center', 'body');
		this.upload._serverSort({
			aid: sPrimaryAccount,
			fid: '__@@MYUPLOAD@@__'
		});

		this.upload._oncount = function(i){
			if ((this.upload.__aRequestData.filter || {}).search) {
				this._getAnchor('splash-label').innerHTML = '<h3>' + getLang('UPLOAD::SPLASH_HEADER_SEARCH') + '</h3>';
			} else {
				this._getAnchor('splash-label').innerHTML = '<h3>' + getLang('UPLOAD::SPLASH_HEADER') + '</h3>';
			}
		
			if (!i)
				addcss(this._main, 'splash');
			else
				removecss(this._main, 'splash');
		}.bind(this);

		gui._obeyEvent('onuploadstart', [this, '_onUploadStart']);
		gui._obeyEvent('onuploadprogress', [this, '_onUploadProgress']);
		gui._obeyEvent('onuploadend', [this, '_onUploadEnd']);
		gui._obeyEvent('onuploadaborted', [this, '_onUploadAborted']);
		gui._obeyEvent('changedId', [this, '__changedIdHandler']);
	},

	__uploadInstances: new Map(),
	_onUploadStart: function(data) {
		console.log('start', data);
		if (data.restore) {
			return;
		}

		var uploadInstance = this.__uploadInstances.get(data.owner);
		if (!uploadInstance) {
			uploadInstance = {
				files: new Map(),
				notification: void 0,
				lastUploadProgress: 0,
				filesUploaded: 0
			};
			this.__uploadInstances.set(data.owner, uploadInstance);
		}
		data.files.forEach(file => {
			uploadInstance.files.set(file, 0);
		});

		if (!this.__isActive) {
			uploadInstance.notification = gui.notifier._value({
				type: 'upload_status',
				args: {
					files: uploadInstance.files,
					text_plain: ' ',
					callback: {
						onclose: function() {
							delete uploadInstance.notification;
						}
					},
					buttons: [{
						text: getLang('FORM_BUTTONS::CLOSE'),
						onclick: function() {
							uploadInstance.notification.close();
							delete uploadInstance.notification;
						}
					}, {
						text: getLang('UPLOAD::ABORT'),
						className: 'decline',
						onclick: function() {
							uploadInstance.files.forEach((completed, file) => {
								file.aborted = true;
							});
							uploadInstance.files.forEach((completed, file) => {
								file._abort && file._abort();
							});
							uploadInstance.notification.close();
							delete uploadInstance.notification;
						}
					}],
					onclick: function() {
						uploadInstance.notification.close();
						delete uploadInstance.notification;
						gui.frm_main.rslide._value('upload', true);
					}
				},
				browserOnly: true
			}, uploadInstance.notification);
		}
		
		this.__updateUploadProgress(data.owner);

		gui.frm_main.stat._unread('upload', !this.__isActive);
		gui.frm_main.stat._unread('upload', true, 'uploading');
	},
	_onUploadProgress: function(data) {
		console.log('progress', data);
		var uploadInstance = this.__uploadInstances.get(data.owner);
		if (!uploadInstance) {
			return;
		}
		if (uploadInstance.files.has(data.file)) {
			data.file.startTime = data.file.startTime || +new Date();
			uploadInstance.files.set(data.file, data.completed > data.size ? data.size : data.completed);
			if (data.completed >= data.size && !data.file.counted) {
				uploadInstance.filesUploaded++;
				data.file.counted = true;
			}
		}

		var allUploaded = true;
		var firstFile;
		uploadInstance.files.forEach(function(completed, file) {
			firstFile = firstFile || file;
			if (completed < file.size) {
				allUploaded = false;
			}
		});
		if (allUploaded) {
			if (uploadInstance.notification) {
				var el = uploadInstance.notification.element;
				el.classList.add('processing');
				el.querySelector('.header').textContent = getLang('NOTIFICATION::UPLOAD_PROCESSING::' + uploadInstance.filesUploaded)
				el.querySelector('.text').textContent = getLang('NOTIFICATION::FILES_UPLOADED::' + uploadInstance.filesUploaded, [uploadInstance.filesUploaded > 1 ? uploadInstance.filesUploaded : firstFile.name]);
			}
			gui.frm_main.stat._unread('upload', false);
			gui.frm_main.stat._unread('upload', false, 'uploading');
		} else {
			this.__updateUploadProgress(data.owner);
		}
	},
	_onUploadAborted: function(data) {
		console.log('abort', data);
		var uploadInstance = this.__uploadInstances.get(data.owner);
		if (uploadInstance && uploadInstance.files.delete(data.file)) {
			this.__updateUploadProgress(data.owner, true);
		}
	},
	_onUploadEnd: function(data) {
		console.log('end', data);
		if (data.restore) {
			return;
		}

		var uploadInstance = this.__uploadInstances.get(data.owner);
		if (!uploadInstance) {
			return;
		}

		var toDelete = 0;
		var firstFile;
		data.files.forEach(function(file) {
			if (uploadInstance.files.delete(file)) {
				firstFile = firstFile || file;
				toDelete++;
			}
		})

		if (!uploadInstance.files.size) {
			if (uploadInstance.filesUploaded) {
				var uploaded = uploadInstance.filesUploaded;
				uploadInstance.filesUploaded -= toDelete;
				this.__updateUploadProgress(data.owner);
				if (!firstFile) {
					if (uploadInstance.notification) {
						uploadInstance.notification.close();
						delete uploadInstance.notification;
					}
				} else {
					uploadInstance.notification = gui.notifier._value({
						type: 'success',
						timeout: 2,
						args: {
							header: 'NOTIFICATION::UPLOAD_SUCCESSFUL',
							text_plain: getLang('NOTIFICATION::FILES_UPLOADED::' + uploaded, [uploaded > 1 ? uploaded : firstFile.name]),
							subtext: 'upload::show_details',
							className: 'upload_status',
							callback: {
								onclose: function() {
									delete uploadInstance.notification;
								}
							},
							onclick: function() {
								uploadInstance.notification.close();
								delete uploadInstance.notification;
								gui.frm_main.rslide._value('upload', true);
							}
						}
					}, uploadInstance.notification);
				}
			} else if (uploadInstance.notification) {
				uploadInstance.notification.close();
				delete uploadInstance.notification;
			}
			return;
		}
		this.__updateUploadProgress(data.owner, true);
	},
	_onactive: function () {
		this.__isActive = true;
		this.upload._updateTimes();
		gui.frm_main.stat._unread('upload', false);
		this.__uploadInstances.forEach(function(instance) {
			instance.notification && instance.notification.close();
			delete instance.notification;
		});
	},
	_ondeactive: function () {
		this.__isActive = false;
		gui.frm_main.stat._unread('upload', false);
		this.__uploadInstances.forEach(function(instance) {
			if (instance.files.size) {
				gui.frm_main.stat._unread('upload', true);
			}
		});
	},

	__changedIdHandler: async function(data) {
		if (this.upload.__aData[WMItems.__clientID(data.oldId)]) {
			await this.upload._clear();
			this.upload._serverSort({
				aid: sPrimaryAccount,
				fid: '__@@MYUPLOAD@@__'
			});
		}
	},
	__updateUploadProgress: function(owner, force) {
		var uploadInstance = this.__uploadInstances.get(owner);

		if (!force && ((+new Date() - uploadInstance.lastUploadProgress) < 500)) {
			return;
		}
		uploadInstance.lastUploadProgress = +new Date();
		var uploaded = 0;
		var uploadedInstance = 0;
		var total = 0;
		var totalInstance = 0;
		var startTime = +new Date();
		var uploading = false;
		this.__uploadInstances.forEach((instance) => {
			instance.files.forEach((completed, file) => {
				if (instance === uploadInstance) {
					if (file.startTime < startTime) {
						startTime = file.startTime;
					}
					totalInstance += file.size;
					uploadedInstance += completed;
				}
				total += file.size;
				uploaded += completed;
			});
			uploading = uploading || instance.files.size;
		});
		var percent = Math.min(Math.ceil(100 / total * uploaded), 100) || 0;
		var percentInstance = Math.min(Math.ceil(100 / totalInstance * uploadedInstance), 100) || 0;

		gui.frm_main.stat._unread('upload', percent && uploading);
		gui.frm_main.stat._unread('upload', percent && uploading, 'uploading');

		if (uploadInstance.notification) {
			var diff = +new Date() - startTime;
			var estimate = Math.floor(diff / percentInstance / 1000 * (100 - percentInstance));
			if (estimate < 60) {
				estimate = getLang('conference::seconds', [estimate]);
			} else if (estimate < 3600) {
				estimate = getLang('conference::minutes', [Math.floor(estimate / 60)]);
			} else {
				estimate = getLang('conference::hours', [Math.floor(estimate / 3600)]);
			}

			uploadInstance.notification.element.querySelector('.header').textContent = gui.notifier.__getNotificationHeader('upload_status', {
				files: uploadInstance.files
			});
			uploadInstance.notification.element.querySelector('.text').textContent = gui.notifier.__getNotificationText('upload_status', {
				text_plain: parseFileSize(uploaded) + ' / ' + parseFileSize(total) + (uploaded ? ' (' + getLang('upload::time_left', [estimate]) + ')' : '')
			});
			var icon = uploadInstance.notification.element.querySelector('.icon');
			if (!uploadInstance.notification.percent) {
				uploadInstance.notification.percent = icon.appendChild(mkElement('div', {
					className: 'percent'
				}));
			}
			uploadInstance.notification.percent.textContent = percentInstance + '%';
			uploadInstance.notification.element.querySelector('.circular-progress').style.setProperty('--progress', percentInstance);
		}
		
		var button = gui.frm_main.stat._main.querySelector('li.ico2.img.ico-upload');
		button.style.setProperty('--progress', percent);
		button.querySelector('span span').setAttribute('data-progress', percent + '%');
		return percent;
	}
};