function obj_rdock_thread(){};
obj_rdock_thread.prototype = {
	__constructor: async function(aOptions){
		this._title('CHAT::THREAD');

		this.__aOptions = Object.assign({
			autofocus: true
		}, aOptions || {});

		//placeholder
		this._getAnchor('splash-label').innerHTML = '<h3>' + getLang('THREAD::SPLASH_HEADER') + '</h3><p>'+ getLang('THREAD::SPLASH_TEXT')+'</p>';

		this._getAnchor('back').addEventListener('click', function() {
			this.__path = null;
			gui.frm_main.rslide._value('threads');
		}.bind(this), false);
		this._getAnchor('header_title').addEventListener('click', function() {
			this.__path = null;
			gui.frm_main.rslide._value('threads');
		}.bind(this), false);
	},

	_init: function(aData){
		this.__aData = aData;
		aData.iid = Array.isArray(aData.iid) ? aData.iid[0] : aData.iid

		this.__destructTimer && clearTimeout(this.__destructTimer);

		this.__path = {aid:aData.aid, fid:aData.fid};

		if (aData.EVNCOMEVNID)
			this.__path.iid = WMItems.__clientID(aData.EVNCOMEVNID);
		else
			this.__path.iid = aData.iid;

		if (WMFolders.getType(this.__path) == 'I'){

			//Set Last comment id
			if (aData.useCookie !== false) {
				Cookie.set(['teamchat','comment'], {fid:this.__path.fid,iid:this.__path.iid});
			}

			//Refresh only new for item
			if (!this.thread || !this.thread.__aData || this.thread.__aData.fid != this.__path.fid || this.thread.__aData.iid != aData.iid){

				//Title
				var sRoomName = WMFolders.getFolderName(this.__path),
					eTitle = this._getAnchor('header2');

				 	eTitle.textContent = sRoomName;
				 	//eTitle.setAttribute('title', sRoomName);
				 	eTitle.onclick = function(){
						gui.frm_main.filter.__filter('I', false, true);
				 		gui.frm_main._selectView({aid:this.__path.aid, fid:this.__path.fid});
				 	}.bind(this);

				//Body
				this._create('thread', 'frm_comment', 'body', '', aData, [this, '__event'], {
					uploadInstanceId: this.__aOptions.uploadInstanceId,
					autofocus: this.__aOptions.autofocus
				});
			}
		}
		else if (aData.useCookie !== false) {
			Cookie.set(['teamchat','comment']);
			this.__path = {};
		}
	},

	_follow:function(b){
		this.__followed = !!+b;

		var eFollow = this._getAnchor('header_info');
			eFollow.innerHTML = '<span>' + getLang(this.__followed?'CHAT::UNFOLLOW':'CHAT::FOLLOW_THREAD') + '</span>';

		if (!eFollow.onclick)
			eFollow.onclick = function(e){
				var lastReply,
					lastAnchor = +this.thread.list._main.lastChild.id.replace(this._pathName, '');
				for (var i in this.thread.list.__aData) {
					if (this.thread.list.__aData[i].anchor === lastAnchor) {
						lastReply = this.thread.list.__aData[i].data;
					}
				}
				if (e.target.tagName == 'SPAN' && lastReply)
					var threads = gui.frm_main.rslide.threads.list;
					if (threads) {
						threads.__lastReplies[this.__path.iid[0]] = lastReply;
					}
					WMChat.follow(this.__path, !this.__followed, [function(bOK, sAction){
						if (bOK){
							this.__aData.ISFOLLOWED = +!+this.__aData.ISFOLLOWED;
							this.__followed = sAction == 'follow';
							if (threads) {
								if (this.__followed) {
									threads._add_message({aid: this.__path.aid, fid: this.__path.fid, iid: this.__path.iid[0]}, {
										REPLY: lastReply
									});
								} else {
									if (threads.__aData[this.__path.iid[0]])
										threads._remove(threads.__aData[this.__path.iid[0]].anchor, this.__path.iid[0]);
								}
							}
							eFollow.innerHTML = '<span>' + getLang(this.__followed?'CHAT::UNFOLLOW':'CHAT::FOLLOW_THREAD') + '</span>';
						}
					}.bind(this)]);
			}.bind(this);
	},

	__event:function(evn){
		if (this._destructed) {
			return;
		}
		switch(evn.action){
			case 'load':
				removecss(this._main, 'splash');

				//Follow, init value
				this._follow(evn.data.ISFOLLOWED);

				break;

			case 'delete':
				addcss(this._main, 'splash');
				Cookie.set(['teamchat','comment']);
				break;

			//Follow event
			case 'follow':
				this._follow(1);
				break;
			case 'unfollow':
				this._follow(0);
		}
	},

	// tab methods //
	_onactive:function(){
		this.__destructTimer && clearTimeout(this.__destructTimer);
		this.__destructTimer2 && clearTimeout(this.__destructTimer2);

		if (!this.thread){
			var aPath = Cookie.get(['teamchat','comment']);
			if (Is.Object(aPath)){
				this._init(Object.assign({aid:sPrimaryAccount}, aPath));
				return;
			}

			addcss(this._main, 'splash');
		}
		this.thread && this.thread.text && this.thread.text._focus();
	},

	//Autodestruct thread after 10s
	_ondeactive: function() {
		this.__destructTimer = setTimeout(function(){
			if (this.thread && !this.thread._destructed)
				this.thread._destruct();
		}.bind(this), 100);

		this.__destructTimer2 = setTimeout(function(){
			this.__path = null;
		}.bind(this), 10000);
	}
};