function obj_rdock_settings(){};

/*
	States for SIP, phone and conference can be monitored by:
		dataSet.get('sip',['state'])	=	(string)	offline | online
		dataSet.get('sip',['activity'])	=	(string)	Calling | Phoning | Ringing | Joining | Conference
			Returns empty string when there is no activity.
*/

obj_rdock_settings.prototype = {
	__constructor: async function(){
		await this._fill();

		gui._obeyEvent('settings_changed', [this, '_layout']);
		gui._obeyEvent('viewSelected', [this, '_layout']);
		gui._obeyEvent('viewSelected', [this, '_compact']);
		gui._obeyEvent('folderSelected', [this, '_compact']);
		gui._obeyEvent('refreshAvatar',[this, '__avatar']);

		gui._obeyEvent('storage', [function(e, arg){
			if (e && e.type == 'set' && Is.Array(arg)){

				if (~arg.indexOf("LAYOUT_SETTINGS")) {
					this.night_mode && this.night_mode._value(GWOthers.getItem('LAYOUT_SETTINGS', 'night_mode'), true);
					this.night_mode_mailview && this.night_mode_mailview._value(GWOthers.getItem('LAYOUT_SETTINGS', 'night_mode_mailview'), true);
					this.compact && this.compact._value(GWOthers.getItem('LAYOUT_SETTINGS', 'compact_view') != 0, true);
				}

				if (~arg.indexOf("AUTORESPONDER"))
					this.__responder();

				if (~arg.indexOf("FORWARDER"))
					this.__forwarder();

				if (~arg.indexOf("VERIFICATION"))
					this._fill();

			}
		}.bind(this)]);

		gui._obeyEvent('chatgptChanged', [function() {
			this._initialPage();
		}.bind(this)]);

		gui._obeyEvent('dashboardLoaded', [function() {
			this._fill();
		}.bind(this)]);

		this._main.onclick = function(e){
			var rel = e.target.getAttribute('rel');

			if (rel && rel.indexOf('set-') === 0){
				this._handleClick(rel);
			}
		}.bind(this);

		this._add_destructor('__destructor');
	},

	__destructor:function() {
		gui._disobeyEvent('settings_changed', [this, '_layout']);
		gui._disobeyEvent('viewSelected', [this, '_layout']);
		gui._disobeyEvent('viewSelected', [this, '_compact']);
		gui._disobeyEvent('folderSelected', [this, '_compact']);
	},

	_fill: async function(){
		var sFullName = dataSet.get('main',['fullname']);
		if (!sFullName){
			sFullName = sPrimaryAccount.split('@').shift();
			sFullName = sFullName.slice(0,1).toUpperCase() + sFullName.slice(1);
		}

		try {
			this.__deviceCount = (await WMItems.list({aid: sPrimaryAccount, fid: '__@@DEVICES@@__'}))[sPrimaryAccount]['__@@DEVICES@@__']['/'];
		} catch (e) {
			this.__deviceCount = 0;
		}

		var aData = {
			user:{
				fullname: sFullName,
				email: dataSet.get('main', ['user'])
			},
			responder:GWOthers.getItem('RESTRICTIONS', 'disable_autoresponder') != '1',
			forwarder:GWOthers.getItem('RESTRICTIONS', 'disable_forwarder') != '1',
			security:sPrimaryAccount2F && !sPrimaryAccount2FE,
			guest:sPrimaryAccountGUEST,
			sip: !sPrimaryAccountGUEST && window.sPrimaryAccountSIP && (GWOthers.getItem('RESTRICTIONS', 'disable_sip') || 0)<1,
			quota: dataSet.get('accounts',[sPrimaryAccount,'MBOX_QUOTA']),
			night_mode: GWOthers.getItemAccess('LAYOUT_SETTINGS', 'night_mode'),
			device_count: this.__deviceCount,
			dashboard_enabled: gui.frm_main._dashboardLoaded(),
			login_interface_color: GWOthers.getItemAccess('LAYOUT_SETTINGS', 'login_interface_color'),
			activesync: sPrimaryAccountACTIVESYNC,
		};

		if (!sPrimaryAccountGUEST)
			switch (sPrimaryAccountType) {
				case 'admin':
					aData.admin_settings = true;
					break;
				case 'domainadmin':
					aData.domain_settings = true;
					break;
			}

		await this._clean();
		await this._draw('obj_rdock_settings', 'main', aData);

		this._getAnchor('btn_close').onclick = function(){
			this._value(false);
		}.bind(this._parent);

		this.__avatar();
		await this._create('scrollbar', 'obj_scrollbar');
		this.scrollbar._scrollbar(this._getAnchor('body'), this._getAnchor('scroller'), null, false, true);

		//night mode
		if (this.night_mode) {
			var nightModeValues = {
				'0': 'THEME::LIGHT',
				'1': 'THEME::DARK',
				
			};
			if (window.matchMedia && window.matchMedia('(prefers-color-scheme)').matches) {
				nightModeValues['2'] = 'THEME::AUTO';
			}
			await this.night_mode._fill(nightModeValues);
			this.night_mode._value(GWOthers.getItem('LAYOUT_SETTINGS', 'night_mode'));
			this.night_mode._onchange = function() {
				var night_mode_enabled = this._value() === '2' ? window.matchMedia('(prefers-color-scheme: dark)').matches : !!+this._value();
				
				if (night_mode_enabled) {
					NightMode().activate();
				} else {
					NightMode().reset();
				}
				dataSet.add('main', ['night_mode_enabled'], night_mode_enabled);

				GWOthers.setItem('LAYOUT_SETTINGS', 'night_mode', this._value());
				this._parent.__saveSettings();
			};
		}

		if (this.night_mode_mailview) {
			this.night_mode_mailview._checked(GWOthers.getItem('LAYOUT_SETTINGS', 'night_mode_mailview') == 1);
			this.night_mode_mailview._onchange = function() {
				GWOthers.setItem('LAYOUT_SETTINGS', 'night_mode_mailview', +me.night_mode_mailview._checked());
				this._parent.__saveSettings();
			}
		}

		if (!sPrimaryAccountGUEST){
			aData.responder && this.__responder();
			aData.forwarder && this.__forwarder();
			aData.security && this.__security();
		}

		this._layout();
		this._compact();

		// SIP
		this.__eSip = this._getAnchor('sip');
		var me = this;
		if (aData.sip && this.__eSip){
			this.__eSip.oncontextmenu = async function (e){
				if (GWOthers.getItem('SIP','mode')=='integrate' && !gui.sipalert){

					var s = dataSet.get('sip',['state']),
						aMenu = [
							{title:'STATUS::ONLINE', css:'ico ico2 sip online'+ (s == 'offline'?'':' check'), arg:[me,'__sip',['online']]},
							{title:'STATUS::OFFLINE', css:'ico ico2 sip offline'+ (s == 'offline'?' check':''), arg:[me,'__sip',['offline']]}
						];

					var	pos = getSize(this);
					me.cmenu = await gui._create('cmenu','obj_context','','sip');
					await me.cmenu._fill(aMenu);
					me.cmenu._place(pos.x, pos.y+(pos.h/2), 170);

					//active class
					me.cmenu.__deactive = function(){removecss(this,'active')}.bind(this);
					me.cmenu._add_destructor('__deactive');
					addcss(this, 'active');

					e.stopPropagation();
					e.preventDefault();
				}
			};

			this.__eSip.onclick = async function (){

				switch(dataSet.get('sip',['activity'])){
					case 'Ringing':	// The phone is ringing
					case 'Calling':	// You are calling someone
						return;

					case 'Phoning':	// Already talking to somebody
						if (!gui.sipalert){
							var	cmenu = await gui._create('sipalert','obj_call');
								cmenu._placeElement(this._main);
						} else
							gui.sipalert._destruct();

						return;
				}

				if (gui.dial){
					if (gui.dial._docked)
						gui.dial._undock();
					else
						gui.dial._destruct();
				}
				else
					await gui._create('dial','frm_dial','','');
			};

			// Add tooltip for SIP phone button
			gui.tooltip._add(this.__eSip, getLang('SIP::SIP')+' ‒ '+getLang('STATUS::OFFLINE'));

			this.__sipbtncss = this.__eSip.className;
			this._listen('sip');
		}

		//Quota
		if (aData.quota){
			await this._create('quota','obj_progress','quota_control','max');
			this.quota.__update = function(){
				var q = dataSet.get('main',['MBOX_QUOTA']),
					u = dataSet.get('main',['MBOX_USAGE']);

				this._range(q);
				this._value(u);

				var percent = roundTo(u / q * 100, 1);
				me._getAnchor('quota').classList.remove('alert');
				me._getAnchor('quota').classList.remove('warning');
				if (percent >= 90) {
					me._getAnchor('quota').classList.add('alert');
				} else if (percent >= 70) {
					me._getAnchor('quota').classList.add('warning');
				}

				me._getAnchor('quota_text').textContent = getLang('QUICK_SETTINGS::USED_STORAGE', [parseFileSize(u * 1024), parseFileSize(q * 1024)]);
				gui.tooltip._add(me._getAnchor('quota'), percent + '%');
				gui.tooltip._add(me._getAnchor('quota_text'), percent + '%');
			};
			this.quota._listen('main');
		}

		this._interfaceColors();

		this._initialPage();
	},

	__avatar:function(){
		this._getAnchor('avatar').innerHTML = obj_avatar.getAvatarHTML({
			email: sPrimaryAccount,
			name: dataSet.get('main', ['fullname']) || sPrimaryAccount,
			size: 28
		});
	},

	__drawLabel:function(sItemClass, sLangKey, b){
		var s = b?'<span class="item-label-on">'+ getLang('COMMON::ON') +'</span>':'<span class="item-label-off">'+ getLang('COMMON::OFF') +'</span>';

		this._getAnchor(sItemClass + '-label').innerHTML = getLang(sLangKey, [s]);
	},

	__responder:function(){
		var from = GWOthers.getItem('AUTORESPONDER','u_respondbetweenfrom');
		var to = GWOthers.getItem('AUTORESPONDER','u_respondbetweento');
		var b = GWOthers.getItem('AUTORESPONDER','u_respond') != '0' &&
				(!from || (new IcewarpDate(from).format(IcewarpDate.JULIAN) <= new IcewarpDate().format(IcewarpDate.JULIAN))) &&
				(!to || (new IcewarpDate(to).format(IcewarpDate.JULIAN) >= new IcewarpDate().format(IcewarpDate.JULIAN)));
		this.__drawLabel('autoresponder', 'QUICK_SETTINGS::AUTORESPONDER', b);
	},

	__forwarder:function(){
		var b = (GWOthers.getItem('FORWARDER','u_forwardto') || '').length;
		this.__drawLabel('redirect', 'QUICK_SETTINGS::REDIRECT', b);
	},

	__security:function(){
		var elm;
		try{
			elm = this._getAnchor('security');
		}
		catch {
			elm = null;
		}

		if (sPrimaryAccount2FE){
			elm && addcss(elm, 'hide');
		}
		else{
			this.__drawLabel('verification', 'QUICK_SETTINGS::AUTHENTICATION', 0);
			elm && removecss(elm, 'hide');
		}
	},

	__update: async function(sDName) {
		
		switch(sDName){
			case 'sip':

				if (this.__eSip){
					var ds = dataSet.get('sip'),
						aStatus = [ds.state];

					switch(ds.activity){
						case 'Ringing':
						case 'Phoning':
						case 'Calling':
							if (this.processing) {
								return;
							}
							this.processing = true;
							aStatus.push('activity');

							if (this.sip && !this.sip._destructed) {
								await this.sip._destruct();
							}

							if (!gui.sipalert) {
								this.sip = await gui._create('sipalert', 'obj_call');
							}

							this.processing = false;
							break;
					}

					if (aStatus.length){
						this.__eSip.className = this.__sipbtncss + ' ' + aStatus.join(' ');
						gui.tooltip._title(this.__eSip, getLang('CONTACT::PHONE')+' - '+getLang('STATUS::'+(ds.state&&ds.state.toUpperCase()||'OFFLINE')));
					}
				}
			}
	},

	__sip: function(sStatus){
		if (sStatus == 'online'){
			if (gui.frm_main.sip)
				gui.frm_main.sip._login(function(ok){
					if(!ok)
						gui._create('alert', 'frm_alert', '', '', '', 'SIP::ERROR', 'SIP::REGISTRATION_FAILED');
				});
			else
			if (!gui.frm_main.sip)
				gui.frm_main._create('sip','obj_sip','','',function(ok){
					if(!ok)
						gui._create('alert', 'frm_alert', '', '', '', 'SIP::ERROR', 'SIP::REGISTRATION_FAILED');
				});
		}
		else
		if (gui.frm_main.sip) {
			if (gui.frm_main.sip.phone) {
				// End ongoing call
				if(gui.dial) {
					gui.frm_main.sip._hangup();
					gui.dial._destruct();
				}
				// Terminate any lingering calls
				gui.frm_main.sip.phone.terminate();
				// Unregister phone
				gui.frm_main.sip.phone.unregister();
			} else
				gui.frm_main.sip._destruct('sip','obj_sip'/*,'dock'*/);
		}
	},

	__saveSettings:function(aHandler){
		WMStorage.set({'resources':dataSet.get('storage')},'storage','', aHandler);
	},

	_compact: function(sView) {
		sView = typeof sView === 'string' ? sView : dataSet.get('current_view');

		this.compact._onchange = function(e, v) {
			GWOthers.setItem('LAYOUT_SETTINGS', 'compact_view', +v);
			GWOthers.save([function() {
				gui.frm_main._changeViewSize(v);
			}]);
		};

		this.compact._value(GWOthers.getItem('LAYOUT_SETTINGS', 'compact_view') || "0", true);
	},

	_layout: function() {
		this.autohide_tree._onchange = function(e, v) {
			GWOthers.setItem('LAYOUT_SETTINGS', 'autohide_tree', +v);
			GWOthers.save([function() {
				v && gui.frm_main._closeFolderPicker();
			}]);
		};
		this.autohide_tree._value(!!+GWOthers.getItem('LAYOUT_SETTINGS', 'autohide_tree'), true);

		if (this.activity_feed) {
			this.activity_feed._onchange = function(e, v) {
				GWOthers.setItem('LAYOUT_SETTINGS', 'activity_feed', +v);
				GWOthers.save();
			};
			this.activity_feed._value(!!+GWOthers.getItem('LAYOUT_SETTINGS', 'activity_feed'), true);
		}

		var aFolder = Path.split(dataSet.get('current_folder'), true),
			viewType = Cookie.__getViewType(['view', aFolder.aid, aFolder.fid]),
			sType = viewType.type,
			sSubType = viewType.subtype;

		var dgw = GWOthers.getItem('RESTRICTIONS', 'disable_gw_types') || '';
		var apps = {
			M: {
				label: getLang('folders::mails')
			},
			MA: {
				label: getLang('folders::mails') + ' (' + getLang('common_folders::all_archives') + ')',
				hidden: true
			},
			MS: {
				label: getLang('folders::mails') + ' (' + getLang('common_folders::sent') + ')',
				hidden: true
			},
			MD: {
				label: getLang('folders::mails') + ' (' + getLang('common_folders::drafts') + ')',
				hidden: true
			},
			MH: {
				label: getLang('folders::mails') + ' (' + getLang('common_folders::trash') + ')',
				hidden: true
			},
			MR: {
				label: getLang('folders::mails') + ' (RSS)',
				hidden: true
			},
			QL: {
				label: getLang('common_folders::quarantine'),
				hidden: true
			},
			E: {
				label: getLang('folders::events')
			},
			C: {
				label: getLang('folders::contacts')
			},
			F: {
				label: getLang('folders::files')
			},
			T: {
				label: getLang('folders::tasks')
			},
			G: {
				label: getLang('common_folders::trash'),
				hidden: true
			}
		};
		for (var i in apps) {
			if (~dgw.indexOf(i.toLowerCase()) || (apps[i].hidden && i !== (sSubType || sType))) {
				delete apps[i];
			} else {
				apps[i] = apps[i].label;
			}
		}

		this.layout_app._onchange = function() {
			var sSubType = this.layout_app._value();

			if (sSubType === 'F' && gui.frm_main._dashboardLoaded() && gui.frm_main.dashboard._hasCapability('files') && dataSet.get('dashboard', ['config', 'dashboard_files_enabled']) == 1) {
				this._getAnchor('preview').classList.add('hide');
				this._getAnchor('layout').classList.remove('hide');
			} else {
				this._getAnchor('preview').classList.remove('hide');
				this._getAnchor('layout').classList.add('hide');
			}
	
			this._getAnchor('app_layout').className = this._getAnchor('app_layout').className.replace(/layout_app-\w+/g, '');
			this._getAnchor('app_layout').classList.add('layout_app-' + sSubType);

			var sView = Cookie.get(['views', false, false, 'view'], {
				type: sSubType === 'MH' ? 'MH' : (sSubType.length === 2 ? 'M' : sSubType),
				subtype: sSubType
			});
			var preview = 0;
			switch (sView) {
				case 'mail_view':
				case 'list_view':
					preview = 1;
					break;
				case 'mail_view_wide':
				case 'list_wide':
					preview = 2;
					break;
				case 'list':
				case 'mail_view_list':
					preview = 3;
					break;
				case 'day_view':
				case 'week_view':
				case 'workweek_view':
				case 'month_view':
					preview = 4;
			}
	
			this.preview._fill([
				{css:'wpreview',value:'list_wide', tooltip: 'ITEMVIEW::SIDE', index: 2},
				{css:'bpreview', value:'list_view', tooltip: 'ITEMVIEW::DOWN', index: 1},
				{css:'lpreview',value:'list', tooltip: 'ITEMVIEW::NONE', index: 3},
				sSubType == 'E' ? {css:'calendar', value:'month_view', tooltip: 'SETTINGS::EVENT_VIEW', index: 4} : false
			].filter(Boolean));
			this.preview._value(preview, true);

			this.layout._fill([
				{css: 'grid', value: 'grid', tooltip: 'LAYOUT::GRID'},
				{css: 'list', value: 'list', tooltip: 'LAYOUT::LIST'},
				{css: 'preview', value: 'preview', tooltip: 'ITEMVIEW::PREVIEW'}
			]);
			this.layout._setValue(Cookie.get(['layout', {F: 'files', N: 'notes'}[sSubType]]) || 'grid', true);
		}.bind(this);
	
		this.preview._onchange = function(){
			var v = this.preview._value();
			var appType = this.layout_app._value();
			var sView = (~'MQR'.indexOf(appType[0])?['','mail_view', 'mail_view_wide','mail_view_list']:['', 'list_view','list_wide','list'])[v];

			if (appType !== (sSubType || sType)) {
				Cookie.set(['views', false, false, 'view'], sView, false, {
					type: appType === 'MH' ? 'MH' : (appType.length === 2 ? 'M' : appType),
					subtype: appType
				});
				return;
			}

			switch (v)	{
				case 4:
					gui.frm_main._selectView(aFolder, GWOthers.getItem('DEFAULT_CALENDAR_SETTINGS', 'event_view'), true, '', '', '');
					break;

				default:
					if (gui.frm_main.main) {

						if (gui.frm_main.main.upload && gui.frm_main.main.upload._uploading) {
							return gui._create('stop_upload','frm_confirm','','',[function(){
								if (gui.frm_main.main.upload)
									gui.frm_main.main.upload._reset();

								gui.frm_main.main._changeview(sView);
							}],'ALERTS::ALERT','CONFIRMATION::STOPUPLOAD');
						}

						if(~gui.frm_main._lastView.indexOf('mail') || ~gui.frm_main._lastView.indexOf('list')) {
							gui.frm_main.main._changeview(sView);
						} else {
							gui.frm_main._selectView(aFolder, sView, true);
						}
					}
			}
		}.bind(this);

		this.layout._onchange = function(){
			var v = this.layout._getValue();
			switch (v) {
				case 'list':
				case 'grid':
				case 'preview':
					Cookie.set(['layout', {F: 'files', N: 'notes'}[this.layout_app._value()]], v);
					gui.__exeEvent('settings_changed');
			}
		}.bind(this);

		this.layout_app._fill(apps);
		this.layout_app._value((sSubType || sType) in apps ? (sSubType || sType) : 'M', true);
		this.layout_app._onchange();
		this.layout_app._obeyEvent('show', [function() {
			this._getAnchor('body').classList.add('scroll_disabled_y');
			this.layout_app.block._add_destructor('__allowScroll');
			this.layout_app.block.__allowScroll = function() {
				this._getAnchor('body').classList.remove('scroll_disabled_y');
			}.bind(this);
		}.bind(this)]);
	},

	_interfaceColors: async function() {
		if (!this.interface_colors) {
			return;
		}
		var me = this;
		var interfaceColor = GWOthers.getItem('LAYOUT_SETTINGS', 'login_interface_color');

		var aColors = {
			custom: '',
			'#702EB7': '',
			'#0086E5': '',
			'#45A154': '',
			'#AC3939': '',
			'#CF9517': '',
			'#A1456D': '',
		};

		await this.interface_colors._fill(aColors);
		await this.interface_colors_background._fill({
			background: 'SETTINGS::INTERFACE_COLORS_BACKGROUND'
		});

		if (interfaceColor === 'background') {
			this.interface_colors_background._value('background');
		} else {
			this.interface_colors._value(interfaceColor in aColors ? interfaceColor : 'custom');
		}

		this.interface_colors._onchange = async function() {
			me.interface_colors_background._uncheck(true);

			if (this._value() === 'custom') {
				var interfaceColor = GWOthers.getItem('LAYOUT_SETTINGS', 'login_interface_color');
				var colorPicker = await this._gui._create('color_picker', 'frm_color_picker', '', '', 'TAGS::CUSTOM_COLOR', Gui.__skin_colors.bg_custom || Gui.__skin_colors.bg_main, [function (sColor) {
					if (!sColor) {
						if (interfaceColor === 'background') {
							me.interface_colors_background._value('background');
						} else {
							me.interface_colors._value(interfaceColor);
						}
					} else {
						gui._setInterfaceColors(sColor, true);

						GWOthers.setItem('LAYOUT_SETTINGS', 'login_interface_color', sColor);
						me.__saveSettings();
					}
				}], {
					theme: true,
					lightness: false,
					hex: false
				});
				colorPicker.btn_default._destruct();
			} else {
				gui._setInterfaceColors(this._value());

				GWOthers.setItem('LAYOUT_SETTINGS', 'login_interface_color', this._value());
				me.__saveSettings();
			}
		};

		this.interface_colors_background._onchange = function() {
			me.interface_colors._uncheck(true);

			GWOthers.setItem('LAYOUT_SETTINGS', 'login_interface_color', 'background');
			gui._setInterfaceColors(gui.__backgroundColor);

			me.__saveSettings();
		};
	},

	_initialPage: function() {
		if (!this.initial_page) {
			return;
		}
		var pages = {};
		if (gui.frm_main._dashboardLoaded()) {
			pages.h = [getLang('COMMON_FOLDERS::DASHBOARD'), 'ico initial_page-h'];
		}
		pages.i = [getLang('COMMON_FOLDERS::INBOX'), 'ico initial_page-i'];
		pages.r = [getLang('SETTINGS::REMEMBER_LAST_PAGE'), 'ico initial_page-r'];
		this.initial_page._fill(pages);

		var initial_page = GWOthers.getItem('LAYOUT_SETTINGS', 'initial_page');
		this.initial_page._onchange = function() {
			var value = this.initial_page._value();
			if (value) {
				this.initial_page._main.classList.remove('initial_page-r', 'initial_page-h', 'initial_page-i');
				this.initial_page._main.classList.add('initial_page-' + value);
				GWOthers.setItem('LAYOUT_SETTINGS', 'initial_page', value);
				GWOthers.save();
			}
		}.bind(this);
		if (!pages[initial_page]) {
			this.initial_page._value('i', true);
		} else {
			this.initial_page._value(initial_page);
		}

		this.initial_page._obeyEvent('show', [function() {
			this._getAnchor('body').classList.add('scroll_disabled_y');
			this.initial_page.block._add_destructor('__allowScroll');
			this.initial_page.block.__allowScroll = function() {
				this._getAnchor('body').classList.remove('scroll_disabled_y');
			}.bind(this);
		}.bind(this)]);
	},

	_handleClick: async function(rel){
		var me = this;

		switch(rel){
			//vCard
			case 'set-profile':
				Item.openwindow([sPrimaryAccount, '@@mycard@@','@@mycard@@'], '', '', 'C', [function(){
					obj_avatar.sAvatarNo = Date.now();
					delete obj_avatar.ownAvatarURL;
					gui.__exeEvent('refreshAvatar');
				}]);
				break;

			//Out of Office
			case 'set-autoresponder':
				gui._create('settings','frm_settings','','','mail_settings','autoresponder');
				break;

			case 'set-redirect':
				gui._create('settings','frm_settings','','','mail_settings','forwarder');
				break;

			//Security
			case 'set-verification':
				gui._create('verify','frm_verify');
				break;

			//Help
			case 'set-help':
				if (gui.help)
					gui.help._destruct();
				else
					gui._create('help', 'frm_help');
				break;

			//Settings
			case 'set-settings':
				gui._create('settings','frm_settings');
				break;
			case 'set-admin-settings':
				gui._create('settings','frm_settings_admin');
				break;
			case 'set-domain-settings':
				gui._create('settings','frm_settings_admin','','',true);
				break;

			//Logout
			case 'set-logout':
				gui.frm_main.__logout();
				break;

			case 'set-wallpaper':
				if (gui.frm_main._dashboardLoaded()) {
					if (dataSet.get('current_view') !== 'dashboard_view') {
						gui.frm_main.filter.__filter('D', false, false, 5);
					}
					gui.frm_main.dashboard._navigate({
						to: 'backgrounds'
					});
				}
				break;
			case 'set-devices':
				if (this.__deviceCount) {
					var devices = await gui._create('devices', 'frm_devices');
					devices._add_destructor('__refresh');
					devices.__refresh = function() {
						me._fill();
					}
				} else {
					var wizard = await gui._create('frm_setupwizard', 'frm_setupwizard', '', '', 'device', ['device', 'mobile', 'finish'], true);
					wizard.__onclose = function() {
						me._fill();
					};
				}
				break;
			case 'set-app':
				gui._create('frm_setupwizard', 'frm_setupwizard', '', '', 'app2', false, true);
		}
	},

	// _onactive:function(){
	// },

	// _ondeactive:function(){
	// }
};