function obj_rdock_im(){};
obj_rdock_im.prototype = {
	__constructor: async function(){
		var me = this;

		this._title('IM::CHAT_TITLE');

		await this._createIM();

		// search
		await this._create('inp_search','obj_input_search','header3', 'obj_input_100 obj_rdock-search');
		this.inp_search._placeholder(getLang('IM::FIND_PH'));
		this.inp_search._onkeyup = function(e){
			var sValue = '';
			// Esc
			if (e.keyCode === 27) {
				this._value('');
				this._parent.im._search('');
			}
			else
				sValue = this._value();

			if (this.__lastValue !== sValue) {
				this.__lastValue = sValue;
				this._parent.im._search(sValue);
			}
		};
		this.inp_search._onkeydown = function(e) {
			this.im._main.dispatchEvent(new KeyboardEvent('keydown', { key: e.key }));
		}.bind(this);
		this.inp_search.__eIN.setAttribute('tabindex', -1);

		var stat = await this._create('status', 'obj_input_dynamic', 'header_info', 'status transparent noborder fit hidden');
			stat._placeholder(getLang('IM::STATUS_MSG'));
			stat._value(this.im._getStatusText());
			stat._onblur = function() {
				this.__eIN.blur();
				if (me.im._getStatusText() != this._value()) {
					me.im._status(me.im._status(), this._value());
					Cookie.set(['im', 'statusText'], this._value());
				}
			};
			stat._onclose = function(){
				this._value(me.im._getStatusText() || '');
				this.__eIN.blur();
			};
			stat._onsubmit = function(){
				this._onblur();
			};

		gui._obeyEvent('storage', [function(e, arg){
			if (e && e.type == 'set' && Is.Array(arg)){
				if (~arg.indexOf('IM')) {
					stat._main.classList[(GWOthers.getItem('IM','status_text') > '0' || this.im._getStatusText()) ? 'remove' : 'add']('hidden');
				}
			}
		}.bind(this)]);

		if (GWOthers.getItem('IM','status_text') > '0' || this.im._getStatusText()) {
			stat._main.classList.remove('hidden');
		}

		//placeholder
		this._getAnchor('splash-label').innerHTML = '<h3>' + getLang('IM::SPLASH_HEADER') + '</h3><p>'+ getLang('IM::SPLASH_TEXT')+'</p>';

		// state
		await this._create('state','obj_select_im','header_info', 'state noborder fit');
		await this._create('splash_state','obj_select_im','splash', 'obj_rdock_im-state noborder fit');

		this.state._onupdate = function(){
			var state = +gui.socket.xmpp._state();
			switch (state) {
				case 0:
					addcss(this._main, 'splash');
					break;
				default:
					removecss(this._main, 'splash');
					if (!me.im) {
						stat._value('');
						return;
					}
					if (state < 5) {
						me.im._skeletons();
					} else {
						setTimeout(function() {
							stat._value(me.im._getStatusText());
							me.im._status(me.im._status(), me.im._getStatusText());
							if (GWOthers.getItem('IM','status_text') > '0' || me.im._getStatusText()) {
								stat._main.classList.remove('hidden');
							}
						}, 5);
					}
			}
		}.bind(this);
		this.state._onupdate();
	},

	_createIM: async function() {
		var im = await this._create('im', 'obj_im', 'body');
		im._add_destructor('__recreate');
		im.__recreate = this._createIM.bind(this);
		// do not refresh IM roster when tab is inactive
		this.im.__noRefresh = this._parent._value() != this._name;

		this.im._search_focus = function(){
			this.inp_search._focus();
		}.bind(this);
	},

	_onactive:function(){
		this.im._doRefresh();
		gui.frm_main.stat._unread('im', false);
		this.inp_search._focus();
	},
	_ondeactive:function(){
		this.im.__noRefresh = true;
	}
};