function obj_rdock_chatgpt_conversation() { };
obj_rdock_chatgpt_conversation.prototype = {
	__constructor: async function (aOptions) {
		this._title('CHAT::THREAD');

		this.__aOptions = Object.assign({
			slide: gui.frm_main.rslide,
			onback: function() {
				this.__aOptions.slide._value('chatgpt')
			}.bind(this),
			onNewConversation: function() {},
			handleNewConversation: function() {
				gui.frm_main._openChatGPTConversation();
			},
			detachable: true,
			allowNew: true,
			allowEdit: true,
			alias: '',
			label: ''
		}, aOptions || {});

		this._getAnchor('splash-label').innerHTML = '';
		this._getAnchor('splash').innerHTML = '';

		this._getAnchor('back').addEventListener('click', function () {
			this.__aOptions.onback();
			this.__aData = null;
		}.bind(this), false);

		if (this.__aOptions.detachable !== false) {
			await this._create('detach', 'obj_button', 'header_info', 'transparent ico detach');
			this.detach._onclick = function() {
				this.thread._detach();
				delete this.thread;
			}.bind(this);
			gui.tooltip._add(this.detach._main, getLang('POPUP_ITEMS::OPEN_WINDOW'));
		}

		if (this.__aOptions.allowNew !== false) {
			await this._create('new', 'obj_button', 'header_info', 'transparent ico add');
			this.new._onclick = this.__aOptions.handleNewConversation;
			gui.tooltip._add(this.new._main, getLang('CHATGPT::NEW_CONVERSATION'))
		}

		if (this.__aOptions.allowEdit !== false) {
			await this._create('edit', 'obj_button', 'header2', 'ico transparent edit simple');
			this.edit._onclick = function() {
				this._edit(true);
			}.bind(this);

			await this._create('label', 'obj_input', 'header2', 'label fit');
			this.label._onsubmit = function () {
				var v = this.label._value();
				if (!v || (v === this.__aData.label)) {
					return this._edit(false);
				}

				this.label._disabled(true);
				this.__aData.update({
					label: v
				}, function() {
					this._edit(false);
				}.bind(this));
			}.bind(this);

			//Cancel
			this.label._onclose = function () {
				this._edit(false);
			}.bind(this);

			this._edit(false);
		}

		if (this.__aOptions.onClose) {
			this._getAnchor('btn_close').onclick = this.__aOptions.onClose;
		}

		this._main.classList.add('new_conversation');

		gui._obeyEvent('ChatGPTConversationUpdate', [this, '__handleChatGPTConversationUpdate']);
		gui._obeyEvent('ChatGPTConversationDelete', [this, '__handleChatGPTConversationDelete']);

		this._add_destructor('__destructor');
	},

	__destructor: function() {
		gui._disobeyEvent('ChatGPTConversationUpdate', [this, '__handleChatGPTConversationUpdate']);
		gui._disobeyEvent('ChatGPTConversationDelete', [this, '__handleChatGPTConversationDelete']);
	},

	__handleChatGPTConversationUpdate: function(conversation) {
		if (this.__aData !== conversation) {
			return;
		}

		if (conversation.realConversation) {
			this.__aData = conversation.realConversation;
			this._getAnchor('header_title').textContent = conversation.label;
		}

		this._getAnchor('header_title').textContent = this.__aData.label;
	},

	__handleChatGPTConversationDelete: function(conversation) {
		if (conversation !== this.__aData) {
			return;
		}

		this.__aData = null;
		this.__aOptions.slide._value('chatgpt');
	},

	_init: async function (conversation, oOptions) {
		return new Promise(async function(resolve) {
			if (conversation && conversation === this.__aData) {
				if (this.thread.list) {
					this.thread.list.__oOptions = Object.assign(this.thread.__oOptions, oOptions || {});
				}
				return resolve(this.thread);
			}
			if (this.thread) {
				await this.thread._destruct();
			}
			if (conversation) {
				if (conversation.id) {
					Cookie.set(['chatgpt', 'rdock'], conversation.id);
					this._main.classList.remove('new_conversation');
					this._getAnchor('header_title').textContent = conversation.label;
					this.__aData = conversation;

					await this._create('thread', 'frm_chatgpt_conversation', 'body', '', conversation, oOptions || {});
					resolve(this.thread);
				} else if (conversation.fake) {
					this._main.classList.remove('new_conversation');
					this._getAnchor('header_title').textContent = conversation.label || '';
					this.__aData = conversation;

					await this._create('thread', 'frm_chatgpt_conversation', 'body', '', conversation, oOptions || {});
					resolve(this.thread);
				} else {
					Cookie.set(['chatgpt', 'rdock'], conversation);
					ChatGPT.getConversation(conversation, async function (bOK, conversation) {
						if (this._destructed) {
							return;
						}
						if (!bOK) {
							return this.__aOptions.slide._value('chatgpt');
						}

						this._main.classList.remove('new_conversation');
						this._getAnchor('header_title').textContent = conversation.label;
						this.__aData = conversation;

						await this._create('thread', 'frm_chatgpt_conversation', 'body', '', conversation, oOptions || {});
						resolve(this.thread);
					}.bind(this));
				}
			} else {
				this._main.classList.add('new_conversation');
				// this._models();
				await this._create('thread', 'frm_chatgpt_conversation', 'body', '', void 0, {
					model: this.model,
					alias: this.__aOptions.alias,
					label: this.__aOptions.label
				}, {
					newConversation: function(conversation) {
						this._main.classList.remove('new_conversation');
						this.__aData = conversation;
						Cookie.set(['chatgpt', 'rdock'], conversation.id);
						this._getAnchor('header_title').textContent = conversation.label;
						this.__aOptions.onNewConversation(conversation);
					}.bind(this)
				});
				this._getAnchor('header_title').textContent = getLang('CHATGPT::ALL_CONVERSATIONS');
				resolve(this.thread);
			}
		}.bind(this));
	},

	_edit: function(bEdit) {
		if (bEdit) {
			this.label._disabled(false);
			this._main.classList.add('edit');

			this.label._value(this.__aData.label);
			this.label._setRange(this.__aData.label.length);
			this.label._focus();
		} else {
			this._main.classList.remove('edit');
		}
	},

	_onactive: function () {
		if (!this.thread) {
			this._init(Cookie.get(['chatgpt', 'rdock']));
		}
	},

	_ondeactive: function () { }
};