function obj_rdock_chatgpt() { };
obj_rdock_chatgpt.prototype = {
	__constructor: async function (aOptions) {
		this.__aOptions = Object.assign({
			handleOpenConversation: async function(conversation, aOptions) {
				await gui.frm_main._openChatGPTConversation(conversation, aOptions);
			}
		}, aOptions);
		this._title('MAIN_MENU::CHATGPT');

		this._getAnchor('splash-label').innerHTML = '';
		this._getAnchor('splash').innerHTML = '';
		await this._create('actions', 'obj_chatgpt_actions', 'splash', '', {
			callback: [this, '__message']
		});

		await this._create('new', 'obj_button', 'header_info', 'transparent ico add');
		this.new._onclick = this.__aOptions.handleOpenConversation.bind(this, '');
		gui.tooltip._add(this.new._main, getLang('CHATGPT::NEW_CONVERSATION'))

		if (this.__aOptions.onClose) {
			this._getAnchor('btn_close').onclick = this.__aOptions.onClose;
		}
	},

	_onactive: async function () {
		var me = this;
		if (!this.list) {
			await this._create('list', 'obj_list_load_chatgpt', 'body');

			this.list._onclick = function (e, elm) {
				var eItem = Is.Child(elm, 'section', this._main);
				if (!eItem) {
					return;
				}

				me.__aOptions.handleOpenConversation(eItem.getAttribute('rel'));
			};

			this.list._oncount = async function (i) {
				if (!i) {
					addcss(this._main, 'splash')

					if (!this.text) {
						await this._create("text", "obj_chat_input", "container", "comment-text", {
							block: true,
							gifs_enabled: false,
							smiles_enabled: false,
							chatgpt_enabled: false,
							upload_enabled: true,
							uploadInstanceId: unique_id()
						});
					
						this.actions.__oOptions.input = this.text;
					
						this.text._onsubmit = function (v) {
							if (this.text._isUploading()) {
								return;
							}

							if (!v.trim()) {
								return;
							}

							this.text._readonly(true);
							this.__message({
								message: v,
								files: []
							});
						}.bind(this);

						this.text._focus(true);
						this.text.input._placeholder(getLang('CHATGPT::ASSISTANT_INPUT_PLACEHOLDER' + (Math.floor((Math.random() * 3)) || '')));
					}

				} else {
					this.text && this.text._destruct();
					removecss(this._main, 'splash');
				}
			}.bind(this);

			this.list._serverSort();
		}

		this.list._active(true);
	},

	_ondeactive: function () { },

	__message: function(oData) {
		oData = oData || {};

		ChatGPT.conversationCreateFake({
			openai_model: oData.model,
			messages: oData.messages,
			label: oData.label,
			instance: oData.instance
		}, function(bOK, conversation) {
			if (bOK) {
				this.__aOptions.handleOpenConversation(conversation);

				var files = this.text._upload._getAttachments();
				if (files.length) {
					var length = files.length;
					var responses = [];

					files.forEach(function(file) {
						ChatGPT.createFile({
							alias: file.id,
							name: file.name,
							url: sPrimaryAccountClient + 'server/download.php?'+ buildURL({dlsess: dataSet.get('main', ['dlsess']), class: 'file', fullpath: file.folder + '/' + file.id})
						}, function(bOK, response) {
							if (!bOK) {
								return;
							}
							responses.push(response);
							if (!--length) {
								this.text._clearAttachments(true);
								oData.files = responses.map(function(file) {
									return {
										alias: file.alias
									}
								});
								this.___message(oData, conversation);
							}
						}.bind(this));
					}, this);
				} else {
					this.___message(oData, conversation);
				}
			} else {
				this.text._readonly(false);
			}
		}.bind(this));
	},

	___message: function(oData, conversation) {
		if (oData.message) {
			conversation.messageCreate({
				message: oData.message,
				files: oData.files
			}, function(bOK, message) {
				this.text._readonly(false);
				if (bOK) {
					message.conversation.process();
				} else {
					conversation.delete();
				}
			}.bind(this));
		}
	}
};