function obj_rdock_calendar() {};
obj_rdock_calendar.prototype = {
	__constructor: async function () {
		this._title('MAIN_MENU::CALENDAR');

		this.__aid = sPrimaryAccount;

		this.__sDataset = 'rdock_calendar';
		this.__sDatasetView = 'rdock_calendar_view';
		this.__doRefresh = false;

		var me = this;

		//Calendar
		await this._create('calendar', 'obj_evnview', 'body');

		this.calendar._onchange = function(aValues, bRefresh){
			frm_main_calendar.prototype._onItemChange.call(me, 1, aValues, false, bRefresh);
		};
		this.calendar._onadd = frm_main_calendar.prototype._onItemAdd.bind(this);
		this.calendar._onremove = async function(id, shift_key){
			var aTmp = dataSet.get(this.__sDataset, [this.__aid, this.__fid, id]),
				oRepeating;

			if (aTmp) {
				if (aTmp.EVNRCR_ID)
					oRepeating = aTmp;

				if (shift_key && !Is.Object(oRepeating)) {
					return await gui._create('frm_confirm', 'frm_confirm_suppress', '', 'frm_trash', [Item.remove, [[this.__aid, this.__fid, [WMItems._stripPipe(id)]], shift_key || false, oRepeating, null, false, [me, '__addEventHandler']]],'CONFIRMATION::DELETE_ITEM_CONFIRMATION','CONFIRMATION::DELETE_ITEM');
				}
				Item.remove([this.__aid, this.__fid, [WMItems._stripPipe(id)]], shift_key || false, oRepeating, null, false, [me, '__addEventHandler']);
			}
		}.bind(this);
		this.calendar._ondblclick = frm_main_calendar.prototype._dblclick.bind(this);
		this.calendar._oncontext = frm_main_calendar.prototype._contextmenu.bind(this);

		this.calendar._listen_data(this.__sDatasetView);

		this.calendar._skipActivate = true;

		await this.__updateCalendarPicker();

		//Range input
		await this._create('btn_prev', 'obj_button', 'header3', 'simple ico img prev transparent');
		this.btn_prev._onclick = function(){
			var r = this._parent.range._value();
			this._parent.range._value(--r);
		};
		this.btn_prev.__eIN.setAttribute('tabIndex', -1);

		await this._create('btn_next', 'obj_button', 'header3', 'simple ico img next transparent');
		this.btn_next._onclick = function(){
			var r = this._parent.range._value();
			this._parent.range._value(++r);
		};
		this.btn_next.__eIN.setAttribute('tabIndex', -1);

		await this._create('range', 'obj_input_calendar', 'header3', 'noborder', false, true);
		this.range._ondateselect = function(){
			this._setRange(this.range._value());
		}.bind(this);
		this.range._ondateselect();
		this.range.input.__eIN.setAttribute('tabIndex', -1);

		await this._create('btn_add', 'obj_button', 'header3', 'noborder transparent simple ico btn_add');
		this.btn_add._disabled(true);
		this.btn_add._value('FORM_BUTTONS::ADD');
		this.btn_add._onclick = function(){
			Item.openwindow([me.__aid, me.__fid], getCurrentEventTime());
		};
		this.btn_add.__eIN.setAttribute('tabIndex', -1);

		this._main.querySelector('.obj_input_calendar').appendChild(mkElement('div', {class:"alternative_calendar"}));

		gui._obeyEvent('account', [this, '__account_refresh']);
		gui._obeyEvent('item', [this, '__item_refresh']);
		dataSet.obey(this, '','folders',true);

		this._add_destructor('__destructor');
	},

	__update: async function (sDataset) {
		if (sDataset === 'folders') {
			this.__updateCalendarPicker();
		}
	},

	__updateCalendarPicker: async function () {
		var calendars = {
			'__@@VIRTUAL@@__/__@@EVENTS@@__': getLang('common_folders::calendars')
		};
		var aFols = dataSet.get('folders', [sPrimaryAccount]);
		var calendars_unsorted = [];
		for (var i in aFols) {
			if (aFols[i].TYPE === 'E' && i !== '__@@VIRTUAL@@__/__@@EVENTS@@__') {
				calendars_unsorted.push({key: i, title: WMFolders.getFolderPath({aid: sPrimaryAccount, fid: i})});
			}
		}
		calendars_unsorted.sort(function(a, b) {
			return a.title.localeCompare(b.title, undefined, {numeric: true, sensitivity: 'base'});
		});
		for (var i in calendars_unsorted) {
			calendars[calendars_unsorted[i].key] = calendars_unsorted[i].title;
		}

		this.__fid = Cookie.get(['rdock_calendar_view']) || Mapping.getDefaultFolderForGWType('E');
		if (!dataSet.get('folders', [this.__aid, this.__fid])) {
			this.__fid = Mapping.getDefaultFolderForGWType('E');
			Cookie.set(['rdock_calendar_view'], this.__fid);
		}

		if (Object.keys(calendars).length > 1) {
			this.calendar_picker = this.calendar_picker || await this._create('calendar_picker', 'obj_select', 'header_info', 'noborder fit');

			this.calendar_picker._onchange = function(){
				this.__fid = this.calendar_picker._value();
				Cookie.set(['rdock_calendar_view'], this.__fid)
				this._serverSort();
			}.bind(this);

			this.calendar_picker._fill(calendars);
			this.calendar_picker._value(this.__fid);
		} else if (this.calendar_picker) {
			this.calendar_picker._destruct();
		}
	},

	//Update date at midnight
	__dateUpdate:function(bSetNew){

		if (this.__updateRangeTimer) {
			clearTimeout(this.__updateRangeTimer);
			delete this.__updateRangeTimer;
		}

		if (bSetNew){
			var tomorrow = IcewarpDate.julian((new IcewarpDate()).add(1,'day').format(IcewarpDate.JULIAN)).startOf('day');

			this.__updateRangeTimer = setTimeout(function(){

				if (!this || this._destructed)
					return;

				var jToday = (new IcewarpDate()).format(IcewarpDate.JULIAN);

				this.range._value(jToday);

			}.bind(this), tomorrow.diff(new IcewarpDate()) + 1000);
		}
	},

	_setRange: async function(r){

		var jToday = (new IcewarpDate()).format(IcewarpDate.JULIAN);
		this.__dateUpdate(r === jToday);

		await this.calendar._range(r,r,GWOthers.getItem('CALENDAR_SETTINGS','day_begins'),GWOthers.getItem('CALENDAR_SETTINGS','day_ends'));
		this._serverSort();
	},

	_serverSort: async function(){

		this.__doRefresh = false;

		var range = await this.calendar._range(),
			aValues = WMItems.default_values('EI');

		WMItems.list({"aid": this.__aid, "fid": this.__fid, "values": aValues, "filter": {'interval': range['start'] + '-' + range['end']}}, this.__sDataset, '', '', [this, '__response', [range]]);
	},

	__addEventHandler:function (bOk) {
		if (bOk == false) {
			dataSet.update(this.__sDatasetView);
		}
	},

	__response: async function (aRange, aValues) {

		if ((await this.calendar._range()).start !== aRange.start || !(aValues = aValues[this.__aid]) || !(aValues = aValues[this.__fid]))
			return;

		var aFillData = [];

		for (var i in aValues) {
			if (i === '/' || i === '#' || i === '$' || i === '@') {
				continue;
			}
			try {
				var fcolor = aValues[i]['EVNFOLDER'] ? getCalendarColor(Path.slash(aValues[i]['EVNFOLDER'])) : '';
				aFillData.push({
					'starttime': (aValues[i]['EVNSTARTTIME'] >= 0) ? aValues[i]['EVNSTARTTIME'] * 60 : -1,
					'endtime': (aValues[i]['EVNENDTIME'] >= 0) ? aValues[i]['EVNENDTIME'] * 60 : -1,
					'startdate': aValues[i]['EVNSTARTDATE'],
					'enddate': parseInt(aValues[i]['EVNENDDATE'], 10) + (aValues[i]['EVNSTARTTIME'] < 0 ? -1 : 0),
					'evntimeformat': aValues[i]['EVNTIMEFORMAT'],
					'evnflags': aValues[i]['EVNFLAGS'],
					'title': aValues[i]['EVNTITLE'],
					'conferenceid': aValues[i]['EVNMEETINGID'] ? parseInt(aValues[i]['EVNMEETINGID']) : undefined,
					'osd': aValues[i]['OSD'],
					'oed': aValues[i]['OED'],
					'evnrcr_id': aValues[i]['EVNRCR_ID'],
					'rmnevn_id': aValues[i]['RMNEVN_ID'],
					'evnclass': aValues[i]['EVNCLASS'],
					'evntype': aValues[i]['EVNTYPE'],
					'evnsharetype': aValues[i]['EVNSHARETYPE'],
					'location': aValues[i]['EVNLOCATION'],
					'owner': aValues[i]['EVNOWN_ID'],
					'evnfolder': aValues[i]['EVNFOLDER'],
					'evnowneremail': aValues[i]['EVNOWNEREMAIL'],
					'fcolor': calendarPalette[fcolor] || fcolor,
					'id': i
				});
			} catch (e) {
				 console.log(e);
			}
		}

		this.__rights = WMFolders.getAccess({'aid': this.__aid, 'fid': this.__fid});

		this.calendar._rights(this.__rights);
		this.btn_add._disabled(!this.__rights.write);

		dataSet.add(this.__sDatasetView, '', aFillData, true);
		dataSet.update(this.__sDatasetView);
	},

	__destructor: function(){
		dataSet.remove(this.__sDataset, true);
		dataSet.remove(this.__sDatasetView, true);

		gui._disobeyEvent('account', [this, '__account_refresh']);
		gui._disobeyEvent('item', [this, '__item_refresh']);

		if (this.__updateRangeTimer)
			clearTimeout(this.__updateRangeTimer);
	},

	//refresh methods
	__account_refresh:function(sMethod, aid){
		if (sMethod === 'refresh' && aid === sPrimaryAccount){
			if (this._parent._value() == this._name)
				this._serverSort();
			else
				this.__doRefresh = true;
		}
	},

	__item_refresh:function(sMethod, args){
		if (args.aid == this.__aid && (args.fid == this.__fid || Is.Defined((args.fid == "__@@VIRTUAL@@__/__@@EVENTS@@__" && dataSet.get('folders',[args.aid, args.fid, 'VIRTUAL', 'FOLDERS']) || {})[this.__fid]))){
			switch(sMethod){
				case 'move':
					//check if id is in the range
					if (!(Is.Array(args.iid) && args.iid.some(function(iid){
						return !!dataSet.get(this.__sDataset,[this.__aid, this.__fid, iid]);
					}, this))){
						return;
					}
				case 'remove':
				default:
					if (this._parent._value() == this._name)
						this._serverSort();
					else
						this.__doRefresh = true;
			}
		}
	},

	_onactive: function () {
		if (this.__updateRangeTimer) {
			this.range._value((new IcewarpDate()).format(IcewarpDate.JULIAN));
		}

		if (this.__doRefresh)
			this._serverSort();
	},
};
