_me = obj_popup.prototype;
function obj_popup(){

};
/**
 *
 *		_ondock
 *		_onundock
 *		_onresize
 **/

obj_popup.activeStack = {
	//PRIVATE
	__stack: [],

	//PUBLIC
	add: function(obj){
		this.remove(obj);
		this.__stack.unshift(obj);
		return true;
	},
	// Remove docked windows from active windows stack
	remove: function(obj){
		for(var i = this.__stack.length; i--;)
			if (this.__stack[i] === obj) {
				this.__stack.splice(i,1);
				return true;
			}
	},
	// Focus next window below the docked one
	focusNext: function(){
		var obj = this.get();
		return obj && obj._focus && obj._focus(true);
	},
	get: function(id){
		return this.__stack[id || 0];
	},
	//Re-order modal popups
	order: function(){
		for (var i = 0, j = this.__stack.length; i<j; i++)
			if (this.__stack[i] && !this.__stack[i]._destructed && this.__stack[i]._isModal() && this.__stack[i]._focus){
				this.__stack[i]._focus();
				break;
			}
	}
};

AttachEvent(document, "onkeydown", function(e) {
	if (e && e.keyCode==27){
		// Escape will close top most recent window
		var p = obj_popup.activeStack.get();
		if (p){
			if ((e.target.nodeName === 'INPUT' || e.target.nodeName === 'TEXTAREA')){
				if (!p.__detached && !p._docked && !p.__hidden && p.__closable && p._main.contains(e.target)){
					p._close(true, e);
				}
			}
			else
			if (!p.__detached && !p._docked && !p.__hidden && p.__closable){
				p._close(true, e);
			}
		}
	}
});

_me.__constructor = async function(owner){
	this._owner = owner;

	this.__resizable	= true;
	this.__closable		= true;
	this.__dockable		= true;
	this.__moveble		= true;
	this.__detachable	= false;

	this.__zindex;
	this.__position = {}; // position memory for fullscrean
	this.__positionShadow = {}; //real possition memory (when shifted)
	this.__positionOffset = {}; //Shift offset

	this.__hidden = false;

	var me = this;

	/* docking */
	this._mydock;

	/* target elements */
	this.__eTitle		= this._getAnchor('title_text');
	this.__eContainer	= this._getAnchor('container');
	this.__eMain		= this._getAnchor('main');

	/* set zindex */
	this.__eContainer.style.zIndex = this.__zindex = maxZIndex.get();

	// Add to active windows stack
	obj_popup.activeStack.add(this);

	/* onclose event */
	this._add_destructor('_onclose');
	this._add_destructor('__destructor');

	var sResize;

	this.__defaultSizeOptions = {
		maximized: false,
		goldenRatio: false,
		minWidth: 300,
		minHeight: 150
	};

	this.__eContainer.onmousemove = function(e){
		var elm = e.target;

		if (this !== elm || !me.__resizable || me.__position.max) {
			this.style.cursor = 'default';
			return;
		}

		var elmleft  = me.__positionShadow.x,
			elmtop   = me.__positionShadow.y,
			elmwidth = elm.offsetWidth,
			elmheight= elm.offsetHeight;

		// left part
		if (e.clientX - elmleft<9){
			// top corner
			if (e.clientY - elmtop<9){
				this.style.cursor = 'nwse-resize';
				sResize = 'lt';
			}
			// bottom corner
			else
			if ((elmtop + elmheight) - e.clientY < 9){
				this.style.cursor = 'nesw-resize';
				sResize = 'lb';
			}
			// side
			else{
				this.style.cursor = 'ew-resize';
				sResize = 'l';
			}
		}
		// right part
		else
		if ((elmleft + elmwidth) - e.clientX<9){
			// top corner
			if (e.clientY - elmtop<9){
				this.style.cursor = 'nesw-resize';
				sResize = 'rt';
			}
			// bottom corner
			else
			if((elmtop + elmheight) - e.clientY < 9){
				this.style.cursor = 'nwse-resize';
				sResize = 'rb';
			}
			// side
			else{
				this.style.cursor = 'ew-resize';
				sResize = 'r';
			}
		}
		// center
		else{
			this.style.cursor = 'ns-resize';

			// top
			if (e.clientY - elmtop < 8)
				sResize = 't';
			// bottom
			else
			if ((elmtop + elmheight) - e.clientY < 8)
				sResize = 'b';
		}
	};

	/* REMOVE EVENT */
	function dispatch(){
		me.__hideBlock();
		me._gui._disobeyEvent('mousemove',[me,'__move_handler']);

		if (me._onresize_end)
			me._onresize_end();

		return false;
	};

	this.__eContainer.onmousedown = function(e){

		var elm = e.target,
			disp = false,
			bStop = false,
			t = +new IcewarpDate();

		// set max zindex
		me._focus();

		// resize event
		if (this === elm){
			if (!me.__resizable || me.__position.max)
				return;

			me.__resize (e,sResize);
			disp = true;
		}
		else
		switch (elm.id.substr(me._pathName.length)){
			// move
			case '#top':
			case '#title_text':
			case '#title':

				if (!this.ondblclick)
					if (this.__lastClick && this.__lastClick+600>t){
						this.__lastClick = 0;

						me._maximize();
						if (me._onresize) me._onresize(e,'max');
						me.__exeEvent('onresize',e,{"owner":me,"main":me._main,"body":me.__eContainer,"type":'max'});

						return;
					}
					else
						this.__lastClick = t;


				if (!me.__moveble) return;

				me.__showBlock('m');

				var difX = e.clientX - me.__positionShadow.x,
					difY = e.clientY - me.__positionShadow.y;

				me.__move_handler = function(e){
					me._place(Math.max(e.clientX - difX, 0), Math.max(e.clientY - difY, 0));
				};
				me._gui._obeyEvent('mousemove',[me,'__move_handler']);
				if (me._onmove)
					me._onmove(e);

				disp = true;

				break;

			case '#ico':
                if (this.ondblclick)
                    break;
				else
				{
					if (!this.__lastClick || this.__lastClick+600<t){
						this.__lastClick = t;
						break;
					}
				}
		}

		if (disp || bStop){
			//propagate click to close context-menus, etc...
			me._main.ownerDocument.onclick && me._main.ownerDocument.onclick({type:'click', 'clientY':e.clientY, 'clientX':e.clientX,'target':elm});

			if (disp)
				me._gui._obeyEvent('mouseup',[dispatch,[e]]);

			if (bStop){
				e.stopPropagation();
			}
			e.preventDefault();
		}
	};

	this.__eContainer.onclick = function(e) {
		var bStop;
		switch(e.target.id.substr(me._pathName.length)) {
			// maximalize
			case '#max':
				if (e.button<2){
					me._maximize();
					if (me._onresize) me._onresize(e,'max');
					me.__exeEvent('onresize',e,{"owner":me,"main":me._main,"body":me.__eContainer,"type":'max'});
				}

				bStop = true;
				break;
			// minimalize
			case '#min':
				if (!me._isModal() && e.button<2)
					me._dock();

				bStop = true;
				break;
			// detach
			case '#detach':
				// time to allow cleanup
				setTimeout(me._detach.bind(me), 5);
				bStop = true;
				break;
			// close
			case '#rem':
				if (me.__closable && e.button<2)
					me._close(true, e);

				// bStop = true;
				break;
		}

		if (bStop){
			e.preventDefault();
			e.stopPropagation();
		}
	};

	// Focus the field user typed in last
	this.__eContainer.onmouseup = function(e){
		if (!Is.Child(e.target, me.__eMain))
			if (!me._preventfocus && me._activeElement) {
				if (me._main.ownerDocument.activeElement != me._activeElement)
					me._activeElement.focus({
						preventScroll: true
					});
			}
			else
			me._main.ownerDocument.activeElement && me._main.ownerDocument.activeElement.blur && me._main.ownerDocument.activeElement.blur();
	};

	this.__eMain.scrollTop = 0;
	this.__eContainer.scrollTop = 0;

	// Monitor any elements getting selected within the popup
	this._activeElement = null;
	if (document.addEventListener) {

		// Remember last active element in this popup
		this.__eContainer.addEventListener('focus', function(e){
			var elm = e.target;

			// Handle special case of rich text area focus OLD
			if (elm.nodeName=='DIV' && elm.getElementsByTagName('iframe').length) {
				elm = elm.getElementsByTagName('iframe')[0];
				elm = elm.contentWindow.document.body;
			}

			if (elm.nodeName=='BODY' || (('onfocus' in elm) && elm.getAttribute('iw-focus') != 'false'))
				me._activeElement = elm;

		},true);
	}

	obj_popup.activeStack.order();

	//window resize
	me._gui._obeyEvent('resize',[this,'__checkPosition']);

	AttachEvent(this._main, "onfocusin", function() {
		me._activate();
	});

	gui.tooltip._add(this._getAnchor('detach'), getLang('POPUP_ITEMS::OPEN_WINDOW'));
	gui.tooltip._add(this._getAnchor('min'), getLang('POPUP_ITEMS::MINIMIZE'));
	gui.tooltip._add(this._getAnchor('max'), getLang('POPUP_ITEMS::MAXIMIZE'));
	gui.tooltip._add(this._getAnchor('rem'), getLang('FORM_BUTTONS::CLOSE'));
};

_me._destruct = async function(bForce) {
	if (bForce && this.__detached) {
		this.__detached.onbeforeunload = false;
	}
	await Gui.prototype._destruct.call(this);
}

_me._detachable = function(bDetachable) {
	if (bDetachable === void 0 || ~currentBrowser().indexOf('MSIE')) {
		return this.__detachable;
	}
	this.__detachable = bDetachable;
	(bDetachable ? removecss : addcss)(this._getAnchor('detach'), 'hidden');
}

_me._dockable = function(b){
	this._getAnchor('min').style.display = ((this.__dockable = (b?true:false)))?'':'none';
};
_me._resizable = function(b){
	this._getAnchor('max').style.display = ((this.__resizable = (b?true:false)))?'':'none';
};
_me._closable = function(b){
	if ((this.__closable = b?true:false))
		removecss(this._getAnchor('rem'),'dim');
	else
		addcss(this._getAnchor('rem'),'dim');
};
_me._moveble = function(b){
	this.__moveble	= b?true:false;
};
_me._autofocusfields = function(b) {
	this._preventfocus = !b;
};

_me.__hide = async function(message, bSkipFocusNext) {
	if (this.__detached) {
		this.loader = await this._gui._create('loader', 'obj_loader');
		message && this.loader._value(getLang(message));
		return;
	}

	if (this._docked) {
		this.__dock.classList.add('hidden');
		gui.frm_main.dock.__checkSize();
	}

	this.__eContainer.style.zIndex = -1;
	this.__eContainer.style.visibility = 'hidden';
	this._main.setAttribute('aria-hidden', '');

	this.__hidden = true;

	if (this._isModal()){
		this.__modaldiv.style.display = 'none';
	}

	// Remove docked windows from active windows stack
	obj_popup.activeStack.remove(this);
	if (!bSkipFocusNext) {
		// Focus next window below the docked one
		obj_popup.activeStack.focusNext();
	}

	this.__exeEvent('onhide','',{"owner":this});
};

_me.__show = function(){
	if (this.__detached) {
		this.loader && this.loader._destruct();
		return;
	}

	if (this._docked) {
		this.__dock.classList.remove('hidden');
		gui.frm_main.dock.__checkSize();
	}

	this.__eContainer.style.zIndex = this.__zindex;
	this.__eContainer.style.visibility = 'visible';
	this._main.removeAttribute('aria-hidden');

	this.__hidden = false;

	if (this._isModal()){
		this.__modaldiv.style.display = 'block';
	}

	obj_popup.activeStack.add(this);

	this.__exeEvent('onshow','',{"owner":this});
};

/**
 * Hidden over-div
 * It avoind of gui selections
 * 22.5.2008 14:06:40
 **/
_me.__showBlock = function(sResize){

	if (!this.__maskDIV){
		this.__maskDIV = mkElement('div',{className:'obj_popup_mask'});
		this.__maskDIV.onclick = function(){
			this.__hideBlock();
		}.bind(this);

		document.body.appendChild(this.__maskDIV);
	}

	if (sResize)
		this.__maskDIV.style.cursor = {m:'Move',lt:'se-resize',lb:'sw-resize',l:'w-resize',rt:'sw-resize',rb:'se-resize',r:'w-resize',t:'s-resize',b:'s-resize'}[sResize];
};
_me.__hideBlock = function(){
	if (this.__maskDIV){
		try{
			this.__maskDIV.parentNode.removeChild(this.__maskDIV);
		}catch(e){ console.log(this._name||false,e)}
		this.__maskDIV = null;

		return true;
	}
	return false;
};


_me._dock = function (skip, sCSS, bUnshift){
	if (this._docked) {
		return;
	}

	var sTitle = false;
	sCSS = sCSS || '';

	if (!this.__dockable) return;

	// If implemented, fire ondock
	if (this._ondock){
		var out = this._ondock();
		// If returns falsy value, skip docking
		if (!out)
			return;
		else
		// Otherwise, try to get title
		if (Is.String(out))
			sTitle = out;
		else
		if (Is.Object(out)){
			if (Is.Defined(out.title))
				sTitle = out.title;
			if (Is.Defined(out.css))
				sCSS = out.css;
		}
	}

	// If no title was supplied use popup title
	if (!Is.String(sTitle))
		sTitle = this._title().unescapeHTML();

	// Remove docked windows from active windows stack
	obj_popup.activeStack.remove(this);
	// Focus next window below the docked one
	obj_popup.activeStack.focusNext();

	// Visually docking;
	this.__eContainer.style.marginLeft = '-300%';
	this.__eContainer.style.visibility = 'hidden';

	//visibility:hidden doesn't prevent FFox of keeping focus
	if ('activeElement' in document){
		var elm = document.activeElement;
		if (elm && elm !== document.body && typeof elm.blur == 'function' && Is.Child(elm,this._main)){
			elm.blur();
		}
	}

	this._main.setAttribute('aria-hidden', '');

	this._docked = true;

	if (!skip) gui.frm_main.dock._add(this,sTitle,sCSS,bUnshift);

	return true;
};


_me._undock = function (skip){
	if (this._docked){
		this._main.removeAttribute('aria-hidden');
		this.__eContainer.style.marginLeft = 'auto';
		this.__eContainer.style.visibility = 'visible';

		this._docked = false;

		if (!skip)
			gui.frm_main.dock._remove(this);

		this._focus();

		if (this._onundock)
			this._onundock();

		return true;
	}
};

// _me._ondock = function(){};
// _me._onundock = function(){};

_me.__resize = function(e,sResize){

	var me = this;
	var difX,difY,dif1,dif2,dif3,dif4;

	//remove old handler
	if (this.__move_handler){
		me._gui._disobeyEvent('mousemove',[this,'__move_handler']);
		this.__move_handler = null;
	}

	this.__showBlock(sResize);

	var position = getSize(this.__eContainer);

	switch(sResize){
	case 't' :
		difY = e.clientY - position.y;
		dif1 = position.h;
		dif2 = position.y;

		me.__move_handler = function(evn){
			var y = Math.max(evn.clientY - difY, 0),
				h = dif1 - (y - dif2);

			if (h < me.__defaultSizeOptions.minHeight){
				y -= me.__defaultSizeOptions.minHeight - h;
				h = me.__defaultSizeOptions.minHeight;
			}

			me._place('',y,'',h);

			/*** resize event ***/
			if (me._onresize) me._onresize(e,'t');
			me.__exeEvent('onresize',e,{"owner":me,"main":me.__eContainer,"body":me.__eMain,"type":'t'});
		};

		break;

	case 'lt':
		difX = e.clientX - position.x;
		difY = e.clientY - position.y;
		dif1 = position.h;
		dif2 = position.y;
		dif3 = position.w;
		dif4 = position.x;

		me.__move_handler = function(evn){
			var x = Math.max(evn.clientX - difX, 0),
				y = Math.max(evn.clientY - difY, 0),
				w = dif3 + dif4 - x,
				h = dif1 - (y - dif2);

				if (w < me.__defaultSizeOptions.minWidth){
					x -= me.__defaultSizeOptions.minWidth - w;
					w = me.__defaultSizeOptions.minWidth;
				}

			if (h < me.__defaultSizeOptions.minHeight){
				y -= me.__defaultSizeOptions.minHeight - h;
				h = me.__defaultSizeOptions.minHeight;
			}

			me._place(x,y,w,h);

			/*** resize event ***/
			if (me._onresize) me._onresize(e,'lt');
			me.__exeEvent('onresize',e,{"owner":me,"main":me.__eContainer,"body":me.__eMain,"type":'lt'});
		};

		break;

	case 'l' :
		difX = e.clientX - position.x;
		dif1 = position.w;
		dif2 = position.x;

		me.__move_handler = function(evn){
			var x = Math.max(evn.clientX - difX, 0),
				w = dif1 + dif2 - x;

			if (w < me.__defaultSizeOptions.minWidth){
				x -= me.__defaultSizeOptions.minWidth - w;
				w = me.__defaultSizeOptions.minWidth;
			}

			me._place(x,'',w);

			/*** resize event ***/
			if (me._onresize) me._onresize(e,'l');
			me.__exeEvent('onresize',e,{"owner":me,"main":me.__eContainer,"body":me.__eMain,"type":'l'});
		};

		break;

	case 'lb':
		difX = e.clientX - position.x;
		difY = e.clientY - (position.y + position.h);
		dif1 = position.w;
		dif2 = position.x;
		dif3 = position.y;

		me.__move_handler = function(evn){
			var x = Math.max(evn.clientX - difX, 0),
				w = dif1 + dif2 - x,
				h = evn.clientY - dif3 - difY;

			if (w < me.__defaultSizeOptions.minWidth){
				x -= me.__defaultSizeOptions.minWidth - w;
				w = me.__defaultSizeOptions.minWidth;
			}

			if (h < me.__defaultSizeOptions.minHeight)
				h = me.__defaultSizeOptions.minHeight;

			me._place(x,'',w,h);

			/*** resize event ***/
			if (me._onresize) me._onresize(e,'lb');
			me.__exeEvent('onresize',e,{"owner":me,"main":me.__eContainer,"body":me.__eMain,"type":'lb'});
		};

		break;
	case 'b' :
		difY = position.h - e.clientY;

		me.__move_handler = function(evn){
			var y = Math.max(evn.clientY,0);

			var size = y + difY;
			size = size<me.__defaultSizeOptions.minHeight?me.__defaultSizeOptions.minHeight:size;

			me._size('',size, false, true);

			/*** resize event ***/
			if (me._onresize) me._onresize(e,'b');
			me.__exeEvent('onresize',e,{"owner":me,"main":me.__eContainer,"body":me.__eMain,"type":'b'});
		};

		break;
	case 'rb':
		difX = position.w - e.clientX;
		difY = position.h - e.clientY;

		me.__move_handler = function(evn){
			var x = Math.max(evn.clientX, 0),
				y = Math.max(evn.clientY, 0);

			var size1 = x + difX;
				size1 = size1<me.__defaultSizeOptions.minWidth?me.__defaultSizeOptions.minWidth:size1;

			var size2 = y + difY;
			    size2 = size2<me.__defaultSizeOptions.minHeight?me.__defaultSizeOptions.minHeight:size2;

			me._size(size1,size2, false, true);

			/*** resize event ***/
			if (me._onresize) me._onresize(e,'rb');
			me.__exeEvent('onresize',e,{"owner":me,"main":me._main,"body":me.__eContainer,"type":'rb'});
		};

		break;
	case 'r' :
		difX = e.clientX;
		dif1 = position.w;

		me.__move_handler = function(evn){
			var X = evn.clientX;
				X = X<0?0:X;

			var size1 = dif1 + X - difX;
   				size1 = size1<me.__defaultSizeOptions.minWidth?me.__defaultSizeOptions.minWidth:size1;

			me._size(size1, '', false, true);

			/*** resize event ***/
			if (me._onresize) me._onresize(e,'r');
			me.__exeEvent('onresize',e,{"owner":me,"main":me._main,"body":me.__eContainer,"type":'r'});
		};

		break;
	case 'rt':
		difX = e.clientX;
		difY = e.clientY;
		dif1 = position.w;
		dif2 = position.h;
		dif3 = position.y;

		me.__move_handler = function(evn){
			var Y = evn.clientY,
				X = evn.clientX;

			Y = Y<0?0:Y;
			X = X<0?0:X;

			var size2 = dif2 - Y + difY;
			if (size2<me.__defaultSizeOptions.minHeight){
				Y = dif2 - me.__defaultSizeOptions.minHeight + difY;
                size2 = me.__defaultSizeOptions.minHeight;
			}

			var size3 = dif3 + Y - difY;

			var size1 = dif1 + X - difX;
            	size1 = size1<me.__defaultSizeOptions.minWidth?me.__defaultSizeOptions.minWidth:size1;

			me._place('',size3,size1,size2);

			/*** resize event ***/
			if (me._onresize) me._onresize(e,'rt');
			me.__exeEvent('onresize',e,{"owner":me,"main":me._main,"body":me.__eContainer,"type":'rt'});
		};

		break;
	}

	if (this.__move_handler && this.__move_handler!= null)
		me._gui._obeyEvent('mousemove',[this,'__move_handler']);
};

_me._title = function(sVal,bText){
	if (typeof sVal == 'undefined')
		return this.__eTitle.innerHTML;
	else {
		if (bText)
			this.__eTitle.innerHTML = sVal?sVal.escapeHTML():'';
		else{
			var tmp = getLang(sVal);
			this.__eTitle.innerHTML = tmp?tmp.escapeHTML():'';
		}
		if (this.__detached) {
			this.__detached.document.title = this.__eTitle.innerHTML;
		}
		if (this._docked) {
			gui.frm_main.dock._setTitle(this, this.__eTitle.innerHTML);
		}
	}
};

_me._close = async function(b, e) {
	if (!this.__closable || (this._onclose && !await this._onclose(b, e))) return false;
    this._remove_destructor('_onclose');
	this._destruct();
	return true;
};

_me._focus = function (bSoft){
	if (this.__detached || (this._docked && this._undock()))
		return;

	// Remove previous z-index and assign new top value
	maxZIndex.remove(this.__zindex);
	this.__zindex = maxZIndex.get();

	// modal window
	/*if (this._isModal()){
		this.__eContainer.style.zIndex = this.__zindex + 1000/;
		if (this.__modaldiv){
			this.__modaldiv.style.zIndex = (this.__zindex + 1000 - 1);
		}
	}
	else*/
		this.__eContainer.style.zIndex = this.__zindex;
		if (this.__modaldiv){
			this.__modaldiv.style.zIndex = this.__zindex - 1;
		}

	// Remove docked windows from active windows stack
	obj_popup.activeStack.add(this);

	// Execute any specific focus action
	if (this._onfocus)
		this._onfocus();

	// Make sure that any modal windows always stays atop
	if (!this.__modaldiv)
		obj_popup.activeStack.order();

	this._activate();
	if (!bSoft) {
		(this._main.ownerDocument.defaultView || window).focus();
	}
};

_me._activate = function(){
	if (!hascss(this._main, 'active')){
		addcss(this._main, 'active');

		var pops = this._gui._main.querySelectorAll('div.obj_popup');
		for(var i = pops.length; i--;){
			if (this._main !== pops[i])
				removecss(pops[i], 'active');
		}
	}
};

_me._isModal = function(){
	return this.__modaldiv?true:false;
};

_me._modal = function(b){

	this._dockable(!b);

	if(b && !this.__modaldiv){
		// Remove previous z-index and assign new top value
		maxZIndex.remove(this.__zindex);
		this.__zindex = maxZIndex.get();

		this.__eContainer.style.zIndex = this.__zindex/* + 1000*/;

		//modal window
		this.__modaldiv = mkElement("div");
		this.__modaldiv.style.zIndex = this.__zindex/* + 1000*/ - 1;
		this._main.insertBefore(this.__modaldiv,this.__eContainer);

		this.__modaldiv.className = 'obj_popup_modaldiv';

		addcss(this._main,'modal');
	}
	else
	if(!b && this.__modaldiv){
		this._main.removeChild(this.__modaldiv);
		this.__modaldiv = null;

		this.__eContainer.style.zIndex = this.__zindex;

		removecss(this._main,'modal');
	}
};

_me._maximize = function(bForcedIsMaximized){

	if (this.__resizable==false) return;

	if (bForcedIsMaximized === false || (bForcedIsMaximized === void 0 && this.__position.max)){
		this.__moveble	= true;
		this.__position.max = 0;
		removecss(this.__eContainer,'maximized');
		gui.tooltip._add(this._getAnchor('max'), getLang('POPUP_ITEMS::MAXIMIZE'))

		this._place(this.__position.x,this.__position.y,this.__position.w,this.__position.h, true);
	}
	else if(bForcedIsMaximized === true || bForcedIsMaximized === void 0) {

		this.__position.max = 1;
		this.__moveble	= false;

		addcss(this.__eContainer,'maximized');
		gui.tooltip._add(this._getAnchor('max'), getLang('POPUP_ITEMS::RESTORE'))

		// if (obj_popup._oldPositioning){
			this.__eContainer.style.left = '0';
			this.__eContainer.style.top = '0';
		// }
		// else
		// 	this.__eContainer.style.transform = 'translate(0,0)';

		this.__eContainer.style.height = '100%';
		this.__eContainer.style.width = '100%';

		if (!this.__eContainer.style.visibility)
			this.__eContainer.style.visibility = 'visible';
	}
};

_me._defaultSize = function(w, h, aOptions) {
	var x = -1;
	var y = -1;

	this.__defaultSizeOptions = aOptions = Object.assign(this.__defaultSizeOptions, aOptions || {});

	if (aOptions.goldenRatio) {
		var goldenRatio = 1.618;
		var newW = this._main.ownerDocument.body.clientWidth / goldenRatio;
		if(newW > w) {
			w = newW;
		}
		var newH = this._main.ownerDocument.body.clientHeight / goldenRatio;
		if(newH > h) {
			h = newH;
		}
	}

	if (GWOthers.getItem('LAYOUT_SETTINGS', 'remember_popup_position') == 1) {
		this.__defaultSize = {x:x,y:y,w:w,h:h,max:aOptions.maximized};

		var aSize = Cookie.get(['popup_' + this._type, screen.width + 'x' + screen.height]);

		if (aSize) {
			if (Is.Defined(aSize.x) && (x = parseInt(aSize.x) || 0))
				x = Math.max(0, x);

			if (Is.Defined(aSize.y) && (y = parseInt(aSize.y) || 0))
				y = Math.max(0, y);

			if (aSize.w && (w = parseInt(aSize.w)))
				w = Math.max(200, w);

			if (aSize.h && (h = parseInt(aSize.h)))
				h = Math.max(88, h);

			if (aSize.max)
				aOptions.maximized = !!aSize.max;
		}

		// register function that will store current size
		this._add_destructor('__rememberSize');
	}

	this.__position.x = x;
	this.__position.y = y;
	this.__position.w = w;
	this.__position.h = h;
	this.__positionShadow = clone(this.__position);

	if (aOptions.maximized) {
		this._maximize();
	}
	else
	if ((Is.Number(x) && Is.Number(y) && x >= 0 && y >= 0) || aOptions.goldenRatio) {
		// Shift non-modal popups, set place
		this._placeShift();
	}
	else
	if (Is.Number(w) && w > 0) {
		if (Is.Number(h) && h > 0)
			this._size(w,h,true);
		else
			this._size(w,'',true);

		// Shift non-modal popups
		this._placeShift(true);
	}
};

_me.__rememberSize = function(){
	var tmp = clone(this.__position);

	for (var i in tmp) {
		if (tmp[i] == this.__defaultSize[i]) {
			delete tmp[i];
		}
	}

	Cookie.set(['popup_' + this._type, screen.width + 'x' + screen.height], tmp);
};

/**
 * @param {bool} bShiftOnly		do not set new position when no shift detected
 */
_me._placeShift	= function(bShiftOnly){

	var bForced = true;
	var x = this.__position.x,
		y = this.__position.y,
		w = this.__position.w,
		h = this.__position.h;

	if (!this._isModal()){
		//Get all instances
		var aPop = this._gui._getChildObjects('main', this._type),
			iH = this._gui._main.offsetHeight,
			iW = this._gui._main.offsetWidth,
			bShifted = false;

		for (var i = aPop.length; i--;){
			if (aPop[i] !== this && !aPop[i]._destructed && !aPop[i]._docked){

				if (x == aPop[i].__position.x && y == aPop[i].__position.y){

					x = aPop[i].__positionShadow.x + 30;
					y = aPop[i].__positionShadow.y + 30;

					if (iH<y+h || iW<x+w){
						y = 30;
						x = 30;
					}

					this.__positionOffset.x = x - this.__position.x;
					this.__positionOffset.y = y - this.__position.y;

					bShifted = true;
					break;
				}
			}
		}
	}

	if (!bShiftOnly || bShifted){
		if (Is.Number(w) && w > 0) {
			if (Is.Number(h) && h > 0)
				this._place(x,y,w,h,bForced);
			else
				this._place(x,y,w, undefined, bForced);
		}
		else
			this._place(x,y, undefined, undefined, bForced);
	}
};

_me._place = function(x,y,w,h, bForce){

	if (this.__position.max || !Is.Defined(x) && !Is.Defined(y) && !Is.Defined(w) && !Is.Defined(h))
		return this.__position;

	//User initialized, will be saved
	if (!bForce){

		//reset offset when user change position
		this.__positionOffset = {};

		if (Is.Number(x)){
			if (x>=0){
				this.__positionShadow.x = x;
			}

			this.__position.x = x;
		}

		if (Is.Number(y)){
			if (y>=0){
				this.__positionShadow.y = y;
			}

			this.__position.y = y;
		}

		if (Is.Number(w)){
			this.__positionShadow.w = w;
			this.__position.w = w;
		}

		if (Is.Number(h)){
			this.__positionShadow.h = h;
			this.__position.h = h;
		}
	}
	else{

		var iH = this._gui._main.offsetHeight,
			iW = this._gui._main.offsetWidth,
			tmp_w = w, tmp_h = h;

		//check Width
		if (w == 'auto'){
			this.__eContainer.style.width = 'auto';
			tmp_w = this.__eContainer.offsetWidth;
		}
		//center X
		if (x<0){
			x = Math.round(Math.max(0, (this._main.ownerDocument.body.clientWidth - tmp_w)/2));
		}
		if (x+tmp_w>iW){
			if (tmp_w>iW){
				tmp_w = w = Math.max(200, iW);
			}

			x = Math.max(0, iW-tmp_w);
		}

		this.__positionShadow.x = x;
		this.__positionShadow.w = w;

		//check Height
		if (h == 'auto'){
			this.__eContainer.style.height = 'auto';
			tmp_h = this.__eContainer.offsetHeight;
		}
		//center Y
		if (y<0){
			y = Math.round(Math.max(0, (this._main.ownerDocument.body.clientHeight - tmp_h)/2));
		}
		if (y+tmp_h>iH){
			if (tmp_h>iH){
				tmp_h = h = Math.max(88, iH);
			}

			y = Math.max(0, iH-tmp_h);
		}

		this.__positionShadow.y = y;
		this.__positionShadow.h = h;
	}

	if (Is.Empty(this.__position) || bForce)
		this.__position = clone(this.__positionShadow);

	// if (obj_popup._oldPositioning){
		this.__eContainer.style.left = this.__positionShadow.x +'px';
		this.__eContainer.style.top = this.__positionShadow.y +'px';
	// }
	// else
	// 	this.__eContainer.style.transform = 'translate('+ Math.floor(this.__positionShadow.x) +'px,'+ Math.floor(this.__positionShadow.y) +'px)';

	this.__eContainer.style.height = Is.Number(this.__positionShadow.h) ? this.__positionShadow.h + 'px' : this.__positionShadow.h;
	this.__eContainer.style.width = Is.Number(this.__positionShadow.w) ? this.__positionShadow.w + 'px' : this.__positionShadow.w;


	// Container is initially hidden, until size is defined so is clear what to show
	if (!this.__eContainer.style.visibility)
		this.__eContainer.style.visibility = 'visible';
};


/**
 * @brief: destructor
 * bDirect - do no conversion
 **/
_me._size = function (w, h, center, bDirect){

	w = Is.Defined(w)?w:this.__positionShadow.w;
	h = Is.Defined(h)?h:this.__positionShadow.h;

	if (center)
		this._place(-1, -1, w, h, !bDirect);
	else
		this._place(this.__positionShadow.x, this.__positionShadow.y, w, h, !bDirect);
};

_me.__checkPosition = function(){
	if (!this.__position.max)
		this._place(this.__position.x + (this.__positionOffset.x || 0), this.__position.y + (this.__positionOffset.y || 0), this.__position.w, this.__position.h, true);
};


// Check whether the current popup is the topmost
_me._isActive = function() {
	return this === obj_popup.activeStack.get();
};

/**
 * @brief: destructor
 * @date : 4.7.2006 14:38:46
 **/
_me.__destructor = async function(){
	await this._undock();
	this.__hideBlock();

	// remove object's zindex
	maxZIndex.remove(this.__zindex);

	// Remove docked windows from active windows stack
	obj_popup.activeStack.remove(this);
	// Focus next window below the docked one
	obj_popup.activeStack.focusNext();

	this._gui._disobeyEvent('resize',[this,'__checkPosition']);
};

/**
 * @brief: onclose method
 **/
//_me._onclose = function(){}
