_me = obj_notifier_item.prototype;

function obj_notifier_item() {};

_me.__constructor = async function (aData) {
	this.__time = new Date();
	aData.time = this.__getTime();
	await this._draw('obj_notifier_item', '', aData);

	this._main.addEventListener('click', function () {
		aData.onclick && aData.onclick();
	});

	this.__activateQuickReply(aData);
};

_me.__activateQuickReply = function (aData) {
	var quick_reply = this._getAnchor('quick_reply');
	if (!quick_reply || !aData.quick_reply) {
		return;
	}

	this.show_reply._onclick = function (e) {
		e.stopPropagation();
		removecss(quick_reply, 'hidden');
		addcss(this.show_reply._main, 'hidden');
		this.input._focus();
		addcss(this._main, 'no-truncate');
	}.bind(this);
	this.reply._onclick = function (e) {
		e.stopPropagation();
		var value = this.input._value().trim();
		if (value) {
			aData.quick_reply(value);
			this.input._value('');
			addcss(quick_reply, 'hidden');
			removecss(this.show_reply._main, 'hidden');
			removecss(this._main, 'no-truncate');
		}
	}.bind(this);
	this.input._onkeydown = function (e) {
		if (e.key === 'Enter') {
			this.reply._onclick(e);
		}
		if (e.key === 'Escape') {
			this.input._value('');
			addcss(quick_reply, 'hidden');
			removecss(this.show_reply._main, 'hidden');
			removecss(this._main, 'no-truncate');
		}
	}.bind(this);
	this.input._onclick = function (e) {
		e.stopPropagation();
	};
};

_me.__updateTime = function () {
	this._getAnchor('time').innerText = this.__getTime();
};

_me.__getTime = function () {
	var date = new Date(this.__time);
	var diff = Math.floor((new Date() - date) / 1000);
	if (diff < 10) {
		return getLang('NOTIFICATION::NOW');
	} else if (diff < 60) {
		return getLang(diff === 1 ? 'NOTIFICATION::SECOND_AGO' : 'NOTIFICATION::SECONDS_AGO', [diff]);
	} else if (diff < 60 * 60) {
		var minutes = Math.floor(diff / 60);
		return getLang(minutes === 1 ? 'NOTIFICATION::MINUTE_AGO' : 'NOTIFICATION::MINUTES_AGO', [minutes]);
	} else if (diff < 60 * 60 * 12) {
		var hours = Math.floor(diff / 60 / 60);
		return getLang(hours === 1 ? 'NOTIFICATION::HOUR_AGO' : 'NOTIFICATION::HOURS_AGO', [hours]);
	} else {
		return CalendarFormatting.normalWithTime(new IcewarpDate(date));
	}
};
