_me = obj_notifier.prototype;

function obj_notifier() {};

_me.__constructor = async function () {

	this.__isActive = false;

	await this._draw('obj_notifier', 'main');
	this.__unique = {};

	this.__setPosition();
	gui._obeyEvent('settings_changed', [this, '__setPosition']);
	gui._obeyEvent('activeWindowChange', [this, '__changeParentWindow']);

	this.__preload();
};

_me.__preload = function() {
	if (!this.___preload) {
		this.___preload = document.head.appendChild(mkElement('link', {
			rel: 'preload',
			as: 'image',
			href: './client/skins/default/images/offline.svg'
		}));

		var img = mkElement('img', {
			src: './client/skins/default/images/offline.svg',
			style: {
				opacity: 0,
				position: 'absolute'
			}
		});
		document.body.appendChild(img);
		document.body.removeChild(img);
	}
};

_me._active = function(b){
	if (Is.Boolean(b)){
		if (b){
			this.__updTime = setInterval(this.__updateTime.bind(this), 10000);
			this.__updateTime();
		}
		else
		if (this.__updTime)
			clearInterval(this.__updTime);

		this.__isActive = b;
	}
	else
		return this.__isActive;
};

_me.__changeParentWindow = function(win) {
	win.gui._main.appendChild(this._main);
};

_me.__setPosition = function () {
	var position = this.__getPositionClassName();

	this._main.classList.remove('top', 'bottom', 'left', 'right', 'center');
	this._main.classList.add(position[0], position[1]);

	var menu = document.querySelector('#gui\\.frm_main > .box > .menu');
	this._main.style.marginTop = !~position.indexOf('top') ? 0 :
		((document.querySelector('.obj_banner') || {}).clientHeight || 0) +
		(menu ? menu.clientHeight : 0) + 'px';
};

_me.__getPositionClassName = function () {
	var position = GWOthers.getItem('LAYOUT_SETTINGS','notification_position');
	if(isNaN(position)) {
		return ['top', gui._rtl ? 'left' : 'right'];
	}
	switch (+position) {
		case 1:
			return ['top', 'left'];
		case 2:
			return ['top', 'center'];
		case 3:
			return ['bottom', 'right'];
		case 4:
			return ['bottom', 'left'];
		case 5:
			return ['bottom', 'center'];
	}
	return ['top', 'right'];
};

_me.__updateTime = function () {
	this._getChildObjects().forEach(function(notification) {
		notification.__updateTime();
	});
};

_me._closeNotification = function (notification, bSkipOncloseCallback) {
	if (!(notification.element || {}).parentNode) {
		return;
	}
	clearTimeout(notification.timeout);
	clearInterval(notification.interval);
	this.__cmenu && this.__cmenu._destruct();
	var event = browserEvent('transitionend');
	if (event && notification.type !== 'request_error' && !bSkipOncloseCallback) {
		var transition_callback = function () {
			if (!notification.element || !notification.element.parentNode) {
				return;
			}
			notification.element.removeEventListener(event, transition_callback);
			notification.element.parentNode.removeChild(notification.element);
		};
		notification.element.addEventListener(event, transition_callback);
		notification.element.classList.add('closing');
		setTimeout(function () {
			notification.element.parentNode && notification.element.parentNode.removeChild(notification.element);
			notification.element = void 0;
		}, 400);
	} else {
		notification.element.parentNode && notification.element.parentNode.removeChild(notification.element);
		notification.element = void 0;
	}

	var v = notification.value;
	if (v.args && v.args.callback && v.args.callback.onclose && !bSkipOncloseCallback) {
		v.args.callback.onclose.call(v.args.callback.context);
	}

	if (notification.unique) {
		delete this.__unique[notification];
	}
};

/*
	Notification object
	@RFC: http://www.w3.org/TR/notifications/

	Attributes:
		iconUrl - src string (PNG)
		body	- string
		tag		- string (notification are collapsed by this string)

	Methods:
		onclick
		onerror
		onshow
		onclose
*/
_me._value2 = function (v, oNotification) {
	var notification = {
		type: this.__getNotificationType(v.type),
		value: v,
		close: function() {
			this._closeNotification(notification)
		}.bind(this)
	};
	notification.element = this.__makeNotificationElement(v, notification);

	this.__setPosition();
	if (oNotification) {
		this._main.replaceChild(notification.element, oNotification.element);
	} else {
		if(+GWOthers.getItem('LAYOUT_SETTINGS','notification_position') >= 3) {
			this._main.appendChild(notification.element); // bottom
		} else {
			this._main.insertBefore(notification.element, this._main.firstChild); // top
		}
	}

	if (!~this.__sticky.indexOf(v.type) && !((v.args || {}).callback || {}).retry) {
		notification.timeout = setTimeout(function () {
			this._closeNotification(notification);
		}.bind(this), v.args.interval * 1000 || 5000);
	}

	if (v.args && v.args.interval) {
		var timeleft = v.args.interval;
		notification.interval = setInterval(function () {
			switch (v.type) {
				case 'send_message':
					notification.element.querySelector('.text').innerHTML = this.__getNotificationText(v.type, {
						interval: --timeleft
					}, true);
					break;
				case 'request_error':
					if (v.args.code === 503) {
						notification.element.querySelector('.text').innerHTML = this.__getNotificationText(v.type, {}) + ' (' + (--timeleft) + ')';
					} else {
						notification.element.querySelector('.retry').innerHTML = getLang('FORM_BUTTONS::RETRY') + ' (' + (--timeleft) + ')';
					}
			}
			if (timeleft <= 0) {
				v.args.callback.success.call(v.args.callback.context);
				clearInterval(notification.interval);
				this._closeNotification(notification);
			}
		}.bind(this), 1000);
	}

	switch(v.type) {
		case 'reminder':
		case 'reminder_conference':
			var diff_end = +IcewarpDate.julian(v.args.enddate, v.args.endtime) - +new IcewarpDate();
			if (diff_end < -5 * 60 * 1000) {
				WMItems.reminders({rid: [v.args.rid]}, [function() {
					dataSet.remove('reminders', null, true);
					gui.frm_main.__RMN_get();
				}]);
				this._closeNotification(notification);
			} else {
				var diff_start = +IcewarpDate.julian(v.args.startdate, v.args.starttime) - +new IcewarpDate();
				if (diff_start > 0) {
					notification.interval = setInterval(function() {
						var diff_end = +IcewarpDate.julian(v.args.enddate, v.args.endtime) - +new IcewarpDate();
						if (diff_end < -5 * 60 * 1000) {
							this._closeNotification(notification);
						} else {
							var data = this.__getNotificationData(v.type, v.args);
							var element = this.__makeNotificationElement(data, notification);
							notification.element.parentNode.replaceChild(element, notification.element);
							notification.element = element;
						}
					}.bind(this), 60 * 1000);
				}
			}
			break;
	}

	notification.unique = v.unique;

	return notification;
};

_me.__makeNotificationElement = function(v, notification) {
	return mkElement('div', {
		className: 'container'
	}, false, [
		mkElement('div', {
			className: 'notification ' + (v.type || '') + (v.class ? ' ' + v.class : ''),
			onclick: function () {
				if (v.onclick) {
					if (v.onclick() !== false) {
						this._closeNotification(notification);
					}
				}
			}.bind(this),
			onmouseenter: function () {
				if (!v.args.interval) {
					clearTimeout(notification.timeout);
				}
			}.bind(this),
			onmouseleave: function () {
				if (!~this.__sticky.indexOf(v.type) && !((v.args || {}).callback || {}).retry) {
					notification.timeout = setTimeout(function () {
						this._closeNotification(notification);
					}.bind(this), 2000);
				}
			}.bind(this)
		}, false, [
			mkElement('div', {
				className: 'icon' + (v.avatar ? ' avatar' : '')
			}, false, [ v.avatar ]),
			mkElement('div', {
				className: 'content'
			}, false, [
				v.header && mkElement('div', {
					className: 'header',
					title: v.header,
					text: v.header
				}),
				v.text && mkElement('div', {
					className: 'text',
					innerHTML: v.html
				}),
				v.subtext && mkElement('div', {
					className: 'subtext',
					text: v.subtext
				})
			].filter(Boolean)),
			v.buttons.length && mkElement('div', {
				className: 'buttons'
			}, false, v.buttons.map(function (button) {
				return mkElement('div', {
					className: 'button' + (button.className ? ' ' + button.className : ''),
					textContent: button.text,
					onclick: async function (e) {
						e.preventDefault();
						e.stopPropagation();
						if (!button.onclick || await button.onclick(e, this._closeNotification.bind(this, notification)) !== false) {
							this._closeNotification(notification);
						}
					}.bind(this)
				});
			}, this))
		].filter(Boolean))
	]);
}

_me.__sticky = ['conference_invite', 'send_message', 'reminder', 'reminder_conference', 'send_after_upload', 'offline', 'upload_status'];

_me.__getNotificationHeader = function (type, args) {
	args = args || {};
	switch (type) {
		case 'im':
			return dataSet.get('xmpp', ['roster', args.jid, 'name']) || args.jid;
		case 'teamchat':
			return args.data['ORIGINATOR-NAME'] || args.data.NAME || args.data['ORIGINATOR-EMAIL'] || args.data.EMAIL;
		case 'sip':
			return getLang(args.header ? args.header : 'SIP::SIP');
		case 'document_added':
		case 'document_edited':
			return args.data['ORIGINATOR-NAME'] || args.data['ORIGINATOR-EMAIL'];
		case 'alert':
			return args.header_plain ? args.header_plain : getLang(args.header ? args.header : 'ALERTS::ALERT');
		case 'reminder':
		case 'reminder_conference':
			return args.title;
		case 'new_email':
			return getLang('NOTIFICATION::NEW_EMAIL', [WMFolders.getFolderPath(args)]);
		case 'offline':
			return getLang('NOTIFICATION::OFFLINE_HEADER');
		case 'request_error':
			return getLang('ERROR::SOMETHING_WENT_WRONG');
		case 'upload_status':
			var uploading = 1;
			args.files.forEach(function(completed, file) {
				if (file.size <= completed) {
					uploading++;
				}
			});
			if (uploading > args.files.size) {
				uploading = args.files.size;
			}
			return getLang('NOTIFICATION::UPLOADING', [args.files.size === 1 ? args.files.keys().next().value.name : getLang('NOTIFICATION::UPLOAD_COUNT_FILES', [uploading, args.files.size])])
		case 'success':
		default:
			return args.header_plain ? args.header_plain : args.header ? getLang(args.header) : '';
	}
};

_me.__getNotificationButtons = function (type, args) {
	var buttons = [];
	var addCloseButton = true;

	function reminderCallback() {
		dataSet.remove('reminders', null, true);
		gui.frm_main.__RMN_get();
	}

	switch (type) {
		case 'conference':
		case 'conference_invite':
			buttons.push({
				className: 'accept',
				text: getLang('EVENT::JOINCONFERENCE'),
				onclick: async function () {
					await storage.library('wm_conference');
					wm_conference.get(args.conferenceid).join();
				}
			});
			break;
		case 'send_message':
			buttons.push({
				text: getLang('FORM_BUTTONS::UNDO'),
				onclick: function (e, closeNotification) {
					args.callback.cancel.call(args.callback.context);
					closeNotification();
				}
			}, {
				className: 'close',
				text: getLang('COMPOSE::SEND_NOW'),
				onclick: function (e, closeNotification) {
					e.preventDefault();
					e.stopPropagation();
					e.stopImmediatePropagation();
					args.callback.success.call(args.callback.context);
					closeNotification();
				}
			});
			addCloseButton = false;
			break;
		case 'reminder':
		case 'reminder_conference':
			var diff = (+IcewarpDate.julian(args.startdate, args.starttime) - +new IcewarpDate()) / 1000;
			if (type === 'reminder_conference' && diff < 60 * 10) {
				buttons.push({
					text: getLang('EVENT::JOINCONFERENCE'),
					className: 'accept',
					onclick: async function() {
						await storage.library('wm_conference');
						wm_conference.get(args.conferenceid).join();
						WMItems.reminders({rid: [args.rid]}, [function() {
							dataSet.remove('reminders', null, true);
							gui.frm_main.__RMN_get();
						}]);
					}
				});
			} else {
				buttons.push({
					text: getLang('REMINDER::SNOOZE'),
					onclick: async function (e, closeNotification) {
						this.__cmenu = await gui._create("cmenu", "obj_context", '', 'notifier', this);
						var aMenu = [
							diff > 0 && { text: getLang('EVENT::AT_EVENT_TIME'), arg: 'start'},
							{ text: '5 ' + getLang('TIME::MINUTES'), arg: 5},
							{ text: '15 ' + getLang('TIME::MINUTES'), arg: 15},
							{ text: '30 ' + getLang('TIME::MINUTES'), arg: 30},
							{ text: '1 ' + getLang('TIME::HOURS'), arg: 60},
							{ text: getLang('CALENDAR::TOMORROW'), arg: 1440},
							{ text: getLang('CALENDAR::NEXT_WEEK'), arg: 10080},
						].filter(Boolean).map(function(item) {
							item.css = 'ico';
							item.arg = [function(snooze) {
								if (snooze === 'start') {
									snooze = (+IcewarpDate.julian(args.startdate, args.starttime) - +new IcewarpDate()) / 1000 / 60;
								}
								WMItems.reminders({rid: [args.rid], snooze: snooze}, [reminderCallback]);
								closeNotification();
							}.bind(null, item.arg)];
							return item;
						}).concat([{ title: '-'},
							{
								text: getLang('TIME::CUSTOM'),
								css: 'ico2 time',
								arg: [async function() {
									gui.notifier._main.style.zIndex = 500;
									var popup = await gui._create('frm_reminders', 'obj_popup', '', 'frm_reminders always_on');
									popup._modal(true);
									popup._resizable(false);
									popup._dockable(false);

									await popup._create('btn_ok', 'obj_button', 'footer', 'ok noborder color1');
									popup.btn_ok._value('FORM_BUTTONS::OK');
									await popup._create('btn_cancel', 'obj_button', 'footer', 'cancel noborder');
									popup.btn_cancel._value('FORM_BUTTONS::CANCEL');

									popup._onclose = function(){
										gui.notifier._main.style.zIndex = '';
										return true;
									};

									popup.btn_cancel._onclick = function () {
										popup._destruct();
									};

									popup._title('REMINDER::REMINDER');
									await popup._create('X_REMINDERS', 'obj_reminder', 'main', '', 'EVENT_SETTINGS');
									popup.X_REMINDERS.checkbox_1._title('REMINDER::REMIND_IN');
									popup.X_REMINDERS._value([{}]);
									popup.X_REMINDERS.reminder_1._getAnchor('label2').innerHTML = '';
									popup.btn_ok._onclick = function () {
										var rem_value = ((popup.X_REMINDERS._value() || [])[0] || {values: { RMNDAYSBEFORE: 0, RMNHOURSBEFORE: 0, RMNMINUTESBEFORE: 0 }}).values;
										var snooze = rem_value.RMNDAYSBEFORE * 1440 + rem_value.RMNHOURSBEFORE * 60 + rem_value.RMNMINUTESBEFORE;
										if (popup.X_REMINDERS.checkbox_1._checked()) {
											WMItems.reminders({rid: [args.rid], snooze: snooze}, [reminderCallback]);
											closeNotification();
										}
										popup._destruct();
									};

									popup.X_REMINDERS.reminder_1.time.x_text._onerror = function(error) {
										popup.btn_ok._disabled(error);
									};
									popup._size(420, 'auto', true);
								}]
							}
						]);

						await this.__cmenu._fill(aMenu);
						var bcr = e.target.getBoundingClientRect();
						this.__cmenu._place(bcr.left, bcr.top + bcr.height / 2);
						return false;
					}.bind(this)
				});
			}
			buttons.push({
				className: 'decline',
				text: getLang('REMINDER::DISMISS'),
				onclick: function () {
					WMItems.reminders({rid: [args.rid]}, [reminderCallback]);
				}
			});
			addCloseButton = false;
			break;
		case 'message_sent':
		case 'send_message_deferred':
			sPrimaryAccountDELIVERY && args[0] && buttons.push({
				text: getLang('ITEMVIEW::DETAILS'),
				onclick: function () {
					gui._create('frm_delivery', 'frm_delivery', '', '', '', args[0]);
				}
			});
			break;
		case 'item_moved':
			(args.callback || {}).undo && buttons.push({
				text: getLang('FORM_BUTTONS::UNDO'),
				onclick: function() {
					delete args.callback.onclose;
					args.callback.undo.call(args.callback.context);
				}
			});
			break;
		case 'email_snoozed':
			args.undo && buttons.push({
				text: getLang('FORM_BUTTONS::UNDO'),
				onclick: args.undo
			});
			break;
		case 'request_error':
			args.callback.retry && buttons.push({
				text: getLang('FORM_BUTTONS::RETRY') + ' (' + args.interval + ')',
				onclick: args.callback.retry,
				className: 'retry'
			});
			args.callback.cancel && buttons.push({
				text: getLang('FORM_BUTTONS::CANCEL'),
				onclick: args.callback.cancel,
				className: 'close',
			});
			addCloseButton = false;
			break;
		case 'send_after_upload':
			args.undo && buttons.push({
				text: getLang('FORM_BUTTONS::UNDO'),
				onclick: args.undo
			});
			addCloseButton = false;
			break;
		default:
			if (args.buttons) {
				args.buttons.forEach(function(button) {
					buttons.push(button);
				});
				addCloseButton = args.buttons.length < 2;
			}
			break;
	}

	if (addCloseButton) {
		buttons.push({
			className: 'close',
			text: getLang('FORM_BUTTONS::CLOSE')
		});
	}
	return buttons;
};

_me.__getNotificationText = function (type, args, bHTML) {

	var langBold = false,
		langKey = 'NOTIFICATION::' + type,
		langArr = args,
		sOut = '';

	switch (type) {
		case 'item_moved':
		case 'item_copied':
			var sType = {
				M: 'MESSAGE',
				E: 'EVENT',
				C: 'CONTACT',
				F: 'FILE',
				T: 'TASK',
				N: 'NOTE'
			}[WMFolders.getType(args)] || 'ITEM';
			if (args.iid === '*') {
				sType = 'ALL_' + sType + 'S';
			} else if (args.iid.length > 1) {
				sType += 'S';
			}
			sType += (type === 'item_moved' ? '_MOVED' : '_COPIED');

			langKey = 'NOTIFICATION::' + sType;
			langArr = [WMFolders.getFolderPath({ aid: args.aid_from, fid: args.fid_from }), WMFolders.getFolderPath(args), args.iid.length];
			langBold = true;
		break;
		case 'email_snoozed':
		case 'email_unsnoozed':
			if (args.iid.length > 1) {
				type = type.replace('_', 's_');
			}
			langKey = 'NOTIFICATION::' + type;
			langArr = [args.iid.length];
		break;
		case 'item_saved':
			var folder = dataSet.get('folders', args);

			if (folder && folder.TYPE && !folder.VIRTUAL) {
				switch (folder.TYPE) {
					case 'F':
					case 'C':
					case 'E':
						langKey = 'NOTIFICATION::ITEM_SAVED_' + folder.TYPE;
						break;

					default:
						langKey = 'NOTIFICATION::ITEM_SAVED_TO';
						break;
				}

				langArr = [folder.NAME || folder.RELATIVE_PATH];
				langBold = true;
			}
			break;

		case 'new_email':
			return args.emails.map(function(email) {
				return [
					(email.from || '').replace(/(^")|("$)/g, '').escapeHTML(),
					email.subject ? '<b>' + email.subject.escapeHTML() + '</b>' : ''
				].filter(Boolean).join(' - ');
			}).filter(Boolean).join('<br />');
		case 'invitation_sent':
			langBold = true;
			break;

		case 'reminder':
		case 'reminder_conference':
			if (!+args.startdate) {
				return;
			}
			sOut = CalendarFormatting.formatStartDate(args);
			break;

		case 'send_message_deferred':
			langArr = ["\r\n" + args[1].format('L'), args[1].format('LT')];
			langBold = true;
			break;

		case 'send_message':
			langArr = [args.interval];
			langBold = true;
			break;

		case 'document_added':
			sOut = getLang('NOTIFICATION::DOCUMENT_ADDED', [args.data.EVNTITLE || args.data.TITLE]);
			break;
		case 'document_edited':
			sOut = getLang('NOTIFICATION::DOCUMENT_EDITED', [args.data.EVNTITLE || args.data.TITLE]);
			break;

		case 'offline':
			sOut = getLang('NOTIFICATION::OFFLINE');
			break;

		case 'request_error':
			if (args.code === 503) {
				sOut = getLang('ERROR::OVERLOADED');
				break;
			}

		default:
			if (args.text_plain) {
				sOut = this.__substituteMentions(args.text_plain, (args.data || {}).MENTIONS);
			} else if (args.text) {
				langKey = args.text;
				langArr = args.args;
				langBold = true;
			}
			break;
	}

	//Convert to HTML for internal Notifier
	if (bHTML) {
		if (sOut.length)
			return sOut.toString().escapeHTML().replace(/(?:\r\n|\r|\n)/gm, '<br>');
		else
		if (Is.Array(langArr)) {
			//Escape all langArr
			langArr = langArr.map(function (v) {
				v = v.toString();
				if (v.length) {
					v = v.escapeHTML().replace(/(?:\r\n|\r|\n)/gm, '<br>');
					if (langBold)
						v = '<b>' + v + '</b>';
				}
				return v;
			});
		}
	} else
		//Plain text for system Notifier
		if (sOut.length)
			return sOut;

	return getLang(langKey.toUpperCase(), langArr, 2);
};

_me.__getNotificationSubtext = function (type, args) {
	switch (type) {
		case 'im':
			return getLang('NOTIFICATION::IM_HELPER');
		case 'teamchat':
			return getLang('NOTIFICATION::TEAMCHAT_HELPER', [this.__getRoomName(args.data.FOLDER)]);
		case 'document_added':
		case 'document_edited':
			return this.__getRoomName(args.FOLDER);
		case 'reminder_conference':
			var diff = (+IcewarpDate.julian(args.startdate, args.starttime) - +new IcewarpDate()) / 1000;
			if (diff < 0) {
				return getLang('CONFERENCE::STARTED');
			} else if (diff < 60*20) {
				return getLang('CONFERENCE::STARTS_IN', [getLang('CONFERENCE::MINUTES', [Math.ceil(diff / 60)])]);
			}
			break;
		case 'upload_status':
			return getLang('upload::show_details');
		default:
			if (args.subtext) {
				return getLang(args.subtext);
			} else if (args.subtext_plain) {
				return args.subtext_plain;
			}
	}
};

_me.__getRoomName = function (folder) {
	var room_name = '';
	if (folder) {
		folder = Path.slash(folder);

		var folders = dataSet.get('folders', [sPrimaryAccount]);
		for (var i in folders) {
			if (Path.slash(folders[i].RELATIVE_PATH) === folder) {
				room_name = folders[i].NAME || Path.slash(folders[i].RELATIVE_PATH).split('/').pop();
				break;
			}
		}
	}
	return room_name;
};

_me.__getNotificationAvatar = function (type, args) {
	switch (type) {
		case 'im':
			return obj_avatar.getAvatarElement({
				email: args.jid,
				name: args.name || args.jid,
				size: 40
			});
		case 'teamchat':
		case 'sip_canceled':
		case 'document_added':
		case 'document_edited':
			return obj_avatar.getAvatarElement({
				email: args.data['ORIGINATOR-EMAIL'] || args.data.EMAIL,
				name: args.data['ORIGINATOR-NAME'] || args.data.NAME,
				size: 40
			});

		case 'upload_status':
			return mkElement('div', {
				innerHTML: '<svg viewBox="0 0 40 40" class="circular-progress" style="--progress:0"><circle class="fg"></circle></svg>'
			}).firstChild;
	}
};

_me.__getNotificationType = function (type, args) {
	switch (type) {
		case 'item_saved':
			var folder = dataSet.get('folders', args);
			if (folder && folder.TYPE) {
				switch (folder.TYPE) {
					case 'C':
						return 'invitation_sent';
				}
			}
			break;
		case 'document_added':
		case 'document_edited':
			var sExtension = Path.extension(args.data.EVNTITLE || args.data.TITLE);
			switch(sExtension) {
				case 'doc': case 'dot': case 'docx':
				case 'docm': case 'dotx': case 'dotm':
				case 'docb': case 'odt': case 'rtf':
					type = 'document';
				break;

				case 'xls': case 'csv': case 'xlsx':
				case 'xla': case 'xlam': case 'xlsb':
				case 'ods': case 'xlsm':
				case 'xlt': case 'xltm': case 'xltx':
					type = 'spreadsheet';
				break;

				case 'ppt': case 'pptx': case 'odp':
				case 'pps': case 'ppsm': case 'ppsx':
				case 'pptm': case 'ppa': case 'ppam':
					type = 'presentation';
				break;

				case 'pdf':
					type = 'pdf';
				default:
					type = 'file';
				break;
			}
			return type;
	}
	return type;
};

_me.__getNotificationClass = function(type, args) {
	switch (type) {
		case 'item_moved':
		case 'item_copied':
			return ({
				M: 'message',
				E: 'event',
				C: 'contact',
				F: 'file',
				T: 'task',
				N: 'note'
			}[WMFolders.getType(args)] || 'item') + '_moved' + (type === 'item_moved' ? ' buttons-visible' : '');

		case 'email_snoozed':
		case 'email_unsnoozed':
		case 'send_after_upload':
			return 'email';
	}
	return args.className || '';
};

_me.__getNotificationAction = function(type, args) {
	switch(type) {
		case 'im':
			return function() {
				gui.frm_main.rslide.im.im._chat(args.jid);
			};
		case 'reminder':
		case 'reminder_conference':
			return function () {
				Item.openwindow([args.aid, args.fid, args.iid]);
				return false;
			};
		
		case 'teamchat':
		case 'document_added':
		case 'document_edited':
			return async function () {
				var aData = args.data || {},
					folder = Path.slash(aData.FOLDER || args.FOLDER),
					item = WMItems.__clientID(aData.ITEM || args.ITEM || ''),
					owner = args.EMAIL || aData.EMAIL,
					aFolders = dataSet.get('folders', [sPrimaryAccount]);
		
				if (folder && owner){
					for (var fid in aFolders){
						if ((!aFolders[fid].OWNER || aFolders[fid].OWNER === owner) && aFolders[fid].RELATIVE_PATH === folder) {
							//Show item in threads with highlight
							if (aData.COMEVNID){
								gui.frm_main._openTeamchatThread({aid:sPrimaryAccount, fid:fid, iid:item, EVNCOMEVNID:aData.COMEVNID});
							}
							//Show item in Room with highlight
							else{
								await gui.frm_main.bar.folders._setActive(sPrimaryAccount + '/' + fid);
		
								//scroll to teamchat item
								if (aFolders[fid].TYPE == 'I')
									await gui.frm_main._selectView({aid:sPrimaryAccount, fid:fid}, 'room_view', {until:item, highlight:true});
								else
									await gui.frm_main._selectView({
										aid: sPrimaryAccount,
										fid: fid
									});
		
								gui.frm_main.filter.__filter(aFolders[fid].TYPE);
							}
						}
					}
				}
			};

		case 'new_email':
			return async function() {
				await gui.frm_main._selectView(args);
				gui.frm_main.filter.__filter('M', false, true);
			};

		case 'request_error':
			return function() {
				return false;
			};

		default:
			return args.onclick;
	}
};

_me.__getNotificationData = function (type, args, aOptions) {
	args = args || [];
	return {
		type: this.__getNotificationType(type, args),
		class: ((aOptions || {}).css || '') + this.__getNotificationClass(type, args),
		avatar: this.__getNotificationAvatar(type, args),
		header: (this.__getNotificationHeader(type, args) || '').trim(),
		onclick: this.__getNotificationAction(type, args),
		text: this.__getNotificationText(type, args),
		html: this.__getNotificationText(type, args, true),
		buttons: this.__getNotificationButtons(type, args),
		subtext: this.__getNotificationSubtext(type, args),
		args: args
	};
};

_me.__getFirstLine = function (aOptions) {
	switch (aOptions.type) {
		case 'teamchat':
			return '<b>' + (aOptions.args.data['ORIGINATOR-NAME'] || aOptions.args.data.NAME || aOptions.args.data['ORIGINATOR-EMAIL'] || aOptions.args.data.EMAIL).escapeHTML() + '</b>';
		case 'sip_canceled':
			return '<b>' + (aOptions.args.data.NAME || aOptions.args.data.EMAIL).escapeHTML() + '</b> <i>' + getLang('NOTIFICATION::MISSED_CALL') + '</i>';
		case 'document_added':
			return getLang('NOTIFICATION::ADDED_DOCUMENT', [
				'<b>' + (aOptions.args.data['ORIGINATOR-NAME'] || aOptions.args.data['ORIGINATOR-EMAIL'] || aOptions.args.data.EMAIL).escapeHTML() + '</b>',
				'<i>' + (aOptions.args.data.EVNTITLE || aOptions.args.data.TITLE || '').escapeHTML() + '</i>'
			]);
		case 'document_edited':
			return getLang('NOTIFICATION::EDITED_DOCUMENT', [
				'<b>' + (aOptions.args.data['ORIGINATOR-NAME'] || aOptions.args.data['ORIGINATOR-EMAIL'] || aOptions.args.data.EMAIL).escapeHTML() + '</b>',
				'<i>' + (aOptions.args.data.EVNTITLE || aOptions.args.data.TITLE || '').escapeHTML() + '</i>'
			]);
	}
	return '';
};

_me.__getSecondLine = function (aOptions) {
	switch (aOptions.type) {
		case 'teamchat':
			return this.__substituteMentions(aOptions.args.text_plain || aOptions.args.text, aOptions.args.data.MENTIONS).escapeHTML();
	}
	return '';
};

_me.__getQuickReply = function (aOptions) {
	switch (aOptions.type) {
		case 'teamchat':
		case 'document_added':
		case 'document_edited':
			return function(message) {
				var aItemInfo = {
					values:{
						EVNNOTE: message,
						EVNSHARETYPE: 'U'
					}
				};
				var sFolder, folders = dataSet.get('folders', [sPrimaryAccount]);
				for (sFolder in folders) {
					if (folders[sFolder].OWNER === aOptions.args.data.EMAIL && folders[sFolder].RELATIVE_PATH === Path.slash(aOptions.args.data.FOLDER)) {
						break;
					}
				}
				aItemInfo.values.EVNCOMEVNID = aOptions.args.data.COMEVNID || aOptions.args.data.ITEM;
				WMItems.add([sPrimaryAccount, sFolder], aItemInfo,'','','', [function() {
					gui.notifier._value({type: 'success', args: { text_plain: getLang('notification::message_sent') }});
				}]);
			};
	}
};

_me.__substituteMentions = function (text, mentions) {
	text = text || '';
	if(!mentions) {
		return text;
	}

	var aMentions = parseParamLine(mentions),
		aMen = {};
	for (var id in aMentions) {
		aMen[aMentions[id].values.EMAIL] = {name:aMentions[id].values.NAME, email:aMentions[id].values.EMAIL};
	}
	return text.replace(/(@\[([^\]]{1,128})\])/g, function() {
		var name = arguments[2],
			email = name.indexOf('@') > -1 ? name : name + '@' + dataSet.get('main', ['domain']);

		if (aMen[email]){
			name = aMen[email].name || aMen[email].email;
		}

		return '@' + name;
	});
};

_me.__getIcon = function (aOptions) {
	switch(aOptions.type) {
		case 'document_added':
		case 'document_edited':
			return aOptions.data.type;
	}
	return aOptions.type;
};

_me.__getSystemNotificationBody = function(aOptions) {
	switch(aOptions.type) {
		case 'new_email':
			if (aOptions.args.emails.length > 1) {
				return getLang('NOTIFICATION::NEW_EMAIL_TEXT', [aOptions.args.emails.length]);
			}
			return aOptions.args.emails[0] ? (aOptions.args.emails[0].from || '').replace(/(^")|("$)/g, '') + ' - ' + (aOptions.args.emails[0].subject || '') : ' ';
	}

	return createTextVersion(aOptions.data.text, {
		linkProcess: function(href, linkText) {
			return linkText || href;
		},
		imgProcess: function() { return ''; }
	});
};

_me._value = function (aOptions, oNotification) {
	if (!aOptions || !aOptions.type || (aOptions.unique && this.__unique[aOptions.unique])) {
		return;
	}
	this.__unique[aOptions.unique] = true;
	var iSetting = parseInt(GWOthers.getItem('LAYOUT_SETTINGS', 'notifications') || 0, 10);

	aOptions.type = aOptions.type.toLowerCase();
	aOptions.timeout = (parseInt(aOptions.timeout || 3, 10) || 3) * 1000;
	aOptions.data = this.__getNotificationData(aOptions.type, aOptions.args, aOptions);
	aOptions.data.group = aOptions.group;

	if (aOptions.save) {
		aOptions.data.id = +new Date();
		aOptions.data.room = this.__getRoomName(aOptions.args.FOLDER || aOptions.args.data.FOLDER);
		aOptions.data.icon = this.__getIcon(aOptions);
		aOptions.data.first_line = this.__getFirstLine(aOptions);
		aOptions.data.second_line = this.__getSecondLine(aOptions);
		aOptions.data.quick_reply = this.__getQuickReply(aOptions);

		// create notification and move it to top
		if (!this.__isActive) {
			gui.frm_main.stat._unread('notify', true);
		}

		// await this._create('notification', 'obj_notifier_item', {element: this._getAnchor('content'), position: 'afterbegin'}, '', aOptions.data);

		if (this._onchange)	this._onchange();
	}

	if (!aOptions.browserOnly && (window.Notification && (iSetting == 1 || (iSetting == 0 && !gui.__focus)))) {
		if (this._value3({
			header: (aOptions.data.header + (aOptions.data.subtext ? ' \n(' + aOptions.data.subtext + ')' : '')) || ' ',
			body: this.__getSystemNotificationBody(aOptions) || aOptions.data.text,
			callback: aOptions.aHandler,
			timeout: aOptions.timeout,
			group: aOptions.group,
			icon: aOptions.data.icon
		}) !== false && this.__sticky.indexOf(aOptions.type) === -1) {
			if (oNotification) {
				oNotification.close();
			}
			return;
		}
	}

	// if (!aOptions.save) {
		return this._value2(aOptions.data, oNotification);
	// }
};

//http://www.w3.org/TR/notifications/
_me._value3 = function (oOptions) {

	var sTitle = oOptions.header,
		sBody = oOptions.body,
		aHandler = oOptions.callback,
		iTime = oOptions.timeout,
		sGroup = oOptions.group,
		sIcon = oOptions.icon ;

	if (!window.Notification || window.Notification.permission == 'denied') {
		return false;
	}

	if (window.Notification.permission == 'granted') {

		if (sTitle && !sBody && GWOthers.getItem('LAYOUT_SETTINGS', 'title')) {
			sBody = sTitle;
			sTitle = GWOthers.getItem('LAYOUT_SETTINGS', 'title');
		}

		var icon = mkElement('div', {
			className: 'icon'
		});
		var virtual = mkElement('div', {
			className: 'virtual ' + sIcon
		}, false, [icon]);
		gui.notifier._main.appendChild(virtual);
		var icon = getComputedStyle(icon, '::after').getPropertyValue('background-image').replace(/(url\(['"])|(['"]\))/g, '');
		gui.notifier._main.removeChild(virtual);

		var arg = {
			body: sBody || '',
			dir: "auto",
			//lang: "",
			tag: sGroup,
			icon: icon
		};

		var n = new Notification(sTitle || getLang('PRELOADER::LOADING'), arg);
		n.onclick = function () {
			//for Chrome
			window.focus();

			if (aHandler)
				try {
					executeCallbackFunction(aHandler);
				}
			catch (r) {
					console.log(this._name || false, r)
			}

			window.focus();

			//Safari likes this
			this.close();
		};
		n.onshow = function () {
			this._date = new IcewarpDate();

			if (iTime)
				setTimeout(function () {
					n.close();
				}, iTime);
		};

		//n.onerror;
		//n.onclose;
		return n;
	} else { //Ask for Permission
		window.Notification.requestPermission().then(function (perm) {
			if (perm == 'granted') {
				this._value3({
					header: sTitle,
					body: sBody,
					callback: aHandler,
					timeout: iTime,
					group: sGroup
				});
			}
		}.bind(this));

		return true;
	}
};

_me._getPermissions = function () {
	return (window.Notification || {}).permission || 'unsupported';
};