_me = obj_mailview.prototype;
function obj_mailview(){};

_me.__constructor = async function(sDataSet,sDataPath,bCheckActive){
	await storage.library('night_mode');
	await storage.library('short_url');
	await storage.library('textversion', 'textversion');
	var me = this;

	this._skipsaving = false;
	this._noupdate = false;

	this._checkActive = bCheckActive;

	this.__eHeader = this._getAnchor('header');
	this.__eSubject = this._getAnchor('subject');
	this.__eFrom = this._getAnchor('from');

	this.__FullHeaders = null;
	this.__HiddenImages = true;
	this.__TextBody = false;

	//Is Address Book available?
	var dgw = GWOthers.getItem('RESTRICTIONS', 'disable_gw_types');
	this.__ab_support = sPrimaryAccountGW>0 && (!dgw || dgw.indexOf('c')<0);

	//scrollbar
	this._scrollbar(this._getAnchor('block'),this._getAnchor('block').parentNode);

	//Skip images
	this.__imgarray = {};

	this.__eFrame = this._getAnchor('frame');
	this.__doc = this.__getDoc();
	this.__doc_base = document.querySelector('base').getAttribute('href');

	//Helping resize frame
	var eHelp = mkElement('iframe',{frameborder:0, marginheight:0, marginwidth:0, src:"", className:'helper', style: {height:'1px'}});
	this._main.appendChild(eHelp);
	eHelp.contentWindow.onresize = function (){
		if (this.__width != eHelp.offsetWidth){
			this.__width = eHelp.offsetWidth;
			me.__resize(true);
		}
	};

	//Events
	// Drag & Drop
	if (window.FormData){
		this.__getDoc().addEventListener("dragstart", function(){
			gui.frm_main.__filedrag = false;
		}, false);
		this.__getDoc().addEventListener("dragend", function(){
			gui.frm_main.__filedrag = true;
		}, false);
	}

	//Skip Images
	this._getAnchor('skip').onclick = function (){
		if(!me.__HTMLBody){
			me.__showHTML();
			this.style.display = 'none';
		}
	};
	//Show Images
	this._getAnchor('show').onclick = function (){
		me.__showImages();
	};

	//Deferred email
	this._getAnchor('deferred').onclick = function (){
		OldMessage.delivery_report([me.__aid, me.__fid, me.__iid]);
	};


	this.__eHeader.onclick = async function(e){
		var elm = e.target;

		if (elm.tagName == 'A') {
			if (elm.classList.contains('expand')) {
				return elm.parentElement.classList.remove('collapsed');
			}
			if (elm.rel){

				var aMail = MailAddress.splitEmailsAndNames(elm.rel);
				if (aMail && aMail[0]){

					//Certificate
					try{
						var aCert;
						if (me.__header_cert && me.__header_cert.values.TYPE.toLowerCase() == 'certificate' && (me.__header_cert.values.CERT.INFO[0].SUBJECT[0].EMAILADDRESS && me.__header_cert.values.CERT.INFO[0].SUBJECT[0].EMAILADDRESS[0].VALUE.toLowerCase() == aMail[0].email.toLowerCase()))
							aCert = [{values:{'class':'item','fullpath':me.__aid +'/'+ me.__fid +'/'+ WMItems.__serverID(me.__iid)}}];
					}
					catch(r){ console.log(this._name||false,r);}

					elm && elm.classList && elm.classList.add('selected');
					var pos = getSize(elm),
						cmenu = await gui._create('cmenu','obj_context_link','','',aMail[0].name,aMail[0].email,aCert,undefined,me._recipients);
					cmenu._place(pos.x+(pos.w/2),pos.y+pos.h,'',2);

					cmenu.__remove_class = function() {
						elm && elm.classList && elm.classList.remove('selected');
					};
					cmenu._add_destructor('__remove_class');
				}


				e.preventDefault();
				e.stopPropagation();
			}
		}
	};

	this.__eHeader.oncontextmenu = function(e){

		var elm = e.target;

		if (elm.tagName == 'A' && hascss(elm,'address') && elm.rel) {
			this.__eHeader.onclick(e);
		} else {
			this._getAnchor('message').oncontextmenu(e);
		}

		var selection, range;
		if (!((selection = window.getSelection()) && selection.rangeCount && (range = selection.getRangeAt(0)) && !range.collapsed)) {
			e.preventDefault();
		}
	}.bind(this);

	this.__getDoc().body.onclick = async function() {
		this._gui.cmenu && this._gui.cmenu._destruct();
	}.bind(this);

	this._getAnchor('message').oncontextmenu = async function(e, frame){
		if (!me.__iid) {
			return;
		}
		var static_flags = dataSet.get('items', [me.__aid, me.__fid, me.__iid, 'STATIC_FLAGS']);

		var elm = e.target;
		if(elm.tagName === 'A' || elm.tagName === 'IMG' || elm.closest('a')) {
			return;
		}
		//In case of selection skip js menu
		try{
				var s = (frame ? frame.contentDocument : document).getSelection(),
				r = s.getRangeAt(0);

			if (((s.focusNode.parentNode || s.focusNode.parentElement) === elm || (elm === s.focusNode)) && r.startOffset !== r.endOffset || r.startContainer !== r.endContainer) {
				return;
			}
		}
		catch(r){ console.log(this._name||false,r);}

		if (!dataSet.get('folders',[me.__aid,me.__fid,'RSS'])){
			var pos = frame ? getSize(frame) : {x: 0, y: 0},
				cmenu = await gui._create('cmenu','obj_context','','mailview_menu');

			await cmenu._fill([
				{config:{css:'large'}},
				{title:'ATTACHMENT::SHOW_HEADERS', arg:[me,'__showHeaders'], css:(me.__FullHeaders?'ico2 check':'ico')},
				{title:'ATTACHMENT::SHOW_TEXT', arg:[me,'__showText',[!me.__TextBody]], css:(me.__TextBody?'ico2 check':'ico')},
				!(static_flags & 4) && !(static_flags & 8) && !(static_flags & 16) && !(static_flags & 32) && {title:'POPUP_ITEMS::SOURCE', arg:[function(){OldMessage.source([me.__aid,me.__fid,me.__iid])}], css:'ico'},
				!(static_flags & 4) && {title:'MAIN_MENU::PRINT', arg:[me,'_print'], css:('ico')},
				!(static_flags & 4) && {title:'-'},
				!(static_flags & 4) && !(static_flags & 32) && {title:'MAIL_VIEW::SHOW_RAW', arg:[function(){

					//var w = window.open('./basic/index.html?'+ buildURL({'_l':'item', 'p0':'html', 'p1':'html', 'p2':'mail.view.html', 'p3':me.__aid, 'p4':me.__fid, 'p5':'M', 'p6':WMItems.__serverID(me.__iid), 'raw':1}) ,"_blank");
					var w = window.open(sPrimaryAccountClient + 'server/download.php?'+ buildURL({
						dlsess: dataSet.get('main', ['dlsess']),
						aid: me.__aid,
						fid: me.__fid,
						iid: WMItems.__serverID(me.__iid),
						class: 'raw_message'
					}) ,"_blank");
					w.opener = w;
					w.focus();
					w = null;

				}], css:'ico'}
			].filter(Boolean));
			cmenu._place(e.clientX + pos.x, e.clientY + pos.y);

			e.stopPropagation();
			e.preventDefault();
		}
	};

	this.__eFrom.onclick = this.__eHeader.onclick;
	this.__eFrom.oncontextmenu = this.__eHeader.oncontextmenu;

	// predelat do dedice
	this._listen(sDataSet, sDataPath);

	// Update IM in header
	if (window.sPrimaryAccountIM && (GWOthers.getItem('RESTRICTIONS', 'disable_im') || 0)<1){
		dataSet.on('xmpp',['roster'], this.__updateAddress, this, false, true);
		this._add_destructor('__removeIMListener');
	}

	this.night_mode._checked(GWOthers.getItem('LAYOUT_SETTINGS', 'night_mode_mailview') == 1);
	this.night_mode._onchange = function() {
		GWOthers.setItem('LAYOUT_SETTINGS', 'night_mode_mailview', +me.night_mode._checked());
		WMStorage.set({resources: dataSet.get('storage')}, 'storage');
	}

	gui._obeyEvent('storage', [this, '__onStorageChange']);
	gui._obeyEvent('chatgptChanged', [this, '__initChatGPT']);

	await this.__initChatGPT();

	this._add_destructor('__destructor');
};

_me.__initChatGPT = async function() {
	if (dataSet.get('chatgpt') && !this.chatgpt) {
		await this._create('chatgpt', 'obj_button', 'chatgpt', 'chatgpt simple border ico ico2 select transparent');
		this.chatgpt._value('MAIN_MENU::CHATGPT');
		this.chatgpt._onclick = async function(e) {
			if (this.cmenu) {
				this.cmenu._destruct();
				return;
			}
			addcss(this.chatgpt._main, 'active');
			
			var cmenu = this.cmenu = await this._gui._create('cmenu', 'obj_context');
			cmenu._onclose = function() {
				if (this.chatgpt && this.chatgpt._main) {
					removecss(this.chatgpt._main, 'active');
					this.cmenu = false;
				}
			}.bind(this);

			var textContent = createTextVersion(this.__body, {
				linkProcess: function(href, linkText) {
					return linkText || href;
				},
				imgProcess: function() {
					return '';
				}
			}).trim();

			await cmenu._fill([
				{
					title: 'CHATGPT::SUGGEST_REPLY',
					handler: [this, '__chatgptSuggestReply'],
					css: 'ico2 reply'
				},
				textContent && {
					title: 'CHATGPT::MAKE_OVERVIEW',
					handler: [this, '__chatgptOverview'],
					css: 'ico2 make_overview'
				},
				textContent && {
					title: 'CHATGPT::TRANSLATE',
					css: 'ico2 translate',
					nodes: [{
						anchor: 'languages',
						css: 'languages'
					}],
					onmouseover: async function() {
						await cmenu._create('translate', 'obj_chatgpt_menu', 'languages', '', {
							header: false
						});
						cmenu.translate._createLanguageMenu(function(lang) {
							this.__chatgptTranslate(getLang('language::'+ lang));
							cmenu._destruct();
						}.bind(this));
					}.bind(this),
					onmouseout: function() {
						cmenu.translate && cmenu.translate._destruct();
					}
				}
			].filter(Boolean));

			var pos = getSize(this.chatgpt._main);
			cmenu._place(pos.x + pos.w / 2, pos.y + pos.h, '', 3);
			e.stopPropagation();
		}.bind(this);
	} else if (this.chatgpt) {
		this.chatgpt._destruct();
		this.chatgpt = false;
	}
};

_me.__getContext = function() {
	var selection = this.__eFrame.contentWindow.getSelection();
	var context;
	if (!selection) {
		context = this.__eFrame.contentDocument.body.cloneNode(true);
	} else {
		var range = selection.rangeCount && selection.getRangeAt(0);
		if (!range || range.collapsed) {
			context = this.__eFrame.contentDocument.body.cloneNode(true);
		} else {
			context = range.cloneContents();
		}
	}
	return context;
};

_me.__chatgptSuggestReply = function() {
	OldMessage.reply({
		id: [this.__aid, this.__fid, this.__iid],
		bReplyToAll: true,
		ChatGPTOptions: {
			chatgpt_action: 'suggest_reply',
			chatgpt_context: this.__getContext()
		}
	});
};

_me.__chatgptOverview = function() {
	var sContext = mkElement('div', {}, false, this.__getContext()).innerHTML;

	sContext = createTextVersion(sContext, {
		linkProcess: function(href, linkText) {
			return linkText || href;
		},
		imgProcess: function() {
			return '';
		},
		headingStyle: 'linebreak'
	}).trim();

	if (!sContext) {
		return;
	}

	ChatGPT.conversationCreate({
		label: this.__eSubject.textContent,
		alias: this.__iid
	}, function(bOK, conversation) {
		if (!bOK) {
			return;
		}

		gui.frm_main._openChatGPTConversation(conversation);

		conversation.messageCreate({
			message: getLang('chatgpt::make_overview') + '.\n' + getLang('chatgpt::context') + ':\n\n' + sContext,
		}, function(bOK) {
			if (bOK) {
				conversation.process();
			} else {
				conversation.delete();
			}
		})
	}.bind(this));
};

_me.__chatgptTranslate = function(sLanguage) {
	var sContext = mkElement('div', {}, false, this.__getContext()).innerHTML;

	var turndownService = new TurndownService();
	turndownService.use([turndownPluginGfm.tables]);
	sContext = turndownService.turndown(sContext).replace(/!\[.*?\]\(.*?\)/g, '').replace(/<\/?img.*?>/g, '');

	if (!sContext) {
		return;
	}

	ChatGPT.conversationCreate({
		label: this.__eSubject.textContent,
		alias: this.__iid
	}, function(bOK, conversation) {
		if (!bOK) {
			return;
		}

		gui.frm_main._openChatGPTConversation(conversation);

		conversation.messageCreate({
			message: getLang('chatgpt::translate_query', [sLanguage]) + '.\n' + getLang('chatgpt::context') + ':\n\n' + sContext,
		}, function(bOK) {
			if (bOK) {
				conversation.process();
			} else {
				conversation.delete();
			}
		})
	}.bind(this));
};

_me.__onStorageChange = function(e, arg) {
	if (e && e.type == 'set' && Is.Array(arg)){
		if (~arg.indexOf("LAYOUT_SETTINGS")) {
			var night_mode = GWOthers.getItem('LAYOUT_SETTINGS', 'night_mode') > 0 && GWOthers.getItem('LAYOUT_SETTINGS', 'night_mode_mailview') == 1;
			this.night_mode && this.night_mode._value(+night_mode, true);

			var NM = NightMode(this.__getDoc().defaultView);
			if (night_mode) {
				NM.activate();
			} else {
				NM.reset();
			}
		}
	}
};

_me.__getDoc = function() {
	return this.__eFrame.contentDocument || this.__eFrame.contentWindow.document;
};

_me.__destructor = function() {
	clearTimeout(this.__mark_as_read_timeout);
	gui._disobeyEvent('storage', [this, '__onStorageChange']);
	gui._disobeyEvent('chatgptChanged', [this, '__initChatGPT']);
};

_me.__removeIMListener = function(){
	dataSet.off('xmpp',['roster'], this.__updateAddress);
};

_me.__updateAddress = function(data){
	data && [].forEach.call(this.__eFrom.querySelectorAll('a.address'), function(elm){
		if (elm.rel){
			var user = MailAddress.splitEmailsAndNames(elm.rel);
			if (user && user[0] && user[0].email){
				elm.className = 'address' + (data[user[0].email]?' im_'+data[user[0].email].show:'');
			}
		}
	});
};

_me.__prepare = function(){
	var NM = NightMode(this.__getDoc().defaultView);
	if(GWOthers.getItem('LAYOUT_SETTINGS', 'night_mode') > 0 && GWOthers.getItem('LAYOUT_SETTINGS', 'night_mode_mailview') == 1 && !this.__nightModeDisabled && dataSet.get('main', ['night_mode_enabled'])) {
		NM.reset(function() {
			NM.activate(function() {
				this._main.style.visibility = 'visible';
			}.bind(this));
		}.bind(this));
	} else {
		NM.reset(function() {
			this._main.style.visibility = 'visible';
		}.bind(this));
	}
	this.__resize(true);
};

_me.__resize = function(bReinit) {
	if (this._destructed) {
		return;
	}
	var body = this.__getDoc().body;
	var scrollTop = this._getAnchor('block').scrollTop;
	var scrollLeft = this._getAnchor('block').scrollLeft;

	if (bReinit) {
		this.__eFrame.style.width = '100%';
		this.__eFrame.style.height = '0px';
	}

	this.__eFrame.style.width = this._getAnchor('message').clientWidth < body.scrollWidth ? body.scrollWidth + 1 + 24 + 'px' : '100%';

	this.__eFrame.style.height = body.scrollHeight + 1 + 'px';
	this._getAnchor('block').scrollTop = scrollTop;
	this._getAnchor('block').scrollLeft = scrollLeft;
};

//mailto context menu
_me._context_link = async function(e, sName, sMail){
	var pos = getSize(this.__eFrame);
	var c = await gui._create('cmenu','obj_context_link','','',sName,sMail);
	c._place(pos.x + e.clientX,pos.y + e.clientY);
	c = null;

	e.stopPropagation();
	e.preventDefault();
};

_me.__parseHeader = function(sEmails, bFull) {
	var out = gui._rtl ? '<bdi>' : '', stat,
		emails = MailAddress.splitEmailsAndNames(sEmails.unescapeXML()),
		bIM = gui.frm_main && gui.frm_main.im && gui.frm_main.im._is_active();

	// emails.sort(function(a, b) {
	// 	if (a.email == sPrimaryAccount) {
	// 		return -1;
	// 	}
	// 	if (b.email == sPrimaryAccount) {
	// 		return 1;
	// 	}
	// 	return (a.name || a.email).localeCompare(b.name || b.email);
	// });

	out = emails.map(function(recipient, i) {
		var address = '';
		if (i === 5) {
			address += '<a class="expand">' + getLang('MAIL_VIEW::SHOW_N_MORE', [emails.length - 5]) + '</a>';
		}
		address += '<a class="address'+ (i >= 5 ? ' collapsed' : '') + (bIM && (stat = gui.frm_main.im._inRoster(recipient.email))?' im_'+stat.escapeXML(true):'') +(recipient.email == sPrimaryAccount?' primary':'')+'" rel="'+ MailAddress.createEmail(recipient.name,recipient.email).escapeXML(true) +'" title="'+ getLang('ITEMVIEW::MESSAGE_TO',[recipient.email.escapeXML(true)]) +'">'+ (bFull?MailAddress.createEmail(recipient.name,recipient.email, true):(recipient.name || recipient.email)).escapeXML() +'</a>';
		return address;
	}).join('');

	return gui._rtl ? out + '</bdi>' : out;
};

_me.__avatar = function(sEmail, sName){
	this._getAnchor('avatar').innerHTML = obj_avatar.getAvatarHTML({
		email: sEmail,
		name: sName || sEmail,
		size: 48
	});
};

_me._header = async function(aData){
	// clear attach
	if (this.attach)
		await this.attach._destruct();

	// clear header
	var child, j, att;
	while((child = this._getAnchor('rows').lastChild)) {
		this._getAnchor('rows').removeChild(child);
	}

	var scr = this._getAnchor('pre');
	scr.innerHTML =	'';
	scr.style.display = '';

	var priority = this._getAnchor('priority');
	priority.className = 'priority';
	if(aData.PRIORITY) {
		addcss(priority, 'priority_' + aData.PRIORITY);
		delete aData.PRIORITY;
	}

	var aData2 = [];
	var classes = {};

	if (aData.COLOR) {
		this._getAnchor('flags').className = 'flag ' + aData.COLOR;
		delete aData.COLOR;
	}

	this._getAnchor('date').innerHTML = aData.DATE ? IcewarpDate.unix(aData.DATE).format('dd L LT') : '';
	this._getAnchor('date').classList.remove('snoozed');
	if (aData.ORIGINAL_DATE) {
		this._getAnchor('date').classList.add('snoozed');
		gui.tooltip._add(this._getAnchor('date'), IcewarpDate.unix(aData.ORIGINAL_DATE).format('dd L LT'));
	}
	delete aData.DATE;
	delete aData.ORIGINAL_DATE;

	if (aData.TO) {
		var tmp = MailAddress.splitEmailsAndNames(aData.TO.replace(/&gt;/gi,">").replace(/&lt;/gi,"<").replace(/&quot;/gi,'"'));
		if (tmp.length) {
			aData2.TO = this.__parseHeader(aData.TO);
			if (~aData2.TO.indexOf('collapsed')) {
				classes.TO = 'collapsed';
			}
		}
		delete aData.TO;
	}
	if (aData.CC){
		aData2.CC = this.__parseHeader(aData.CC);
		if (~aData2.CC.indexOf('collapsed')) {
			classes.CC = 'collapsed';
		}
		delete aData.CC;
	}
	if (aData.BCC){
		aData2.BCC = this.__parseHeader(aData.BCC);
		if (~aData2.BCC.indexOf('collapsed')) {
			classes.BCC = 'collapsed';
		}
		delete aData.BCC;
	}
	this.tags._setId([this.__aid, this.__fid, this.__iid]);
	this.tags._autosave(true);
	delete aData.TAGS;

	delete aData.REPLY_FULLPATH;

	if (aData.ATTACHMENTS) {
		aData2.ATTACHMENTS = aData.ATTACHMENTS;
		delete aData.ATTACHMENTS;
		delete aData.SMART_ATTACH;
	}

	aData2 = arrConcat(aData2, aData);

	for (var i in aData2){

		if (i === 'ATTACHMENTS') {
			await this._create('attach', 'obj_attach_mailview', 'attach');
			this.attach._aid = this.__aid;
			this.attach._fid = this.__fid;
			this.attach._iid = this.__iid;

			var urlAll = '';
			for (j in aData2.ATTACHMENTS) {
				if (aData2.ATTACHMENTS[j].hidden) {
					continue;
				}
				att = aData2.ATTACHMENTS[j].values;
				if (att.SMART && att.ALL) {
					urlAll = att.URL;
					break;
				}
			}

			var aOut = [];
			for (j in aData2.ATTACHMENTS) {
				if (aData2.ATTACHMENTS[j].hidden) {
					continue;
				}
				att = aData2.ATTACHMENTS[j].values;
				if (!att.ALL) {
					var out = {
						name: att.NAME || att.ATTNAME,
						cert: att.CERT,
						size: att.SIZE || att.ATTSIZE,
						id: j,
						type: att.TYPE,
						fullpath: att.FULLPATH
					};
					if (att.SMART) {
						out.url = att.URL;
						if (att.DOCREF) {
							out.docref = true;
						} else {
							var fp = '';
							for (var k in this.__aAttData) {
								var d = this.__aAttData[k].split('=');
								if (out.name === decodeURIComponent(d[0])) {
									fp = decodeURIComponent(d[1]);
									delete this.__aAttData[k];
									break;
								}
							};
							out.allurl = urlAll;
							out.fullpath = fp;
						}
					}
					aOut.push(out);
				}
			}

			this.attach._value({ attachments: aOut });
		} else if (i == 'ALL_HEADERS') {
			scr.innerHTML = aData2[i];
			scr.style.display = 'flex';
		} else {
			this._getAnchor('rows').appendChild(mkElement('div', {
				className: i.toLowerCase() + ' row'
			}, false, [
				mkElement('div', {
					className: 'label',
					textContent: getLang('MAIL_VIEW::' + i) + ':'
				}),
				mkElement('div', {
					className: [classes[i] || '', 'scroll'].filter(Boolean).join(' '),
					innerHTML: aData2[i]
				})
			]));
		}
	}
};

_me.__frameEventsBound = false;
_me._frame = async function(v){
	var me = this;
	if (typeof v != 'undefined'){
		this.__nightModeDisabled = !!v.match(/@media.*(prefers-color-scheme: dark)/);

		// var NM = NightMode(this.__eFrame.contentWindow);
		// if (this.__nightModeDisabled) {
		// 	NM.disable();
		// } else {
		// 	NM.enable();
		// }
		if(GWOthers.getItem('LAYOUT_SETTINGS', 'night_mode') == 1 && !this.__nightModeDisabled) {
			this._main.style.visibility = 'hidden';
		}

		//remove img preview
		await this.__showImages(true);

		// http proxy
		if(location.protocol === 'https:') {
			v = v.replace(/(<[^a][^<]*?)(http:.*?)(['"])/gi, function(_, prefix, url, postfix) {
				return prefix + (url.indexOf('data:') === 0 ? url : (location.origin + '/teamchatapi/http.download?token=' + sPrimaryAccountTeamchatToken + '&url=' + encodeURIComponent(url.unentityify()))) + postfix;
			});
		}

		//fix html content if broken
		var tmp = mkElement('div', {
			innerHTML: v
		}, this.__doc);
		tmp.style.setProperty('height', 'auto', 'important');

		var resizeTimeout;
		function imageErrorHandler(e) {
			clearTimeout(resizeTimeout);
			resizeTimeout = setTimeout(function() {
				me.__resize(true);
			}, 5);
			if (!~(e.target.src || '').indexOf('/teamchatapi/http.download')) {
				e.target.src = location.origin + '/teamchatapi/http.download?token=' + sPrimaryAccountTeamchatToken + '&url=' + encodeURIComponent(e.target.src.unentityify());
				e.target.removeEventListener('error', imageErrorHandler, false);
				e.target.addEventListener('error', function() {
					if (!e.target || !e.target.style.height || (e.target.style.height === 'auto')) {
						e.target.style.height = 'fit-content';
					}
					clearTimeout(resizeTimeout);
					resizeTimeout = setTimeout(function() {
						me.__resize(true);
					}, 5);	
				}, false);
			}
		};
		[].forEach.call(tmp.querySelectorAll('img'), function(img) {
			if(~img.style.height.indexOf('%')) {
				img.style.height = 'auto';
			}
			img.addEventListener('load',function(){
				clearTimeout(resizeTimeout);
				resizeTimeout = setTimeout(function() {
					me.__resize(true);
				}, 5);
			},false);
			img.addEventListener('error', imageErrorHandler, false);

			if (img.getAttribute('data-preview')) {
				img.addEventListener('click', async function(e) {
					e.preventDefault();
					e.stopImmediatePropagation();
					var img = await gui._create('imgview', 'frm_imgview');
					await img._fill([{ url: this.getAttribute('data-preview') }]);
					img._value(0);
				}.bind(img));
			}
		});

		[].forEach.call(tmp.querySelectorAll('table, div'), function(el) {
			el.getAttribute('style') && el.setAttribute('style', el.getAttribute('style').replace(/\s*height:\s*100%\s*(!important)?;?/gi, 'height: auto;'));
			el.getAttribute('height') && el.setAttribute('height', 'auto');
		});

		if (this.__static_flags & 4 || this.__static_flags & 32) {
			tmp.classList.add('unselectable');
		}

		while(this.__getDoc().head.firstElementChild) {
			this.__getDoc().head.removeChild(this.__getDoc().head.lastElementChild);
		}
		while(this.__getDoc().body.firstChild) {
			this.__getDoc().body.removeChild(this.__getDoc().body.lastChild);
		}

		//raw resize
		this.__resize(true, true);

		var skin = GWOthers.getItem('LAYOUT_SETTINGS', 'skin');

		[
			mkElement('link', {
				type: 'text/css',
				rel: 'stylesheet',
				'iw-skip': true,
				href: getCssPath('font.css', 'default', this.__doc_base),
				onload: onLoad
			}, this.__doc),
			mkElement('link', {
				type: 'text/css',
				rel: 'stylesheet',
				'iw-skip': true,
				href: getCssPath('obj_mailview_body.css', 'default', this.__doc_base),
				onload: onLoad
			}, this.__doc),
			(skin !== 'default') && mkElement('link', {
				type: 'text/css',
				rel: 'stylesheet',
				'iw-skip': true,
				href: getCssPath('obj_mailview_body.css', skin, this.__doc_base),
				onload: onLoad
			}, this.__doc),
			mkElement('meta', {
				'http-equiv': 'x-dns-prefetch-control',
				content: 'off'
			}, this.__doc),
			mkElement('base', {
				href: this.__doc_base
			}, this.__doc)
		].filter(Boolean).forEach(function(element) {
			this.__getDoc().head.appendChild(element);
		}, this);

		this.__getDoc().body.setAttribute('id', 'iw_webmail_msg_body');
		this.__getDoc().body.style.visibility = 'hidden';
		while(tmp.childNodes.length) {
			this.__getDoc().body.appendChild(tmp.firstChild);
		}

		setTimeout(function() {
			this.__resize();
		}.bind(this), 5);

		var toLoad = 2;
		if (skin !== 'default') {
			toLoad = 3;
		}
		function onLoad() {
			if(!--toLoad) {
				me.__prepare();
			}
		}

		this.__getDoc().body.scrollTop = 0;

		function keyEvn(evt) {
			evt = new KeyboardEvent(evt.type, {
				altKey: evt.altKey,
				charCode: evt.charCode,
				code: evt.code,
				ctrlKey: evt.ctrlKey,
				key: evt.key,
				keyCode: evt.keyCode,
				metaKey: evt.metaKey,
				shiftKey: evt.shiftKey,
				which: evt.which
			});

			return me._main.ownerDocument.body.dispatchEvent(evt);
		};

		this.__getDoc().onkeydown = keyEvn;
		this.__getDoc().onkeyup = keyEvn;

		if(this.__frameEventsBound) {
			return;
		}
		this.__frameEventsBound = true;

		//// Document Events Forwarding
		function mouseEvn(e){
			var pos = getSize(me.__eFrame);

			var evt = new MouseEvent(e.type, {
				clientX: e.clientX + pos.x,
				clientY: e.clientY + pos.y,
				ctrlKey: e.ctrlKey,
				altKey: e.altKey,
				shiftKey: e.shiftKey,
				metaKey: e.metaKey,
				button: e.button
			});

			return me.__eFrame.dispatchEvent(evt);
		};

		this.__getDoc().onmousemove = mouseEvn;
		this.__getDoc().onmousedown = mouseEvn;
		this.__getDoc().onmouseup = mouseEvn;
		this.__getDoc().onclick = mouseEvn;
		//this.__getDoc().oncontextmenu = mouseEvn;

		this.__getDoc().addEventListener('click', function(event) {
			var tmp;

			if (event.target.tagName === 'A') {
				if((tmp = event.target.href.match(wm_conference.linkRegExp))) {
					event.preventDefault();
					event.stopPropagation();
					event.stopImmediatePropagation();

					wm_conference.get(tmp[2] + '_' + tmp[1]).join();
				}

				if(event.target.href.match(/\/collaboration\/\?ticket=(.*?)&url=(.*?)(?:&|$)/) || ShortURL.matches(event.target.href)) {
					event.preventDefault();
					event.stopPropagation();
					event.stopImmediatePropagation();

					window.open(event.target.href);
				}
			}
		});

		this.__getDoc().oncontextmenu = function(e){
			return me._getAnchor('message').oncontextmenu(e, me.__eFrame);
		};

		this.__getDoc().onmouseover = mouseEvn;

		AttachEvent(this.__doc, "onkeydown", function(e){

			//check for input
			if (e.target.tagName == 'INPUT' || e.target.tagName == 'TEXTAREA')
				return;

			if (me._onkeypress)
				me._onkeypress(e);

			//Scrolling
			var jump = [0,0];
			switch(e.keyCode){
				//HOME
			case 36:
				me._getAnchor('block').scrollTop = 0;
				return;
				//END
			case 35:
				me._getAnchor('block').scrollTop = me._getAnchor('block').scrollHeight;
				return;

				//top
			case 38:
				jump = [-28,0];
				break;
				//bottom
			case 40:
				jump = [28,0];
				break;
				//left
			case 37:
				jump = [0,-28];
				break;
				//right
			case 39:
				jump = [0,28];
				break;

				//PgUp
			case 33:
				jump = [(me._getAnchor('block').clientHeight*-1),0];
				break;
				//PgDn
			case 34:
				jump = [me._getAnchor('block').clientHeight,0];
				break;

			default:
				return;
			}

			if (jump[0])
				me._getAnchor('block').scrollTop += jump[0];

			if (jump[1])
				me._getAnchor('block').scrollLeft += jump[1];
		});

		AttachEvent(this.__doc, "oncopy", function(){

			var se = this.getSelection(),
				fn = se[se.focusOffset>se.anchorOffset?'focusNode':'anchorNode'];

			if (fn && fn.textContent){
				var tx = fn.textContent;

				if (tx.match(/\($/g) && fn.nextElementSibling && fn.nextElementSibling.tagName == 'A' && fn.nextElementSibling.protocol == 'mailto:'){
					var name = tx.replace(/(^([^:.]+):)|\($/g,''),
						mail = fn.nextElementSibling.href.substring(fn.nextElementSibling.protocol.length);

					if (mail){
						var div = mkElement('div', {
							text: MailAddress.createEmail(name, mail),
							style:{
								position:'fixed',
								left:'-99999px'
							}
						}, this);

						this.body.appendChild(div);
						se.selectAllChildren(div);

						window.setTimeout(function () {
							if (div.parentNode)
								this.removeChild(div);
						}.bind(this.body), 100);
					}
				}
			}
		});
	}
	else{
		try{
			if (currentBrowser() != 'Mozilla')
				this.__getDoc().body.innerHTML;
			else
				return this.__getDoc().getElementsByTagName('div')[0].innerHTML;
		}
		catch {
			return '';
		}
	}
};

_me.__update = function(sName,aPath)
{
	var aMails = dataSet.get(sName);

	//header links update
	if (sName == 'xmpp'){

		var tmp, i,
			links = this.__eHeader.getElementsByTagName('A');

			// one user
		if (aPath && aPath[0] == 'roster' && aPath[1] && aPath[2] == 'show'){
			for(i = links.length-1; i>-1; i--)
				if (links[i].rel && (tmp = MailAddress.splitEmailsAndNames(links[i].rel)) && (tmp = tmp[0]))
					if (tmp.email.toLowerCase() == aPath[1])
						links[i].className = 'address im_' + gui.frm_main.im._inRoster(aPath[1]) + (hascss(links[i], 'primary')?' primary':'');
			// else
			// if (tmp.email.toLowerCase() == sPrimaryAccount)
			// 	links[i].className = 'address im_' + gui.frm_main.im._status();
		}
		// IM goes offline
		else
		if (!gui.frm_main.im._is_active())
			for(i = links.length-1; i>-1; i--)
				if (links[i].rel && hascss(links[i],'address'))
					links[i].className = 'address' + (hascss(links[i], 'primary')?' primary':'');
	}
	else
	if (!aMails){
		this._value(false);
	}
	else {

		//Get Item info
		for(var sAccId in aMails){
			for(var sFolId in aMails[sAccId]){
				delete aMails[sAccId][sFolId]['#'];
				delete aMails[sAccId][sFolId]['/'];
				delete aMails[sAccId][sFolId]['$'];
				delete aMails[sAccId][sFolId]['@'];

				for(var sItId in aMails[sAccId][sFolId])
					break;

				break;
			}
			break;
		}

		//Check if not already active
		if ((!('HTML' in aMails[sAccId][sFolId][sItId]) && typeof (aMails[sAccId][sFolId][sItId].CLEAN_HTML || aMails[sAccId][sFolId][sItId].TEXT || aMails[sAccId][sFolId][sItId].MESSAGE_ID) == 'undefined') || /*(WMFolders.getType([sAccId,sFolId]) != 'M' && WMFolders.getType([sAccId,sFolId]) != 'Q') ||*/ (this._checkActive && sItId.indexOf('|')<0 && (dataSet.get('active_items', [sAccId, sFolId]) && dataSet.get('active_items',[sAccId,sFolId]) != sItId)))
			return;

		//new mail?
		if (this.__aid != sAccId || this.__fid != sFolId || this.__iid != sItId){
			//scroll to top
			var eblock = this._getAnchor('block');
			if (eblock){
				eblock.scrollTop = 0;
				eblock = null;
			}
		}

		//disable full headers
		if (this.__FullHeaders && (this.__FullHeaders.aid != sAccId || this.__FullHeaders.fid != sFolId || this.__FullHeaders.iid != sItId))
			this.__FullHeaders = '';

		aMails = clone(aMails[sAccId][sFolId][sItId]);

		// Save all recipients of the email for later access
		this._recipients = MailAddress.splitEmailsAndNames(aMails.FROM);
		this._recipients = this._recipients.concat(
			MailAddress.splitEmailsAndNames(aMails.TO),
			MailAddress.splitEmailsAndNames(aMails.CC)
		);

		delete aMails.aid;
		delete aMails.fid;
		delete aMails.FLAGS;
		//delete aMails.STATIC_FLAGS;
		// delete aMails.HAS_ATTACHMENT;
		delete aMails.HAS_EMBEDDED_ATTACHMENT;

		//delete aMails.SMIME_STATUS;
		// delete aMails.PRIORITY;
		delete aMails.CONFIRM_ADDR;
		delete aMails.REPLY_TO;
		delete aMails.SIZE;
		delete aMails.SPELLCHECKER;
		delete aMails.SENT;

		delete aMails.MESSAGE_ID;
		delete aMails.REFERENCES;
		delete aMails.IN_REPLY_TO;

		delete aMails.TEAMCHAT;
		delete aMails.TEAMCHAT_COMMENT;

		aMails.AID = sAccId;
		aMails.FID = sFolId;
		aMails.IID = sItId;

		this._value(aMails);
	}
};

_me.__showImages = async function(bHide) {

	this.__HiddenImages = bHide;

	var me = this;

	if (bHide){

		//Remove
		var elm = document.getElementById(this._pathName+'/frame_images');
		if (elm)
			elm.parentNode.removeChild(elm);
		removecss(this._main,'images');

		if (Is.Empty(this.__aImages))
			removecss(this._main,'preview');
		else
			addcss(this._main,'preview');
	}
	else
	{
		var sURL;

			//Remove Label
		removecss(this._main,'preview');
		if (this.preview)
			this.preview._destruct();

		//Add Image row
		addcss(this._main,'images');
		var etmp = mkElement('div', {id:this._pathName+'/frame_images',className:'obj_mailview_images'}),
			etmp2= mkElement('p', {className: 'maxbox relative'});

		etmp2.onclick = async function(e){
			if (e.target.tagName == 'IMG'){

				var imgs = this.getElementsByTagName('img'),
					out = [], v = 0;

				for (var i = imgs.length-1; i>=0; i--)
					if (imgs[i].src && imgs[i].src == e.target.src){
						v = i;
						break;
					}

				var ratio = window.retina || window.devicePixelRatio || 1;

				for (i in me.__aImages)
					if (me.__aImages[i].url.indexOf('http://') == 0 || me.__aImages[i].url.indexOf('https://') == 0)
						out.push(me.__aImages[i]);
					else
						out.push({title:me.__aImages[i].title, url: await Item.webdavURL([me.__aid, me.__fid, me.__iid], me.__aImages[i].url, { resize: 1, width: screen.availWidth * ratio, height: screen.availHeight * ratio })});

				if (out.length){
					var img = await gui._create('imgview','frm_imgview');
					await img._fill(out);
					img._value(v);
				}
			}
		};

		if (this.attach)
			etmp2.oncontextmenu = async function(e){
				var elm = e.target;

				if (elm.tagName == 'IMG' && Is.Defined(elm.getAttribute('rel'))){

					var att = me.__aImages[elm.getAttribute('rel')];

					if (att){
						var	cmenu = await gui._create("cmenu","obj_context"),
							aMenu = [{"title":'ATTACHMENT::DOWNLOAD', 'arg':[downloadItem, [await Item.webdavURL([me.__aid, me.__fid, me.__iid], att.url), true]]}],
							pos = getSize(elm);

						if (sPrimaryAccountGW>0){
							var dgw = GWOthers.getItem('RESTRICTIONS', 'disable_gw_types');
							if (!dgw || dgw.indexOf('f')<0)
								aMenu.push({"title":'ATTACHMENT::SAVE_TO_FOLDER','arg':[me.attach,'_saveFolder',[[{'name':elm.title,'size':0,'fullpath':me.__aid+'/'+me.__fid+'/'+ WMItems.__serverID(me.__iid)+'/'+att.url}]]]});
						}

						await cmenu._fill(aMenu);
						cmenu._place(pos.x+(pos.w/2),pos.y,'',3);
					}
				}

				e.preventDefault();
			};

		for (var i in this.__aImages) {
			if (this.__aImages[i].url.indexOf('http://') == 0 || this.__aImages[i].url.indexOf('https://') == 0)
				sURL = this.__aImages[i].url;
			else
				sURL = await Item.webdavURL([me.__aid, me.__fid, me.__iid], this.__aImages[i].url, {resize: 1, width: 100, height: 100, crop:'50%' });

			etmp2.appendChild(mkElement('img',{'src':sURL,'title':this.__aImages[i].title, 'rel':i}));
		}


		etmp.appendChild(etmp2);
		this._main.appendChild(etmp);

		this._scrollbar(etmp2,etmp2.parentNode);
	}
};

_me.__showText = function (b){
	//get info from dataset
	var aMails = dataSet.get(this._listener,this._listenerPath);
	if (!aMails) return;

	for(var sAccId in aMails)
		for(var sFolId in aMails[sAccId]){
			delete aMails[sAccId][sFolId]['#'];
			delete aMails[sAccId][sFolId]['/'];
			delete aMails[sAccId][sFolId]['$'];
			delete aMails[sAccId][sFolId]['@'];

			for(var sItId in aMails[sAccId][sFolId]);
		}

	this.__TextBody = b;

	//ico
	/*
		var tmp = this._getAnchor('buttons').getElementsByTagName('A')[2];
		if (this.__TextBody){
		    addcss(tmp,'active');
		    tmp.title = getLang('ATTACHMENT::SHOW_HTML');
		}
		else{
			removecss(tmp,'active');
			tmp.title = getLang('ATTACHMENT::SHOW_TEXT');
		}
*/
	//get short headers
	WMItems.list({"aid": sAccId, "fid": sFolId, "iid": sItId, "values": this.__TextBody?OldMessage.__TEXTMAIL_VALUES:OldMessage.__FULLMAIL_VALUES},this._listener,this._listenerPath);
};

_me.__showHTML = function (){
	//get info from dataset
	var aMails = dataSet.get(this._listener,this._listenerPath);
	if (!aMails) return;

	this.__HTMLBody = true;

	for(var sAccId in aMails)
		for(var sFolId in aMails[sAccId]){
			delete aMails[sAccId][sFolId]['#'];
			delete aMails[sAccId][sFolId]['/'];
			delete aMails[sAccId][sFolId]['$'];
			delete aMails[sAccId][sFolId]['@'];

			for(var sItId in aMails[sAccId][sFolId]);
		}

		//get short headers
	WMItems.list({"aid": sAccId, "fid": sFolId, "iid": sItId, "values": OldMessage.__FULLMAIL_VALUES_DANGER},this._listener,this._listenerPath);
};

_me.__showHeaders = function (aHandler){
	//get info from dataset
	var aMails = dataSet.get(this._listener,this._listenerPath);
	if (!aMails) return;

	for(var sAccId in aMails)
		for(var sFolId in aMails[sAccId]){
			delete aMails[sAccId][sFolId]['#'];
			delete aMails[sAccId][sFolId]['/'];
			delete aMails[sAccId][sFolId]['$'];
			delete aMails[sAccId][sFolId]['@'];

			for(var sItId in aMails[sAccId][sFolId]);
		}

	//Back to normal view
	if (this.__FullHeaders && this.__FullHeaders.aid == sAccId && this.__FullHeaders.fid == sFolId && this.__FullHeaders.iid == sItId){

		//get short headers
		WMItems.list({"aid": sAccId, "fid": sFolId, "iid": sItId, "values": this.__TextBody?OldMessage.__TEXTMAIL_VALUES:(this.__HTMLBody?OldMessage.__FULLMAIL_VALUES_DANGER:OldMessage.__FULLMAIL_VALUES)},this._listener,this._listenerPath,'',aHandler);
		this.__FullHeaders = '';
		return;
	}

	//Load All headers
	var MAILINFO_VALUES = [	'FROM', 'SUBJECT', 'ALL_HEADERS', this.__TextBody?'TEXT':(this.__HTMLBody?'HTML':'CLEAN_HTML'), 'DATE', 'ATTACHMENTS', 'FLAGS', 'HAS_ATTACHMENT', 'PRIORITY',
		'STATIC_FLAGS', 'SMIME_STATUS', 'CONFIRM_ADDR'];

	// Async list item (refresh mailview) and refresh folders (folder tree)
	WMItems.list({"aid": sAccId, "fid": sFolId, "iid": sItId, "values": MAILINFO_VALUES},this._listener,this._listenerPath);

	this.__FullHeaders = {"aid": sAccId, "fid": sFolId, "iid": sItId};
};

_me._print = async function(){
	if (!this.__aid || !this.__fid || !this.__iid || !this.__doc) return false;

	if (this.__static_flags & 4) {
		return gui.notifier._value({type: 'alert', args: {header: '', text: 'ERROR::ACTION_DISABLED'}});
	}

	if (this.__header_cert || (Is.Array(this.__aImages) && this.__aImages.length)){
		if (this.print_opt)
			await this.print_opt._destruct();

		this.print_opt = await gui._create('print_opt', 'frm_mail_print','','',[this, '__print'], {cert_info:this.__header_cert?true:false, images:this.__aImages.length>0});
	}
	else
		this.__print();
};

_me.__print = function(aOpt){

	if (this.__FullHeaders){
		this.__showHeaders([this,'__print']);
		return false;
	}

	//Options
	if (Is.Object(aOpt)){
		window[aOpt.images?'addcss':'removecss'](this.__getDoc().body, 'print_images');
		window[aOpt.cert_info?'addcss':'removecss'](this.__getDoc().body, 'print_cert');
	}

	//PRINT
	var tags = this.__eFrame.contentDocument.querySelector('.iw_webmail_msg_header table .tags');
	tags && tags.parentElement.removeChild(tags);
	this.__eFrame.contentDocument.querySelector('.iw_webmail_msg_header table').appendChild(mkElement('tr', {
		className: 'tags'
	}, false, [
		mkElement('th', {
			textContent: getLang('TASK::CATEGORY') + ':'
		}),
		mkElement('td', {
			textContent: this.tags._value().split(',').join(', ')
		})
	]));

	this.__eFrame.contentWindow.focus();
	var NM = NightMode(this.__eFrame.contentWindow);
	if(NM.init) {
		NM.reset(function() {
			if (this.__getDoc().queryCommandSupported('print'))
				this.__getDoc().execCommand('print', false, null);
			else
				this.__eFrame.contentWindow.print();
			NM.activate();
		}.bind(this));
	} else {
		if (this.__getDoc().queryCommandSupported('print'))
			this.__getDoc().execCommand('print', false, null);
		else
			this.__eFrame.contentWindow.print();
	}

};

_me._value = async function(aData){
	try{
		var me = this, i, list, arr, hla, j, att, name, r, a, k;

		this._getAnchor('smart').style.display = 'none';
		this._getAnchor('serror').style.display = 'none';
		this._getAnchor('imip').style.display = 'none';
		this._getAnchor('deferred').style.display = 'none';
		this._getAnchor('skip').style.display = 'none';
		this._getAnchor('player').style.display ='none';

		// Remove old objects
		var	obj = this._getChildObjects();
		for(i in obj)
			if (obj[i]._name.indexOf('X_') == 0)
				await obj[i]._destruct();

		removecss(this._main, 'skeleton');
		removecss(this._main, 'noitem');
		this.__aData = aData;
		if (!aData) {
			if (aData === false) {
				addcss(this._main, 'noitem');
				this.__aid = this.__fid = this.__iid = false;
			} else {
				if (this._main.classList.contains('skeleton')) {
					return;
				}
				addcss(this._main, 'skeleton');
				aData = {
					FROM: '.',
					TO: '.',
					SUBJECT: '.',
					DATE: (new IcewarpDate().unix()).toString(),
					PRIORITY: '4'
				};
			}
		}

		// HTML has higher priority than TEXT
		if (aData['HTML'] || aData['CLEAN_HTML']){
			delete aData['TEXT'];
			this.__TextBody = false;
			this.__HTMLBody = aData['HTML']?true:false;
		}
		else
		if (aData['TEXT'])
			this.__TextBody = true;

		if (!aData.ALL_HEADERS)
			this.__FullHeaders = null;

		var aHeaders = {},
			sBody = '',
			sStyles;

		var aIMIP = [];

		this.__aImages = [];

		//Remove old sMIME
		this.__eSubject.className = 'subject';
		this.__header_cert = '';
		this.__header_base = '';
		this.__header_html = false;

		//Prefill aData
		aData = Object.assign({
			SUBJECT:null,
			FROM: null
		}, aData);

		var forwarded_invite = false, elm;

		//Attachments
		if (aData['ATTACHMENTS']) {
			for(var n in aData['ATTACHMENTS']) {
				att = aData.ATTACHMENTS[n].values;
				if (!att || att.SMART == 'true' || att.SMART == '1') {
					continue;
				}
				name = att.NAME || att.ATTNAME;
				if (name) {
					if (Item.imageSupport(name)) {
						this.__aImages.push({title:name, url:att['URL'] || n});
					} else if (att['TYPE']) {
						if (att['TYPE'].indexOf('image') == 0) {
							switch(att['TYPE'].toLowerCase()){
								case 'image/png':
								case 'image/jpeg':
								case 'image/gif':
								case 'image/tif':
								case 'image/bmp':
									this.__aImages.push({title:name, url:att['URL'] || n});
							}
						} else if (att['TYPE'].toLowerCase() == 'text/calendar' && att['IMIP'] && WMFolders.getType({aid:aData.AID, fid:aData.FID}) === 'M') {
							var del = true;
							try{
								if (!aData.ATTACHMENTS[n].values.NAME.match(new RegExp('^' + n))) {
									forwarded_invite = true;
								}
								arr = XMLTools.Str2Arr(att['IMIP']);
								if (arr.VCALENDAR) {
									arr.VCALENDAR[0].PARTID = [{VALUE:n}];
									aIMIP.push(arr);
								} else {
									del = false;
								}
							}
							catch(r){ console.log(this._name||false,r);}

							if (del) {
								aData['ATTACHMENTS'][n].hidden = true;
							}
						}
					}
				}
			}

			aHeaders['ATTACHMENTS'] = aData['ATTACHMENTS'];
		}

		//Certificates
		if (aData['CERTIFICATE'])
			try{
				aData['CERTIFICATE'] = XMLTools.Str2Arr(aData['CERTIFICATE']);

				//Add to attachment
				if (!aHeaders['ATTACHMENTS'])
                	aHeaders['ATTACHMENTS'] = {};

				aHeaders['ATTACHMENTS'].CERT = this.__header_cert = {values:{TYPE:'certificate',CERT:aData['CERTIFICATE'],NAME:getLang('MAIL_VIEW::CERTIFICATE')}};

				if (!aData.FROM || (me.__header_cert.values.CERT.INFO[0].SUBJECT[0].EMAILADDRESS && MailAddress.splitEmailsAndNames(aData.FROM)[0].email.toLowerCase() != aData['CERTIFICATE'].INFO[0].SUBJECT[0].EMAILADDRESS[0].VALUE.toLowerCase()))
					aData.SMIME_STATUS = 10;
			}
			catch {
				aData.SMIME_STATUS = 2;
			}

		//Avatar
		var sAvatarOrigin = '';
		if (Is.String((sAvatarOrigin = aData['FROM'] || aData['TO']))){
			sAvatarOrigin = MailAddress.splitEmailsAndNames(sAvatarOrigin)[0];

			if (sAvatarOrigin.email && sAvatarOrigin.email !== '.')
				this.__avatar(sAvatarOrigin.email, sAvatarOrigin.name);
			else
				this.__avatar();

			this._getAnchor('avatar').querySelector('.component-avatar').onclick = async function(e){
				var aMail = MailAddress.splitEmailsAndNames(aData['FROM'] || aData['TO']);
				if (aMail && aMail[0]){

					//Certificate
					try{
						var aCert;
						if (me.__header_cert && me.__header_cert.values.TYPE.toLowerCase() == 'certificate' && (me.__header_cert.values.CERT.INFO[0].SUBJECT[0].EMAILADDRESS && me.__header_cert.values.CERT.INFO[0].SUBJECT[0].EMAILADDRESS[0].VALUE.toLowerCase() == aMail[0].email.toLowerCase()))
							aCert = [{values:{'class':'item','fullpath':me.__aid +'/'+ me.__fid +'/'+ WMItems.__serverID(me.__iid)}}];
					}
					catch(r){ console.log(this._name||false,r);}

					await gui._create('cmenu','obj_context_link','','',aMail[0].name,aMail[0].email,aCert);
					gui.cmenu._placeMenu(this, {mode:'bottom'});

					e.stopPropagation();
					e.preventDefault();
					return;
				}
			};
		}
		else{
			this.__avatar();
			this._getAnchor('avatar').onclick = null;
		}

		//Other
		aHeaders['COLOR'] = 'bg_none';
		for (i in aData){
			switch(i){
			case 'STATIC_FLAGS':
				this.__static_flags = aData.STATIC_FLAGS;
				this.__header_html = (aData.STATIC_FLAGS & 1) ? true : false;
				break;
			case 'BASE_URL':
       				if (aData['BASE_URL'].indexOf('file://')===0)
					delete aData['BASE_URL'];
				else{
	                    if (!(/\/$/gi.test(aData['BASE_URL'])))
						this.__header_base = aData['BASE_URL'] + '/';
					else
						this.__header_base = aData['BASE_URL'];

					if (!(/^((http)|(https)):/gi.test(this.__header_base)))
						this.__header_base = 'http://' + this.__header_base;
				}

				break;
			case 'SUBJECT':
				this.__eSubject.innerHTML = (aData[i] || getLang('MAIL_VIEW::NOSUBJECT')).entityify();
				break;

			case 'FROM':
				if (Is.String(aData[i])){
					if (Is.String(aData.SENDER))
						this.__eFrom.innerHTML = this.__parseHeader(aData.SENDER) + '<span class="behalf">' + getLang('MAIL_VIEW::SENDER') + '</span>' + this.__parseHeader(aData[i]);
					else
						this.__eFrom.innerHTML = this.__parseHeader(aData[i],!dataSet.get('folders',[aData['AID'],aData['FID'],'RSS']));
				}
				else
					this.__eFrom.innerHTML = '';
				break;

			case 'CLEAN_HTML':
				if(!aIMIP.length) {
					this._getAnchor('skip').style.display = 'flex';
				}
			case 'HTML':
				if (aData[i]) {
					sStyles = (aData[i].match(/<style[\w\W]*?<\/style>/g) || []).join('');

					sBody = aData[i].replace(/<style[\w\W]*?<\/style>/g, '');
					sBody = DOMPurify.sanitize(sBody);
					sBody = sBody.replace(/<span[^>]*?><\/span>/gi, '').replace(/<p[^>]*?><\/p>/gi, '').replace(/&ldquo;/g, '“').replace(/windowtext/g, 'black');
					this.__body = sBody;
				}
				break;
			case 'TEXT':
				if (aData[i]) {
					hla = aData[i].unescapeHTML().highlight_links_array();
					sBody = hla.string.escapeHTML().replace(new RegExp(hla.replace, 'g'), function(s, id) {
						return hla.array[id];
					}).replace(/(?:\r\n|\r|\n)/gm, '<br>');
					this.__body = sBody;
				}
				break;

			case 'AID':
				this.__aid = aData[i];
				break;

			case 'FID':
				this.__fid = aData[i];
				break;

			case 'IID':
				this.__iid = aData[i];
				break;

			case 'SENDER':
			case 'CERTIFICATE':
				break;

			case 'SMART_ATTACH':
				if (aData.HAS_ATTACHMENT === 'true' || aData.HAS_ATTACHMENT === true) {
					this._getAnchor('smart').style.display = 'flex';
				}
				break;

			case 'DEFERRED_DELIVERY':
				if (GWOthers.getItem('DEFAULT_FOLDERS','sent') == aData.AID +'/'+ aData.FID){
					var d = new IcewarpDate(aData.DEFERRED_DELIVERY);
					elm = this._getAnchor('deferred');
					elm.innerHTML = getLang('MAIL_VIEW::DEFERRED',[d.format('dd L LT')]);
					elm.style.display = 'flex';
				}
				break;

			case 'SMIME_STATUS':

				switch(parseInt(aData.SMIME_STATUS)){
				case 3: addcss(this.__eSubject,'smime'); break;
				case 4: addcss(this.__eSubject,'sign'); break;
				case 5: addcss(this.__eSubject,'ssmime'); break;

				case 2:
				case 6:
				case 7:
				case 10:
					addcss(this.__eSubject,'serror');
					elm = this._getAnchor('serror');
					elm.innerHTML = getLang('MAIL_VIEW::' + ({2:'SERROR',6:'EXPIRED',7:'EXPIRED',10:'SVERIFY'}[parseInt(aData.SMIME_STATUS)]));
					elm.style.display = 'flex';
					break;
				}

				break;

			case 'LIST_UNSUBSCRIBE_POST':
				break;
			case 'LIST_UNSUBSCRIBE':
				list = MailAddress.splitEmailsAndNames(aData.LIST_UNSUBSCRIBE);
				list.forEach(function(adr){
					if (adr.email.toLowerCase().indexOf('mailto:') === 0) {
						var	sTo = adr.email.replace(/^mailto:/, '');
						var web = sTo.split('@')[1];
						var elm = mkElement('span', {
							text: getLang('MAIL_VIEW::UNSUBSCRIBE'),
							className: 'unsubscribe',
							onclick: function(){
								gui._create('unsubscribe', 'frm_confirm', '', 'frm_alert', [function() {
									if (!hascss(this, 'disabled')) {
										var msg = new NewMessage();
										msg._suppressSuccessNotifications = true;
										msg.sTo = sTo;
	
										addcss(this, 'disabled');
	
										msg.send(false, [function(bOK) {
											if (bOK){
												gui.notifier._value({type: 'success', args: {header_plain: '', text_plain: getLang('MAIL_VIEW::UNSUBSCRIBED', [web])}});
												elm.parentElement && elm.parentElement.removeChild(elm);
											} else {
												removecss(elm, 'disabled');
											}
										}]);
									}
								}.bind(this)],'MAIL_VIEW::UNSUBSCRIBE', 'CONFIRMATION::UNSUBSCRIBE_LIST', [web]);
							}
						});

						me._getAnchor('from').appendChild(elm);
						list = [];
					}
				});

				list.forEach(function(adr) {
					if (Is.URL(adr.email)) {
						var host = mkElement('a', {
								href: adr.email
							}).hostname,
							elm = mkElement('span', {
								text: getLang('MAIL_VIEW::UNSUBSCRIBE'),
								className:'unsubscribe',
								onclick: function() {
									gui._create('unsubscribe', 'frm_confirm', '', 'frm_alert', [function() {
										window.open(adr.email);
									}],'MAIL_VIEW::UNSUBSCRIBE', 'CONFIRMATION::UNSUBSCRIBE_LIST', [host]);
								}
							});

						me._getAnchor('from').appendChild(elm);
					}
				});

				break;

			case 'COLOR':
				aHeaders[i] = 'bg_' + ({'1':'red','2':'blue','3':'green','4':'gray','5':'orange','6':'cyan','7':'brown','8':'purple','9':'light_blue','A':'yellow','Y':'complete','Z':'none'}[aData[i]] || 'none');
				break;

			case 'TO':
				if (~['"Undisclosed Recipients" <>', '"undisclosed-recipients:"'].indexOf(aData['TO']))
					break;

				// headers
			case 'PRIORITY':
				aHeaders[i] = aData[i];
				break;

			case 'X_ICEWARP_ATT_DATA':
				this.__aAttData = (Array.isArray(aData[i]) ? aData[i] : [aData[i]]).filter(Boolean);
				break;

			case 'HAS_ATTACHMENT':
				break;

			default:
				if (Is.String(aData[i]) && i.indexOf('X_')<0) aHeaders[i] = aData[i].entityify();
			}
		}

		delete aData.HAS_ATTACHMENT;
		// Transform Conference id to clickable button
		if (aData.X_ICEWARP_CONFERENCE) {
			sBody = await (new cTemplate()).tmp('obj_mailview_conference', {
				conference: aData.X_ICEWARP_CONFERENCE,
				readonly: this._readonly
			}) + sBody;
		}

		// Transform VoiceMail to mp3 player
		if (aData.X_ICEWARP_VOICEMAIL && aData.ATTACHMENTS) {

			for (var atid in aData.ATTACHMENTS)
				if (aData.ATTACHMENTS[atid].values && aData.ATTACHMENTS[atid].values.TYPE == 'audio/mpeg'){
					this._getAnchor('player').style.display = 'flex';
					var p = await this._create('X_player','obj_player','player');
					p._value([{
						src: await Item.webdavURL([this.__aid, this.__fid, this.__iid], atid),
						title: aData.ATTACHMENTS[atid].values.NAME
					}]);

					break;
				}

		}

		// FOLDER SUBSCRIBE 1
		if (aData.X_ICEWARP_SERVER_REQUEST && (!aData.X_ICEWARP_SERVER_REQUEST.METHOD || aData.X_ICEWARP_SERVER_REQUEST.METHOD[0].VALUE != 'invite')){

			var aRights = aData.X_ICEWARP_SERVER_REQUEST.RIGHTS && aData.X_ICEWARP_SERVER_REQUEST.RIGHTS[0].VALUE?aData.X_ICEWARP_SERVER_REQUEST.RIGHTS[0].VALUE.split(""):[],
				tmpi = [], tmpf = [],
				aTplData = {
					'user':aData.X_ICEWARP_SERVER_REQUEST.USER[0].VALUE,
					'author':aData.X_ICEWARP_SERVER_REQUEST.AUTHOR?aData.X_ICEWARP_SERVER_REQUEST.AUTHOR[0].VALUE:'',
					'folder':aData.X_ICEWARP_SERVER_REQUEST.DISPLAYNAME ? aData.X_ICEWARP_SERVER_REQUEST.DISPLAYNAME[0].VALUE : aData.X_ICEWARP_SERVER_REQUEST.FOLDER[0].VALUE,
					'btn_folder':true,
					'btn_account':true
				};

			for(r in aRights)
				switch(aRights[r]){
				case 'r': tmpi.push(getLang('SETTINGS::READ')); break;
				case 'i': tmpi.push(getLang('SETTINGS::WRITE')); break;
				case 'w': tmpi.push(getLang('SETTINGS::MODIFY')); break;
				case 't': tmpi.push(getLang('SETTINGS::DELETE')); break;

				case 'a': tmpf.push(getLang('SETTINGS::OWNER')); break;
				case 'l': tmpf.push(getLang('SETTINGS::READ')); break;
				case 'k': tmpf.push(getLang('SETTINGS::WRITE')); break;
				case 'x': tmpf.push(getLang('SETTINGS::DELETE')); break;
				}

			if (tmpi.length)
				aTplData.items = tmpi.join(', ');

			if (tmpf.length)
				aTplData.folders = tmpf.join(', ');

			if (aTplData.folder == '*')
				aTplData.summary = getLang('MAIL_VIEW::ACCOUNT_ACCESS',[aTplData.author || aTplData.user]);
			else
				aTplData.summary = getLang('MAIL_VIEW::ACCESS',[aTplData.folder,aTplData.author || aTplData.user]);

			if (aData.AID == sPrimaryAccount){
				//Account
				var sSType = '';
				if (aTplData.folder == '*'){
					var tmp_fol = dataSet.get('folders', [sPrimaryAccount, sPrimaryAccountSPREFIX + aTplData.user]);
					if (tmp_fol){
						if (tmp_fol.SUBSCRIPTION_TYPE)
							sSType = tmp_fol.SUBSCRIPTION_TYPE;

						if (tmp_fol.SHARED)
							aTplData.btn_account = false;
					}

					aTplData.btn_folder = false;
				}
				//Folder
				else
				if (aTplData.folder)
					sSType = dataSet.get('folders', [sPrimaryAccount, sPrimaryAccountSPREFIX + aTplData.user +'/'+ aTplData.folder, 'SUBSCRIPTION_TYPE']);

				if (sSType){
					aTplData.btn_folder = false;
					if (sSType == 'account')
						aTplData.btn_account = false;
				}
			}
			else{
				aTplData.btn_folder = false;
				aTplData.btn_account = false;
			}

			sBody = await (new cTemplate()).tmp('obj_mailview_subscribe',aTplData);
		}
		else
		/** iMip 1 **/
		if (aIMIP.length>0){
			var atmp;
			for(i in aIMIP){

				if (!aIMIP[i] || !aIMIP[i].VCALENDAR || !aIMIP[i].VCALENDAR[0])
					continue;

				aTplData = {};

				if (aIMIP[i].VCALENDAR[0]['X-SERVER-NONEDITABLE'])
					aTplData.groupchat = true;

				if (aIMIP[i].VCALENDAR[0].METHOD)
					aTplData.imip_method = aIMIP[i].VCALENDAR[0].METHOD[0].VALUE.toUpperCase();

				atmp = aIMIP[i].VCALENDAR[0];
				if (atmp.VEVENT){

					var out='', t1 = 0, t2;
					//select last vevent
					for (j in atmp.VEVENT){
						if (atmp.VEVENT[j]['LAST-MODIFIED'] && atmp.VEVENT[j]['LAST-MODIFIED'][0].VALUE){
							t2 = new IcewarpDate(atmp.VEVENT[j]['LAST-MODIFIED'][0].VALUE).unix();

							if (t1<t2 || (t1 == t2 && atmp.VEVENT[j]['RECURRENCE-ID'])){
								t1 = t2;
								out = atmp.VEVENT[j];
							}
						}
					}

					atmp = out || atmp.VEVENT[0];
					aTplData.imip_type = 'VEVENT';

					if (aTplData.imip_method != 'COUNTER')
						aTplData.timecontrols = true;

					if (aTplData.imip_method === 'REQUEST' && atmp.SEQUENCE) {
						var sequence = +atmp.SEQUENCE[0].VALUE;
						list = await WMItems.list({
							aid: sPrimaryAccount,
							fid: Mapping.getDefaultFolderForGWType('E'),
							filter: {
								search: 'uid:"' + atmp.UID[0].VALUE + '"',
								limit: 1
							},
							values: ['EVNSEQUENCE', 'EVNFLAGS']
						});
						if (list && (list = list[sPrimaryAccount]) && (list = list[Mapping.getDefaultFolderForGWType('E')])) {
							for (k in list) {
								if (k.indexOf('*') === 0) {
									if (list[k].EVNSEQUENCE > sequence) {
										aTplData.outOfDate = true;
										this._getAnchor('imip').innerHTML = getLang('MAIL_VIEW::OUT_OF_DATE');
										this._getAnchor('imip').style.display = 'flex';
									} else if (list[k].EVNSEQUENCE < sequence) {
										//
									} else if (!(list[k].EVNFLAGS & 32) && !(list[k].EVNFLAGS & 8)) {
										aTplData.accepted = true;
										this._getAnchor('imip').innerHTML = getLang('MAIL_VIEW::ALREADY_ACCEPTED');
										this._getAnchor('imip').style.display = 'flex';
									} else if (list[k].EVNFLAGS & 8) {
										aTplData.tentative = true;
									}
									break;
								}
							}
						}
					}
				}
				else
				if (atmp.VTODO){
					atmp = atmp.VTODO[0];
					aTplData.imip_type = 'VTODO';
				}
				else
				if (atmp.VJOURNAL){
					atmp = atmp.VJOURNAL[0];
					aTplData.imip_type = 'VJOURNAL';

					if (aTplData.imip_method != 'COUNTER')
						aTplData.timecontrols = true;
				}
				else
					continue;

				aTplData.pid = aIMIP[i].VCALENDAR[0].PARTID[0].VALUE;
				aTplData.summary = atmp.SUMMARY && atmp.SUMMARY[0] && atmp.SUMMARY[0].VALUE?atmp.SUMMARY[0].VALUE.entityify():'- - -';

				if (atmp.LOCATION && atmp.LOCATION[0] && atmp.LOCATION[0].VALUE)
					aTplData.location = atmp.LOCATION[0].VALUE.entityify();

				var time;

				if (atmp.DTSTART){

					time = ~atmp.DTSTART[0].VALUE.indexOf('T');
					a = time ? atmp.DTSTART[0].ATTRIBUTES['X-UNIXTIME'] ? IcewarpDate.unix(+atmp.DTSTART[0].ATTRIBUTES['X-UNIXTIME']) : new IcewarpDate(atmp.DTSTART[0].VALUE) : IcewarpDate.julian(atmp.DTSTART[0].ATTRIBUTES['X-CTZDATE'], Math.max(atmp.DTSTART[0].ATTRIBUTES['X-CTZTIME'],0));
					var aa = atmp.DTSTART[0].ATTRIBUTES['X-ORIGINALDATE'] && IcewarpDate.julian(atmp.DTSTART[0].ATTRIBUTES['X-ORIGINALDATE'], Math.max(atmp.DTSTART[0].ATTRIBUTES['X-ORIGINALTIME'],0));

					aTplData.date = '<strong>'+ a.format('dddd') +'</strong>, '+ a.format('L' + (time ? ' LT' : ''));
					if (aa) {
						aTplData.original_date = '<strong>'+ aa.format('dddd') +'</strong>, '+ aa.format('L' + (time ? ' LT' : ''));
					}

					var end = atmp.DTEND || atmp.DTDUE;
					if (end){
						time = ~end[0].VALUE.indexOf('T')
						var b = time ? end[0].ATTRIBUTES['X-UNIXTIME'] ? IcewarpDate.unix(+end[0].ATTRIBUTES['X-UNIXTIME']) : new IcewarpDate(end[0].VALUE) : IcewarpDate.julian(end[0].ATTRIBUTES['X-CTZDATE'], Math.max(end[0].ATTRIBUTES['X-CTZTIME'], 0)),
							bb = end[0].ATTRIBUTES['X-ORIGINALDATE'] && IcewarpDate.julian(end[0].ATTRIBUTES['X-ORIGINALDATE'], Math.max(end[0].ATTRIBUTES['X-ORIGINALTIME'], 0));

						if (aTplData.imip_type === "VEVENT" && !time) {
							a.date(a.date() - 1);
							b.date(b.date() - 1);
							aa && aa.date(aa.date() - 1);
							bb && bb.date(bb.date() - 1);
						}

						if (a.isSame(b, 'day')){
							if (+a != +b)
								aTplData.date += ' - ' + b.format('LT');
						}
						else {
							aTplData.date += ' - ' + b.format('L' + (time ? ' LT' : ''));
						}

						if(aa && bb) {
							if (aa.isSame(bb, 'day')){
								if (+aa != +bb)
									aTplData.original_date += ' - ' + bb.format('LT');
							}
							else {
								aTplData.original_date += ' - ' + bb.format('L' + (time ? ' LT' : ''));
							}
						}
					}

					//With
					if (atmp.ATTENDEE){

						//Owner
						if (atmp.ORGANIZER && atmp.ORGANIZER[0].ATTRIBUTES && atmp.ORGANIZER[0].ATTRIBUTES.CN) {
							aTplData.organiser = atmp.ORGANIZER[0].VALUE;
							aTplData.attendee = '<a href="'+ aTplData.organiser.escapeHTML()+'">' + atmp.ORGANIZER[0].ATTRIBUTES.CN.escapeHTML() + '</a>';
							if (aTplData.organiser.indexOf('mailto:')===0)
								aTplData.organiser = aTplData.organiser.substr(7);
						}
						else
							aTplData.attendee = '';

						//Attendees
						for (var atd in atmp.ATTENDEE)
							if (atmp.ATTENDEE[atd].ATTRIBUTES && atmp.ATTENDEE[atd].ATTRIBUTES.ROLE != 'NON-PARTICIPANT' && (!atmp.ORGANIZER || atmp.ATTENDEE[atd].VALUE != atmp.ORGANIZER[0].VALUE))
								aTplData.attendee += (aTplData.attendee?', ':'') + '<a href="'+ atmp.ATTENDEE[atd].VALUE.escapeHTML()+'">' + (atmp.ATTENDEE[atd].ATTRIBUTES.CN || atmp.ATTENDEE[atd].VALUE.replace(/^mailto:/gi,'')).escapeHTML() + '</a>';
					}

					//Tags
					if (atmp.CATEGORIES && atmp.CATEGORIES[0].VALUE){
						aTplData.tags = [];
						arr = atmp.CATEGORIES[0].VALUE.split(',');
						var aTags = dataSet.get('tags');
						for (var sTag in arr)
							if ((arr[sTag] = arr[sTag].trim()))
								aTplData.tags.push({TAGNAME:arr[sTag],TAGCOLOR:(aTags[arr[sTag]] && aTags[arr[sTag]].TAGCOLOR?aTags[arr[sTag]].TAGCOLOR:'')});
					}

					//Recurrence
					if (atmp.RRULE) {
						aTplData.rcr = true;
						var recur = new iMipRecurrence(atmp.RRULE[0].VALUE,a,time,b);
						aTplData.date = recur.toString();
					}
					else
					//Occurrence
					if (atmp['RECURRENCE-ID'])
						aTplData.ocr = true;

					var text_desc = false;
					if (atmp['X-ALT-DESC'] && atmp['X-ALT-DESC'][0] && atmp['X-ALT-DESC'][0].VALUE) {
						if(atmp['X-ALT-DESC'][0].ATTRIBUTES && atmp['X-ALT-DESC'][0].ATTRIBUTES.FMTTYPE === 'text/html') {
							aTplData.description = DOMPurify.sanitize(atmp['X-ALT-DESC'][0].VALUE);
						} else {
							text_desc = true;
							aTplData.description = atmp['X-ALT-DESC'][0].VALUE;
						}
					} else if (atmp.DESCRIPTION && atmp.DESCRIPTION[0] && atmp.DESCRIPTION[0].VALUE) {
						text_desc = true;
						aTplData.description = atmp.DESCRIPTION[0].VALUE;
					}

					if (text_desc) {
						hla = aTplData.description.highlight_links_array();
						aTplData.description = hla.string.escapeHTML().trim().replace(/\n/g, '<br>').replace(new RegExp(hla.replace, 'g'), function(s, id){
							return hla.array[id];
						});
					}

					if (atmp.COMMENT && atmp.COMMENT[0] && atmp.COMMENT[0].VALUE)
						aTplData.comment = atmp.COMMENT[0].VALUE.escapeHTML().highlight_links();
				}

				//DISABLE BUTTONS
				aTplData.disabled = aTplData.outOfDate || !WMFolders.getAccess([this.__aid, this.__fid]).write || !aTplData.imip_method || !~['REQUEST', 'COUNTER', 'DECLINECOUNTER', 'PUBLISH'].indexOf(aTplData.imip_method);
				aTplData.import_only = aTplData.imip_method === 'PUBLISH';
				aTplData.organiser = aTplData.organiser==sPrimaryAccount;
				aTplData.canceled = aTplData.imip_method === 'CANCEL';

				sBody = (forwarded_invite ? sBody + '<br>' : '') + await (new cTemplate()).tmp('obj_mailview_imip', aTplData);
			}
		}

		var date = dataSet.get('items',[this.__aid,this.__fid,this.__iid,'DATE']);
		if (date){
			var oDate = IcewarpDate.unix(date);
		}

		//add target to links
		//sBody = sBody.replace(/\<[aA]\b/gm,'<a target="_blank" ');

		/* Put Email header together as html */
		var sBody_data = '<div class="iw_webmail_msg_header">'+
		'<h1>'+ (aData['SUBJECT']?aData['SUBJECT'].escapeHTML():'') +'</h1>'+
		'<table>'+
		'<tr><th width="0%" nowrap>'+getLang('DATAGRID_ITEMS_VIEW::FROM')+':&nbsp;</th><td width="100%">'+ (aData['FROM']?aData['FROM'].escapeXML():'') +'</td>'+(oDate?'<td width="0%" valign="top" nowrap>'+(oDate?oDate.format('L LT'):'')+'</td>':'')+'</tr>'+
		(aData['TO']?'<tr><th width="0%" nowrap>'+ getLang('DATAGRID_ITEMS_VIEW::TO') +':&nbsp;</th><td width="100%" colspan="2">'+ aData['TO'].escapeXML() +'</td></tr>':'')+
		(aData['CC']?'<tr><th width="0%" nowrap>'+ getLang('DATAGRID_ITEMS_VIEW::CC') +':&nbsp;</th><td width="100%" colspan="2">'+ aData['CC'].escapeXML() +'</td></tr>':'')+
		(aData['BCC']?'<tr><th width="0%" nowrap>'+ getLang('DATAGRID_ITEMS_VIEW::BCC') +':&nbsp;</th><td width="100%" colspan="2">'+ aData['BCC'].escapeXML() +'</td></tr>':'');

		if (aData['ATTACHMENTS']){
			sBody_data += '<tr><th width="0%" nowrap>'+getLang('DATAGRID_ITEMS_VIEW::ATTACHMENTS')+':&nbsp;</th><td colspan="2">';
			for (j in aData['ATTACHMENTS']) {
				att = aData['ATTACHMENTS'][j]['values'];
				name = att.NAME || att.ATTNAME;
				var size = att.SIZE || att.ATTSIZE;
				if (name)
					sBody_data += name.escapeXML() + (size?' ('+ parseFileSize(size) +')':'') + '; ';
			}
			sBody_data += '</td></tr>';
		}

		sBody_data += '</table></div>';

		// Add Email body
		if (sBody)
			if (this.__TextBody)
				sBody_data += '<div style="font-family: Lucida Console,Courier New,Courier,Monospace;">' + sBody + '</div>';
			else
			if (this.__header_html)
				sBody_data += sBody;
			else
				sBody_data += '<div>' + sBody + '</div>';


		if (this.__header_cert){

			var aOut = {purposes:{}, data:this.__header_cert.values.CERT.INFO[0]};

			aOut.from =	IcewarpDate.utct(aOut.data.VALIDFROM[0].VALUE).format('L LT');
			aOut.to = IcewarpDate.utct(aOut.data.VALIDTO[0].VALUE).format('L LT');

			if (aOut.data.PURPOSES && aOut.data.PURPOSES[0] && aOut.data.PURPOSES[0].ITEM)
				for (i in aOut.data.PURPOSES[0].ITEM)
					if (aOut.data.PURPOSES[0].ITEM[i].VAR1 && aOut.data.PURPOSES[0].ITEM[i].VAR1[0] && aOut.data.PURPOSES[0].ITEM[i].VAR1[0].VALUE == '1' &&
						aOut.data.PURPOSES[0].ITEM[i].VAR3 && aOut.data.PURPOSES[0].ITEM[i].VAR3[0] && aOut.data.PURPOSES[0].ITEM[i].VAR3[0].VALUE)
						switch(aOut.data.PURPOSES[0].ITEM[i].VAR3[0].VALUE){
						case 'sslclient':
							aOut.purposes.SSL = true;
							break;
						case 'smimeencrypt':
						case 'smimesign':
							aOut.purposes.SMIME = true;
							break;
						}

			sBody_data += '<div class="iw_webmail_msg_cert">' + await (new cTemplate()).tmp('frm_certificate', aOut) + '</div>';
		}

		if (!Is.Empty(this.__aImages)){

			sBody_data += '<div class="iw_webmail_msg_images">';

			for (i in this.__aImages)
				sBody_data += '<img src="'+(this.__aImages[i].url.indexOf('http://') == 0 || this.__aImages[i].url.indexOf('https://') == 0 ? this.__aImages[i].url : await Item.webdavURL([this.__aid, this.__fid, this.__iid], this.__aImages[i].url))+'" />';

			sBody_data += '</div>';
		}

		if (sStyles) {
			sBody_data += sStyles;
		}

		await this._frame(sBody_data);

		var removeFreebusy = true;
		if (sBody) {
			this._highlight();

			//hide reply headers
			[].forEach.call(this.__getDoc().querySelectorAll('span[iw-to="'+sPrimaryAccount+'"]'), function(elm){
				elm.style.display = 'none';
			});

			var previewImages = [].filter.call(this.__getDoc().querySelectorAll('img'), function(img) {
				return !img.classList.contains('iw-placeholder') && !img.closest('a');
			});
			previewImages.forEach(function(img) {
				img.style.cursor = 'zoom-in';
				img.addEventListener('click', async function() {
					previewImages = previewImages.filter(function(img) {
						return img.naturalWidth > 1 && img.naturalHeight > 1;
					});
					var imgview = await gui._create('imgview', 'frm_imgview');
					var index = 0;
					var data = previewImages.map(function(img, i) {
						if (img === this) {
							index = i;
						}
						return {
							url: img.src
						};
					}, this);
					await imgview._fill(data);
					imgview._value(index);
				});
			});

			//parse links
			var h =  new RegExp("^"+ this.__doc_base.quoteMeta(),"gi");
			r = /^((http)|(https)|(ftp)):/gi;
			var as = [].concat([].slice.apply(this.__getDoc().getElementsByTagName('a')), [].slice.apply(this.__getDoc().getElementsByTagName('area')));

			// var	tmp = this.__getDoc().getElementsByTagName('a');
			// for (var i = 0; i<tmp.length; i++)
			//     a.push(tmp[i]);

			// var	tmp = this.__getDoc().getElementsByTagName('area');
			// for (var i = 0; i<tmp.length; i++)
			// 	a.push(tmp[i]);

			this.__anchors = {};
			for (i = 0; i<as.length; i++)
				try{
					if (as[i].getAttribute('href')){

						as[i].setAttribute('target','_blank');

						//Anchor
						if (as[i].getAttribute('href').indexOf('#') == 0 || as[i].href.indexOf(document.location.href+'#')==0 || (this.__doc_base && as[i].href.indexOf(this.__doc_base+'#')==0)){
							as[i].removeAttribute('target');
							as[i].onclick = function(){

								var anchor = me.__anchors[this.hash] || me.__anchors[unescape(this.hash)];
								if (Is.Defined(anchor)){
									var elm;
									if ((elm = this.ownerDocument.getElementById('wm_anchor_' + anchor)))
										try{
											var pos1 = getSize(elm, this.ownerDocument),
												pos2 = getSize(me.__eFrame),
												pos3 = getSize(me._main);

											me._getAnchor('block').scrollTop += pos1.y + pos2.y - pos3.y;
										}
										catch(r){ console.log(this._name||false,r);}

									return false;
  								}

  								if (this.getAttribute('href').indexOf('#') == 0)
  									return false;
							};
						}
						//Mailto
						else
						if (as[i].href.toLowerCase().indexOf('mailto:') == 0){
							as[i].onclick = function(){
								var out = {to:this.href.substr(7)};
								if (out.to && out.to.indexOf('?')>-1){
									out.subject = parseURL(out.to).subject;
									out.mailBody = parseURL(out.to).body;
									out.to = out.to.substring(0,out.to.indexOf('?'));
								}
								NewMessage.compose(out);
								return false;
							};

							as[i].oncontextmenu = function(e){
								var p,
									sMail = this.href.substr(7),
									sName = this.innerHTML;

								if ((p = sMail.indexOf('?'))>-1)
								    sMail = sMail.substr(0,p);

								if (sName.indexOf('@')>-1){
									//probably whole EMAIL
									if (sName.indexOf('&lt;')>-1){
										var aMail = MailAddress.splitEmailsAndNames(sName.unescapeHTML());
							            if (aMail && aMail[0] && aMail[0].name && aMail[0].email){
							            	sName = aMail[0].name;
							            	sMail = aMail[0].email;
							            }
							            else
                                        	sName = '';
									}
									else
										sName = '';
								}

								me._context_link(e, sName, sMail);
								return false;
							};
						}
						//Link
						else{
							if (this.__header_base)
								as[i].href = as[i].href.replace(h,this.__header_base);

							if (!Is.URL(as[i].href))
       							as[i].onmousedown = function(){
									window.open(this.href);
									return false;
								};

							var spamreport_regex = new RegExp('^' + location.origin + '/reports/a\\.html\\?a=[^5]');
							if (spamreport_regex.test(as[i].href)) {
								as[i].addEventListener('click', function(i, e) {
									e.preventDefault();
									e.stopPropagation();
									e.stopImmediatePropagation();
									var req = new XMLHttpRequest();
									req.open('GET', as[i].href, false);
									req.send(null);
									var message = (req.responseText.match(/<p>(.*)<\/p>/) || [])[1];
									if (!message) {
										message = req.responseText.split('<')[0];
										if (message) {
											return gui.notifier._value({type: 'alert', args: { text_plain: message }});
										}
									}
									switch(req.status) {
										case 200:
											gui.notifier._value({type: 'success', args: { text_plain: message }});
											break;
										default:
											gui.notifier._value({type: 'info', args: { text_plain: message }});
									}
								}.bind(this, i))
							}
						}
					}
					else
					if (as[i].name){
						this.__anchors['#' + as[i].name] = i;
						as[i].id = 'wm_anchor_' + i;
						as[i].removeAttribute('href');
					}
					else{
						as[i].removeAttribute('href');
						as[i].onclick = function(){return false};
					}
				}
				catch {
					as[i].removeAttribute('href');
					as[i].onclick = function(){return false};
				}

			//change URLs for links and img
			if (this.__header_base){
				as = this.__getDoc().getElementsByTagName('link');
				for (i = 2; i<as.length; i++)
					if (!as[i].getAttribute('iw-skip'))
						as[i].href = as[i].href.replace(h,this.__header_base);
			}

			var elms;
			/** FOLDER SUBSCRIBE 2 - oziveni tlacitek **/
			if (aData.X_ICEWARP_SERVER_TEAMCHAT_NOTIFICATIONS){


				var data = aData.X_ICEWARP_SERVER_TEAMCHAT_NOTIFICATIONS || {};
				var roomID = (((data.ROOM_ID || [])[0] || {}).VALUE || '').replace(/\\/g, '/');
				var threadID = ((data.THREAD_ID || [])[0] || {}).VALUE;
				var postID = ((data.POST_ID || [])[0] || {}).VALUE;

				if(!data.SERVER_ID || data.SERVER_ID[0].VALUE !== dataSet.get('main',['server_id']) || ((data.USER || [])[0] || {}).VALUE !== sPrimaryAccount) {
					[].forEach.call(this.__getDoc().querySelectorAll('.iw-hidden'), function(elm) {
						elm.classList.remove('iw-hidden');
					});
				}
				elms = this.__getDoc().querySelectorAll('.btn-primary');
				[].forEach.call(elms, function(elm) {
					elm.addEventListener('click', async function(e) {
						if(e.ctrlKey || e.metaKey || !dataSet.get('folders', [sPrimaryAccount, roomID])) {
							return;
						}

						e.preventDefault();
						e.stopPropagation();
						e.stopImmediatePropagation();

						if (threadID || postID) {
							return gui.frm_main._openTeamchatThread({
								aid: sPrimaryAccount,
								fid: roomID,
								iid: WMItems.__clientID(threadID || postID)
							});
						}

						Cookie.set(['filter_tree'], 'I,Y');
						gui.frm_main.filter.__filter('I');

						var folders = gui.frm_main.bar.folders;
							await folders._setActive(sPrimaryAccount + '/' + roomID);
							folders._handleNode({
								aid: sPrimaryAccount,
								fid: roomID
							});
							folders._filter_folder(['I', 'Y']);
							folders._fill();
					});

				});

			} else if (aData.X_ICEWARP_SERVER_REQUEST){
            	if (aData.X_ICEWARP_SERVER_REQUEST.METHOD && aData.X_ICEWARP_SERVER_REQUEST.METHOD[0].VALUE == 'invite'){
            		if (aData.X_ICEWARP_SERVER_REQUEST.SERVER_ID && aData.X_ICEWARP_SERVER_REQUEST.SERVER_ID[0].VALUE == dataSet.get('main',['server_id']) && aData.X_ICEWARP_SERVER_REQUEST.USER && aData.X_ICEWARP_SERVER_REQUEST.FOLDER){

						elms = this.__getDoc().querySelectorAll('.btn-primary');
						[].forEach.call(elms, function(elm) {

							var aF = dataSet.get('folders',[sPrimaryAccount]),
								srp = Path.slash(aData.X_ICEWARP_SERVER_REQUEST.FOLDER[0].VALUE),
								onclick = function(){
									if (dataSet.get('folders',[sPrimaryAccount, fid])){
										//gui.frm_main.bar.folders._setActive(sPrimaryAccount +'/' + fid);
										//gui.frm_main.bar.folders._handleNode({aid:sPrimaryAccount, fid:fid});

										//should be used...
										gui.frm_main.filter.__filter('I', false, true);
										gui.frm_main._selectView({'aid':sPrimaryAccount,'fid':fid});

										return false;
									}
									gui.notifier._value({type: 'teamchat_not_exists', args: [srp]});

									return false;
								};

							for (var fid in aF){
								if (aF[fid].TYPE == "I" && aF[fid].RELATIVE_PATH == srp){

									elm.onclick = onclick;

									break;
								}
							}
							elm.onclick = elm.onclick || function(){
								accounts.refresh({'aid':sPrimaryAccount},'folders','',[function() {
									aF = dataSet.get('folders',[sPrimaryAccount]);
									for (var fid in aF){
										if (aF[fid].TYPE == "I" && aF[fid].RELATIVE_PATH == srp){
											return onclick();
										}
									}
									gui.notifier._value({type: 'teamchat_not_exists', args: [srp]});
								}]);
								return false;
							};
						});
					}

            	}
            	else{
					elm = this.__getDoc().getElementsByTagName('form');
					if (elm && (elm = elm[0])){
						if ((elm = elm.getElementsByTagName('input'))){
							for(i = elm.length-1; i>=0; i--)
								if (elm[i].type == 'button'){

									//Subscribe Account
									if (elm[i].name == 'account'){
										/*
										var tmp_fol = dataSet.get('folders',[sPrimaryAccount,sPrimaryAccountSPREFIX + aData.X_ICEWARP_SERVER_REQUEST.USER[0].VALUE]);
										if (tmp_fol && tmp_fol.SHARED)
											elm[i].disabled = true;
										else
										{
										*/
										elm[i].onclick = function(){
											this.disabled = true;
											var aAccountInfo = {
												aid:sPrimaryAccount,
												subscription:[aData.X_ICEWARP_SERVER_REQUEST.USER[0].VALUE]
											};

											WMAccounts.subscribe(aAccountInfo,[this,'__disable']);
										};

										elm[i].__disable = function(aResponse){
											try{
												if (aResponse.IQ[0].ERROR){
													gui.notifier._value({type: 'alert', args: {header: '', text: 'ERROR::SUBSCRIBE_ERROR', args: [aResponse.IQ[0].ERROR[0].VALUE]}});
													this.disabled = false;
													return;
												}
												else{
													gui.notifier._value({type: 'account_subscribed', args: [aData.X_ICEWARP_SERVER_REQUEST.USER[0].VALUE]});

													//Remove Email
													if (me.__aid && me.__fid && me.__iid){
					                                        Item.remove([me.__aid,me.__fid,[me.__iid]],true);

														if (me._parent._type == 'frm_mail')
															me._parent._destruct();
													}
												}
											}
											catch {
												this.disabled = false;
											}

											//Refresh
											accounts.refresh({'aid':sPrimaryAccount},'folders');
										};
										//}
									}
									//Subscribe Folder
									else
									if (elm[i].name == 'subscribe'){

										/*
										var tmp_fol = dataSet.get('folders',[sPrimaryAccount,sPrimaryAccountSPREFIX + aData.X_ICEWARP_SERVER_REQUEST.USER[0].VALUE + (aData.X_ICEWARP_SERVER_REQUEST.FOLDER[0].VALUE == '*'?'':'/' + aData.X_ICEWARP_SERVER_REQUEST.FOLDER[0].VALUE)]);
										if ((tmp_fol && tmp_fol['TYPE']) || aData.X_ICEWARP_SERVER_REQUEST.FOLDER[0].VALUE == '*')
											elm[i].disabled = true;
										else
										{
										*/
										elm[i].__disable = function(bOK,aResponse,sType,sAccount,sFolder){
											try{
												if (bOK){
													gui.notifier._value({type: (!sFolder || sFolder == '*'?'ACCOUNT':'FOLDER') + '_' + (sType=='subscribe'?'SUBSCRIBED':'UNSUBSCRIBED'), args: [sAccount,sFolder]});

													//Remove Email
													if (bOK && me.__aid && me.__fid && me.__iid){
														Item.remove([me.__aid,me.__fid,[me.__iid]],true);

														if (me._parent._type == 'frm_mail')
															me._parent._destruct();
													}
												}
												else{
													gui.notifier._value({type: 'alert', args: {header: '', text: 'MAIL_VIEW::ERROR', args: [sAccount,sFolder]}});
													this.disabled = false;
													return;
												}
											}
											catch {
												this.disabled = false;
											}

											//Refresh
											accounts.refresh({'aid':sPrimaryAccount},'folders');
										};

										elm[i].onclick = function(){
											if (me.__aid && me.__fid && me.__iid){
												this.disabled = true;
												WMItems.action({aid:me.__aid,fid:me.__fid,iid:me.__iid},this.name,[this,'__disable',[this.name,aData.X_ICEWARP_SERVER_REQUEST.USER[0].VALUE,aData.X_ICEWARP_SERVER_REQUEST.FOLDER[0].VALUE]]);
											}
										};

										//}

									}
								}
						}
					}
				}
			}
			else
			/** iMIP 2 - oziveni tlacitek **/
			if (aIMIP.length>0 && atmp && (atmp.DTSTART || atmp['PERCENT-COMPLETE'])){
				var aItem = {aid:this.__aid, fid:this.__fid, iid:this.__iid};

				if (aTplData.imip_type == 'VEVENT' && !aTplData.canceled && atmp.DTSTART && (atmp.DTEND || atmp.DTDUE) && atmp.UID) {
					removeFreebusy = false;
					if (!me.x_freebusy || me.x_freebusy._destructed) {
						await this._create('x_freebusy', 'obj_freebusy', 'block', '');
					}
					me._x_freebusy_helper = me._x_freebusy_helper || mkElement('div', {
						className: 'freebusy_helper'
					});
					this.x_freebusy._main.insertAdjacentElement('beforebegin', me._x_freebusy_helper);
					this.x_freebusy._obeyEvent('ondestruct', [function() {
						me._x_freebusy_helper.parentElement && me._x_freebusy_helper.parentElement.removeChild(me._x_freebusy_helper);
					}]);

					this.x_freebusy._init({
						evnid: atmp.UID[0].VALUE,
						users: [sPrimaryAccount],
					});

					this.x_freebusy._readonly(true);

					if (aTplData.imip_method === 'REPLY') {
						me._x_freebusy_helper.innerHTML = '';
					}
					this.x_freebusy._obeyEvent('oncollision', [function(_, args) {
						if(args.arg) {
							me._x_freebusy_helper.classList.add('collision');
							if(aTplData.imip_method === 'COUNTER' || aTplData.imip_method === 'REPLY') {
								me._x_freebusy_helper.innerHTML = getLang('MAIL_VIEW::FREEBUSY_BUSY');
							} else {
								me._x_freebusy_helper.innerHTML = getLang('MAIL_VIEW::FREEBUSY_BUSY_PROPOSE', ['<a>' + getLang('MAIL_VIEW::PROPOSE') + '</a>']);
								me._x_freebusy_helper.querySelector('a').onclick = function() {
									var button = me.__doc.getElementsByTagName('form')[0].querySelector('input[name=propose]');
									button.onclick.call(button);
								};
							}
						} else {
							me._x_freebusy_helper.innerHTML = (aTplData.imip_method === 'REPLY') ? '' : getLang('MAIL_VIEW::FREEBUSY_FREE');
							me._x_freebusy_helper.classList.remove('collision');
						}
					}]);

					var startT = ~atmp.DTSTART[0].VALUE.indexOf('T');
					var endT = ~(atmp.DTEND || atmp.DTDUE)[0].VALUE.indexOf('T');
					this.x_freebusy._value({
						startdate: +atmp.DTSTART[0].ATTRIBUTES['X-CTZDATE'],
						starttime: a.format(IcewarpDate.JULIAN_TIME),
						enddate: +(atmp.DTEND || atmp.DTDUE)[0].ATTRIBUTES['X-CTZDATE'],
						endtime: b.format(IcewarpDate.JULIAN_TIME),
						title: atmp.SUMMARY?atmp.SUMMARY[0].VALUE:'',
						tzid: normalizeTimezone(GWOthers.getItem('CALENDAR_SETTINGS', 'timezone'))
					});
				}

				for(i in aIMIP){
					var frm;
					if ((frm = this.__getDoc().getElementsByTagName('form')))
						for (k=0;k<frm.length;k++){
							elm = frm[k].getElementsByTagName('input');

							for (j=0;j<elm.length;j++){
								if (elm[j].type != 'button') continue;

								if (me.__aid != sPrimaryAccount)
									elm[j].disabled = true;
								else{
									elm[j].__disable = function(bOK, bObsolete, aItem, bRemove) {
										bRemove = bRemove || (GWOthers.getItem('MAIL_SETTINGS_GENERAL', 'delete_invitation') == 1);
										//Remove Email after action
										if (((bOK && bRemove) || bObsolete) && aItem && aItem.aid && aItem.fid && aItem.iid){
											Item.remove([aItem.aid,aItem.fid,[aItem.iid]], GWOthers.getItem('MAIL_SETTINGS_GENERAL','move_to_trash') == 0, false, (gui.frm_main.main || {}).list, (gui.frm_main.main || {}).list && gui.frm_main.main.list.__getNext([me.__iid]));
											me.x_freebusy && me.x_freebusy._destruct();

											if (me._parent._type == 'frm_mail')
												me._parent._destruct();

											//Show Info...
											if (!bObsolete)
												gui.notifier._value({type: (aItem.imip_type === 'VTODO' ? 'task_' : 'event_') + ({accept: "accepted",tentative:"unsure",decline:"declined",propose:'proposed'})[this.name]});
										}
										else{
											var inp = this.form.querySelectorAll('input[type=button]');
											for(var i = inp.length;i--;)
												inp[i].disabled = bOK && inp[i] == this;
										}
									};


									elm[j].__imipID = i;
									if (elm[j].name === 'accept' && aTplData.accepted) {
										elm[j].disabled = true;
									}
									if (elm[j].name === 'tentative' && aTplData.tentative) {
										elm[j].disabled = true;
									}
									elm[j].onclick = async function(){
										aItem.partid = this.form.partid.value;
										aItem.imip_type = this.form.imip_type.value;

										var name = this.name + (this.form.imip_method.value == 'COUNTER'?'_counter':''),
											self = this;

										this.disabled = true;

										switch(this.name){
										case 'decline':

											var frm = await gui._create('decline','frm_text','','frm_ok_cancel', [
												function(s){
													aItem.reason = s;
													WMItems.imip(aItem, name, [self, '__disable', [aItem]]);
												}],
											'EVENT::REASON');

											frm._onclose = function(){
												self.disabled = false;
												return true;
											};

											frm.x_btn_ok._value('FORM_BUTTONS::DECLINE');
											break;

										case 'propose':
											var list = await WMItems.list({
												aid: sPrimaryAccount,
												fid: Mapping.getDefaultFolderForGWType('E'),
												filter: {
													search: 'uid:"' + atmp.UID[0].VALUE + '"',
													limit: 1
												},
												values: WMItems.default_values('E')
											});
											if (list && (list = list[sPrimaryAccount]) && (list = list[Mapping.getDefaultFolderForGWType('E')])) {
												for (var k in list) {
													if (k.indexOf('*') === 0) {
														Item.openwindow([sPrimaryAccount, Mapping.getDefaultFolderForGWType('E'), k], list[k], null, 'E', { propose: true },[
															function(frm){
																frm._onclose = function(){
																	self.disabled = false;
																	return true;
																};

																frm.x_btn_ok._onclick = async function(){
																	if(await frm._userEdited()) {
																		aItem.gwparams = frm.X_TIMEINTERVAL._value();
																		WMItems.imip(aItem, 'propose', [self,'__disable',[aItem]]);
																	}
																	frm._destruct();
																};
																frm.x_btn_ok._disabled(false);
															}
														]);
													}
												}
											} else {
												WMItems.action({
													aid: me.__aid,
													fid: me.__fid,
													iid: me.__iid + '|' + aItem.partid,
													attrs: {
														delete: 1
													}
												}, 'importattachment', [function(bOK, xResponse) {
													var aValues = WMItems.parse(xResponse);
													for (var aid in aValues)
														for (var fid in aValues[aid]) {
															delete aValues[aid][fid]['/'];
															delete aValues[aid][fid]['#'];
															delete aValues[aid][fid]['$'];
															delete aValues[aid][fid]['@'];
															for (var iid in aValues[aid][fid]) {
																aValues = aValues[aid][fid][iid];
	
																Item.openwindow([aid, fid, iid], aValues, null, 'E', { propose: true },[
																	function(frm){
																		frm._onclose = function(){
																			self.disabled = false;
																			return true;
																		};
	
																		frm.x_btn_ok._onclick = function(){
																			if(frm._userEdited()) {
																				aItem.gwparams = frm.X_TIMEINTERVAL._value();
																				WMItems.imip(aItem, 'propose', [self,'__disable',[aItem, true]]);
																			}
																			frm._destruct();
																		};
																		frm.x_btn_ok._disabled(false);
																	}
																]);
	
															}
														}
													self.__disable(bOK, aItem, true);
													}]);
											}
											break;

										case 'tentative':
											WMItems.imip(aItem, name, [this,'__disable',[aItem]]);
											break;

										default:
											WMItems.imip(aItem, name, [function(bOk, bObsolete) {
												this.__disable(bOk, bObsolete, aItem);
												me._getAnchor('imip').innerHTML = getLang('MAIL_VIEW::ALREADY_ACCEPTED');
												me._getAnchor('imip').style.display = 'flex';
											}.bind(this)]);
										}

									};
								}
							}
						}
				}
			}
		}

		if(removeFreebusy && me.x_freebusy) {
			await me.x_freebusy._destruct();
		}

		/*
		else
			this._frame('');
*/

		if(this.__preventPrint) {
			window.removeEventListener('keydown', this.__preventPrint);
			this.__doc.defaultView.removeEventListener('keydown', this.__preventPrint);
		}
		if (this.__static_flags & 4) {
			this.__preventPrint = function(e) {
				if ((e.ctrlKey || e.metaKey) && e.key === 'p') {
					e.preventDefault();
				}
			};
			window.addEventListener('keydown', this.__preventPrint);
			this.__doc.defaultView.addEventListener('keydown', this.__preventPrint);

			this.__doc.head.appendChild(mkElement('style', {
				type: 'text/css',
				media: 'print',
				textContent: 'body { visibility: hidden; display: none }'
			}));
		}
		if (this.__static_flags & 4 || this.__static_flags & 32) {
			this.__doc.head.appendChild(mkElement('style', {
				type: 'text/css',
				textContent: `* {
					-webkit-touch-callout: none!important;
					-webkit-user-select: none!important;
					user-select: none!important;
				}`
			}));
		}

		await this._header(aHeaders);

		//show images
		if (!Is.Empty(this.__aImages)){
			await storage.library('gw_others');
			if (parseInt(GWOthers.getItem('MAIL_SETTINGS_GENERAL','auto_show_images')) == 1)
				this.__showImages();
			else
				this.__showImages(true);
		}
		else
			this.__showImages(true);

		/*
		else
		if (this.btn_show)
			this.btn_show._destruct();
		*/

		if (GWOthers.getItem('MAIL_SETTINGS_GENERAL', 'mark_as_read') > 0) {
			clearTimeout(this.__mark_as_read_timeout);
			this.__mark_as_read_timeout = setTimeout(function () {
				// destruted | skeleton | already read
				if (this._destructed || this._main.classList.contains('skeleton') || !me.__iid || (dataSet.get('items', [me.__aid, me.__fid, me.__iid, 'FLAGS']) & 32)) {
					return;
				}
				OldMessage.markAsRead([me.__aid, me.__fid, [me.__iid]]);
			}.bind(this), GWOthers.getItem('MAIL_SETTINGS_GENERAL', 'mark_as_read_delay') * 1000);
		}
	}
	catch(r){
		console.log(r);
		window.Sentry && Sentry.withScope(function(scope) {
			scope.setTag('module', 'mail');
			Sentry.captureException(r);
		});
	}

};

_me._highlight = function() {
	this._unhighlight();
	this.__searchQuery = gui.frm_main.search.search.getQuery();
	var results;
	if ((results = this.__searchQuery.match(/\+"(.*?)"/)) && results[1]) {
		this.__highlight(this.__getDoc().body, results[1]);
	}
}

_me._unhighlight = function() {
	[].forEach.call(this.__getDoc().body.querySelectorAll('.iw-highlight'), function(node) {
		node.classList.remove('iw-highlight');
	});
};

_me.__highlight = function(node, needle) {
	var skip = 0;
	if (node.nodeType == 3) {
		var pos = node.data.match(new RegExp(needle.replace(/([\\\[\]])/g, '\\$1'), 'i'));
		if (pos && pos.index >= 0) {
			var spannode = document.createElement('span');
			spannode.className = 'iw-highlight';
			var middlebit = node.splitText(pos.index).splitText(needle.length).previousSibling;
			spannode.appendChild(middlebit.cloneNode(true));
			middlebit.parentNode.replaceChild(spannode, middlebit);
			skip = 1;
		}
	} else if (node.nodeType == 1 && node.childNodes && !(/(script|style)/i).test(node.tagName)) {
		for (var i = 0; i < node.childNodes.length; ++i) {
			i += this.__highlight(node.childNodes[i], needle);
		}
	}
	return skip;
};