_me = obj_mail_suggest.prototype;
function obj_mail_suggest(){};

/**
 * @brief: CONSTRUCTOR
 * @date : 29.1.2013
 **/
_me.__constructor = async function(){
	var me = this;

	this.__activeFirst = true;

	this._min = 1;
	this._limit = 15;
	this._folder;

	this.__hints = [];
	this.__relay = '';

	//Scrollbar
	this.__block = this._getAnchor('container');
	this._scrollbar(this.__block, this._main);

	//Registr Drop
	if (gui.frm_main && gui.frm_main.dnd){
		//Drag and Drop
		this.__etag.onmousedown = function(e){

			if (me.__dndtimer){
				window.clearTimeout(me.__dndtimer);
				delete me.__dndtimer;
			}

			if (e.button>1 || e.ctrlKey || e.metaKey || !me.__initdrag) return;
			var elm = e.target;

			if (elm == this || elm.tagName == 'INPUT') return;
			if (elm.tagName != 'SPAN')
				elm = Is.Child(elm,'SPAN');

			//fire the event :)
			if (elm) {
				var x = e.clientX, y = e.clientY;

				me._gui._obeyEvent('mouseup',[me,'__dndDispatch']);
				me.__dndtimer = setTimeout(function(){
					me.__initdrag(elm, x, y);
				}, 250);

				e.preventDefault();
				e.stopPropagation();
			}
		};

		this._placeholder(getLang('POPUP_ITEMS::ENTER_EMAIL_ADDRESS'));

		gui.frm_main.dnd.registr_drop(this,['rcp','jabber','item']);
	}

	this.__etag.oncontextmenu = async function(e) {
		var elm = e.target;

		if (elm == this || elm.tagName == 'INPUT') return;
		if (elm.tagName != 'SPAN')
			elm = Is.Child(elm,'SPAN');
		
		if (elm) {
			e.preventDefault();

			var aMail = MailAddress.splitEmailsAndNames(elm.getAttribute('val'));

			elm.classList.add('active');
			var pos = getSize(elm),
				cmenu = await me._gui._create('cmenu', 'obj_context_link', '', '', aMail[0].name, aMail[0].email);
			cmenu._place(pos.x + (pos.w / 2), pos.y + pos.h, '', 2);

			cmenu.__remove_class = function() {
				elm.classList.remove('active');
			};
			cmenu._add_destructor('__remove_class');
		}
	}

	this.plus._onpaste = function(e) {
		var toPaste = (e.clipboardData.getData('text/plain') || e.clipboardData.getData('text')).replace(/[\u200B-\u200D\uFEFF]/g, '').trim();
		var a = me._decode(toPaste.split('\n').join(';'));
		for (var i in a) {
			me._addTag(a[i]);
		}
		e.preventDefault();
		return false;
	};
};

_me._onexpand = function(elm){
	if (elm){
		var v = elm.getAttribute('val'),
			me = this;

		//remove []
		v = v.substr(1,v.length-2);

		this._gui._create('expand','frm_confirm','','frm_alert noblur', [function(){

			if (elm && v){

				var id = v;
				if(v.indexOf('::')) {
					id = v.split('::')[0];
				}
				if(~['I', 'Y'].indexOf(WMFolders.getType([sPrimaryAccount, id]))) {
					WMItems.list({
						aid: sPrimaryAccount,
						fid: '__@@GROUP@@__/' + id
					},'','','',[function(response) {
						response = ((response || {})[sPrimaryAccount] || {})['__@@GROUP@@__/' + id];
						if(!response) {
							return gui.notifier._value({type: 'alert', args: {header: 'ALERTS::NOT_FOUND', text: 'CONFIRMATION::DL_NOT_FOUND'}});
						}
						for(var i in response) {
							if(!i.indexOf('*')) {
								var a = me._decode(MailAddress.createEmail(response[i].FRTNAME, response[i].FRTEMAIL));
								for (var j in a){
									me._addTag(a[j], elm);
									elm = '';
								}
							}
						}
					}]);
				} else {
					var fid = '__@@ADDRESSBOOK@@__';

					//DL with path
					if (v.indexOf('::')>1){
						var tmp = v.split('::');
						fid = tmp[0];
						v = tmp[1];
					}

					WMItems.list({"aid": sPrimaryAccount, "fid": fid,
						filter:{search: '"' + v.replace(/"/g,'\\"') + '"'},
						values:['ITMCLASS', 'ITMCLASSIFYAS']
					}, '', '', '', [function(aData){

						if (aData && (aData = aData[sPrimaryAccount]) && (aData = aData[fid])){
							var exactMatch;
							for(var iid in aData) {
								if (aData[iid].ITMCLASS == 'L' && aData[iid].ITMCLASSIFYAS === v) {
									exactMatch = iid;
									break;
								}
							}
							//Search
							for(iid in aData)
								if (iid.charAt(0) == '*')
									if (aData[iid].ITMCLASS == 'L'){
										if (exactMatch && exactMatch !== iid) {
											continue;
										}
										//Load Item
										WMItems.list({"aid": sPrimaryAccount, "fid": fid, iid:iid},'','','',[
											function(aData){
												if (aData && (aData = aData[sPrimaryAccount]) && (aData = aData[fid]) && (aData = aData[iid]) && (aData = aData.LOCATIONS)) {
													if (elm) {
														me._removeTag(elm);
														elm = '';
													}
													for(var lid in aData)
														if (aData[lid].values && aData[lid].values.LCTEMAIL1){
															var a = me._decode(MailAddress.createEmail(aData[lid].values.LCTDESCRIPTION, aData[lid].values.LCTEMAIL1));
															for (var i in a){
																me._addTag(a[i]);
															}
														}
												}
											}
										]);

										return;
									}
						}

						//Not found
						gui.notifier._value({type: 'alert', args: {header: 'ALERTS::NOT_FOUND', text: 'CONFIRMATION::DL_NOT_FOUND'}});

					}]);
				}

			}

		}], 'ALERTS::ALERT', 'CONFIRMATION::EXPAND');

	}
};

//decode input content
_me._decode = function(v){
	if ((v || '').indexOf('@') === 0) {
		var tmp = (v || '').replace(/::/g, '§§').split(':').map(function(v) {
			return v.replace(/§§/g, '::');
		});
		v = tmp.pop();
		this.__relay = tmp.length ? tmp.join(':') + ':' : (this.__relay || '');
	}
	var aIN = MailAddress.splitEmailsAndNames(v),
		rx = new RegExp("^([a-z0-9\\'\\!\\#\\$\\%\\&\\+\\-\\/\\=\\?\\^\\_\\`\\{\\|\\}\\~\\*][\\.]?)+",'gim'),
		aOut = [];

	for (var i in aIN) {
		var email = aIN[i].email || '';
		var unpunied = punycode.toASCII(email.toLowerCase());
		//Name & Email
		if (aIN[i].name && email)
			aOut.push({tag:MailAddress.createEmail(aIN[i].name, this.__relay + email), label:MailAddress.createEmail(aIN[i].name, this.__relay + email, true)});
		else
		//Email only
		if (email){
			if (!Is.Email(unpunied)){

				//Distrib
				if (email.indexOf('[') === 0 && email.indexOf(']') === email.length - 1) {
					aOut.push({tag: this.__relay + email, label: this.__relay + ((email.match(/\[(?:.*::)?(.*)\]/) || [])[1]) || false, expand: true});
					continue;
				}

				if (email.indexOf('@')<0){
					//Some spaces
					if (email.indexOf(' ') >- 1){
						var a = email.split(' ');
						if (a.length>1){
							aOut = aOut.concat(this._decode(a.join(',')));
							continue;
						}
					}
					//local name
					else
					if (rx.test(email)){
						aOut.push({tag:this.__relay + email, label: this.__relay + email});
						continue;
					}
				}

				//wrong
				aOut.push({tag:this.__relay + email,err:1, label: this.__relay + email});
			}
			//Email only
			else
				aOut.push({tag:this.__relay + email, label: this.__relay + email});
		}
	}

	this.__relay = '';

	return aOut;
};

_me._getErrors = function(value) {
	var errors = [],
		aIN = MailAddress.splitEmailsAndNames(value || this._value()),
		rx = new RegExp("^([a-z0-9\\'\\!\\#\\$\\%\\&\\+\\-\\/\\=\\?\\^\\_\\`\\{\\|\\}\\~\\*][\\.]?)+", 'gim');

	for (var i in aIN) {
		var email = aIN[i].email || '';
		var unpunied = punycode.toASCII(email.toLowerCase());
		if (email.indexOf('@') === 0) {
			var tmp = email.replace(/::/g, '§§').split(':').map(function(v) {
				return v.replace(/§§/g, '::');
			});
			email = tmp.pop();
			tmp = tmp[0];
			if (tmp) { // relays
				tmp = tmp.split(',');
				var error;
				for (var j in tmp) {
					if (tmp[j][0] !== '@') {
						errors.push(aIN[i].email);
						error = true;
						break;
					}
				}
				if (error) {
					break;
				}
			}
		}
		if (!Is.Email(unpunied)){

			//Distrib
			if (email.indexOf('[') === 0 && email.indexOf(']') === email.length - 1) {
				continue;
			}

			if (email.indexOf('@')<0){
				//Some spaces
				if (email.indexOf(' ') >- 1){
					var a = email.split(' ');
					if (a.length > 1) {
						errors = errors.concat(this._getErrors(a.join(',')));
						continue;
					}
				}
				//local name
				else
				if (rx.test(email)){
					continue;
				}
			}

			//wrong
			errors.push(email);
		}
	}

	return errors;
};

//OK Inherited
_me._qdata = function(v){

	var cart = this._getCartPos(),
		end = false, word = [0,0];

	for (var i=0, l=v.length; i<l; i++){
		switch(v.charAt(i)){
		case ',':
			if (cart<=i)
				end = true;
			else
				word = [i+1,i+1];

			break;

		default:
            	word[1] = i+1;
		}

		if (end) break;
	}

	v = v.substring(word[0],word[1]);
	this.__last_pos = [word[0],word[1],v];
	return v;
};

//OK (inherited)
_me._qvalue = function(v){
	if (Is.Object(v))
		v = v.value;

	if (typeof v != 'undefined'){
		var inp = this._getFocusedInput();
		if (inp){

			var old = inp._value();
			this._qdata(old);
			inp._value(old.substr(0,this.__last_pos[0]) + v + old.substr(this.__last_pos[1]));

			//Add New Imidietly
			if (inp._name == 'plus') {
				this.__inpBlur('',{owner:inp});
			}
		}
	}
};

//OK
_me._query = function(v){
	var tmp, aFilter;
	if (v.indexOf('[')==0){
		tmp = v;
		if (!(v = v.replace(/[[\]]+/g,'')))
		    return;

   		this.__last_qdata = {email:tmp};

		v = v.replace(/'/g, "''").replace(/%/g , "\\%");
		aFilter = {
			search: 'class:L classify:'+v,
			sort:'ITMCLASSIFYAS',
			limit: this._limit
		};
	}
	else{
		//4. naparsovat adresu
		if ((v || '').indexOf('@') === 0) {
			tmp = (v || '').replace(/::/g, '§§').split(':').map(function(v) {
				return v.replace(/§§/g, '::');
			});
			v = tmp.pop();
		}
		var aParsed = MailAddress.splitEmailsAndNames(v)[0];

		if (!aParsed) {
			return;
		}

		if (!aParsed.name)
			aParsed.name = aParsed.email;

		this.__last_qdata = aParsed;
		aFilter = {
			search: 'addressbook:"' + v.replace(/"/g,'\\"') + '"',
			limit: this._limit * 2,
			nocount: 1,
			groupbyemail: GWOthers.getItem('MAIL_SETTINGS_GENERAL', 'GROUP_CONTACTS_BY_EMAIL') == '1',
			includesentfolderemails: GWOthers.getItem('MAIL_SETTINGS_DEFAULT', 'SUGGEST_SENT_FOLDER_EMAILS') == '1'
		};
	}

	if (!sPrimaryAccountGW || (GWOthers.getItem('RESTRICTIONS', 'disable_gw_types') || '').indexOf('c')>-1)
		this._parse(v,[]);
	else{

		// if (+GWOthers.getItem('RESTRICTIONS', 'disable_group_sharing'))
		// 	aFilter.search += ' AND flags:0';

		WMItems.list({'aid':sPrimaryAccount,'fid':(GWOthers.getItem('RESTRICTIONS','gal_suggest') == 1?"__@@ADDRESSBOOK@@__":Mapping.getDefaultFolderForGWType('C')),'values':['ITMTITLE','ITMCLASS','ITMCLASSIFYAS','ITMFIRSTNAME','ITMMIDDLENAME','ITMSURNAME','ITMSUFFIX','LCTEMAIL1','LCTEMAIL2','LCTEMAIL3','LCTTYPE'],'filter':aFilter},'','','',[this,'_parse',[v]]);
	}
};

// OK
_me._parse = async function(sWord,aValues){
	var i, input = this._input_value() || '';
	if (input.indexOf('@') === 0) {
		var tmp = input.replace(/::/g, '§§').split(':').map(function(v) {
			return v.replace(/§§/g, '::');
		});
		input = tmp.pop();
		this.__relay = tmp.length ? tmp.join(':') + ':' : '';
	}
	if (!aValues || input != sWord){
		this.__show();
		this.__sLastRequestString = '';
		return;
	}

	var emails = [], name, email;
	//Prepare Query data
	if (!Is.Empty(aValues)){

		for(var aid in aValues)
			for (var fid in aValues[aid]);

		if (aid && fid && (aValues = aValues[aid][fid])){

			delete aValues['/'];
			delete aValues['#'];
			delete aValues['$'];
			delete aValues['@'];

			var found;
			for(i in aValues){

				if (aValues[i].ITMCLASS == 'L'){
					email = ['['+aValues[i].ITMCLASSIFYAS+']'];
					name  = '';
				}
				else
				if (!aValues[i].LCTEMAIL1 && !aValues[i].LCTEMAIL2 && !aValues[i].LCTEMAIL3)
					    continue;
				else{
					name  = aValues[i].ITMCLASSIFYAS || ((aValues[i].ITMFIRSTNAME || '') + (aValues[i].ITMSURNAME?' '+aValues[i].ITMSURNAME:''));
					email = [];
					if (aValues[i].LCTEMAIL1)
						    email.push(aValues[i].LCTEMAIL1);

					if (GWOthers.getItem('MAIL_SETTINGS_GENERAL','search_primary') != 1){
						if (aValues[i].LCTEMAIL2)
							    email.push(aValues[i].LCTEMAIL2);

						if (aValues[i].LCTEMAIL3)
							    email.push(aValues[i].LCTEMAIL3);
					}

				}

				for(var j in email){
					found = false;

					for (var k in emails)
						if (emails[k].email.toLowerCase() == email[j].toLowerCase() || (aValues[i].ITMCLASS=='L' && ('['+emails[k].email.toLowerCase()+']') == email[j].toLowerCase())){
							if (name && !emails[k].name)
								emails[k].name = name;

							found = true;
						}

					if (!found)
						emails.push({name:name,email:email[j]});
				}
			}
		}
	}

	//Concat Query and Cookie Data
	var recipientHistory = Cookie.get(['recipient_history']) || [];
	var domain = '@' + dataSet.get('main', ['domain']);
	var sc = function (a,b) {
		var rha = ~recipientHistory.indexOf(a.email);
		var rhb = ~recipientHistory.indexOf(b.email);

		if (rha && rhb) {
			return ~rha - ~rhb;
		}
		if (rhb) {
			return 1;
		}
		if (rha) {
			return -1;
		}

		var inta = !!~a.email.indexOf(domain);
		var intb = !!~b.email.indexOf(domain);

		if (inta && !intb) {
			return -1;
		}
		if (intb && !inta) {
			return 1;
		}

		var x = (a.name || '') + a.email.replace(/[[\]]/g, '');
		var y = (b.name || '') + b.email.replace(/[[\]]/g, '');

		if (x < y) {
			return -1;
		}

		return x > y;
	};

	emails = emails.sort(sc);

	//Create output string
	var out = [];

	var value = await this._value();
	for(i in emails){
		name  = emails[i].name;
		email = emails[i].email;

		if (~value.indexOf(email)) {
			continue;
		}
		if ((name && this.__last_qdata.name != name) || (email && this.__last_qdata.email != email)){
			if (email.indexOf('[')===0)
				out.push({value:email, css:'avatar'});
			else
				out.push({value:MailAddress.createEmail(name,email), text:MailAddress.createEmail(name,email, true), css:'avatar', prefix:obj_avatar.getAvatarHTML({email: email, name: name, size: 32 })});
		}
	}

	if (this._filterResults) {
		out = this._filterResults(out);
	}

	if (out.length)
		this.__show(out);
	else
		this.__hide();

	this.__sLastRequestString = this.__relay + sWord;
	this.__sLastSuggest = sWord;
};


/**
 * Drag & Drop
 **/

_me.__dndDispatch = function(){
	if (this.__dndtimer){
		window.clearTimeout(this.__dndtimer);
		delete this.__dndtimer;
	}
	return false; // for _disobeyEvent
};

_me.__initdrag = function(elm,x,y){

	//disable drag if rename state
	if (this.edit || !elm.parentNode) return false;

	this.__dragged = elm;
	addcss(elm,'drag');

	//create Drag box
	var id = elm.getAttribute('val');
	var split = MailAddress.splitEmailsAndNames(id)[0];
	gui.frm_main.dnd.create_drag({
		type: 'rcp',
		obj: this,
		value: [{
			id: id,
			type: 'contact',
			name: split.name,
			folder: split.email,
			icon: obj_avatar.getAvatarHTML({email: split.email, name: split.name, size: 48}),
			elm: elm
		}],
		x: x,
		y: y
	});
};

_me._active_dropzone = function(v){

	this.__aDragTargets = [];

	if (v){

		//Filter all Items except Contacts
		if (v.type == 'item' && WMFolders.getType(v.value[0]) != 'C')
			return false;

		this.__objPos = getSize(this._main);

		var a = this.__etag.getElementsByTagName('SPAN');
		for(var i = a.length-1;i>=0;i--)
			if (a[i] != v.value)
				this.__aDragTargets.push([a[i],getSize(a[i])]);
	}
	else
	if (this.__dragged && this.__dragged.parentNode){
		removecss(this.__dragged,'drag');
		removecss(this._main,'dragover');
		this.__dragged = null;
	}
};

_me._ondragover = function(){
	addcss(this._main,'dragover');
};

_me._ondragout = function(){
	removecss(this._main,'dragover');
};

_me._ondrop = function(v){
	if (v.value && v.target !== v.obj){
		var a = [], tmp, i;
		switch(v.type){
		case 'item':

			if (v.value){
				var aID = [];
				for(i = 0; i<v.value.length; i++)
					aID.push(WMItems.__serverID(v.value[i].iid));

				if (aID.length){
					var me = this;

					WMItems.list({
						aid:v.value[0].aid,
						fid:v.value[0].fid,
						filter:{search:'items:"'+ aID.join(',').replace(/\*/g,'') +'"'},
						values:['ITMCLASSIFYAS','LCTEMAIL1','LCTEMAIL2','LCTEMAIL3','ITMCLASS']
					},'','','',[
						function(itm){
							if (me._addTag && itm && (itm = itm[v.value[0].aid]) && (itm = itm[v.value[0].fid]))
								for(i in itm)
									if (Is.Object(itm[i]))
										if (itm[i].ITMCLASS == 'L'){

											//Build Distrib Name
											var sPrefix = '',
												sName = itm[i].ITMCLASSIFYAS;

											if (itm[i].aid != sPrimaryAccount || sName.indexOf('::') >= 0)
												sPrefix = itm[i].aid + '::' + itm[i].fid + '::';
											else
											if (itm[i].fid != Mapping.getDefaultFolderForGWType('C') && itm[i].fid != "__@@ADDRESSBOOK@@__")
												sPrefix = itm[i].fid + '::';

											me._addTag({tag:'['+ sPrefix + sName +']'});
										}
										else
										if (itm[i].LCTEMAIL1 || itm[i].LCTEMAIL2 || itm[i].LCTEMAIL3)
											me._addTag({tag:MailAddress.createEmail(itm[i].ITMCLASSIFYAS, (itm[i].LCTEMAIL1 || itm[i].LCTEMAIL2 || itm[i].LCTEMAIL3))});
						}]);
				}
			}

			return;

		case 'jabber':
			for (i = 0; i<v.value.length; i++){
				tmp = dataSet.get('xmpp', ['roster',v.value[i].id,'name']);
				tmp = MailAddress.createEmail(tmp && tmp != v.value[i].id?tmp:'', v.value[i].id);
				if (tmp)
					a.push({tag:tmp});
			}
			break;

		case 'rcp':
			a = this._decode(v.value[0].id);
		}

		if (a.length)
			for (i = 0; i<a.length; i++)
				this._addTag(a[i]);
	}
};

_me._ondragstart = function(v){
	var elm = v.value[0].elm;
	if (elm.parentNode)
		addcss(elm,'dragged');
};

_me._ondragend = function(e, v) {
	var elm = v.value[0].elm;
	if (v.target && v.target !== this) {
		this._removeTag(elm);
	} else {
		var tags = [].slice.call(this._getAnchor('tag').querySelectorAll('.tag'));
		var reposition = false;
		for (var i in tags) {
			var bcr = tags[i].getBoundingClientRect();
			if (bcr.top < e.clientY && bcr.left < e.clientX && bcr.bottom > e.clientY && bcr.right > e.clientX) {
				tags[i].insertAdjacentElement('beforebegin', elm);
				reposition = true;
				break;
			}
		}
		if (v.target === this && !reposition) {
			this._getAnchor('tag').insertAdjacentElement('beforeend', elm);
		}
		removecss(elm,'dragged');
	}
};

_me._collapsedValue = function(v){
	var dv = this._decode(v);
	if (dv.length>this.__collapse_limit)
		this._value(v, true);
	else
		this._value(v);
};
