_me = obj_list_load_im_message.prototype;
function obj_list_load_im_message(){};

_me.__constructor = async function(aData, aTmpData) {
	var me = this;
	this.__aData = aData;
	this.__aTmpData = aTmpData || {};
	await this._draw('obj_list_load_im_message', 'main', aTmpData);
	[].forEach.call(this._main.querySelectorAll('.hljs'), function(hljs) {
		hljs.addEventListener('contextmenu', async function(e) {
			await gui._create("cmenu", "obj_context", '', '', me);
			var aMenu = [{
				title: 'CHATGPT::COPY_TO_CLIPBOARD',
				arg: [function() {
					toClipboard({
						'text/plain': hljs.querySelector('code').textContent
					}, 'codeblock');
				}]
			}];

			await gui.cmenu._fill(aMenu);
			gui.cmenu._place(e.clientX, e.clientY);
			e.preventDefault();
			e.stopImmediatePropagation();
		});
	});

	if (Is.Object(aTmpData.reply)) {
		this._getAnchor('reply').classList.add('image');
		aTmpData.reply.body = obj_groupchat_item.prototype.__encode_body(aTmpData.reply.body || '');
		await this._create('reply', 'obj_list_load_im_file', 'reply', 'reply', {
			body: aTmpData.reply
		}, {});
	} else if (aTmpData.reply) {
		await this._create('reply', 'obj_list_load_im_message', 'reply', 'reply', false, {
			body: obj_groupchat_item.prototype.__encode_body(aTmpData.reply)
		});
	}

	if (this.__aData && this.__aData.body) {
		this._init_controls();
	}

	[].forEach.call(this._main.querySelectorAll('img'), function(image) {
		var height = me._main.clientHeight;
		image.addEventListener('load', function() {
			if (me._parent._scrollBy) {
				me._parent._scrollBy(me._main.clientHeight - height);
			}
		});
	});
};

_me._init_controls = async function(bShow){
	var me = this;
	if (bShow){
		if (!this.controls){
			await this._create('controls', 'obj_tch_control', 'message', '', [
				!this.__aTmpData.password_protected && this.__aData.body && !me.__aData.body.url && {
					id: 'copy',
					tooltip: getLang('CHATGPT::COPY_TO_CLIPBOARD'),
					callback: [function() {
						var text = me.__aData.body;
						if (text.indexOf('```') === 0 && (text.match(/```/g) || []).length < 3) {
							text = text.replace(/```(.*?\n|$)/g, '').trim();
						}
						text = obj_groupchat_item.prototype.__encode_body(text);
						var text2 = createTextVersion(text, {
							linkProcess: function(href, linkText) {
								return linkText || href;
							},
							imgProcess: function() {
								return '';
							}
						});

						toClipboard({
							'text/html': text,
							'text/plain': text2
						}, 'message');
					}]
				},
				!this.__aTmpData.password_protected && this.__aData.body.url && {
					id: 'download',
					tooltip: getLang('ATTACHMENT::DOWNLOAD'),
					callback: [function() {
						downloadItem(me.__aData.body.parsedURL || me.__aData.body.url, true);
					}]
				},
				!this.__aTmpData.password_protected && this.__aData.body.url && {
					id: 'save_to_folder',
					tooltip: getLang('ATTACHMENT::SAVE_TO_FOLDER'),
					callback: [function() {
						gui._create('select_folder', 'frm_select_folder', '', '', 'POPUP_FOLDERS::SELECT_FOLDER', sPrimaryAccount, Mapping.getDefaultFolderForGWType('F'), [me, '__saveFolder', [[me.__aData.body]]], true, false, 'F', 'i', true);
					}]
				},
				!this.__aTmpData.password_protected && !this.__aData.undelivered && {
					id: 'reply',
					tooltip: getLang('CHAT::REPLY'),
					callback: [function() {
						me._parent._parent._reply(me.__aData.body);
					}]
				},
				!this.__aTmpData.password_protected && this.__aData.undelivered && {
					id: 'resend',
					tooltip: getLang('IM::RESEND'),
					callback: [function() {
						var h = dataSet.get('xmpp', ['roster', me.__aData.to, 'history']);
						h = h.filter(function(msg) {
							return !(msg.date === me.__aData.date && msg.to === me.__aData.to && msg.body === me.__aData.body);
						});
						dataSet.add('xmpp', ['roster', me.__aData.to, 'history'], h);

						me._destruct();
						me._parent._parent.__im._send(me.__aData.to, me.__aData.body);
					}]
				}
			]);
		}

		this.controls._show();
	} else {
		if (this.controls) {
			this.controls._destruct();
			delete this.controls;
		}

		this._getAnchor('message').onmouseover = function(){
			obj_list_load_im_message.prototype._init_controls.call(me, true);
		};

		this._getAnchor('message').onmouseleave = function(){
			obj_list_load_im_message.prototype._init_controls.call(me);
		};
	}
};