_me = obj_list_load_im_file.prototype;
function obj_list_load_im_file(){};

_me.__constructor = async function(aData, aTmpData, bScroll) {
	await storage.library('short_url');
	var tmp = mkElement('A',{href:aData.body.url}),
		sFileName = aData.body.url,
		addon = 'file';

	if (aData.body.url && ~aData.body.url.indexOf('/teamchatapi/') && ~aData.body.url.indexOf('ticket=')) {
		aData.body.url = aData.body.url.replace(/(&token=[a-z\d-]+)/, '');
		aData.body.url += '&token=' + sPrimaryAccountTeamchatToken;
	}

	if (tmp.pathname){
		sFileName = Path.basename(tmp.pathname).urlDecode();
	}
	tmp = null;

	this.__aTmpData = aTmpData || {};
	aTmpData.body = obj_groupchat_item.prototype.__encode_body(aData.body.body);
	aTmpData.filename = aData.body.desc || sFileName;
	var ext = Path.extension(aTmpData.filename);

	this.__aData = aData;

	if (aTmpData.unavailable) {
		return;
	}

	if (Item.imageSupport(aTmpData.filename)) {
		aTmpData.modify = getLang('CHAT::ITM_NEW_PICTURE');
		aTmpData.subtype = 'obj_groupchat_file-image';
		addon = 'image';
	} else if (Path.extension(aTmpData.filename) === 'heic') {
		aTmpData.modify = getLang('CHAT::ITM_NEW_PICTURE');
		aTmpData.subtype = 'obj_groupchat_file-image';
		addon = 'image';
	} else if (Item.videoSupport(aTmpData.filename)) {
		aTmpData.subtype = 'obj_groupchat_file-video';
		aTmpData.poster = aData.body.url;
		aTmpData.url = aData.body.url;
		addon = 'video';
	} else {
		aTmpData.subtype = 'obj_groupchat_file-file';

		if (ext == 'pdf'){
			aTmpData.modify = getLang('CHAT::ITM_NEW_DOC');
			aTmpData.doctype = 'pdf';
		} else if (Item.isDocument(aTmpData.filename)){
			aTmpData.modify = getLang('CHAT::ITM_NEW_DOC');
			aTmpData.doctype = 'doc';
		} else if (Item.isSpreadsheet(aTmpData.filename)){
			aTmpData.modify = getLang('CHAT::ITM_NEW_XLS');
			aTmpData.doctype = 'xls';
		} else if (Item.isPresentation(aTmpData.filename)){
			aTmpData.modify = getLang('CHAT::ITM_NEW_PPT');
			aTmpData.doctype = 'ppt';
		} else {
			aTmpData.modify = getLang('CHAT::ITM_NEW_FILE');
		}

		if (aData.body.url && aTmpData.doctype){
			switch(aTmpData.doctype){
				case 'pdf':
					aTmpData.openbutton = GWOthers.getItem('LAYOUT_SETTINGS','disable_pdf') != '1';
					break;

				default:
					aTmpData.preview = true;
					aTmpData.openbutton = Item.officeSupport(aTmpData.filename);
			}
		}
	}

	//Draw
	await this._draw('obj_list_load_im_file', 'main', aTmpData);
	await this._draw('obj_list_load_im_file-' + addon, 'addon', aTmpData, 2);

	if (aTmpData.password_protected) {
		this.btn_unlock._onclick = function() {
			ShortURL.resolve({
				url: aData.body.url,
				filename: aData.body.desc,
				callback: async function(oURL, sError) {
					if (oURL) {
						aTmpData.password_protected = false;
					} else if (sError) {
						aTmpData.unavailable = true;
					}
					await this._clean();
					this.__constructor(aData, aTmpData);
				}.bind(this),
				doNotTrack: true
			});
		}.bind(this);
	} else if (!aTmpData.unavailable && !aTmpData.resolved) {
		ShortURL.resolve({
			url: aData.body.url,
			callback: async function(oURL, sError) {
				if (this._destructed) {
					return;
				}
				if (oURL) {
					aTmpData.resolved = true;
					aData.body.desc = oURL.filename;
					aData.body.parsedURL = oURL.url;
					await this._clean();
					this.__constructor(aData, aTmpData);
				} else if (sError) {
					switch(sError) {
						case 'E_DOCUMENT_INVITE_PASSWORD':
							aTmpData.password_protected = true;
						break;
						default:
							aTmpData.unavailable = true;
					}
					await this._clean();
					this.__constructor(aData, aTmpData);
				} else {
					this.__activateAddon(bScroll);
				}
			}.bind(this),
			skipPasswordPrompt: true,
			doNotTrack: true
		});
	} else {
		this.__activateAddon(bScroll);
	}

	obj_list_load_im_message.prototype._init_controls.call(this);
};

_me.__activateAddon = function(bScroll) {
	var me = this;
	var aData = this.__aData;
	var aTmpData = this.__aTmpData;

	if (Item.imageSupport(aTmpData.filename) || Path.extension(aTmpData.filename) === 'heic') {
		ShortURL.resolve({
			url: aData.body.parsedURL || aData.body.url,
			callback: async function(oURL) {
				if (this._destructed) {
					return;
				}
				var url = oURL ? oURL.url : aData.body.url;

				if (Path.extension(aTmpData.filename) === 'heic') {
					addcss(this._main, 'generating_preview');
					await storage.library('heic-to', 'heic-to/dist');
					var loader = await this._create('img_generator_loader', 'obj_loader', 'ratio-wrapper');
					loader._value('Generating preview');
					getRemoteFileContent(url, function(response) {
						heicTo({ blob: response, toType: "image/jpg", quality: 0.5 }).then(function(newImage) {
							var url = URL.createObjectURL(newImage);
							dataSet.add('cache', ['image', aData.body.parsedURL], url);
							if (me._destructed) {
								return;
							}

							removecss(me._main, 'generating_preview');
							aData.body.parsedURL = url;
							loader._destruct();
							me.__initImage(url, bScroll);
						}).catch(function() {
							loader._destruct();
						});
					}, 'blob');
					return;
				}

				this.__initImage(url, bScroll);
			}.bind(this)
		});
	} else if (Item.videoSupport(aTmpData.filename)) {
		ShortURL.resolve({
			url: aData.body.parsedURL || aData.body.url,
			callback: async function(oURL) {
				await storage.library('video.min', 'videojs');
				storage.css('video-js-base');
				storage.css('video-js-theme-fantasy');

				var url = oURL ? oURL.url : aData.body.url;
				aData.body.url = url;
				this._getAnchor('video').setAttribute('poster', url);
				this._getAnchor('video').querySelector('source').setAttribute('src', url);

				this.__video = videojs(this._getAnchor('video'), {
					controlBar: {
						pictureInPictureToggle: false
					}
				});
				this.__video.on('play', function() {
					gui.__exeEvent('videojs-started', this.__video);
				}.bind(this));
				this.__video.on('canplay', function() {
					this.__video.off('canplay');
					this._getAnchor('video-wrapper').classList.remove('hidden');
				}.bind(this));
				this.__video.on('error', function() {
					this._getAnchor('video-wrapper').classList.add('hidden');
				}.bind(this));
				gui._obeyEvent('videojs-started', [this, '__stopVideo']);
			}.bind(this)
		});
	}

	if (this.btn_open){
		this.btn_open._onclick = function(e){
			ShortURL.resolve({
				url: aData.body.parsedURL || aData.body.url,
				callback: async function(oURL) {
					var url = oURL ? oURL.url : aData.body.url;
					if (aTmpData.doctype == 'pdf'){
						if(GWOthers.getItem('LAYOUT_SETTINGS','disable_pdf') == 1) {
							downloadItem(url, true);
						} else {
							var pdf = await me._gui._create('pdf','frm_pdf');
							pdf._load(url, aTmpData.filename);
						}
					}
					else
					if (Item.officeSupport(aTmpData.filename)){
						var parsed = parseURL(url) || {};
						var sMode = 'edit';
						switch (GWOthers.getItem('DOCUMENTS', 'office_app')) {
							case 'webdoc_read':
								parsed.id = false;
								sMode = 'view';
								break;
							case 'suite':
								parsed.id = false;
								sMode = 'external';
						}
						Item.officeOpen(parsed.id ? {
							iid: parsed.id,
							ticket: parsed.ticket,
							EVNTITLE: aData.body.desc, password: parsed.password
						} : {
							url:url,
							ticket: parsed.ticket,
							EVNTITLE: aData.body.desc,
							password: parsed.password,
							downloadable: oURL.downloadable
						}, [downloadItem, [url,true]], Path.extension(aTmpData.filename), sMode);
					}
					else{
						if (this._parent._imagePreview) {
							this._parent._imagePreview(url);
						} else if (this._parent._parent._imagePreview) {
							this._parent._parent._imagePreview(url);
						}
						e.preventDefault();
						e.stopPropagation();
						e.stopImmediatePropagation();
					}
				}
			});
		};

		if (aTmpData.preview){
			this._getAnchor('preview').onclick = function(){
				me.btn_open._onclick();
			};
		}
	}
};

_me.__initImage = function(url, bScroll) {
	var img = new Image();
	img.onload = function(sUrl){
		if (this._destructed)
			return;

		if (img.naturalHeight>400){
			this._getAnchor('center-wrapper').style.width = img.naturalWidth * (400/img.naturalHeight) + 'px';
		}
		else{
			this._getAnchor('center-wrapper').style.width = img.naturalWidth + 'px';
		}

		this._getAnchor('ratio-wrapper').style.paddingBottom = (img.naturalHeight / img.naturalWidth * 100) + '%';
		this._getAnchor('preview').src = sUrl;

		addcss(this._main, 'wrap');

		if (bScroll) {
			if (this._parent._scroll) {
				this._parent._scroll(0);
			} else if (this._parent._parent._scroll) {
				this._parent._parent._scroll(0);
			}
		}
	}.bind(this, url);

	img.onerror = function(sUrl) {
		img.onerror = false;
		img.src = sUrl;
	}.bind(this, url);

	this._getAnchor('preview').onclick = function(sUrl, e) {
		if (this._parent._imagePreview) {
			this._parent._imagePreview(sUrl);
		} else if (this._parent._parent._imagePreview) {
			this._parent._parent._imagePreview(sUrl);
		}
		e.preventDefault();
		e.stopPropagation();
		e.stopImmediatePropagation();
	}.bind(this, url);

	img.src = url;
};

_me._preview_image = function(src){
	if (!this._destructed && src) {
		if (this._getAnchor('preview')) {
			this._getAnchor('preview').src = encodeURI(src);
		} else if (this._getAnchor('border')) {
			this._getAnchor('border').style.backgroundImage = 'url("'+ encodeURI(src) +'")';
		}
	}
};

_me._saveFolder = async function(aid, fid) {
	await storage.library('wm_upload');
	new wm_upload().uploadFromURL(this.__aData.body.url, [function(bOK, response) {
		gui.notifier._value({
			type: bOK ? 'success' : 'alert',
			args: {
				header: '',
				text: bOK ? 'NOTIFICATION::FILE_SAVED' : ('ERROR::' + response)
			}
		});
	}], aid, fid);
};

_me.__stopVideo = function(context) {
	if (this.__video && context !== this.__video) {
		try {
			this.__video.pause();
		} catch {
			//
		}
	}
};

_me.__saveFolder = function(aid, fid, arg, callback) {
	//DIRECT
	var now = new IcewarpDate(),
		att = [];

	for (var i in arg)
		att.push({
			values:{
				class: 'link',
				description: arg[i].desc,
				size: arg[i].size,
				fullpath: arg[i].url
			}
		});

	WMItems.add([aid,fid],{
		values:{
			'EVNSHARETYPE': GWOthers.getItem('DEFAULT_CALENDAR_SETTINGS','file_sharing'),
			'EVNSTARTDATE': now.format(IcewarpDate.JULIAN),
			'EVNSTARTTIME': now.format(IcewarpDate.JULIAN_TIME)
		},
		duplicity: 'rename',
		ATTACHMENTS: att
	},'','','',[
		function(bOK, result) {
			//Notify user
			if (bOK && result && result.id) {
				callback && callback.success && callback.success.call(callback.context || this, result);
				if (gui.notifier) {
					if (aid === '@@alfresco@@') {
						if (att.length > 1) {
							gui.notifier._value({type: 'success', args: {text_plain: getLang('NOTIFICATION::ATTACHMENTS_SAVED_ALFRESCO', [att.length, fid])}});
						} else {
							gui.notifier._value({type: 'success', args: {text_plain: getLang('NOTIFICATION::ATTACHMENT_SAVED_ALFRESCO', [att[0].values.description, fid])}});
						}
					} else {
						// gui.notifier._value({type: 'item_saved', args: [aid, fid]});
					}
				}

				//refresh Files folder if active
				var aItems = dataSet.get('items');
				for(var sAccId in aItems)
					for(var sFolId in aItems[sAccId])
						break;

				if (aid == sAccId && fid == sFolId) {
					try {
						gui.frm_main.main.list._serverSort({aid:aid,fid:fid});
					} catch(r){
						 console.log(this._name||false,r);
					}
				}
			}
		}
	]);

};
