_me = obj_list_load_im.prototype;
function obj_list_load_im(){};

_me.__constructor = async function(){
	await storage.library('short_url');
	await storage.library('obj_highlight');

	this.__options = {
		autoscroll:true
	};

	this._row2 = obj_list_load.prototype._row.bind(this);
	this.__aRequestData.fetchnew = false;

	this._getAnchor('loading').innerHTML = getLang('CHAT::LOADING');

	this._onclick = function(e){
		var elm = e.target;
		if (elm.tagName == 'A' && elm.protocol === 'mailto:'){
			e.preventDefault();
			NewMessage.compose({to:elm.pathname});
			return false;
		}
	};

	this._oncontext = async function(e){
		var elm = e.target;
		if (elm.tagName == 'A') {
			if (elm.protocol === 'mailto:') {
				e.preventDefault();
				e.stopPropagation();

				var pos = getSize(elm),
					cmenu = await gui._create('cmenu', 'obj_context_link','','','', elm.pathname);
					cmenu._place(pos.x+pos.w,pos.y+(pos.h/2));
				return false;
			}
		}
	};

	this.__aData = {};

	gui.frm_main.dnd.registr_drop(this, ['item']);
};

_me._active_dropzone = async function(v) {
	if (!v) {
		return;
	}

	var mask = mkElement('div', {
		className: 'dropzone item' + (this._parent._docked ? ' small' : ''),
		onmouseenter: function() {
			mask.classList.add('active');
		},
		onmouseleave: function() {
			mask.classList.remove('active');
		},
		innerHTML: await (new cTemplate()).tmp('dropzone', {
			title: getLang('CHAT::DROP_TITLE', [this._parent._getUserName()]),
			body: ''
		})
	});

	this._parent._getAnchor('wrapper').appendChild(mask);

	return mask
};

_me._ondrop = function(v) {
	var me = this._parent;
	if (v.type == 'item'){
		v.value.forEach(function(v) {
			return me.__addItems([{
				title: v.name,
				size: v.size,
				aid: v.aid,
				fid: v.fid,
				iid: v.iid,
				fullpath: v.aid + '/' + v.fid + '/' + WMItems.__serverID(v.iid)
			}]);
		});
	}
};

_me._imagePreview = async function(sUrl) {
	var images = [];
	for (var i in this.__aData) {
		var data = this.__aData[i];
		if (Item.imageSupport(data.data.body.desc || ((data.data.body.parsedURL || data.data.body.url) && new URL(data.data.body.parsedURL || data.data.body.url).pathname) || '')) {
			images.push({
				url: data.data.body.parsedURL || data.data.body.url,
				title: data.data.body.desc
			});
		}
	}
	images = images.reverse();
	var imgview = await gui._create('imgview', 'frm_imgview');
	await imgview._fill(images);
	var index = 0;
	for (i in images) {
		if (images[i].url === sUrl || images[i].parsedURL === sUrl) {
			index = i;
			break;
		}
	}
	imgview._value(index);
};

_me._fill = function(aData, bSkipTodayLabel, bTop){
	if (aData && aData.length){
		this.__loading = 1;
		this._response(aData, !bTop, !bTop);
	}
};

_me._clear = async function(bNoRequest) {
	await obj_list_load.prototype._clear.call(this, bNoRequest);
	this.__aRequestData.fetchnew = false;
	this.__aData = {};
}

_me._response = async function(aData, bUpdate, bScroll, bSkipTime){
	var bScrollDown = false,
		scroll = false,
		scrollTimeout,
		offset, tmp;

	//Scroll to bottom?
	if (bScroll){
		var elm, n = this.__body.childNodes;
		if (n.length && (elm = n[n.length-1])){
			if (elm.offsetTop < this.__body.scrollTop + this.__body.clientHeight + 10) {
				bScrollDown = true;
				offset = 0;
			} else
			if (this.__body.scrollTop + this.__body.scrollHeight == this.__body.clientHeight) {
				bScrollDown = true;
				offset = this.__body.scrollHeight - this.__body.clientHeight - this.__body.scrollTop;
			}
		}
		else {
			bScrollDown = true;
			offset = this.__body.scrollHeight - this.__body.clientHeight - this.__body.scrollTop;
		}
	}
	else
	if (!bUpdate) {
		scroll = [this.__body.scrollTop, this.__body.scrollHeight];
	}

	var last, date, result = [];

	for (var iid in aData){

		if (aData[iid].type === 'notice' || !aData[iid].body) {
			continue;
		}

		aData[iid].id = aData[iid].id || gui.frm_main.im.__xmpp._getUniqueID();

		if (this.__aData[aData[iid].id] && ((this.__aData[aData[iid].id] || {}).data.date) === aData[iid].date) {
			console.log('duplicate IM message entry', aData[iid], this.__aData[aData[iid].id]);
			continue;
		}

		var data = {data:aData[iid]};
		this.__aData[aData[iid].id] = data;
		date = IcewarpDate.unix(aData[iid].date);

		//separator
		var sep = date;

		if (bUpdate){
			if (!this.__sep2.sep || !sep.isSame(this.__sep2.sep, 'date')){
				this.__sep2 = {sep:sep};
				obj_list_load.prototype._separator.call(this, this.__sep2.sep);
			}
		}
		else
		if (!this.__sep1.sep || !sep.isSame(this.__sep1.sep, 'date')){
			if (this.__sep1.sep)
				this._separator(this.__sep1.sep, '', false, true);

			this.__sep1 = {sep:sep};

			if (!this.__sep2.sep)
				this.__sep2 = {sep:sep};
		}

		var row = false,
			bGroup = false;

		if (bUpdate){

			row = this._row2('', '', iid);

			//Grouping Update
			if (this.__sep2.row && this.__sep2.row.group && this.__sep2.row.email == aData[iid].from && ['system','notice'].indexOf(aData[iid].type)<0 && this.__sep2.row.time>date.unix() - 300)
				addcss(row.elm, 'group');

		}
		else{
			row = this._row('', '', iid);

			//Grouping History
			if (this.__sep1.row && this.__sep1.row.group && this.__sep1.row.email == aData[iid].from /*&& ['system','notice'].indexOf(aData[iid].type)<0*/ && this.__sep1.row.time<date.unix() + 300)
				addcss(this.__sep1.row.elm, 'group');
		}

		if (row){
			row.data = aData[iid];

			try{
				switch(aData[iid].type){
				case 'system':
					tmp = {
						time: date.format('LT'),
						fulltime: date.format('L LT'),
						body: obj_groupchat_item.prototype.__encode_body(aData[iid].body)
					};

					row.elm.innerHTML = await (new cTemplate()).tmp('obj_list_load_im_system', tmp);
					break;

				case 'notice':
					/** do not show User left the conversation and status change */
					break;

				default:
					if (aData[iid].undelivered) {
						aData[iid].from = sPrimaryAccount;
					}

					tmp = {
						me:aData[iid].reply,
						time: date.format('LT'),
						fulltime: date.format('L LT')
					};

					var highlighted = this.__highlight && (aData[iid].id === this.__highlight);
					if (highlighted) {
						delete this.__highlight;
					}

					if (Is.Object(aData[iid].body)){
						switch (aData[iid].body.type){
						case "file":
							data.row = await this._create('item', 'obj_list_load_im_file', row.anchor, '', aData[iid], tmp, bScroll);
							break;

						case "geoloc":
							var key = GWOthers.getItem('EXTERNAL_SETTINGS', 'google_maps_api_key') || '';
							if (key) {
								tmp.addon = true;
								tmp.addon_body = mkElement('iframe', {frameborder: 0, src: './client/gmaps.html?obj=gui.map&scale_controll=0&' + buildURL({lat:aData[iid].body.geoloc.LAT[0].VALUE, lon:aData[iid].body.geoloc.LON[0].VALUE, key: key})}).outerHTML + '<p class="overlay"></p>';
								data.row = await this._create('item', 'obj_list_load_im_message', row.anchor, '', aData[iid], tmp);

								row.elm.querySelector('iframe + p.overlay').onclick = function(){
									this.parentNode.removeChild(this);
								};
							} else {
								tmp.body = obj_groupchat_item.prototype.__encode_body(getLang('IM::GEO_KEY_MISSING')) + '<br><a target="_blank" href="https://www.google.com/maps/place/'+encodeURIComponent(aData[iid].body.geoloc.LAT[0].VALUE+','+aData[iid].body.geoloc.LON[0].VALUE)+'">' + getLang('IM::OPEN_IN_GOOGLE_MAPS') + '</a>';
								data.row = await this._create('item', 'obj_list_load_im_message', row.anchor, '', aData[iid], tmp);
							}
							break;
						}
					} else {
						var parsed = this.__parse_reply(aData[iid].body), m;
						tmp.reply = parsed.reply;
						tmp.body = obj_groupchat_item.prototype.__encode_body(parsed.body);
						aData[iid].body = parsed.body;

						// Conference link transformation
						var parts = parsed.body.split('```');
						for (var i = 0; i < parts.length; i = i + 2) {
							m = parts[i].match(wm_conference.linkRegExp);
							if (m) {
								break;
							}
						}
						if (m) {
							data.row = await this._create('item', 'obj_list_load_im_conference', row.anchor, '', aData[iid], tmp, m[2] + '_' + m[1]);
						} else {
							var file_link;;
							parts = aData[iid].body.split('```');
							for (i = 0; i < parts.length; i = i + 2) {
								file_link = ShortURL.match(parts[i])
								if (file_link) {
									break;
								}
							}
							if (file_link) {
								aData[iid].body = {
									body: aData[iid].body,
									desc: getLang('FILE::UNKNOWN_FILENAME'),
									type: 'file',
									url: file_link[0]
								};
								data.row = await this._create('item', 'obj_list_load_im_file', row.anchor, highlighted ? 'highlight' : '', aData[iid], tmp, bScroll);
							} else {
								data.row = await this._create('item', 'obj_list_load_im_message', row.anchor, highlighted ? 'highlight' : '', aData[iid], tmp);
								bGroup = true;
							}
						}
					}

					result.push(row);
					if (aData[iid].undelivered) {
						row.elm.classList.add('undelivered');
					}
				}

			}
			catch(r){
				if (data && (!data.obj || !data.obj._destructed))
					throw r;
				return;
			}

			data.anchor = row.anchor;

			if (bUpdate)
				this.__sep2.row = {elm: row.elm, email: aData[iid].from, time: date.unix(), group: bGroup};
			else{
				this.__sep1.row = {elm: row.elm, email: aData[iid].from, time: date.unix(), group: bGroup};

				if (!this.__sep2.row)
					this.__sep2.row = clone(this.__sep1.row);
			}

			last = row;
		}

		if (this.__options.autoscroll){
			//timeout for hljs init
			clearTimeout(scrollTimeout);
			scrollTimeout = setTimeout(function() {
				if (this.__body && this.__body.parentNode)
					if (bScrollDown) {
						this._scroll(0);
					} else
					if (scroll) {
						this.__body.scrollTop = scroll[0] + this.__body.scrollHeight - scroll[1];
					}

				this._fetch();
			}.bind(this), 5);
		}
	}
	if (bScrollDown) {
		setTimeout(function() {
			this.__body.scrollTop = this.__body.scrollHeight - this.__body.clientHeight - offset;
		}.bind(this), 5);
	}

	if (!bUpdate){

		if (this.__anim_last && this.__anim_last.parentNode)
			this.__anim_last.parentNode.removeChild(this.__anim_last);

		if (this.__sep1.sep){
			this.__anim_last = this._separator(this.__sep1.sep, '', true);
			addcss(this.__anim_last,'last');
			this._main.appendChild(this.__anim_last);
		}
	}

	if (this.__sep1.sep && !this.__anim && last && this.__sep1.elm !== last.elm){
		this.__anim = this._separator(this.__sep1.sep, '', true);
		this._main.appendChild(this.__anim);
	}

	if (this.__body.style.visibility == 'hidden')
		this.__body.style.visibility = 'visible';

	if (!bSkipTime) {
		this.__loading = 0;
	}

	if (!this.__options.autoscroll) {
		this._fetch();
	}

	return result;
};

_me.__parse_reply = function(sBody) {
	var aBody = [],
		aReply = [],
		bReply = true,
		reply;
	(sBody || '').split('\n').forEach(function(row) {
		if (bReply && row.indexOf('||') === 0) {
			aReply.push(row.replace(/^\|\|/g, ''));
		} else {
			aBody.push(row);
			bReply = false;
		}
	});

	reply = aReply.join('\n');
	try {
		var parsed = reply && JSON.parse(reply);
		if (parsed.url && parsed.desc && Object.keys(parsed).length !== 2) {
			reply = parsed;
		}
	} catch {
		//
	}

	return {
		body: aBody.join('\n'),
		reply: reply
	}
};

_me._system = function (sStatus) {

	var aData = [
		{
			body: sStatus,
			date: new IcewarpDate(),
			type: 'system'
		}
	];

	this._response(aData, true, true, true);
};
_me._notice = function (sFrom, sBody){

	var aData = [
		{
			from: sFrom,
			body: sBody,
			date: (new IcewarpDate()).unix(),
			type: 'notice'
		}
	];

	this._response(aData, true, true, true);
};
_me._add = async function(sFrom, sTo, sBody, bReply, date, bError, sId) {
	var aData = [{
		from: sTo,
		to: sFrom,
		body: sBody,
		reply: bReply,
		date: date,
		undelivered: bError,
		id: sId
	}];

	return await this._response(aData, true, true, true)[0];
};

_me._delete = function(sId) {
	if (this.__aData[sId]) {
		this.__aData[sId].row._destruct();
		delete this.__aData[sId];
	}
}

/////////////////////

_me._translateUser = function (sUser) {

	if (sUser == sPrimaryAccount)
		return dataSet.get('main',['fullname']) || dataSet.get('main',['user']);

	return dataSet.get('xmpp', ['roster', sUser, 'name']) || sUser;
};