_me = obj_list_load_chatgpt_conversation.prototype;
function obj_list_load_chatgpt_conversation() { };

_me.__constructor = async function (oOptions) {
	this.__oOptions = Object.assign({

	}, oOptions || {});
	this._getAnchor('loading').innerHTML = getLang('CHAT::LOADING');

	this._getAnchor('placeholder').innerHTML = '';
	await this._create('actions', 'obj_chatgpt_actions', 'placeholder', '', {
		callback: [function(oData) {
			ChatGPT.conversationCreateFake({
				openai_model: oData.model,
				messages: oData.messages,
				label: oData.label,
				instance: oData.instance
			}, function(bOK, conversation) {
				if (bOK) {
					gui.frm_main._openChatGPTConversation(conversation);
	
					if (oData.message) {
						conversation.messageCreate({
							message: oData.message,
							files: oData.files
						}, function(bOK, message) {
							if (bOK) {
								message.conversation.process();
							} else {
								conversation.delete();
							}
						}.bind(this));
					}
				}
			}.bind(this));
		}.bind(this)]
	});

	this._getAnchor('unread_threads').textContent = getLang('CHATGPT::CANCEL');
	this._getAnchor('unread_threads').onclick = function() {
		this.__conversation.cancel();
	}.bind(this);

	gui._obeyEvent('ChatGPTConversationUpdate', [this, '__ChatGPTConversationUpdate']);
	gui._obeyEvent('ChatGPTConversationMessageCreate', [this, '__ChatGPTConversationMessageCreate']);
	gui._obeyEvent('ChatGPTConversationMessageDelete', [this, '__ChatGPTConversationMessageDelete']);

	this._add_destructor('__destructor');
};

_me.__generateRegenerateButton = async function() {
	var modelType = ChatGPT.getModel(this.__conversation.openai_model).type;
	this._main.setAttribute('iw-model-type', modelType);
	if (modelType === 'image' && !this.regenerate) {
		await this._create('regenerate', 'obj_button', 'buttons', 'ico dalle generate simple inline');
		this.regenerate._value('CHATGPT::REGENERATE');
		this.regenerate._onclick = function() {
			this.__conversation.process();
		}.bind(this);
	}
};

_me.__destructor = function() {
	gui._disobeyEvent('ChatGPTConversationUpdate', [this, '__ChatGPTConversationUpdate']);
	gui._disobeyEvent('ChatGPTConversationMessageCreate', [this, '__ChatGPTConversationMessageCreate']);
	gui._disobeyEvent('ChatGPTConversationMessageDelete', [this, '__ChatGPTConversationMessageDelete']);
};

_me._serverSort = function (conversation) {
	this.__conversation = conversation;
	conversation.messagesList(function (bOK) {
		bOK && this._response(conversation.messages);
	}.bind(this));
};

_me._oncount = function (i) {
	if (!i) {
		addcss(this._main, 'noitems');
	} else {
		removecss(this._main, 'noitems');
	}
};

_me._response = function (aMessages) {
	aMessages.forEach(function (message) {
		this.__createItem(message);
	}, this);
};

_me.__createItem = async function (aData, bTop) {
	if (this.__aData[aData.id]) {
		return;
	}

	var row;
	if (bTop) {
		row = this._row('', 'obj_threads_item', aData.id);
	} else {
		row = obj_list_load.prototype._row.call(this, '', 'obj_threads_item', aData.id);
	}

	for (var i in this.__aData) {
		delete this.__aData[i].obj.__oOptions.defaultAction;
	}

	var item = await this._create('msg', 'obj_chatgpt_item', row.anchor, '', aData, {
		defaultAction: this.__oOptions.defaultAction,
		customAction: this.__oOptions.customAction
	});
	item.__list = this;
	this.__aData[aData.id] = {
		obj: item,
		row: row
	};
	this._scroll(0);


	this._oncount && this._oncount(!Is.Empty(this.__aData));
};

_me._edit = function (id) {
	this.__aData[id].obj._edit(true);
};

_me._oncontext = async function (e, eTarget, elm, id) {
	gui.cmenu && await gui.cmenu._destruct();

	elm = e.target;
	var section = elm.closest('section');

	if (section) {
		e.preventDefault();

		id = section.getAttribute('rel');

		if (this.__aData[id].obj.__aData.role !== 'user') {
			return;
		}

		section.classList.add('active');
		var cmenu = await this._gui._create("cmenu", "obj_context", '', '', this);

		await cmenu._fill([{
			title: 'FORM_BUTTONS::EDIT',
			arg: [this, '_edit', [id]]
		}]);
		cmenu._place(e.clientX, e.clientY);
		cmenu._onclose = function() {
			section.classList.remove('active');
		};
	}
};

_me.__ChatGPTConversationUpdate = function(conversation) {
	if (conversation !== this.__conversation) {
		return;
	}

	if (conversation.realConversation) {
		this.__conversation = conversation.realConversation;
	}

	if (this.__conversation.processing && this.__conversation.instance !== 'assistant') {
		addcss(this._main, 'unread_threads');
		removecss(this._main, 'regenerate');
	} else {
		removecss(this._main, 'unread_threads');
		if (ChatGPT.getModel(this.__conversation.openai_model).type === 'image') {
			addcss(this._main, 'regenerate');
		}
	}
	this.__generateRegenerateButton();
};

_me.__ChatGPTConversationMessageCreate = function(message) {
	if (message.conversation !== this.__conversation) {
		return;
	}
	this.__createItem(message);
	this.__generateRegenerateButton();
};

_me.__ChatGPTConversationMessageDelete = function(message) {
	if (message.conversation !== this.__conversation || !this.__aData[message.id]) {
		return;
	}

	this.__aData[message.id].obj._destruct();
	var anchor = this._getAnchor(this.__aData[message.id].row.anchor);
	anchor && anchor.parentElement.removeChild(anchor);
	delete this.__aData[message.id];
};